/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.LineElement;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.text.PositionTracker;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ReplaceRefactoring
extends Refactoring {
    private final FileSearchResult fResult;
    private final Object[] fSelection;
    private final boolean fSkipFiltered;
    private HashMap fMatches;
    private String fReplaceString;
    private Change fChange;

    public ReplaceRefactoring(FileSearchResult result, Object[] selection, boolean skipFiltered) {
        Assert.isNotNull((Object)result);
        this.fResult = result;
        this.fSelection = selection;
        this.fSkipFiltered = skipFiltered;
        this.fMatches = new HashMap();
        this.fReplaceString = null;
    }

    public String getName() {
        return SearchMessages.ReplaceRefactoring_refactoring_name;
    }

    public void setReplaceString(String string) {
        this.fReplaceString = string;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        String searchString = this.getQuery().getSearchString();
        if (searchString.length() == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)SearchMessages.ReplaceRefactoring_error_illegal_search_string);
        }
        this.fMatches.clear();
        if (this.fSelection != null) {
            int i = 0;
            while (i < this.fSelection.length) {
                this.collectMatches(this.fSelection[i]);
                ++i;
            }
        } else {
            Object[] elements = this.fResult.getElements();
            int i = 0;
            while (i < elements.length) {
                this.collectMatches(elements[i]);
                ++i;
            }
        }
        if (!this.hasMatches()) {
            return RefactoringStatus.createFatalErrorStatus((String)SearchMessages.ReplaceRefactoring_error_no_matches);
        }
        return new RefactoringStatus();
    }

    private void collectMatches(Object object) throws CoreException {
        block7: {
            Match[] matches;
            block8: {
                block6: {
                    if (!(object instanceof LineElement)) break block6;
                    LineElement lineElement = (LineElement)object;
                    FileMatch[] matches2 = lineElement.getMatches(this.fResult);
                    int i = 0;
                    while (i < matches2.length) {
                        FileMatch fileMatch = matches2[i];
                        if (!this.isSkipped(fileMatch)) {
                            this.getBucket(fileMatch.getFile()).add(fileMatch);
                        }
                        ++i;
                    }
                    break block7;
                }
                if (!(object instanceof IContainer)) break block8;
                IContainer container = (IContainer)object;
                IResource[] members = container.members();
                int i = 0;
                while (i < members.length) {
                    this.collectMatches(members[i]);
                    ++i;
                }
                break block7;
            }
            if (!(object instanceof IFile) || (matches = this.fResult.getMatches(object)).length <= 0) break block7;
            Collection bucket = null;
            int i = 0;
            while (i < matches.length) {
                FileMatch fileMatch = (FileMatch)matches[i];
                if (!this.isSkipped(fileMatch)) {
                    if (bucket == null) {
                        bucket = this.getBucket((IFile)object);
                    }
                    bucket.add(fileMatch);
                }
                ++i;
            }
        }
    }

    public int getNumberOfFiles() {
        return this.fMatches.keySet().size();
    }

    public int getNumberOfMatches() {
        int count = 0;
        Iterator iterator = this.fMatches.values().iterator();
        while (iterator.hasNext()) {
            Collection bucket = (Collection)iterator.next();
            count += bucket.size();
        }
        return count;
    }

    public boolean hasMatches() {
        return !this.fMatches.isEmpty();
    }

    private boolean isSkipped(FileMatch match) {
        return !this.fSkipFiltered && match.isFiltered();
    }

    private Collection getBucket(IFile file) {
        HashSet col = (HashSet)this.fMatches.get(file);
        if (col == null) {
            col = new HashSet();
            this.fMatches.put(file, col);
        }
        return col;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.fReplaceString == null) {
            return RefactoringStatus.createFatalErrorStatus((String)SearchMessages.ReplaceRefactoring_error_no_replace_string);
        }
        Pattern pattern = null;
        FileSearchQuery query = this.getQuery();
        if (query.isRegexSearch()) {
            pattern = this.createSearchPattern(query);
        }
        RefactoringStatus resultingStatus = new RefactoringStatus();
        Set allFilesSet = this.fMatches.keySet();
        IFile[] allFiles = allFilesSet.toArray(new IFile[allFilesSet.size()]);
        Arrays.sort(allFiles, new Comparator(){
            private Collator fCollator = Collator.getInstance();

            public int compare(Object o1, Object o2) {
                String p1 = ((IFile)o1).getFullPath().toString();
                String p2 = ((IFile)o2).getFullPath().toString();
                return this.fCollator.compare(p1, p2);
            }
        });
        this.checkFilesToBeChanged(allFiles, resultingStatus);
        if (resultingStatus.hasFatalError()) {
            return resultingStatus;
        }
        CompositeChange compositeChange = new CompositeChange(SearchMessages.ReplaceRefactoring_composite_change_name);
        compositeChange.markAsSynthetic();
        ArrayList matchGroups = new ArrayList();
        boolean hasChanges = false;
        try {
            int i = 0;
            while (i < allFiles.length) {
                IFile file = allFiles[i];
                Collection bucket = (Collection)this.fMatches.get(file);
                if (!bucket.isEmpty()) {
                    try {
                        TextChange change = this.createFileChange(file, pattern, bucket, resultingStatus, matchGroups);
                        if (change != null) {
                            compositeChange.add((Change)change);
                            hasChanges = true;
                        }
                    }
                    catch (CoreException e) {
                        String message = Messages.format(SearchMessages.ReplaceRefactoring_error_access_file, new Object[]{file.getName(), e.getLocalizedMessage()});
                        return RefactoringStatus.createFatalErrorStatus((String)message);
                    }
                }
                ++i;
            }
        }
        catch (PatternSyntaxException e) {
            String message = Messages.format(SearchMessages.ReplaceRefactoring_error_replacement_expression, e.getLocalizedMessage());
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        if (!hasChanges && resultingStatus.isOK()) {
            return RefactoringStatus.createFatalErrorStatus((String)SearchMessages.ReplaceRefactoring_error_no_changes);
        }
        compositeChange.add((Change)new SearchResultUpdateChange(this.fResult, matchGroups.toArray(new MatchGroup[matchGroups.size()]), true));
        this.fChange = compositeChange;
        return resultingStatus;
    }

    private void checkFilesToBeChanged(IFile[] filesToBeChanged, RefactoringStatus resultingStatus) throws CoreException {
        ArrayList<IFile> readOnly = new ArrayList<IFile>();
        int i = 0;
        while (i < filesToBeChanged.length) {
            IFile file = filesToBeChanged[i];
            if (file.isReadOnly()) {
                readOnly.add(file);
            }
            ++i;
        }
        IFile[] readOnlyFiles = readOnly.toArray(new IFile[readOnly.size()]);
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(readOnlyFiles, this.getValidationContext());
        if (status.getSeverity() == 8) {
            throw new OperationCanceledException();
        }
        resultingStatus.merge(RefactoringStatus.create((IStatus)status));
        if (resultingStatus.hasFatalError()) {
            return;
        }
        resultingStatus.merge(ResourceChangeChecker.checkFilesToBeChanged((IFile[])filesToBeChanged, null));
    }

    private TextChange createFileChange(IFile file, Pattern pattern, Collection matches, RefactoringStatus resultingStatus, Collection matchGroups) throws PatternSyntaxException, CoreException {
        PositionTracker tracker = InternalSearchUI.getInstance().getPositionTracker();
        TextFileChange change = new TextFileChange(Messages.format(SearchMessages.ReplaceRefactoring_group_label_change_for_file, file.getName()), file);
        change.setEdit((TextEdit)new MultiTextEdit());
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(file.getFullPath(), LocationKind.IFILE, null);
        try {
            ITextFileBuffer textFileBuffer = manager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
            if (textFileBuffer == null) {
                resultingStatus.addError(Messages.format(SearchMessages.ReplaceRefactoring_error_accessing_file_buffer, file.getName()));
                return null;
            }
            IDocument document = textFileBuffer.getDocument();
            String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
            Iterator iterator = matches.iterator();
            while (iterator.hasNext()) {
                String originalText;
                FileMatch match = (FileMatch)iterator.next();
                int offset = match.getOffset();
                int length = match.getLength();
                Position currentPosition = tracker.getCurrentPosition(match);
                if (currentPosition != null) {
                    offset = currentPosition.offset;
                    if (length != currentPosition.length) {
                        resultingStatus.addError(Messages.format(SearchMessages.ReplaceRefactoring_error_match_content_changed, file.getName()));
                        continue;
                    }
                }
                if ((originalText = ReplaceRefactoring.getOriginalText(document, offset, length)) == null) {
                    resultingStatus.addError(Messages.format(SearchMessages.ReplaceRefactoring_error_match_content_changed, file.getName()));
                    continue;
                }
                String replacementString = this.computeReplacementString(pattern, originalText, this.fReplaceString, lineDelimiter);
                if (replacementString == null) {
                    resultingStatus.addError(Messages.format(SearchMessages.ReplaceRefactoring_error_match_content_changed, file.getName()));
                    continue;
                }
                ReplaceEdit replaceEdit = new ReplaceEdit(offset, length, replacementString);
                change.addEdit((TextEdit)replaceEdit);
                TextEditChangeGroup textEditChangeGroup = new TextEditChangeGroup((TextChange)change, new TextEditGroup(SearchMessages.ReplaceRefactoring_group_label_match_replace, (TextEdit)replaceEdit));
                change.addTextEditChangeGroup(textEditChangeGroup);
                matchGroups.add(new MatchGroup(textEditChangeGroup, match));
            }
        }
        finally {
            manager.disconnect(file.getFullPath(), LocationKind.IFILE, null);
        }
        return change;
    }

    private static String getOriginalText(IDocument doc, int offset, int length) {
        try {
            return doc.get(offset, length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private Pattern createSearchPattern(FileSearchQuery query) {
        return PatternConstructor.createPattern(query.getSearchString(), true, true, query.isCaseSensitive(), false);
    }

    private String computeReplacementString(Pattern pattern, String originalText, String replacementText, String lineDelimiter) throws PatternSyntaxException {
        if (pattern != null) {
            StringBuffer sb;
            Matcher matcher;
            try {
                replacementText = PatternConstructor.interpretReplaceEscapes(replacementText, originalText, lineDelimiter);
                matcher = pattern.matcher(originalText);
                sb = new StringBuffer();
                matcher.reset();
                if (!matcher.find()) {
                    return null;
                }
                matcher.appendReplacement(sb, replacementText);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new PatternSyntaxException(ex.getLocalizedMessage(), replacementText, -1);
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        return replacementText;
    }

    public FileSearchQuery getQuery() {
        return (FileSearchQuery)this.fResult.getQuery();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.fChange;
    }

    private static class MatchGroup {
        public TextEditChangeGroup group;
        public FileMatch match;

        public MatchGroup(TextEditChangeGroup group, FileMatch match) {
            this.group = group;
            this.match = match;
        }
    }

    public static class SearchResultUpdateChange
    extends Change {
        private MatchGroup[] fMatchGroups;
        private Match[] fMatches;
        private final FileSearchResult fResult;
        private final boolean fIsRemove;

        public SearchResultUpdateChange(FileSearchResult result, MatchGroup[] matchGroups, boolean isRemove) {
            this.fResult = result;
            this.fMatchGroups = matchGroups;
            this.fMatches = null;
            this.fIsRemove = isRemove;
        }

        public SearchResultUpdateChange(FileSearchResult result, Match[] matches, boolean isRemove) {
            this.fResult = result;
            this.fMatches = matches;
            this.fMatchGroups = null;
            this.fIsRemove = isRemove;
        }

        public Object getModifiedElement() {
            return null;
        }

        public String getName() {
            return SearchMessages.ReplaceRefactoring_result_update_name;
        }

        public void initializeValidationData(IProgressMonitor pm) {
        }

        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return new RefactoringStatus();
        }

        private Match[] getMatches() {
            if (this.fMatches == null) {
                ArrayList<FileMatch> matches = new ArrayList<FileMatch>();
                int i = 0;
                while (i < this.fMatchGroups.length) {
                    MatchGroup curr = this.fMatchGroups[i];
                    if (curr.group.isEnabled()) {
                        matches.add(curr.match);
                    }
                    ++i;
                }
                this.fMatches = matches.toArray(new Match[matches.size()]);
                this.fMatchGroups = null;
            }
            return this.fMatches;
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            Match[] matches = this.getMatches();
            if (this.fIsRemove) {
                this.fResult.removeMatches(matches);
            } else {
                this.fResult.addMatches(matches);
            }
            return new SearchResultUpdateChange(this.fResult, matches, !this.fIsRemove);
        }
    }
}

