/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.core.vm.js;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;

class BreakableSourceChecker
implements Debugger {
    int lineNumber;
    boolean breakable;

    BreakableSourceChecker() {
    }

    static boolean check(String source, int lineNumber) {
        Context cx = Context.enter();
        Debugger oldDebugger = cx.getDebugger();
        Object oldContext = cx.getDebuggerContextData();
        boolean oldGenerate = cx.isGeneratingDebug();
        int oldLevel = cx.getOptimizationLevel();
        try {
            BreakableSourceChecker checker = new BreakableSourceChecker();
            checker.lineNumber = lineNumber + 2;
            cx.setDebugger((Debugger)checker, null);
            cx.setGeneratingDebug(true);
            cx.setOptimizationLevel(-1);
            cx.compileString(BreakableSourceChecker.addHeader(source), "<check>", 1, null);
            boolean bl = checker.breakable;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
        finally {
            cx.setDebugger(oldDebugger, oldContext);
            cx.setGeneratingDebug(oldGenerate);
            cx.setOptimizationLevel(oldLevel);
            Context.exit();
        }
    }

    private static String addHeader(String source) {
        return "function addHeader(){\r\n" + source + "\r\n}";
    }

    public DebugFrame getFrame(Context arg0, DebuggableScript arg1) {
        return null;
    }

    public void handleCompilationDone(Context arg0, DebuggableScript arg1, String arg2) {
        if (!arg1.isTopLevel()) {
            return;
        }
        this.breakable = false;
        this.checkBreakable(arg1);
    }

    private void checkBreakable(DebuggableScript script) {
        int i;
        int[] nums = script.getLineNumbers();
        if (nums != null && nums.length > 0) {
            i = 0;
            while (i < nums.length) {
                if (nums[i] == this.lineNumber) {
                    this.breakable = true;
                    return;
                }
                ++i;
            }
        }
        i = 0;
        while (i < script.getFunctionCount()) {
            this.checkBreakable(script.getFunction(i));
            if (this.breakable) {
                return;
            }
            ++i;
        }
    }
}

