/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.FeatureSelectionDialog;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.context.XMLDocumentSetupParticpant;
import org.eclipse.pde.internal.ui.editor.text.XMLConfiguration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class LicenseFeatureSection
extends PDESection {
    private Text fLicenseFeatureIDText;
    private Button fLicenseButton;
    private Text fLicenseFeatureVersionText;
    private Text fUrlText;
    private SourceViewer fSourceViewer;
    private SourceViewerConfiguration fSourceConfiguration;
    private IDocument fDocument;
    private boolean fIgnoreChange;
    private Button fSharedLicenseButton;
    private Button fLocalLicenseButton;

    public LicenseFeatureSection(PDEFormPage page, Composite parent, XMLConfiguration fSourceConfiguration) {
        super(page, parent, 4096, false);
        this.fSourceConfiguration = fSourceConfiguration;
        this.fDocument = new Document();
        new XMLDocumentSetupParticpant().setup(this.fDocument);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite page = toolkit.createComposite((Composite)section);
        final StackLayout stackLayout = new StackLayout();
        GridLayout layout = FormLayoutFactory.createClearGridLayout(false, 2);
        layout.horizontalSpacing = 8;
        page.setLayout((Layout)layout);
        this.fSharedLicenseButton = toolkit.createButton(page, PDEUIMessages.FeatureEditor_licenseFeatureSection_sharedButton, 16);
        this.fLocalLicenseButton = toolkit.createButton(page, PDEUIMessages.FeatureEditor_licenseFeatureSection_localButton, 16);
        GridData gd = new GridData();
        gd.horizontalIndent = 5;
        this.fLocalLicenseButton.setLayoutData((Object)gd);
        final Composite sectionsComposite = toolkit.createComposite(page);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        sectionsComposite.setLayoutData((Object)gd);
        sectionsComposite.setLayout((Layout)stackLayout);
        final Composite licenseFeatureComposite = toolkit.createComposite(sectionsComposite);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        licenseFeatureComposite.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 2;
        layout.marginHeight = 5;
        layout.verticalSpacing = 8;
        licenseFeatureComposite.setLayout((Layout)layout);
        Label label = toolkit.createLabel(licenseFeatureComposite, PDEUIMessages.FeatureEditor_licenseFeatureSection_featureID);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fLicenseFeatureIDText = toolkit.createText(licenseFeatureComposite, null, 4);
        this.fLicenseFeatureIDText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LicenseFeatureSection.this.infoModified();
            }
        });
        this.fLicenseFeatureIDText.setEditable(true);
        gd = new GridData(768);
        this.fLicenseFeatureIDText.setLayoutData((Object)gd);
        this.fLicenseButton = toolkit.createButton(licenseFeatureComposite, PDEUIMessages.FeatureEditor_licenseFeatureSection_browse, 8);
        this.fLicenseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseFeatureSection.this.handleSelect();
            }
        });
        label = toolkit.createLabel(licenseFeatureComposite, PDEUIMessages.FeatureEditor_licenseFeatureSection_featureVersion);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fLicenseFeatureVersionText = toolkit.createText(licenseFeatureComposite, null, 4);
        this.fLicenseFeatureVersionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LicenseFeatureSection.this.infoModified();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fLicenseFeatureVersionText.setLayoutData((Object)gd);
        final Composite localLicenseComposite = toolkit.createComposite(sectionsComposite);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        localLicenseComposite.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 5;
        layout.verticalSpacing = 8;
        localLicenseComposite.setLayout((Layout)layout);
        label = toolkit.createLabel(localLicenseComposite, PDEUIMessages.FeatureEditor_InfoSection_url);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fUrlText = toolkit.createText(localLicenseComposite, null, 4);
        this.fUrlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LicenseFeatureSection.this.infoModified();
            }
        });
        gd = new GridData(768);
        this.fUrlText.setLayoutData((Object)gd);
        label = toolkit.createLabel(localLicenseComposite, PDEUIMessages.FeatureEditor_InfoSection_text);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        gd = new GridData(2);
        label.setLayoutData((Object)gd);
        int styles = 834;
        this.fSourceViewer = new SourceViewer(localLicenseComposite, null, styles);
        this.fSourceViewer.configure(this.fSourceConfiguration);
        this.fSourceViewer.setDocument(this.fDocument);
        StyledText styledText = this.fSourceViewer.getTextWidget();
        styledText.setFont(JFaceResources.getTextFont());
        styledText.setMenu(this.getPage().getPDEEditor().getContextMenu());
        styledText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        if (!SWT.getPlatform().equals("motif")) {
            toolkit.paintBordersFor(localLicenseComposite);
        }
        gd = new GridData(1808);
        gd.widthHint = 50;
        gd.heightHint = 50;
        styledText.setLayoutData((Object)gd);
        this.fSharedLicenseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    stackLayout.topControl = licenseFeatureComposite;
                    sectionsComposite.layout();
                }
            }
        });
        this.fLocalLicenseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    stackLayout.topControl = localLicenseComposite;
                    sectionsComposite.layout();
                }
            }
        });
        section.setClient((Control)page);
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        if (feature.getLicenseFeatureID() == null || feature.getLicenseFeatureID().length() == 0) {
            this.fLocalLicenseButton.setSelection(true);
            this.fSharedLicenseButton.setSelection(false);
            stackLayout.topControl = localLicenseComposite;
        } else {
            this.fLocalLicenseButton.setSelection(false);
            this.fSharedLicenseButton.setSelection(true);
            stackLayout.topControl = licenseFeatureComposite;
        }
        toolkit.paintBordersFor(licenseFeatureComposite);
    }

    private void handleSelect() {
        BusyIndicator.showWhile((Display)this.fLicenseFeatureIDText.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IFeatureModel[] allModels = PDECore.getDefault().getFeatureModelManager().getModels();
                ArrayList<IFeatureModel> newModels = new ArrayList<IFeatureModel>();
                int i = 0;
                while (i < allModels.length) {
                    if (this.canAdd(allModels[i])) {
                        newModels.add(allModels[i]);
                    }
                    ++i;
                }
                IFeatureModel[] candidateModels = newModels.toArray(new IFeatureModel[newModels.size()]);
                FeatureSelectionDialog dialog = new FeatureSelectionDialog(LicenseFeatureSection.this.fLicenseFeatureIDText.getShell(), candidateModels, false);
                if (dialog.open() == 0) {
                    Object[] models = dialog.getResult();
                    this.doSelect((IFeatureModel)models[0]);
                }
            }

            private void doSelect(IFeatureModel licenseFeatureModel) {
                IFeature licenseFeature = licenseFeatureModel.getFeature();
                LicenseFeatureSection.this.fLicenseFeatureIDText.setText(licenseFeature.getId());
                LicenseFeatureSection.this.fLicenseFeatureVersionText.setText(licenseFeature.getVersion());
            }

            private boolean canAdd(IFeatureModel candidate) {
                IFeatureModel model = (IFeatureModel)LicenseFeatureSection.this.getPage().getModel();
                IFeature feature = model.getFeature();
                String id = feature.getId();
                String candidateID = candidate.getFeature().getId();
                return !candidateID.equals(id) && !candidateID.equals(LicenseFeatureSection.this.fLicenseFeatureIDText.getText());
            }
        });
    }

    private void infoModified() {
        IFeatureModel featureModel = (IFeatureModel)this.getPage().getModel();
        if (this.fLicenseFeatureIDText.getText().length() == 0 && this.fLicenseFeatureVersionText.getText().length() > 0) {
            this.fIgnoreChange = true;
            this.fLicenseFeatureVersionText.setText("");
            this.fIgnoreChange = false;
        }
        if (!this.fIgnoreChange && featureModel instanceof IEditable) {
            ((IEditable)featureModel).setDirty(true);
            this.markDirty();
        }
    }

    public void refresh() {
        this.fIgnoreChange = true;
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        IFeatureInfo info = feature.getFeatureInfo(2);
        this.fLicenseFeatureIDText.setText(feature.getLicenseFeatureID());
        this.fLicenseFeatureVersionText.setText(feature.getLicenseFeatureVersion());
        this.fUrlText.setText(info.getURL() != null ? info.getURL() : "");
        this.fDocument.set(info.getDescription());
        super.refresh();
        this.fIgnoreChange = false;
    }

    public void commit(boolean onSave) {
        IFeatureModel featureModel = (IFeatureModel)this.getPage().getModel();
        IFeature feature = featureModel.getFeature();
        if (this.fSharedLicenseButton.getSelection()) {
            feature.setLicenseFeatureID(this.fLicenseFeatureIDText.getText());
            feature.setLicenseFeatureVersion(this.fLicenseFeatureVersionText.getText());
        } else {
            feature.setLicenseFeatureID("");
            feature.setLicenseFeatureVersion("");
            this.fIgnoreChange = true;
            this.fLicenseFeatureIDText.setText("");
            this.fLicenseFeatureVersionText.setText("");
            this.fIgnoreChange = false;
        }
        String url = this.fUrlText.getText();
        String description = this.fDocument.get();
        try {
            IFeatureInfo targetInfo = feature.getFeatureInfo(2);
            if (targetInfo == null) {
                targetInfo = featureModel.getFactory().createInfo(2);
                feature.setFeatureInfo(targetInfo, 2);
            }
            targetInfo.setURL(url);
            targetInfo.setDescription(description);
        }
        catch (CoreException coreException) {}
        super.commit(onSave);
    }
}

