/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IScriptDataSetDesign;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSourceFactory;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.IQueryContextVisitor;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.impl.ScriptDataSetRuntime;
import org.eclipse.birt.data.engine.odi.ICandidateQuery;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;

class PreparedScriptDSQuery
extends PreparedDataSourceQuery
implements IPreparedQuery {
    PreparedScriptDSQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn, IBaseDataSetDesign dataSetDesign, Map appContext, IQueryContextVisitor contextVisitor) throws DataException {
        super(dataEngine, queryDefn, dataSetDesign, appContext, contextVisitor);
        Object[] params = new Object[]{dataEngine, queryDefn, dataSetDesign, appContext};
        logger.entering(PreparedScriptDSQuery.class.getName(), "PreparedScriptDSQuery", params);
        logger.exiting(PreparedScriptDSQuery.class.getName(), "PreparedScriptDSQueryss");
        logger.logp(Level.FINER, PreparedScriptDSQuery.class.getName(), "PreparedScriptDSQuery", "PreparedScriptDSQuery starts up.");
    }

    public Collection getParameterMetaData() throws DataException {
        DataException e = new DataException("data.engine.NoParamMetaForDataSource");
        logger.logp(Level.FINE, PreparedDataSourceQuery.class.getName(), "getParameterMetaData", "Cannot get parameter metadata for this type of data source.", (Throwable)((Object)e));
        throw e;
    }

    protected QueryExecutor newExecutor() {
        return new ScriptDSQueryExecutor();
    }

    class ScriptDSQueryExecutor
    extends PreparedDataSourceQuery.DSQueryExecutor {
        private ResultClass resultClass;
        private CustomDataSet customDataSet;

        ScriptDSQueryExecutor() {
        }

        protected IDataSource createOdiDataSource() throws DataException {
            PreparedScriptDSQuery self = PreparedScriptDSQuery.this;
            return DataSourceFactory.getFactory().getDataSource(null, null, self.dataEngine.getSession());
        }

        protected IQuery createOdiQuery() throws DataException {
            assert (this.odiDataSource != null);
            ICandidateQuery candidateQuery = this.odiDataSource.newCandidateQuery(this.fromCache());
            return candidateQuery;
        }

        protected boolean fromCache() throws DataException {
            return super.fromCache() && this.dataSet.getDesign() instanceof IScriptDataSetDesign;
        }

        protected void populateOdiQuery() throws DataException {
            super.populateOdiQuery();
            ICandidateQuery candidateQuery = (ICandidateQuery)this.odiQuery;
            assert (candidateQuery != null);
            ScriptDataSetRuntime scriptDataSet = (ScriptDataSetRuntime)this.dataSet;
            List resultHints = this.dataSet.getResultSetHints();
            List computedColumns = this.dataSet.getComputedColumns();
            ArrayList<ResultFieldMetadata> columnsList = new ArrayList<ResultFieldMetadata>();
            this.resolveDataSetParameters(true);
            if (scriptDataSet.describe()) {
                columnsList.addAll(scriptDataSet.getDescribedMetaData());
            } else {
                Iterator it = resultHints.iterator();
                int j = 0;
                while (it.hasNext()) {
                    IColumnDefinition columnDefn = (IColumnDefinition)it.next();
                    ResultFieldMetadata columnMetaData = new ResultFieldMetadata(j + 1, columnDefn.getColumnName(), columnDefn.getColumnName(), DataType.getClass((int)columnDefn.getDataType()), null, true, columnDefn.getAnalysisType(), columnDefn.getAnalysisColumn(), columnDefn.isIndexColumn(), columnDefn.isCompressedColumn());
                    columnsList.add(columnMetaData);
                    columnMetaData.setAlias(columnDefn.getAlias());
                    ++j;
                }
            }
            int count = columnsList.size();
            Iterator it = computedColumns.iterator();
            int j = resultHints.size();
            while (it.hasNext()) {
                IComputedColumn compColumn = (IComputedColumn)it.next();
                ResultFieldMetadata columnMetaData = new ResultFieldMetadata(++count, compColumn.getName(), compColumn.getName(), DataType.getClass((int)compColumn.getDataType()), null, true, -1);
                columnsList.add(columnMetaData);
                ++j;
            }
            this.resultClass = new ResultClass(columnsList);
        }

        protected void prepareOdiQuery() throws DataException {
            assert (this.odiQuery != null);
            assert (this.resultClass != null);
            assert (this.dataSet instanceof ScriptDataSetRuntime);
            ICandidateQuery candidateQuery = (ICandidateQuery)this.odiQuery;
            this.customDataSet = new CustomDataSet();
            candidateQuery.setCandidates(this.customDataSet);
        }

        protected IResultIterator executeOdiQuery(IEventHandler eventHandler) throws DataException {
            this.customDataSet.open();
            this.dataSetAfterOpen();
            ICandidateQuery candidateQuery = (ICandidateQuery)this.odiQuery;
            return candidateQuery.execute(eventHandler);
        }

        private final class CustomDataSet
        implements ICustomDataSet {
            private CustomDataSet() {
            }

            public IResultClass getResultClass() {
                return ScriptDSQueryExecutor.this.resultClass;
            }

            public void open() throws DataException {
                ((ScriptDataSetRuntime)ScriptDSQueryExecutor.this.dataSet).open();
            }

            public IResultObject fetch() throws DataException {
                Object[] fields = new Object[ScriptDSQueryExecutor.this.resultClass.getFieldCount()];
                ResultObject resultObject = new ResultObject(ScriptDSQueryExecutor.this.resultClass, fields);
                ScriptDSQueryExecutor.this.dataSet.setRowObject(resultObject, true);
                boolean evalResult = ((ScriptDataSetRuntime)ScriptDSQueryExecutor.this.dataSet).fetch();
                if (!evalResult) {
                    resultObject = null;
                }
                return resultObject;
            }

            public void close() throws DataException {
                ((ScriptDataSetRuntime)ScriptDSQueryExecutor.this.dataSet).close();
            }
        }
    }
}

