/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.impl.document.stream.WrapperedRAInputStream;

public class RDAggrUtil {
    private HashMap<String, RDAggrValueHolder> holders = new HashMap();
    private IBaseQueryDefinition qd;

    public RDAggrUtil(StreamManager manager, IBaseQueryDefinition qd) throws DataException {
        this.qd = qd;
        try {
            RAInputStream aggrIndexStream = manager.getInStream(103, 0, 2);
            int aggrSize = IOUtil.readInt((InputStream)aggrIndexStream);
            DataInputStream aggrIndexDis = new DataInputStream((InputStream)aggrIndexStream);
            DataInputStream valueStream = new DataInputStream((InputStream)((Object)new WrapperedRAInputStream(manager.getInStream(104, 0, 2), 0L, -1L)));
            int i = 0;
            while (i < aggrSize) {
                RDAggrValueHolder holder = new RDAggrValueHolder(valueStream);
                this.holders.put(holder.getName(), holder);
                if (i < aggrSize - 1) {
                    long offset = IOUtil.readLong((DataInputStream)aggrIndexDis);
                    valueStream = manager.getVersion() >= 140 ? new DataInputStream((InputStream)((Object)new WrapperedRAInputStream(manager.getInStream(104, 0, 2), offset, -1L))) : new DataInputStream((InputStream)((Object)new WrapperedRAInputStream(manager.getInStream(104, 0, 2), offset + 1L, -1L)));
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    public boolean contains(String aggrName) {
        return this.holders.containsKey(aggrName);
    }

    public int getGroupLevel(String aggrName) {
        if (this.contains(aggrName)) {
            return this.holders.get(aggrName).getGroupLevel();
        }
        return -1;
    }

    public boolean isRunningAggr(String aggrName) {
        if (this.contains(aggrName)) {
            return this.holders.get(aggrName).isRunningAggr();
        }
        return false;
    }

    public Object getValue(String aggrName, int groupInstanceIndex) throws DataException {
        try {
            if (this.contains(aggrName)) {
                Object value = this.holders.get(aggrName).get(groupInstanceIndex);
                if (value != null && value instanceof BirtException) {
                    throw (BirtException)((Object)value);
                }
                if (this.qd != null && this.qd.getBindings().containsKey(aggrName)) {
                    IBinding b = (IBinding)this.qd.getBindings().get(aggrName);
                    value = DataTypeUtil.convert((Object)value, (int)b.getDataType());
                }
                return value;
            }
            return null;
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
        catch (BirtException e) {
            throw new DataException(e.getErrorCode(), e);
        }
    }

    private static class RDAggrValueHolder {
        private int groupInstanceIndex = 0;
        private int size = 0;
        private int groupLevel;
        private DataInputStream valueStream;
        private boolean isRunningAggr;
        private String bindingName;
        private Object currentValue;

        public RDAggrValueHolder(DataInputStream valueStream) throws IOException, DataException {
            this.bindingName = IOUtil.readString((DataInputStream)valueStream);
            this.populateRunningAggrInfo(valueStream);
            this.groupLevel = IOUtil.readInt((InputStream)valueStream);
            this.size = IOUtil.readInt((InputStream)valueStream);
            this.valueStream = valueStream;
            if (this.size > 0) {
                this.currentValue = IOUtil.readObject((DataInputStream)valueStream, (ClassLoader)DataEngineSession.getCurrentClassLoader());
            }
        }

        private void populateRunningAggrInfo(DataInputStream valueStream) throws IOException, DataException {
            String aggrName = IOUtil.readString((DataInputStream)valueStream);
            if (AggregationManager.getInstance().getAggregation(aggrName) == null) {
                throw new DataException("data.engine.InvalidAggregation", aggrName);
            }
            this.isRunningAggr = AggregationManager.getInstance().getAggregation(aggrName).getType() == 1;
        }

        public String getName() {
            return this.bindingName;
        }

        public boolean isRunningAggr() {
            return this.isRunningAggr;
        }

        public int getGroupLevel() {
            return this.groupLevel;
        }

        /*
         * Unable to fully structure code
         */
        public Object get(int index) throws IOException {
            if (index == this.groupInstanceIndex) {
                return this.currentValue;
            }
            if (index >= this.groupInstanceIndex && index < this.size) ** GOTO lbl7
            return null;
lbl-1000:
            // 1 sources

            {
                this.currentValue = IOUtil.readObject((DataInputStream)this.valueStream, (ClassLoader)DataEngineSession.getCurrentClassLoader());
                ++this.groupInstanceIndex;
lbl7:
                // 2 sources

                ** while (this.groupInstanceIndex < index)
            }
lbl8:
            // 1 sources

            return this.currentValue;
        }
    }
}

