/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.PropertySecurity;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.odaconsumer.ColumnHint;
import org.eclipse.birt.data.engine.odaconsumer.Connection;
import org.eclipse.birt.data.engine.odaconsumer.ExceptionHandler;
import org.eclipse.birt.data.engine.odaconsumer.OdaDataException;
import org.eclipse.birt.data.engine.odaconsumer.ParameterHint;
import org.eclipse.birt.data.engine.odaconsumer.ParameterMetaData;
import org.eclipse.birt.data.engine.odaconsumer.ProjectedColumns;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odaconsumer.ResultSetMetaData;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.datatools.connectivity.oda.IAdvancedQuery;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreparedStatement
extends ExceptionHandler {
    private String m_dataSetType;
    private Connection m_connection;
    private String m_queryText;
    private IQuery m_statement;
    private ArrayList<Property> m_properties;
    private int m_maxRows;
    private ArrayList<SortSpec> m_sortSpecs;
    private Boolean m_supportsNamedResults;
    private Boolean m_supportsOutputParameters;
    private Boolean m_supportsNamedParameters;
    private Boolean m_supportsInputParameters;
    private Boolean m_supportsMultipleResultSets;
    private ArrayList m_parameterHints;
    private Collection m_parameterMetaData;
    private ProjectedColumns m_projectedColumns;
    private IResultClass m_currentResultClass;
    private ResultSet m_currentResultSet;
    private IResultSet m_driverResultSet;
    private boolean m_updateProjectedColumns;
    private Hashtable m_namedProjectedColumns;
    private Hashtable m_namedCurrentResultClasses;
    private Hashtable m_namedCurrentResultSets;
    private HashSet m_updateNamedProjectedColumns;
    private SequentialResultSetHandler m_seqResultSetHdlr;
    private static String sm_className = PreparedStatement.class.getName();

    PreparedStatement(IQuery statement, String dataSetType, Connection connection, String query) {
        super(sm_className);
        String methodName = "PreparedStatement";
        if (PreparedStatement.getLogger().isLoggingEnterExitLevel()) {
            PreparedStatement.getLogger().entering(sm_className, methodName, new Object[]{statement, dataSetType, connection, query});
        }
        assert (statement != null && connection != null);
        this.m_statement = statement;
        this.m_dataSetType = dataSetType;
        this.m_connection = connection;
        this.m_queryText = query;
        PreparedStatement.getLogger().exiting(sm_className, methodName, this);
    }

    public String getEffectiveQueryText() {
        PreparedStatement.getLogger().entering(sm_className, "getEffectiveQueryText");
        String queryText = null;
        try {
            queryText = this.m_statement.getEffectiveQueryText();
        }
        catch (Exception ex) {
            PreparedStatement.getLogger().logp(Level.WARNING, sm_className, "getEffectiveQueryText", "Unable to get effective query text.", ex);
        }
        PreparedStatement.getLogger().exiting(sm_className, "getEffectiveQueryText", queryText);
        return queryText;
    }

    public QuerySpecification getQuerySpecification() {
        PreparedStatement.getLogger().entering(sm_className, "getQuerySpecification");
        QuerySpecification querySpec = null;
        try {
            querySpec = this.m_statement.getSpecification();
        }
        catch (Exception ex) {
            PreparedStatement.getLogger().logp(Level.WARNING, sm_className, "getQuerySpecification", "Unable to get effective query specification.", ex);
        }
        PreparedStatement.getLogger().exiting(sm_className, "getQuerySpecification", querySpec);
        return querySpec;
    }

    public void setProperty(String name, String value) throws DataException {
        String methodName = "setProperty";
        if (PreparedStatement.getLogger().isLoggingEnterExitLevel()) {
            PreparedStatement.getLogger().entering(sm_className, methodName, new Object[]{name, value});
        }
        this.doSetProperty(name, value);
        this.getPropertiesList().add(new Property(name, value));
        PreparedStatement.getLogger().exiting(sm_className, methodName);
    }

    private void doSetProperty(String name, String value) throws DataException {
        String methodName = "doSetProperty";
        if (PreparedStatement.getLogger().isLoggingEnterExitLevel()) {
            PreparedStatement.getLogger().entering(sm_className, methodName, new Object[]{name, value});
        }
        try {
            this.m_statement.setProperty(name, value);
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotSetStatementProperty", methodName);
        }
        catch (UnsupportedOperationException ex) {
            PreparedStatement.getLogger().logp(Level.WARNING, sm_className, methodName, "Cannot set statement property.", ex);
        }
        PreparedStatement.getLogger().exiting(sm_className, methodName);
    }

    private ArrayList<Property> getPropertiesList() {
        if (this.m_properties == null) {
            this.m_properties = new ArrayList();
        }
        return this.m_properties;
    }

    public void setSortSpec(SortSpec sortBy) throws DataException {
        String methodName = "setSortSpec";
        PreparedStatement.getLogger().entering(sm_className, methodName, sortBy);
        this.doSetSortSpec(sortBy);
        this.getSortSpecsList().add(sortBy);
        PreparedStatement.getLogger().exiting(sm_className, methodName);
    }

    private void doSetSortSpec(SortSpec sortBy) throws DataException {
        String methodName = "doSetSortSpec";
        PreparedStatement.getLogger().entering(sm_className, methodName, sortBy);
        try {
            this.m_statement.setSortSpec(sortBy);
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotSetSortSpec", methodName);
        }
        catch (UnsupportedOperationException ex) {
            this.throwException(ex, "odaconsumer.CannotSetSortSpec", methodName);
        }
        PreparedStatement.getLogger().exiting(sm_className, methodName);
    }

    private ArrayList<SortSpec> getSortSpecsList() {
        if (this.m_sortSpecs == null) {
            this.m_sortSpecs = new ArrayList();
        }
        return this.m_sortSpecs;
    }

    public void setMaxRows(int max) throws DataException {
        String methodName = "setMaxRows";
        PreparedStatement.getLogger().entering(sm_className, methodName, max);
        this.doSetMaxRows(max);
        this.m_maxRows = max;
        PreparedStatement.getLogger().exiting(sm_className, methodName);
    }

    private void doSetMaxRows(int max) throws DataException {
        String methodName = "doSetMaxRows";
        PreparedStatement.getLogger().entering(sm_className, methodName, max);
        try {
            this.m_statement.setMaxRows(max);
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotSetMaxRows", methodName);
        }
        catch (UnsupportedOperationException ex) {
            PreparedStatement.getLogger().logp(Level.WARNING, sm_className, methodName, "Cannot set max rows.", ex);
        }
        PreparedStatement.getLogger().exiting(sm_className, methodName);
    }

    public IResultClass getMetaData() throws DataException {
        String methodName = "getMetaData";
        PreparedStatement.getLogger().entering(sm_className, methodName);
        IResultClass ret = null;
        ret = this.m_currentResultSet != null ? this.m_currentResultSet.getMetaData() : this.doGetMetaData();
        PreparedStatement.getLogger().exiting(sm_className, methodName, ret);
        return ret;
    }

    private IResultClass doGetMetaData() throws DataException {
        String methodName = "doGetMetaData";
        PreparedStatement.getLogger().entering(sm_className, methodName);
        if (this.m_currentResultClass == null) {
            List projectedColumns = this.getProjectedColumns().getColumnsMetadata();
            this.m_currentResultClass = this.doGetResultClass(projectedColumns);
        }
        PreparedStatement.getLogger().exiting(sm_className, methodName, this.m_currentResultClass);
        return this.m_currentResultClass;
    }

    private ResultClass doGetResultClass(List projectedColumns) throws DataException {
        String methodName = "doGetResultClass";
        PreparedStatement.getLogger().entering(sm_className, methodName, projectedColumns);
        assert (projectedColumns != null);
        ResultClass ret = new ResultClass(projectedColumns);
        PreparedStatement.getLogger().exiting(sm_className, methodName, ret);
        return ret;
    }

    private ProjectedColumns getProjectedColumns() throws DataException {
        String methodName = "getProjectedColumns";
        PreparedStatement.getLogger().entering(sm_className, methodName);
        if (this.m_projectedColumns == null) {
            IResultSetMetaData odaMetadata = this.getRuntimeMetaData();
            this.m_projectedColumns = this.doGetProjectedColumns(odaMetadata);
        } else if (this.m_updateProjectedColumns) {
            IResultSetMetaData odaMetadata = this.getRuntimeMetaData();
            ProjectedColumns newProjectedColumns = this.doGetProjectedColumns(odaMetadata);
            this.updateProjectedColumns(newProjectedColumns, this.m_projectedColumns);
            this.m_projectedColumns = newProjectedColumns;
            this.m_updateProjectedColumns = false;
        }
        PreparedStatement.getLogger().exiting(sm_className, methodName, this.m_projectedColumns);
        return this.m_projectedColumns;
    }

    private IResultSetMetaData getRuntimeMetaData() throws DataException {
        String methodName = "getRuntimeMetaData";
        PreparedStatement.getLogger().entering(sm_className, methodName);
        try {
            IResultSetMetaData ret = this.m_statement.getMetaData();
            PreparedStatement.getLogger().exiting(sm_className, methodName, ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotGetResultSetMetaData", methodName);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.throwUnsupportedException("odaconsumer.CannotGetResultSetMetaData", methodName);
        }
        return null;
    }

    private ProjectedColumns doGetProjectedColumns(IResultSetMetaData odaMetadata) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetProjectedColumns( IResultSetMetaData )", odaMetadata);
        ResultSetMetaData metadata = new ResultSetMetaData(odaMetadata, this.m_connection.getDataSourceId(), this.m_dataSetType);
        ProjectedColumns ret = new ProjectedColumns(metadata);
        PreparedStatement.getLogger().exiting(sm_className, "doGetProjectedColumns( IResultSetMetaData )", ret);
        return ret;
    }

    public IResultClass getMetaData(String resultSetName) throws DataException {
        String methodName = "getMetaData";
        PreparedStatement.getLogger().entering(sm_className, methodName, resultSetName);
        this.validateNamedResultsSupport();
        ResultSet cfr_ignored_0 = (ResultSet)this.getNamedCurrentResultSets().get(resultSetName);
        IResultClass ret = null;
        ret = this.doGetMetaData(resultSetName);
        PreparedStatement.getLogger().exiting(sm_className, methodName, ret);
        return ret;
    }

    private IResultClass doGetMetaData(String resultSetName) throws DataException {
        String methodName = "doGetMetaData";
        PreparedStatement.getLogger().entering(sm_className, methodName, resultSetName);
        IResultClass resultClass = (IResultClass)this.getNamedCurrentResultClasses().get(resultSetName);
        if (resultClass == null) {
            List projectedColumns = this.getProjectedColumns(resultSetName).getColumnsMetadata();
            resultClass = this.doGetResultClass(projectedColumns);
            this.getNamedCurrentResultClasses().put(resultSetName, resultClass);
        }
        PreparedStatement.getLogger().exiting(sm_className, methodName, resultClass);
        return resultClass;
    }

    private ProjectedColumns getProjectedColumns(String resultSetName) throws DataException {
        String methodName = "getProjectedColumns";
        PreparedStatement.getLogger().entering(sm_className, methodName, resultSetName);
        ProjectedColumns projectedColumns = (ProjectedColumns)this.getNamedProjectedColumns().get(resultSetName);
        if (projectedColumns == null) {
            IResultSetMetaData odaMetadata = this.getRuntimeMetaData(resultSetName);
            projectedColumns = this.doGetProjectedColumns(odaMetadata);
            this.getNamedProjectedColumns().put(resultSetName, projectedColumns);
        } else if (this.m_updateNamedProjectedColumns != null && this.m_updateNamedProjectedColumns.contains(resultSetName)) {
            IResultSetMetaData odaMetadata = this.getRuntimeMetaData(resultSetName);
            ProjectedColumns newProjectedColumns = this.doGetProjectedColumns(odaMetadata);
            this.updateProjectedColumns(newProjectedColumns, projectedColumns);
            this.getNamedProjectedColumns().put(resultSetName, newProjectedColumns);
            this.m_updateNamedProjectedColumns.remove(resultSetName);
        }
        PreparedStatement.getLogger().exiting(sm_className, methodName, projectedColumns);
        return projectedColumns;
    }

    private IResultSetMetaData getRuntimeMetaData(String resultSetName) throws DataException {
        String methodName = "getRuntimeMetaData";
        PreparedStatement.getLogger().entering(sm_className, methodName, resultSetName);
        try {
            IResultSetMetaData ret = this.getAdvancedStatement().getMetaDataOf(resultSetName);
            PreparedStatement.getLogger().exiting(sm_className, methodName, ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetMetaDataForNamedResultSet", resultSetName, methodName);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.throwUnsupportedException("odaconsumer.CannotGetMetaDataForNamedResultSet", resultSetName, methodName);
        }
        return null;
    }

    public boolean execute() throws DataException {
        String methodName = "execute";
        PreparedStatement.getLogger().entering(sm_className, methodName);
        this.resetCachedResultSets();
        this.doGetMetaData();
        try {
            boolean ret = false;
            if (this.isAdvancedQuery()) {
                ret = this.getAdvancedStatement().execute();
            } else {
                this.m_driverResultSet = this.m_statement.executeQuery();
                ret = true;
            }
            if (PreparedStatement.getLogger().isLoggingEnterExitLevel()) {
                PreparedStatement.getLogger().exiting(sm_className, methodName, ret);
            }
            return ret;
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotExecuteStatement", methodName);
        }
        catch (UnsupportedOperationException ex) {
            this.throwException(ex, "odaconsumer.CannotExecuteStatement", methodName);
        }
        return false;
    }

    private void resetCachedResultSets() {
        this.m_driverResultSet = null;
        this.m_currentResultSet = null;
        if (this.m_namedCurrentResultSets != null) {
            this.m_namedCurrentResultSets.clear();
        }
        if (this.m_seqResultSetHdlr != null) {
            this.m_seqResultSetHdlr.resetResultSetsState();
        }
    }

    public ResultSet getResultSet() throws DataException {
        ResultSet rs;
        String methodName = "getResultSet";
        PreparedStatement.getLogger().entering(sm_className, methodName);
        IResultSet resultSet = null;
        try {
            if (this.isAdvancedQuery()) {
                resultSet = this.getAdvancedStatement().getResultSet();
            } else {
                resultSet = this.m_driverResultSet;
                this.m_driverResultSet = null;
            }
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotGetResultSet", methodName);
        }
        catch (UnsupportedOperationException ex) {
            this.throwException(ex, "odaconsumer.CannotGetResultSet", methodName);
        }
        this.m_currentResultSet = rs = new ResultSet(resultSet, this.doGetMetaData());
        this.m_currentResultClass = null;
        PreparedStatement.getLogger().exiting(sm_className, methodName, rs);
        return rs;
    }

    public ResultSet getResultSet(String resultSetName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "getResultSet(String)", resultSetName);
        this.validateNamedResultsSupport();
        IResultSet resultset = null;
        try {
            resultset = this.getAdvancedStatement().getResultSet(resultSetName);
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetNamedResultSet", resultSetName, "getResultSet(String)");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetNamedResultSet", resultSetName, "getResultSet(String)");
        }
        ResultSet rs = new ResultSet(resultset, this.doGetMetaData(resultSetName));
        this.getNamedCurrentResultSets().put(resultSetName, rs);
        this.getNamedCurrentResultClasses().remove(resultSetName);
        PreparedStatement.getLogger().exiting(sm_className, "getResultSet(String)", rs);
        return rs;
    }

    public ResultSet getResultSet(int resultSetNum) throws DataException {
        return this.getSequentialResultHandler().getResultSet(resultSetNum);
    }

    public IResultClass getMetaData(int resultSetNum) throws DataException {
        return this.getSequentialResultHandler().getMetaData(resultSetNum);
    }

    public boolean getMoreResults() throws DataException {
        return this.getSequentialResultHandler().getMoreResults();
    }

    public int findOutParameter(String paramName) throws DataException {
        String methodName = "findOutParameter";
        PreparedStatement.getLogger().entering(sm_className, methodName, paramName);
        this.validateOutputParameterSupport();
        try {
            int ret = this.getAdvancedStatement().findOutParameter(paramName);
            PreparedStatement.getLogger().exiting(sm_className, methodName, ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotFindOutParameter", paramName, methodName);
        }
        catch (UnsupportedOperationException ex) {
            PreparedStatement.getLogger().logp(Level.INFO, sm_className, methodName, "Cannot find output parameter by name.", ex);
            throw PreparedStatement.newException("odaconsumer.CannotFindOutParameter", paramName, ex);
        }
        return 0;
    }

    public int getParameterType(int paramIndex) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "getParameterType( int )", paramIndex);
        ParameterMetaData paramMD = this.getParameterMetaData(paramIndex);
        assert (paramMD != null);
        int ret = paramMD.getDataType();
        PreparedStatement.getLogger().exiting(sm_className, "getParameterType( int )", ret);
        return ret;
    }

    public int getParameterType(String paramName) throws DataException {
        ParameterName paramNameObj = new ParameterName(paramName, this);
        return this.getParameterType(paramNameObj, true);
    }

    private int getParameterType(ParameterName paramName, boolean retryByIndex) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "getParameterType( ParameterName )", paramName);
        ParameterMetaData paramMD = this.getParameterMetaData(paramName);
        if (paramMD != null) {
            int dataTypeCode = paramMD.getDataType();
            PreparedStatement.getLogger().exiting(sm_className, "getParameterType( ParameterName )", dataTypeCode);
            return dataTypeCode;
        }
        int parameterType = 0;
        if (retryByIndex) {
            int paramPos = this.getIndexFromParamHints(paramName.getRomName());
            if (paramPos <= 0) {
                this.throwError("odaconsumer.CannotGetParameterType", paramName, "getParameterType( ParameterName )");
            }
            parameterType = this.getParameterType(paramPos);
        } else {
            parameterType = this.getOdaTypeFromParamHints(paramName.getRomName(), 0);
        }
        PreparedStatement.getLogger().exiting(sm_className, "getParameterType( ParameterName )", parameterType);
        return parameterType;
    }

    public Object getParameterValue(int paramIndex) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "getParameterValue( int )", paramIndex);
        Object ret = this.getParameterValue(null, paramIndex);
        PreparedStatement.getLogger().exiting(sm_className, "getParameterValue( int )", ret);
        return ret;
    }

    public Object getParameterValue(String paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "getParameterValue( String )", paramName);
        Object ret = this.getParameterValue(paramName, 0);
        PreparedStatement.getLogger().exiting(sm_className, "getParameterValue( String )", ret);
        return ret;
    }

    public void cancel() throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "cancel");
        try {
            this.m_statement.cancel();
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotCancelStatement", "cancel");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.throwUnsupportedException("odaconsumer.CannotCancelStatement", "cancel");
        }
        PreparedStatement.getLogger().exiting(sm_className, "cancel");
    }

    public void close() throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "close");
        this.flushResultSets();
        this.resetCachedResultSets();
        this.resetResultsAndMetaData();
        try {
            this.m_statement.close();
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotCloseStatement", "close");
        }
        catch (UnsupportedOperationException ex) {
            PreparedStatement.getLogger().logp(Level.WARNING, sm_className, "close", "Cannot close statement.", ex);
        }
        PreparedStatement.getLogger().exiting(sm_className, "close");
    }

    private void flushResultSets() {
        try {
            while (this.getMoreResults()) {
            }
        }
        catch (DataException dataException) {}
    }

    private void resetResultsAndMetaData() {
        PreparedStatement.getLogger().entering(sm_className, "resetResultsAndMetaData");
        this.resetCurrentResultAndMetaData();
        if (this.m_namedCurrentResultSets != null) {
            this.m_namedCurrentResultSets.clear();
        }
        if (this.m_namedCurrentResultClasses != null) {
            this.m_namedCurrentResultClasses.clear();
        }
        if (this.m_seqResultSetHdlr != null) {
            this.m_seqResultSetHdlr.resetResultSetsState();
        }
        PreparedStatement.getLogger().exiting(sm_className, "resetResultsAndMetaData");
    }

    public void addColumnHint(ColumnHint columnHint) throws DataException {
        String methodName = "addColumnHint";
        PreparedStatement.getLogger().entering(sm_className, methodName, columnHint);
        if (columnHint != null) {
            this.getProjectedColumns().addHint(columnHint);
        }
        PreparedStatement.getLogger().exiting(sm_className, methodName);
    }

    public void addColumnHint(String resultSetName, ColumnHint columnHint) throws DataException {
        String methodName = "addColumnHint";
        if (PreparedStatement.getLogger().isLoggingEnterExitLevel()) {
            PreparedStatement.getLogger().entering(sm_className, methodName, new Object[]{resultSetName, columnHint});
        }
        this.validateNamedResultsSupport();
        if (columnHint != null) {
            this.getProjectedColumns(resultSetName).addHint(columnHint);
        }
        PreparedStatement.getLogger().exiting(sm_className, methodName);
    }

    public void addColumnHint(int resultSetNum, ColumnHint columnHint) throws DataException {
        this.getSequentialResultHandler().addColumnHint(resultSetNum, columnHint);
    }

    private ArrayList getParameterHints() {
        if (this.m_parameterHints == null) {
            this.m_parameterHints = new ArrayList();
        }
        return this.m_parameterHints;
    }

    public void addParameterHint(ParameterHint paramHint) throws DataException {
        String methodName = "addParameterHint";
        PreparedStatement.getLogger().entering(sm_className, methodName, paramHint);
        if (paramHint != null) {
            this.validateAndAddParameterHint(paramHint);
            this.m_parameterMetaData = null;
        }
        PreparedStatement.getLogger().exiting(sm_className, methodName);
    }

    private void validateAndAddParameterHint(ParameterHint newParameterHint) throws DataException {
        String methodName = "validateAndAddParameterHint";
        PreparedStatement.getLogger().entering(sm_className, methodName, newParameterHint);
        ArrayList parameterHintsList = this.getParameterHints();
        String newParamHintName = newParameterHint.getName();
        int newParamHintIndex = newParameterHint.getPosition();
        int i = 0;
        int n = parameterHintsList.size();
        while (i < n) {
            block6: {
                int existingParamHintIndex;
                String existingParamHintName;
                ParameterHint existingParamHint;
                block5: {
                    existingParamHint = (ParameterHint)parameterHintsList.get(i);
                    existingParamHintName = existingParamHint.getName();
                    if (existingParamHintName.equals(newParamHintName)) break block5;
                    int existingParamHintPosition = existingParamHint.getPosition();
                    if (newParamHintIndex == 0 || existingParamHintPosition != newParamHintIndex) break block6;
                    this.throwError("odaconsumer.DifferentParamNameForSamePosition", new Object[]{existingParamHintName, existingParamHintPosition}, methodName);
                }
                if ((existingParamHintIndex = existingParamHint.getPosition()) != newParamHintIndex && existingParamHintIndex > 0 && newParamHintIndex > 0) {
                    this.throwError("odaconsumer.SameParamNameForDifferentHints", existingParamHintName, methodName);
                }
                existingParamHint.updateHint(newParameterHint);
                PreparedStatement.getLogger().logp(Level.FINE, sm_className, methodName, "Updating parameter hint with attributes in another hint that has the same name ({0}).", existingParamHintName);
                PreparedStatement.getLogger().exiting(sm_className, methodName);
                return;
            }
            ++i;
        }
        parameterHintsList.add(newParameterHint);
        PreparedStatement.getLogger().exiting(sm_className, methodName);
    }

    public void setColumnsProjection(String[] projectedNames) throws DataException {
        String methodName = "setColumnsProjection";
        PreparedStatement.getLogger().entering(sm_className, methodName, projectedNames);
        this.resetCurrentResultAndMetaData();
        this.getProjectedColumns().setProjectedNames(projectedNames);
        PreparedStatement.getLogger().exiting(sm_className, methodName);
    }

    public void setColumnsProjection(String resultSetName, String[] projectedNames) throws DataException {
        String methodName = "setColumnsProjection";
        if (PreparedStatement.getLogger().isLoggingEnterExitLevel()) {
            PreparedStatement.getLogger().entering(sm_className, methodName, new Object[]{resultSetName, projectedNames});
        }
        this.validateNamedResultsSupport();
        this.resetResultAndMetaData(resultSetName);
        this.getProjectedColumns(resultSetName).setProjectedNames(projectedNames);
        PreparedStatement.getLogger().exiting(sm_className, methodName);
    }

    public void setColumnsProjection(int resultSetNum, String[] projectedNames) throws DataException {
        this.getSequentialResultHandler().setColumnsProjection(resultSetNum, projectedNames);
    }

    public void declareCustomColumn(String columnName, Class columnType) throws DataException {
        String methodName = "declareCustomColumn";
        if (PreparedStatement.getLogger().isLoggingEnterExitLevel()) {
            PreparedStatement.getLogger().entering(sm_className, methodName, new Object[]{columnName, columnType});
        }
        assert (columnName != null);
        assert (columnName.length() != 0);
        this.resetCurrentResultAndMetaData();
        this.getProjectedColumns().addCustomColumn(columnName, columnType);
        PreparedStatement.getLogger().exiting(sm_className, methodName);
    }

    public void declareCustomColumn(String resultSetName, String columnName, Class columnType) throws DataException {
        String methodName = "declareCustomColumn";
        if (PreparedStatement.getLogger().isLoggingEnterExitLevel()) {
            PreparedStatement.getLogger().entering(sm_className, methodName, new Object[]{resultSetName, columnName, columnType});
        }
        this.validateNamedResultsSupport();
        assert (columnName != null);
        assert (columnName.length() != 0);
        this.resetResultAndMetaData(resultSetName);
        this.getProjectedColumns(resultSetName).addCustomColumn(columnName, columnType);
        PreparedStatement.getLogger().exiting(sm_className, methodName);
    }

    public void declareCustomColumn(int resultSetNum, String columnName, Class columnType) throws DataException {
        this.getSequentialResultHandler().declareCustomColumn(resultSetNum, columnName, columnType);
    }

    private void resetCurrentResultAndMetaData() {
        PreparedStatement.getLogger().entering(sm_className, "resetCurrentResultAndMetaData");
        this.m_currentResultClass = null;
        this.m_currentResultSet = null;
        PreparedStatement.getLogger().exiting(sm_className, "resetCurrentResultAndMetaData");
    }

    private void resetResultAndMetaData(String resultSetName) {
        PreparedStatement.getLogger().entering(sm_className, "resetResultAndMetaData(String)", resultSetName);
        this.getNamedCurrentResultClasses().remove(resultSetName);
        this.getNamedCurrentResultSets().remove(resultSetName);
        PreparedStatement.getLogger().exiting(sm_className, "resetResultAndMetaData(String)");
    }

    private Hashtable getNamedProjectedColumns() {
        if (this.m_namedProjectedColumns == null) {
            this.m_namedProjectedColumns = PropertySecurity.createHashtable();
        }
        return this.m_namedProjectedColumns;
    }

    private Hashtable getNamedCurrentResultClasses() {
        if (this.m_namedCurrentResultClasses == null) {
            this.m_namedCurrentResultClasses = PropertySecurity.createHashtable();
        }
        return this.m_namedCurrentResultClasses;
    }

    private Hashtable getNamedCurrentResultSets() {
        if (this.m_namedCurrentResultSets == null) {
            this.m_namedCurrentResultSets = PropertySecurity.createHashtable();
        }
        return this.m_namedCurrentResultSets;
    }

    private IQuery getStatement() {
        return this.m_statement;
    }

    private IAdvancedQuery getAdvancedStatement() {
        assert (this.isAdvancedQuery());
        return (IAdvancedQuery)this.m_statement;
    }

    private boolean isAdvancedQuery() {
        return this.m_statement instanceof IAdvancedQuery;
    }

    public boolean supportsNamedResults() throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "supportsNamedResults");
        if (this.m_supportsNamedResults == null) {
            boolean isSupported = this.isAdvancedQuery() && this.m_connection.getMetaData(this.m_dataSetType).supportsNamedResultSets();
            this.m_supportsNamedResults = isSupported;
        }
        PreparedStatement.getLogger().exiting(sm_className, "supportsNamedResults", this.m_supportsNamedResults);
        return this.m_supportsNamedResults;
    }

    private boolean supportsInputParameter() throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "supportsInputParameter");
        if (this.m_supportsInputParameters == null) {
            this.m_supportsInputParameters = this.m_connection.getMetaData(this.m_dataSetType).supportsInParameters();
        }
        PreparedStatement.getLogger().exiting(sm_className, "supportsInputParameter", this.m_supportsInputParameters);
        return this.m_supportsInputParameters;
    }

    private boolean supportsOutputParameter() throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "supportsOutputParameter");
        if (this.m_supportsOutputParameters == null) {
            boolean isSupported = this.isAdvancedQuery() && this.m_connection.getMetaData(this.m_dataSetType).supportsOutParameters();
            this.m_supportsOutputParameters = isSupported;
        }
        PreparedStatement.getLogger().exiting(sm_className, "supportsOutputParameter", this.m_supportsOutputParameters);
        return this.m_supportsOutputParameters;
    }

    public boolean supportsNamedParameter() throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "supportsNamedParameter");
        if (this.m_supportsNamedParameters == null) {
            boolean isSupported = this.m_connection.getMetaData(this.m_dataSetType).supportsNamedParameters();
            this.m_supportsNamedParameters = isSupported;
        }
        PreparedStatement.getLogger().exiting(sm_className, "supportsNamedParameter", this.m_supportsNamedParameters);
        return this.m_supportsNamedParameters;
    }

    public boolean supportsMultipleResultSets() throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "supportsMultipleResultSets");
        if (this.m_supportsMultipleResultSets == null) {
            boolean isSupported = this.isAdvancedQuery() && this.m_connection.getMetaData(this.m_dataSetType).supportsMultipleResultSets();
            this.m_supportsMultipleResultSets = isSupported;
        }
        PreparedStatement.getLogger().exiting(sm_className, "supportsMultipleResultSets", this.m_supportsMultipleResultSets);
        return this.m_supportsMultipleResultSets;
    }

    private void validateNamedResultsSupport() throws DataException {
        if (!this.supportsNamedResults()) {
            this.throwUnsupportedException("odaconsumer.NamedResultSetsUnsupported", "validateNamedResultsSupport");
        }
    }

    public Collection getParameterMetaData() throws DataException {
        String methodName = "getParameterMetaData";
        PreparedStatement.getLogger().entering(sm_className, methodName);
        if (this.m_parameterMetaData == null) {
            IParameterMetaData odaParamMetaData;
            block4: {
                if (!this.supportsInputParameter() && !this.supportsOutputParameter()) {
                    PreparedStatement.getLogger().logp(Level.INFO, sm_className, methodName, "The ODA driver does not support any type of parameters (IDataSetMetaData); no metadata is available.");
                    PreparedStatement.getLogger().exiting(sm_className, methodName, null);
                    return null;
                }
                odaParamMetaData = null;
                try {
                    odaParamMetaData = this.getOdaDriverParamMetaData();
                }
                catch (DataException e) {
                    if (this.m_parameterHints != null && this.m_parameterHints.size() > 0) break block4;
                    throw e;
                }
            }
            this.m_parameterMetaData = odaParamMetaData == null ? this.mergeParamHints() : this.mergeParamHintsWithMetaData(odaParamMetaData);
        }
        PreparedStatement.getLogger().exiting(sm_className, methodName, this.m_parameterMetaData);
        return this.m_parameterMetaData;
    }

    private ParameterMetaData getParameterMetaData(int paramIndex) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "getParameterMetaData( int )", paramIndex);
        Collection allParamsMetadata = null;
        if (paramIndex > 0) {
            allParamsMetadata = this.getParameterMetaData();
        }
        if (allParamsMetadata != null) {
            for (ParameterMetaData aParamMetaData : allParamsMetadata) {
                if (aParamMetaData.getPosition() != paramIndex) continue;
                PreparedStatement.getLogger().exiting(sm_className, "getParameterMetaData( int )", aParamMetaData);
                return aParamMetaData;
            }
        }
        this.throwError("odaconsumer.CannotGetParameterMetaData", paramIndex, "getParameterMetaData( int )");
        return null;
    }

    private ParameterMetaData getParameterMetaData(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "getParameterMetaData( ParameterName )", paramName);
        ParameterMetaData aParamMetaData = PreparedStatement.findParameterMetaDataByName(this.getParameterMetaData(), paramName);
        PreparedStatement.getLogger().exiting(sm_className, "getParameterMetaData( ParameterName )", aParamMetaData);
        return aParamMetaData;
    }

    private String getNativeNameFromParameterMetaData(String romParamName) {
        ParameterMetaData effectiveParamMd = null;
        try {
            effectiveParamMd = PreparedStatement.findParameterMetaDataByName(this.getParameterMetaData(), romParamName, false);
        }
        catch (DataException dataException) {}
        return effectiveParamMd != null ? effectiveParamMd.getNativeName() : null;
    }

    private IParameterMetaData getOdaDriverParamMetaData() throws DataException {
        String methodName = "getOdaDriverParamMetaData";
        PreparedStatement.getLogger().entering(sm_className, methodName);
        IParameterMetaData odaParamMetaData = null;
        try {
            odaParamMetaData = this.m_statement.getParameterMetaData();
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotGetParameterMetaData", methodName);
        }
        catch (UnsupportedOperationException ex) {
            PreparedStatement.getLogger().logp(Level.WARNING, sm_className, methodName, "The ODA driver is not capable of providing parameter metadata.", ex);
        }
        PreparedStatement.getLogger().exiting(sm_className, methodName, odaParamMetaData);
        return odaParamMetaData;
    }

    private Collection mergeParamHints() throws DataException {
        String methodName = "mergeParamHints";
        PreparedStatement.getLogger().entering(sm_className, methodName);
        ArrayList parameterMetaData = null;
        if (this.m_parameterHints != null && this.m_parameterHints.size() > 0) {
            parameterMetaData = new ArrayList();
            this.addParameterHints(parameterMetaData, this.m_parameterHints);
        }
        PreparedStatement.getLogger().exiting(sm_className, methodName, parameterMetaData);
        return parameterMetaData;
    }

    private void addParameterHints(List parameterMetaData, List parameterHints) {
        String methodName = "addParameterHints";
        if (PreparedStatement.getLogger().isLoggingEnterExitLevel()) {
            PreparedStatement.getLogger().entering(sm_className, methodName, new Object[]{parameterMetaData, parameterHints});
        }
        ListIterator iter = parameterHints.listIterator();
        while (iter.hasNext()) {
            ParameterHint paramHint = (ParameterHint)iter.next();
            ParameterMetaData paramMd = new ParameterMetaData(paramHint, this.m_connection.getDataSourceId(), this.m_dataSetType);
            parameterMetaData.add(paramMd);
        }
        PreparedStatement.getLogger().exiting(sm_className, methodName);
    }

    private Collection mergeParamHintsWithMetaData(IParameterMetaData runtimeParamMetaData) throws DataException {
        String methodName = "mergeParamHintsWithMetaData";
        PreparedStatement.getLogger().entering(sm_className, methodName, runtimeParamMetaData);
        assert (runtimeParamMetaData != null);
        int numOfParameters = this.doGetParameterCount(runtimeParamMetaData);
        ArrayList<ParameterMetaData> paramMetaData = new ArrayList<ParameterMetaData>(numOfParameters);
        int i = 1;
        while (i <= numOfParameters) {
            ParameterMetaData paramMd = new ParameterMetaData(runtimeParamMetaData, i, this.m_connection.getDataSourceId(), this.m_dataSetType);
            paramMetaData.add(paramMd);
            ++i;
        }
        if (this.m_parameterHints != null && this.m_parameterHints.size() > 0) {
            this.updateWithParameterHints(paramMetaData, this.m_parameterHints);
        }
        PreparedStatement.getLogger().exiting(sm_className, methodName, paramMetaData);
        return paramMetaData;
    }

    private int doGetParameterCount(IParameterMetaData runtimeParamMetaData) throws DataException {
        String methodName = "doGetParameterCount";
        PreparedStatement.getLogger().entering(sm_className, methodName, runtimeParamMetaData);
        try {
            int ret = runtimeParamMetaData.getParameterCount();
            PreparedStatement.getLogger().exiting(sm_className, methodName, ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotGetParameterCount", methodName);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.throwUnsupportedException("odaconsumer.CannotGetParameterCount", methodName);
        }
        return 0;
    }

    private void updateWithParameterHints(List parametersMetaData, List parameterHints) throws DataException {
        if (PreparedStatement.getLogger().isLoggingEnterExitLevel()) {
            PreparedStatement.getLogger().entering(sm_className, "updateWithParameterHints", new Object[]{parametersMetaData, parameterHints});
        }
        if (parametersMetaData == null || parametersMetaData.isEmpty() || parameterHints == null || parameterHints.isEmpty()) {
            PreparedStatement.getLogger().exiting(sm_className, "updateWithParameterHints");
            return;
        }
        ListIterator iter = parameterHints.listIterator();
        while (iter.hasNext()) {
            ParameterHint paramHint = (ParameterHint)iter.next();
            ParameterMetaData paramMd = this.findParameterMetaData(parametersMetaData, paramHint);
            if (paramMd == null) continue;
            paramMd.updateWith(paramHint, this.m_connection.getDataSourceId(), this.m_dataSetType);
        }
        PreparedStatement.getLogger().exiting(sm_className, "updateWithParameterHints");
    }

    private ParameterMetaData findParameterMetaData(List parametersMetaData, ParameterHint paramHint) throws DataException {
        String paramHintNativeName = paramHint.getNativeName();
        int position = 0;
        if (PreparedStatement.hasValue(paramHintNativeName)) {
            ParameterMetaData paramMd = PreparedStatement.findParameterMetaDataByName(parametersMetaData, paramHintNativeName, true);
            if (paramMd != null) {
                return paramMd;
            }
            if (paramHint.isInputMode()) {
                position = this.getRuntimeParameterIndexFromName(paramHintNativeName, true);
            }
            if (paramHint.isOutputMode() && (position <= 0 || position > parametersMetaData.size())) {
                position = this.getRuntimeParameterIndexFromName(paramHintNativeName, false);
            }
        }
        int numOfRuntimeParameters = parametersMetaData.size();
        if (position <= 0 || position > numOfRuntimeParameters) {
            position = paramHint.getPosition();
        }
        if (position <= 0 || position > numOfRuntimeParameters) {
            return null;
        }
        return (ParameterMetaData)parametersMetaData.get(position - 1);
    }

    private static ParameterMetaData findParameterMetaDataByName(Collection parametersMetaData, ParameterName paramName) {
        if (paramName == null) {
            return null;
        }
        ParameterMetaData paramMd = PreparedStatement.findParameterMetaDataByName(parametersMetaData, paramName.getNativeName(), true);
        if (paramMd == null) {
            paramMd = PreparedStatement.findParameterMetaDataByName(parametersMetaData, paramName.getRomName(), false);
        }
        if (paramMd == null) {
            paramMd = PreparedStatement.findParameterMetaDataByName(parametersMetaData, paramName.getEffectiveName(), true);
        }
        return paramMd;
    }

    private static ParameterMetaData findParameterMetaDataByName(Collection parametersMetaData, String paramName, boolean useNativeName) {
        if (parametersMetaData == null || parametersMetaData.isEmpty() || !PreparedStatement.hasValue(paramName)) {
            return null;
        }
        for (ParameterMetaData paramMd : parametersMetaData) {
            if (useNativeName && paramName.equals(paramMd.getNativeName())) {
                return paramMd;
            }
            if (useNativeName || !paramName.equals(paramMd.getName())) continue;
            return paramMd;
        }
        return null;
    }

    private int getRuntimeParameterIndexFromName(String paramName, boolean forInput) throws DataException {
        String methodName = "getRuntimeParameterIndexFromName";
        if (PreparedStatement.getLogger().isLoggingEnterExitLevel()) {
            PreparedStatement.getLogger().entering(sm_className, methodName, new Object[]{paramName, forInput});
        }
        if (forInput) {
            try {
                int ret = this.findInParameter(paramName);
                PreparedStatement.getLogger().exiting(sm_className, methodName, ret);
                return ret;
            }
            catch (DataException ex) {
                if (ex.getCause() instanceof UnsupportedOperationException) {
                    PreparedStatement.getLogger().exiting(sm_className, methodName, 0);
                    return 0;
                }
                PreparedStatement.getLogger().logp(Level.SEVERE, sm_className, methodName, "Cannot get runtime parameter index.", (Throwable)((Object)ex));
                throw ex;
            }
        }
        try {
            int ret = this.findOutParameter(paramName);
            PreparedStatement.getLogger().exiting(sm_className, methodName, ret);
            return ret;
        }
        catch (DataException ex) {
            if (ex.getCause() instanceof UnsupportedOperationException) {
                PreparedStatement.getLogger().exiting(sm_className, methodName, 0);
                return 0;
            }
            PreparedStatement.getLogger().logp(Level.SEVERE, sm_className, methodName, "Cannot get runtime parameter index.", (Throwable)((Object)ex));
            throw ex;
        }
    }

    private void validateOutputParameterSupport() throws DataException {
        if (!this.supportsOutputParameter()) {
            this.throwUnsupportedException("odaconsumer.OutputParameterUnsupported", "validateOutputParameterSupport");
        }
    }

    private Object getParameterValue(String paramName, int paramIndex) throws DataException {
        if (PreparedStatement.getLogger().isLoggingEnterExitLevel()) {
            PreparedStatement.getLogger().entering(sm_className, "getParameterValue( String, int )", new Object[]{paramName, paramIndex});
        }
        this.validateOutputParameterSupport();
        ParameterName paramNameObj = null;
        if (paramName != null) {
            paramNameObj = new ParameterName(paramName, this);
            paramNameObj.logNullNativeName();
        }
        Object paramValue = null;
        int paramType = paramNameObj == null ? this.getParameterType(paramIndex) : this.getParameterType(paramNameObj, false);
        switch (paramType) {
            case 4: {
                int i;
                int n = i = paramNameObj == null ? this.doGetInt(paramIndex) : this.getInt(paramNameObj);
                if (this.wasNull()) break;
                paramValue = i;
                break;
            }
            case 8: {
                double d;
                double d2 = d = paramNameObj == null ? this.doGetDouble(paramIndex) : this.getDouble(paramNameObj);
                if (this.wasNull()) break;
                paramValue = new Double(d);
                break;
            }
            case 1: {
                paramValue = paramNameObj == null ? this.doGetString(paramIndex) : this.getString(paramNameObj);
                break;
            }
            case 3: {
                paramValue = paramNameObj == null ? this.doGetBigDecimal(paramIndex) : this.getBigDecimal(paramNameObj);
                break;
            }
            case 91: {
                paramValue = paramNameObj == null ? this.doGetDate(paramIndex) : this.getDate(paramNameObj);
                break;
            }
            case 92: {
                paramValue = paramNameObj == null ? this.doGetTime(paramIndex) : this.getTime(paramNameObj);
                break;
            }
            case 93: {
                paramValue = paramNameObj == null ? this.doGetTimestamp(paramIndex) : this.getTimestamp(paramNameObj);
                break;
            }
            case 2004: {
                paramValue = paramNameObj == null ? this.doGetBlob(paramIndex) : this.getBlob(paramNameObj);
                break;
            }
            case 2005: {
                paramValue = paramNameObj == null ? this.doGetClob(paramIndex) : this.getClob(paramNameObj);
                break;
            }
            case 16: {
                paramValue = paramNameObj == null ? this.doGetBoolean(paramIndex) : this.getBoolean(paramNameObj);
                break;
            }
            case 2000: {
                paramValue = paramNameObj == null ? this.doGetObject(paramIndex) : this.getObject(paramNameObj);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        Object ret = this.wasNull() ? null : paramValue;
        PreparedStatement.getLogger().exiting(sm_className, "getParameterValue( String, int )", ret);
        return ret;
    }

    private int getInt(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "getInt( ParameterName )", paramName);
        int ret = 0;
        if (!this.supportsNamedParameter()) {
            int paramIndex = this.getIndexFromParamHints(paramName.getRomName());
            if (paramIndex > 0) {
                ret = this.doGetInt(paramIndex);
            }
        } else {
            ret = this.doGetInt(paramName);
        }
        PreparedStatement.getLogger().exiting(sm_className, "getInt( ParameterName )", ret);
        return ret;
    }

    private double getDouble(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "getDouble( ParameterName )", paramName);
        double ret = 0.0;
        if (!this.supportsNamedParameter()) {
            int paramIndex = this.getIndexFromParamHints(paramName.getRomName());
            if (paramIndex > 0) {
                ret = this.doGetDouble(paramIndex);
            }
        } else {
            ret = this.doGetDouble(paramName);
        }
        if (PreparedStatement.getLogger().isLoggingEnterExitLevel()) {
            PreparedStatement.getLogger().exiting(sm_className, "getDouble( ParameterName )", new Double(ret));
        }
        return ret;
    }

    private String getString(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "getString( ParameterName )", paramName);
        String ret = null;
        if (!this.supportsNamedParameter()) {
            int paramIndex = this.getIndexFromParamHints(paramName.getRomName());
            if (paramIndex > 0) {
                ret = this.doGetString(paramIndex);
            }
        } else {
            ret = this.doGetString(paramName);
        }
        PreparedStatement.getLogger().exiting(sm_className, "getString( ParameterName )", ret);
        return ret;
    }

    private BigDecimal getBigDecimal(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "getBigDecimal( ParameterName )", paramName);
        BigDecimal ret = null;
        if (!this.supportsNamedParameter()) {
            int paramIndex = this.getIndexFromParamHints(paramName.getRomName());
            if (paramIndex > 0) {
                ret = this.doGetBigDecimal(paramIndex);
            }
        } else {
            ret = this.doGetBigDecimal(paramName);
        }
        PreparedStatement.getLogger().exiting(sm_className, "getBigDecimal( ParameterName )", ret);
        return ret;
    }

    private java.util.Date getDate(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "getDate( ParameterName )", paramName);
        java.util.Date ret = null;
        if (!this.supportsNamedParameter()) {
            int paramIndex = this.getIndexFromParamHints(paramName.getRomName());
            if (paramIndex > 0) {
                ret = this.doGetDate(paramIndex);
            }
        } else {
            ret = this.doGetDate(paramName);
        }
        PreparedStatement.getLogger().exiting(sm_className, "getDate( ParameterName )", ret);
        return ret;
    }

    private Time getTime(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "getTime( ParameterName )", paramName);
        Time ret = null;
        if (!this.supportsNamedParameter()) {
            int paramIndex = this.getIndexFromParamHints(paramName.getRomName());
            if (paramIndex > 0) {
                ret = this.doGetTime(paramIndex);
            }
        } else {
            ret = this.doGetTime(paramName);
        }
        PreparedStatement.getLogger().exiting(sm_className, "getTime( ParameterName )", ret);
        return ret;
    }

    private Timestamp getTimestamp(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "getTimestamp( ParameterName )", paramName);
        Timestamp ret = null;
        if (!this.supportsNamedParameter()) {
            int paramIndex = this.getIndexFromParamHints(paramName.getRomName());
            if (paramIndex > 0) {
                ret = this.doGetTimestamp(paramIndex);
            }
        } else {
            ret = this.doGetTimestamp(paramName);
        }
        PreparedStatement.getLogger().exiting(sm_className, "getTimestamp( ParameterName )", ret);
        return ret;
    }

    private IBlob getBlob(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "getBlob( ParameterName )", paramName);
        IBlob ret = null;
        if (!this.supportsNamedParameter()) {
            int paramIndex = this.getIndexFromParamHints(paramName.getRomName());
            if (paramIndex > 0) {
                ret = this.doGetBlob(paramIndex);
            }
        } else {
            ret = this.doGetBlob(paramName);
        }
        PreparedStatement.getLogger().exiting(sm_className, "getBlob( ParameterName )", ret);
        return ret;
    }

    private IClob getClob(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "getClob( ParameterName )", paramName);
        IClob ret = null;
        if (!this.supportsNamedParameter()) {
            int paramIndex = this.getIndexFromParamHints(paramName.getRomName());
            if (paramIndex > 0) {
                ret = this.doGetClob(paramIndex);
            }
        } else {
            ret = this.doGetClob(paramName);
        }
        PreparedStatement.getLogger().exiting(sm_className, "getClob( ParameterName )", ret);
        return ret;
    }

    private Boolean getBoolean(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "getBoolean( ParameterName )", paramName);
        Boolean ret = null;
        if (!this.supportsNamedParameter()) {
            int paramIndex = this.getIndexFromParamHints(paramName.getRomName());
            if (paramIndex > 0) {
                ret = this.doGetBoolean(paramIndex);
            }
        } else {
            ret = this.doGetBoolean(paramName);
        }
        PreparedStatement.getLogger().exiting(sm_className, "getBoolean( ParameterName )", ret);
        return ret;
    }

    private Object getObject(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "getObject( ParameterName )", paramName);
        Object ret = null;
        if (!this.supportsNamedParameter()) {
            int paramIndex = this.getIndexFromParamHints(paramName.getRomName());
            if (paramIndex > 0) {
                ret = this.doGetObject(paramIndex);
            }
        } else {
            ret = this.doGetObject(paramName);
        }
        PreparedStatement.getLogger().exiting(sm_className, "getObject( ParameterName )", ret);
        return ret;
    }

    private int doGetInt(int paramIndex) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetInt( int )", paramIndex);
        try {
            int ret = this.getAdvancedStatement().getInt(paramIndex);
            PreparedStatement.getLogger().exiting(sm_className, "doGetInt( int )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetIntFromParameter", paramIndex, "doGetInt( int )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetIntFromParameter", paramIndex, "doGetInt( int )");
        }
        return 0;
    }

    private int doGetInt(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetInt( ParameterName )", paramName);
        String effectiveParamName = paramName.getEffectiveName();
        try {
            int ret = this.getAdvancedStatement().getInt(effectiveParamName);
            PreparedStatement.getLogger().exiting(sm_className, "doGetInt( ParameterName )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetIntFromParameter", effectiveParamName, "doGetInt( ParameterName )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetIntFromParameter", effectiveParamName, "doGetInt( ParameterName )");
        }
        return 0;
    }

    private double doGetDouble(int paramIndex) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetDouble( int )", paramIndex);
        try {
            double ret = this.getAdvancedStatement().getDouble(paramIndex);
            if (PreparedStatement.getLogger().isLoggingEnterExitLevel()) {
                PreparedStatement.getLogger().exiting(sm_className, "doGetDouble( int )", new Double(ret));
            }
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetDoubleFromParameter", paramIndex, "doGetDouble( int )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetDoubleFromParameter", paramIndex, "doGetDouble( int )");
        }
        return 0.0;
    }

    private double doGetDouble(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetDouble( ParameterName )", paramName);
        String effectiveParamName = paramName.getEffectiveName();
        try {
            double ret = this.getAdvancedStatement().getDouble(effectiveParamName);
            if (PreparedStatement.getLogger().isLoggingEnterExitLevel()) {
                PreparedStatement.getLogger().exiting(sm_className, "doGetDouble( ParameterName )", new Double(ret));
            }
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetDoubleFromParameter", effectiveParamName, "doGetDouble( ParameterName )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetDoubleFromParameter", effectiveParamName, "doGetDouble( ParameterName )");
        }
        return 0.0;
    }

    private String doGetString(int paramIndex) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetString( int )", paramIndex);
        try {
            String ret = this.getAdvancedStatement().getString(paramIndex);
            PreparedStatement.getLogger().exiting(sm_className, "doGetString( int )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetStringFromParameter", paramIndex, "doGetString( int )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetStringFromParameter", paramIndex, "doGetString( int )");
        }
        return null;
    }

    private String doGetString(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetString( ParameterName )", paramName);
        String effectiveParamName = paramName.getEffectiveName();
        try {
            String ret = this.getAdvancedStatement().getString(effectiveParamName);
            PreparedStatement.getLogger().exiting(sm_className, "doGetString( ParameterName )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetStringFromParameter", effectiveParamName, "doGetString( ParameterName )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetStringFromParameter", effectiveParamName, "doGetString( ParameterName )");
        }
        return null;
    }

    private BigDecimal doGetBigDecimal(int paramIndex) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetBigDecimal( int )", paramIndex);
        try {
            BigDecimal ret = this.getAdvancedStatement().getBigDecimal(paramIndex);
            PreparedStatement.getLogger().exiting(sm_className, "doGetBigDecimal( int )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetBigDecimalFromParameter", paramIndex, "doGetBigDecimal( int )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetBigDecimalFromParameter", paramIndex, "doGetBigDecimal( int )");
        }
        return null;
    }

    private BigDecimal doGetBigDecimal(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetBigDecimal( ParameterName )", paramName);
        String effectiveParamName = paramName.getEffectiveName();
        try {
            BigDecimal ret = this.getAdvancedStatement().getBigDecimal(effectiveParamName);
            PreparedStatement.getLogger().exiting(sm_className, "doGetBigDecimal( ParameterName )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetBigDecimalFromParameter", effectiveParamName, "doGetBigDecimal( ParameterName )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetBigDecimalFromParameter", effectiveParamName, "doGetBigDecimal( ParameterName )");
        }
        return null;
    }

    private java.util.Date doGetDate(int paramIndex) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetDate( int )", paramIndex);
        try {
            Date ret = this.getAdvancedStatement().getDate(paramIndex);
            PreparedStatement.getLogger().exiting(sm_className, "doGetDate( int )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetDateFromParameter", paramIndex, "doGetDate( int )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetDateFromParameter", paramIndex, "doGetDate( int )");
        }
        return null;
    }

    private java.util.Date doGetDate(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetDate( ParameterName )", paramName);
        String effectiveParamName = paramName.getEffectiveName();
        try {
            Date ret = this.getAdvancedStatement().getDate(effectiveParamName);
            PreparedStatement.getLogger().exiting(sm_className, "doGetDate( ParameterName )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetDateFromParameter", effectiveParamName, "doGetDate( ParameterName )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetDateFromParameter", effectiveParamName, "doGetDate( ParameterName )");
        }
        return null;
    }

    private Time doGetTime(int paramIndex) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetTime( int )", paramIndex);
        try {
            Time ret = this.getAdvancedStatement().getTime(paramIndex);
            PreparedStatement.getLogger().exiting(sm_className, "doGetTime( int )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetTimeFromParameter", paramIndex, "doGetTime( int )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetTimeFromParameter", paramIndex, "doGetTime( int )");
        }
        return null;
    }

    private Time doGetTime(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetTime( ParameterName )", paramName);
        String effectiveParamName = paramName.getEffectiveName();
        try {
            Time ret = this.getAdvancedStatement().getTime(effectiveParamName);
            PreparedStatement.getLogger().exiting(sm_className, "doGetTime( ParameterName )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetTimeFromParameter", effectiveParamName, "doGetTime( ParameterName )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetTimeFromParameter", effectiveParamName, "doGetTime( ParameterName )");
        }
        return null;
    }

    private Timestamp doGetTimestamp(int paramIndex) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetTimestamp( int )", paramIndex);
        try {
            Timestamp ret = this.getAdvancedStatement().getTimestamp(paramIndex);
            PreparedStatement.getLogger().exiting(sm_className, "doGetTimestamp( int )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetTimestampFromParameter", paramIndex, "doGetTimestamp( int )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetTimestampFromParameter", paramIndex, "doGetTimestamp( int )");
        }
        return null;
    }

    private Timestamp doGetTimestamp(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetTimestamp( ParameterName )", paramName);
        String effectiveParamName = paramName.getEffectiveName();
        try {
            Timestamp ret = this.getAdvancedStatement().getTimestamp(effectiveParamName);
            PreparedStatement.getLogger().exiting(sm_className, "doGetTimestamp( ParameterName )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetTimestampFromParameter", effectiveParamName, "doGetTimestamp( ParameterName )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetTimestampFromParameter", effectiveParamName, "doGetTimestamp( ParameterName )");
        }
        return null;
    }

    private IBlob doGetBlob(int paramIndex) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetBlob( int )", paramIndex);
        try {
            IBlob ret = this.getAdvancedStatement().getBlob(paramIndex);
            PreparedStatement.getLogger().exiting(sm_className, "doGetBlob( int )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetBlobFromParameter", paramIndex, "doGetBlob( int )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetBlobFromParameter", paramIndex, "doGetBlob( int )");
        }
        return null;
    }

    private IBlob doGetBlob(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetBlob( ParameterName )", paramName);
        String effectiveParamName = paramName.getEffectiveName();
        try {
            IBlob ret = this.getAdvancedStatement().getBlob(effectiveParamName);
            PreparedStatement.getLogger().exiting(sm_className, "doGetBlob( ParameterName )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetBlobFromParameter", effectiveParamName, "doGetBlob( ParameterName )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetBlobFromParameter", effectiveParamName, "doGetBlob( ParameterName )");
        }
        return null;
    }

    private IClob doGetClob(int paramIndex) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetClob( int )", paramIndex);
        try {
            IClob ret = this.getAdvancedStatement().getClob(paramIndex);
            PreparedStatement.getLogger().exiting(sm_className, "doGetClob( int )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetClobFromParameter", paramIndex, "doGetClob( int )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetClobFromParameter", paramIndex, "doGetClob( int )");
        }
        return null;
    }

    private IClob doGetClob(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetClob( ParameterName )", paramName);
        String effectiveParamName = paramName.getEffectiveName();
        try {
            IClob ret = this.getAdvancedStatement().getClob(effectiveParamName);
            PreparedStatement.getLogger().exiting(sm_className, "doGetClob( ParameterName )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetClobFromParameter", effectiveParamName, "doGetClob( ParameterName )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetClobFromParameter", effectiveParamName, "doGetClob( ParameterName )");
        }
        return null;
    }

    private Boolean doGetBoolean(int paramIndex) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetBoolean( int )", paramIndex);
        try {
            boolean ret = this.getAdvancedStatement().getBoolean(paramIndex);
            Boolean retObj = this.wasNull() ? null : Boolean.valueOf(ret);
            PreparedStatement.getLogger().exiting(sm_className, "doGetBoolean( int )", retObj);
            return retObj;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetBooleanFromParameter", paramIndex, "doGetBoolean( int )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetBooleanFromParameter", paramIndex, "doGetBoolean( int )");
        }
        return null;
    }

    private Boolean doGetBoolean(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetBoolean( ParameterName )", paramName);
        String effectiveParamName = paramName.getEffectiveName();
        try {
            boolean ret = this.getAdvancedStatement().getBoolean(effectiveParamName);
            Boolean retObj = this.wasNull() ? null : Boolean.valueOf(ret);
            PreparedStatement.getLogger().exiting(sm_className, "doGetBoolean( ParameterName )", retObj);
            return retObj;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetBooleanFromParameter", effectiveParamName, "doGetBoolean( ParameterName )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetBooleanFromParameter", effectiveParamName, "doGetBoolean( ParameterName )");
        }
        return null;
    }

    private Object doGetObject(int paramIndex) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetObject( int )", paramIndex);
        try {
            Object ret = this.getAdvancedStatement().getObject(paramIndex);
            PreparedStatement.getLogger().exiting(sm_className, "doGetObject( int )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetObjectFromParameter", paramIndex, "doGetObject( int )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetObjectFromParameter", paramIndex, "doGetObject( int )");
        }
        return null;
    }

    private Object doGetObject(ParameterName paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "doGetObject( ParameterName )", paramName);
        String effectiveParamName = paramName.getEffectiveName();
        try {
            Object ret = this.getAdvancedStatement().getObject(effectiveParamName);
            PreparedStatement.getLogger().exiting(sm_className, "doGetObject( ParameterName )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetObjectFromParameter", effectiveParamName, "doGetObject( ParameterName )");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetObjectFromParameter", effectiveParamName, "doGetObject( ParameterName )");
        }
        return null;
    }

    private boolean wasNull() throws DataException {
        try {
            return this.getAdvancedStatement().wasNull();
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotDetermineWasNull", "wasNull");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException(ex, "odaconsumer.CannotDetermineWasNull", "wasNull");
        }
        return false;
    }

    private int getOdaTypeFromParamHints(String paramName, int paramIndex) {
        if (this.m_parameterHints == null) {
            return 1;
        }
        ListIterator iter = this.m_parameterHints.listIterator();
        boolean useParamName = paramName != null;
        while (iter.hasNext()) {
            ParameterHint paramHint = (ParameterHint)iter.next();
            if ((!useParamName || !paramHint.getName().equals(paramName)) && (useParamName || paramHint.getPosition() != paramIndex)) continue;
            return paramHint.getEffectiveOdaType(this.m_connection.getDataSourceId(), this.m_dataSetType);
        }
        return 1;
    }

    private int getIndexFromParamHints(String paramName) {
        if (this.m_parameterHints == null) {
            return 0;
        }
        ListIterator iter = this.m_parameterHints.listIterator();
        while (iter.hasNext()) {
            ParameterHint paramHint = (ParameterHint)iter.next();
            if (!paramHint.getName().equals(paramName)) continue;
            return paramHint.getPosition();
        }
        return 0;
    }

    private String getNativeNameFromParamHints(String paramName) {
        if (this.m_parameterHints == null) {
            return null;
        }
        ListIterator iter = this.m_parameterHints.listIterator();
        while (iter.hasNext()) {
            ParameterHint paramHint = (ParameterHint)iter.next();
            if (!paramHint.getName().equals(paramName)) continue;
            return paramHint.getNativeName();
        }
        return null;
    }

    public void clearParameterValues() throws DataException {
        String methodName = "clearParameterValues";
        PreparedStatement.getLogger().entering(sm_className, methodName);
        try {
            this.getStatement().clearInParameters();
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotClearInParameters", methodName);
        }
        catch (AbstractMethodError err) {
            PreparedStatement.getLogger().logp(Level.WARNING, sm_className, methodName, "clearInParameters method undefined.", err);
            this.handleUnsupportedClearInParameters();
        }
        catch (UnsupportedOperationException ex) {
            PreparedStatement.getLogger().logp(Level.WARNING, sm_className, methodName, "clearInParameters is not supported.", ex);
            this.handleUnsupportedClearInParameters();
        }
        this.resetResultsAndMetaData();
        this.m_updateProjectedColumns = true;
        if (this.m_namedProjectedColumns != null) {
            Set keys = this.m_namedProjectedColumns.keySet();
            if (this.m_updateNamedProjectedColumns == null) {
                this.m_updateNamedProjectedColumns = new HashSet(keys);
            } else {
                this.m_updateNamedProjectedColumns.addAll(keys);
            }
        }
        PreparedStatement.getLogger().exiting(sm_className, methodName);
    }

    private void handleUnsupportedClearInParameters() throws DataException {
        ListIterator<Property> iter;
        this.m_statement = this.m_connection.prepareOdaQuery(this.m_queryText, this.m_dataSetType, this.getQuerySpecification());
        if (this.m_properties != null) {
            iter = this.m_properties.listIterator();
            while (iter.hasNext()) {
                Property property = iter.next();
                this.doSetProperty(property.getName(), property.getValue());
            }
        }
        this.doSetMaxRows(this.m_maxRows);
        if (this.m_sortSpecs != null) {
            iter = this.m_sortSpecs.listIterator();
            while (iter.hasNext()) {
                SortSpec sortBy = (SortSpec)iter.next();
                this.doSetSortSpec(sortBy);
            }
        }
    }

    private void updateProjectedColumns(ProjectedColumns newProjectedColumns, ProjectedColumns oldProjectedColumns) throws DataException {
        ListIterator iter;
        ArrayList customColumns = oldProjectedColumns.getCustomColumns();
        ArrayList columnHints = oldProjectedColumns.getColumnHints();
        String[] projections = oldProjectedColumns.getProjections();
        if (customColumns != null) {
            iter = customColumns.listIterator();
            while (iter.hasNext()) {
                CustomColumn customColumn = (CustomColumn)iter.next();
                newProjectedColumns.addCustomColumn(customColumn.getName(), customColumn.getType());
            }
        }
        if (columnHints != null) {
            iter = columnHints.listIterator();
            while (iter.hasNext()) {
                ColumnHint columnHint = (ColumnHint)iter.next();
                newProjectedColumns.addHint(columnHint);
            }
        }
        newProjectedColumns.setProjectedNames(projections);
    }

    public int findInParameter(String paramName) throws DataException {
        PreparedStatement.getLogger().entering(sm_className, "findInParameter(String)", paramName);
        try {
            int ret = this.getStatement().findInParameter(paramName);
            PreparedStatement.getLogger().exiting(sm_className, "findInParameter(String)", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotFindInParameter", paramName, "findInParameter(String)");
        }
        catch (UnsupportedOperationException ex) {
            PreparedStatement.getLogger().logp(Level.INFO, sm_className, "findInParameter(String)", "Cannot find input parameter by name.", ex);
            throw PreparedStatement.newException("odaconsumer.CannotFindInParameter", paramName, ex);
        }
        return 0;
    }

    public void setParameterValue(int paramIndex, Object paramValue) throws DataException {
        this.setParameterValue(null, paramIndex, paramValue);
    }

    public void setParameterValue(String paramName, Object paramValue) throws DataException {
        this.setParameterValue(paramName, 0, paramValue);
    }

    private void setParameterValue(String paramName, int paramIndex, Object paramValue) throws DataException {
        ParameterName paramNameObj = null;
        if (paramName != null) {
            paramNameObj = new ParameterName(paramName, this);
            paramNameObj.logNullNativeName();
        }
        try {
            if (paramValue == null) {
                this.setNull(paramNameObj, paramIndex);
                return;
            }
            if (paramValue instanceof Integer) {
                int i = (Integer)paramValue;
                this.setInt(paramNameObj, paramIndex, i);
                return;
            }
            if (paramValue instanceof Double) {
                double d = (Double)paramValue;
                this.setDouble(paramNameObj, paramIndex, d);
                return;
            }
            if (paramValue instanceof String) {
                String string = (String)paramValue;
                this.setString(paramNameObj, paramIndex, string);
                return;
            }
            if (paramValue instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)paramValue;
                this.setBigDecimal(paramNameObj, paramIndex, decimal);
                return;
            }
            if (paramValue instanceof Time) {
                Time time = (Time)paramValue;
                this.setTime(paramNameObj, paramIndex, time);
                return;
            }
            if (paramValue instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)paramValue;
                this.setTimestamp(paramNameObj, paramIndex, timestamp);
                return;
            }
            if (paramValue instanceof Date) {
                Date sqlDate = (Date)paramValue;
                this.setDate(paramNameObj, paramIndex, sqlDate);
                return;
            }
            if (paramValue instanceof Boolean) {
                boolean val = (Boolean)paramValue;
                this.setBoolean(paramNameObj, paramIndex, val);
                return;
            }
            this.setObject(paramNameObj, paramIndex, paramValue);
            return;
        }
        catch (RuntimeException ex) {
            this.retrySetParameterValue(paramNameObj, paramIndex, paramValue, ex);
            return;
        }
        catch (DataException ex) {
            this.retrySetParameterValue(paramNameObj, paramIndex, paramValue, (Exception)((Object)ex));
            return;
        }
    }

    private void retrySetParameterValue(ParameterName paramName, int paramIndex, Object paramValue, Exception lastException) throws DataException {
        int parameterType = 0;
        try {
            parameterType = paramName == null ? this.getParameterType(paramIndex) : this.getParameterType(paramName, false);
        }
        catch (Exception exception) {}
        if (parameterType == 0) {
            String paramModelName = paramName != null ? paramName.getRomName() : null;
            parameterType = this.getOdaTypeFromParamHints(paramModelName, paramIndex);
        }
        if (parameterType == 4 && paramValue instanceof Integer || parameterType == 8 && paramValue instanceof Double || parameterType == 1 && paramValue instanceof String || parameterType == 3 && paramValue instanceof BigDecimal || parameterType == 92 && paramValue instanceof Time || parameterType == 93 && paramValue instanceof Timestamp || parameterType == 91 && paramValue instanceof Date || parameterType == 16 && paramValue instanceof Boolean) {
            this.throwSetParamValueLastException(lastException, "retrySetParameterValue");
        }
        if (paramValue == null) {
            this.retrySetNullParamValue(paramName, paramIndex, parameterType, lastException);
            return;
        }
        if (parameterType == 2000) {
            this.setObject(paramName, paramIndex, paramValue);
            return;
        }
        if (paramValue instanceof Integer) {
            this.retrySetIntegerParamValue(paramName, paramIndex, (Integer)paramValue, parameterType);
            return;
        }
        if (paramValue instanceof Double) {
            this.retrySetDoubleParamValue(paramName, paramIndex, (Double)paramValue, parameterType);
            return;
        }
        if (paramValue instanceof String) {
            this.retrySetStringParamValue(paramName, paramIndex, (String)paramValue, parameterType);
            return;
        }
        if (paramValue instanceof BigDecimal) {
            this.retrySetBigDecimalParamValue(paramName, paramIndex, (BigDecimal)paramValue, parameterType);
            return;
        }
        if (paramValue instanceof Time) {
            this.retrySetTimeParamValue(paramName, paramIndex, (Time)paramValue, parameterType);
            return;
        }
        if (paramValue instanceof Timestamp) {
            this.retrySetTimestampParamValue(paramName, paramIndex, (Timestamp)paramValue, parameterType);
            return;
        }
        if (paramValue instanceof Date) {
            this.retrySetDateParamValue(paramName, paramIndex, (Date)paramValue, parameterType);
            return;
        }
        if (paramValue instanceof Boolean) {
            this.retrySetBooleanParamValue(paramName, paramIndex, (Boolean)paramValue, parameterType);
            return;
        }
        assert (false);
    }

    private void retrySetIntegerParamValue(ParameterName paramName, int paramIndex, Integer paramValue, int parameterType) throws DataException {
        switch (parameterType) {
            case 8: {
                double d = paramValue.doubleValue();
                this.setDouble(paramName, paramIndex, d);
                return;
            }
            case 1: {
                String s = paramValue.toString();
                this.setString(paramName, paramIndex, s);
                return;
            }
            case 3: {
                int i = paramValue;
                BigDecimal bd = new BigDecimal(i);
                this.setBigDecimal(paramName, paramIndex, bd);
                return;
            }
            case 16: {
                boolean val = paramValue != 0;
                this.setBoolean(paramName, paramIndex, val);
                return;
            }
        }
        this.throwConversionError(paramName, paramIndex, paramValue, parameterType, null);
    }

    private void retrySetDoubleParamValue(ParameterName paramName, int paramIndex, Double paramValue, int parameterType) throws DataException {
        switch (parameterType) {
            case 4: {
                int i = paramValue.intValue();
                Double intValue = new Double(i);
                if (!paramValue.equals(intValue)) {
                    this.throwConversionError(paramName, paramIndex, paramValue, parameterType, null);
                }
                this.setInt(paramName, paramIndex, i);
                return;
            }
            case 1: {
                String s = paramValue.toString();
                this.setString(paramName, paramIndex, s);
                return;
            }
            case 3: {
                double d = paramValue;
                BigDecimal bd = new BigDecimal(d);
                this.setBigDecimal(paramName, paramIndex, bd);
                return;
            }
            case 16: {
                boolean val = paramValue != 0.0;
                this.setBoolean(paramName, paramIndex, val);
                return;
            }
        }
        this.throwConversionError(paramName, paramIndex, paramValue, parameterType, null);
    }

    private void retrySetStringParamValue(ParameterName paramName, int paramIndex, String paramValue, int parameterType) throws DataException {
        switch (parameterType) {
            case 4: {
                try {
                    int i = Integer.parseInt(paramValue);
                    this.setInt(paramName, paramIndex, i);
                    return;
                }
                catch (NumberFormatException ex) {
                    this.throwConversionError(paramName, paramIndex, paramValue, parameterType, ex);
                    return;
                }
            }
            case 8: {
                try {
                    double d = Double.parseDouble(paramValue);
                    this.setDouble(paramName, paramIndex, d);
                    return;
                }
                catch (NumberFormatException ex) {
                    this.throwConversionError(paramName, paramIndex, paramValue, parameterType, ex);
                    return;
                }
            }
            case 3: {
                try {
                    BigDecimal bd = new BigDecimal(paramValue);
                    this.setBigDecimal(paramName, paramIndex, bd);
                    return;
                }
                catch (NumberFormatException ex) {
                    this.throwConversionError(paramName, paramIndex, paramValue, parameterType, ex);
                    return;
                }
            }
            case 91: {
                try {
                    Date d = Date.valueOf(paramValue);
                    this.setDate(paramName, paramIndex, d);
                    return;
                }
                catch (IllegalArgumentException ex) {
                    this.throwConversionError(paramName, paramIndex, paramValue, parameterType, ex);
                    return;
                }
            }
            case 92: {
                try {
                    Time t = Time.valueOf(paramValue);
                    this.setTime(paramName, paramIndex, t);
                    return;
                }
                catch (IllegalArgumentException ex) {
                    this.throwConversionError(paramName, paramIndex, paramValue, parameterType, ex);
                    return;
                }
            }
            case 93: {
                try {
                    Timestamp ts = Timestamp.valueOf(paramValue);
                    this.setTimestamp(paramName, paramIndex, ts);
                    return;
                }
                catch (IllegalArgumentException ex) {
                    this.throwConversionError(paramName, paramIndex, paramValue, parameterType, ex);
                    return;
                }
            }
            case 16: {
                boolean val = Boolean.valueOf(paramValue);
                this.setBoolean(paramName, paramIndex, val);
                return;
            }
        }
        this.throwConversionError(paramName, paramIndex, paramValue, parameterType, null);
    }

    private void retrySetBigDecimalParamValue(ParameterName paramName, int paramIndex, BigDecimal paramValue, int parameterType) throws DataException {
        switch (parameterType) {
            case 4: {
                int i = paramValue.intValue();
                BigDecimal intValue = new BigDecimal(i);
                if (!paramValue.equals(intValue)) {
                    this.throwConversionError(paramName, paramIndex, paramValue, parameterType, null);
                }
                this.setInt(paramName, paramIndex, i);
                return;
            }
            case 8: {
                double d = paramValue.doubleValue();
                BigDecimal doubleValue = new BigDecimal(d);
                if (!paramValue.equals(doubleValue)) {
                    this.throwConversionError(paramName, paramIndex, paramValue, parameterType, null);
                }
                this.setDouble(paramName, paramIndex, d);
                return;
            }
            case 1: {
                String s = paramValue.toString();
                this.setString(paramName, paramIndex, s);
                return;
            }
            case 16: {
                boolean val = paramValue.compareTo(BigDecimal.valueOf(0L)) != 0;
                this.setBoolean(paramName, paramIndex, val);
                return;
            }
        }
        this.throwConversionError(paramName, paramIndex, paramValue, parameterType, null);
    }

    private void retrySetDateParamValue(ParameterName paramName, int paramIndex, Date paramValue, int parameterType) throws DataException {
        switch (parameterType) {
            case 1: {
                Date sqlDate = new Date(paramValue.getTime());
                String s = sqlDate.toString();
                this.setString(paramName, paramIndex, s);
                return;
            }
            case 92: {
                Time timeValue = new Time(paramValue.getTime());
                this.setTime(paramName, paramIndex, timeValue);
                return;
            }
            case 93: {
                Timestamp ts = new Timestamp(paramValue.getTime());
                this.setTimestamp(paramName, paramIndex, ts);
                return;
            }
        }
        this.throwConversionError(paramName, paramIndex, paramValue, parameterType, null);
    }

    private void retrySetTimeParamValue(ParameterName paramName, int paramIndex, Time paramValue, int parameterType) throws DataException {
        switch (parameterType) {
            case 1: {
                String s = paramValue.toString();
                this.setString(paramName, paramIndex, s);
                return;
            }
            case 91: {
                Date d = new Date(paramValue.getTime());
                this.setDate(paramName, paramIndex, d);
                return;
            }
            case 93: {
                Timestamp ts = new Timestamp(paramValue.getTime());
                this.setTimestamp(paramName, paramIndex, ts);
                return;
            }
        }
        this.throwConversionError(paramName, paramIndex, paramValue, parameterType, null);
    }

    private void retrySetTimestampParamValue(ParameterName paramName, int paramIndex, Timestamp paramValue, int parameterType) throws DataException {
        switch (parameterType) {
            case 1: {
                String s = paramValue.toString();
                this.setString(paramName, paramIndex, s);
                return;
            }
            case 91: {
                long time = paramValue.getTime();
                Date d = new Date(time);
                this.setDate(paramName, paramIndex, d);
                return;
            }
            case 92: {
                Time timeValue = new Time(paramValue.getTime());
                this.setTime(paramName, paramIndex, timeValue);
                return;
            }
        }
        this.throwConversionError(paramName, paramIndex, paramValue, parameterType, null);
    }

    private void retrySetBooleanParamValue(ParameterName paramName, int paramIndex, Boolean paramValue, int parameterType) throws DataException {
        switch (parameterType) {
            case 4: {
                int i = paramValue != false ? 1 : 0;
                this.setInt(paramName, paramIndex, i);
                return;
            }
            case 8: {
                double d = paramValue != false ? 1 : 0;
                this.setDouble(paramName, paramIndex, d);
                return;
            }
            case 1: {
                String s = paramValue.toString();
                this.setString(paramName, paramIndex, s);
                return;
            }
            case 3: {
                int i = paramValue != false ? 1 : 0;
                BigDecimal bd = new BigDecimal(i);
                this.setBigDecimal(paramName, paramIndex, bd);
                return;
            }
        }
        this.throwConversionError(paramName, paramIndex, paramValue, parameterType, null);
    }

    private void retrySetNullParamValue(ParameterName paramName, int paramIndex, int parameterType, Exception lastException) throws DataException {
        switch (parameterType) {
            case 1: {
                this.setString(paramName, paramIndex, null);
                return;
            }
            case 3: {
                this.setBigDecimal(paramName, paramIndex, null);
                return;
            }
            case 91: {
                this.setDate(paramName, paramIndex, null);
                return;
            }
            case 92: {
                this.setTime(paramName, paramIndex, null);
                return;
            }
            case 93: {
                this.setTimestamp(paramName, paramIndex, null);
                return;
            }
            case 2000: {
                this.setObject(paramName, paramIndex, null);
                return;
            }
        }
        PreparedStatement.getLogger().logp(Level.SEVERE, sm_className, "retrySetNullParamValue", "Input parameter value is null; not able to retry, throws exception from underlying ODA driver.");
        this.throwSetParamValueLastException(lastException, "retrySetNullParamValue");
    }

    private void throwConversionError(ParameterName paramName, int paramIndex, Object paramValue, int odaType, Exception cause) throws DataException {
        Object paramValueArg = paramValue == null ? "" : paramValue;
        Object paramClassArg = paramValue == null ? "null" : paramValue.getClass();
        Object[] errMsgArgs = null;
        errMsgArgs = paramName == null ? new Object[]{paramValueArg, paramIndex, paramClassArg, odaType} : new Object[]{paramValueArg, paramName, paramClassArg, odaType};
        this.throwException((Throwable)cause, "odaconsumer.CannotConvertIndexedParameterValue", errMsgArgs, "conversionError");
    }

    private void throwSetParamValueLastException(Exception lastException, String methodName) throws RuntimeException, DataException, IllegalStateException {
        assert (lastException != null);
        String logContextMsg = "Cannot set input parameter.";
        if (lastException instanceof RuntimeException) {
            PreparedStatement.getLogger().logp(Level.SEVERE, sm_className, methodName, logContextMsg, lastException);
            throw (RuntimeException)lastException;
        }
        if (lastException instanceof DataException) {
            PreparedStatement.getLogger().logp(Level.SEVERE, sm_className, methodName, logContextMsg, lastException);
            throw (DataException)((Object)lastException);
        }
        String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.UnknownExceptionThrown");
        IllegalStateException ex = new IllegalStateException(localizedMessage);
        ex.initCause(lastException);
        PreparedStatement.getLogger().logp(Level.SEVERE, sm_className, methodName, logContextMsg, lastException);
        throw ex;
    }

    private void setInt(ParameterName paramName, int paramIndex, int i) throws DataException {
        if (paramName == null) {
            this.doSetInt(paramIndex, i);
        } else {
            this.setInt(paramName, i);
        }
    }

    private void setInt(ParameterName paramName, int i) throws DataException {
        if (this.supportsNamedParameter()) {
            this.doSetInt(paramName, i);
            return;
        }
        if (!this.setIntUsingHints(paramName, i)) {
            Object[] msgArgs = new Object[]{i, paramName};
            this.throwError("odaconsumer.CannotSetIntParameter", msgArgs, "setInt( ParameterName, int )");
        }
    }

    private boolean setIntUsingHints(ParameterName paramName, int i) throws DataException {
        int paramIndex = this.getIndexFromParamHints(paramName.getRomName());
        if (paramIndex <= 0) {
            return false;
        }
        this.doSetInt(paramIndex, i);
        return true;
    }

    private void setDouble(ParameterName paramName, int paramIndex, double d) throws DataException {
        if (paramName == null) {
            this.doSetDouble(paramIndex, d);
        } else {
            this.setDouble(paramName, d);
        }
    }

    private void setDouble(ParameterName paramName, double d) throws DataException {
        if (this.supportsNamedParameter()) {
            this.doSetDouble(paramName, d);
            return;
        }
        if (!this.setDoubleUsingHints(paramName, d)) {
            Object[] msgArgs = new Object[]{new Double(d), paramName};
            this.throwError("odaconsumer.CannotSetDoubleParameter", msgArgs, "setDouble( ParameterName, double )");
        }
    }

    private boolean setDoubleUsingHints(ParameterName paramName, double d) throws DataException {
        int paramIndex = this.getIndexFromParamHints(paramName.getRomName());
        if (paramIndex <= 0) {
            return false;
        }
        this.doSetDouble(paramIndex, d);
        return true;
    }

    private void setString(ParameterName paramName, int paramIndex, String stringValue) throws DataException {
        if (paramName == null) {
            this.doSetString(paramIndex, stringValue);
        } else {
            this.setString(paramName, stringValue);
        }
    }

    private void setString(ParameterName paramName, String stringValue) throws DataException {
        if (this.supportsNamedParameter()) {
            this.doSetString(paramName, stringValue);
            return;
        }
        if (!this.setStringUsingHints(paramName, stringValue)) {
            Object[] msgArgs = new Object[]{stringValue, paramName};
            this.throwError("odaconsumer.CannotSetStringParameter", msgArgs, "setString( ParameterName, String )");
        }
    }

    private boolean setStringUsingHints(ParameterName paramName, String stringValue) throws DataException {
        int paramIndex = this.getIndexFromParamHints(paramName.getRomName());
        if (paramIndex <= 0) {
            return false;
        }
        this.doSetString(paramIndex, stringValue);
        return true;
    }

    private void setBigDecimal(ParameterName paramName, int paramIndex, BigDecimal decimal) throws DataException {
        if (paramName == null) {
            this.doSetBigDecimal(paramIndex, decimal);
        } else {
            this.setBigDecimal(paramName, decimal);
        }
    }

    private void setBigDecimal(ParameterName paramName, BigDecimal decimal) throws DataException {
        if (this.supportsNamedParameter()) {
            this.doSetBigDecimal(paramName, decimal);
            return;
        }
        if (!this.setBigDecimalUsingHints(paramName, decimal)) {
            Object[] msgArgs = new Object[]{decimal, paramName};
            this.throwError("odaconsumer.CannotSetBigDecimalParameter", msgArgs, "setBigDecimal( ParameterName, BigDecimal )");
        }
    }

    private boolean setBigDecimalUsingHints(ParameterName paramName, BigDecimal decimal) throws DataException {
        int paramIndex = this.getIndexFromParamHints(paramName.getRomName());
        if (paramIndex <= 0) {
            return false;
        }
        this.doSetBigDecimal(paramIndex, decimal);
        return true;
    }

    private void setDate(ParameterName paramName, int paramIndex, Date date) throws DataException {
        if (paramName == null) {
            this.doSetDate(paramIndex, date);
        } else {
            this.setDate(paramName, date);
        }
    }

    private void setDate(ParameterName paramName, Date date) throws DataException {
        if (this.supportsNamedParameter()) {
            this.doSetDate(paramName, date);
            return;
        }
        if (!this.setDateUsingHints(paramName, date)) {
            Object[] msgArgs = new Object[]{date, paramName};
            this.throwError("odaconsumer.CannotSetDateParameter", msgArgs, "setDate( ParameterName, Date )");
        }
    }

    private boolean setDateUsingHints(ParameterName paramName, Date date) throws DataException {
        int paramIndex = this.getIndexFromParamHints(paramName.getRomName());
        if (paramIndex <= 0) {
            return false;
        }
        this.doSetDate(paramIndex, date);
        return true;
    }

    private void setTime(ParameterName paramName, int paramIndex, Time time) throws DataException {
        if (paramName == null) {
            this.doSetTime(paramIndex, time);
        } else {
            this.setTime(paramName, time);
        }
    }

    private void setTime(ParameterName paramName, Time time) throws DataException {
        if (this.supportsNamedParameter()) {
            this.doSetTime(paramName, time);
            return;
        }
        if (!this.setTimeUsingHints(paramName, time)) {
            Object[] msgArgs = new Object[]{time, paramName};
            this.throwError("odaconsumer.CannotSetTimeParameter", msgArgs, "setTime( ParameterName, Time )");
        }
    }

    private boolean setTimeUsingHints(ParameterName paramName, Time time) throws DataException {
        int paramIndex = this.getIndexFromParamHints(paramName.getRomName());
        if (paramIndex <= 0) {
            return false;
        }
        this.doSetTime(paramIndex, time);
        return true;
    }

    private void setTimestamp(ParameterName paramName, int paramIndex, Timestamp timestamp) throws DataException {
        if (paramName == null) {
            this.doSetTimestamp(paramIndex, timestamp);
        } else {
            this.setTimestamp(paramName, timestamp);
        }
    }

    private void setTimestamp(ParameterName paramName, Timestamp timestamp) throws DataException {
        if (this.supportsNamedParameter()) {
            this.doSetTimestamp(paramName, timestamp);
            return;
        }
        if (!this.setTimestampUsingHints(paramName, timestamp)) {
            Object[] msgArgs = new Object[]{timestamp, paramName};
            this.throwError("odaconsumer.CannotSetTimestampParameter", msgArgs, "setTimestamp( ParameterName, Timestamp )");
        }
    }

    private boolean setTimestampUsingHints(ParameterName paramName, Timestamp timestamp) throws DataException {
        int paramIndex = this.getIndexFromParamHints(paramName.getRomName());
        if (paramIndex <= 0) {
            return false;
        }
        this.doSetTimestamp(paramIndex, timestamp);
        return true;
    }

    private void setBoolean(ParameterName paramName, int paramIndex, boolean val) throws DataException {
        if (paramName == null) {
            this.doSetBoolean(paramIndex, val);
        } else {
            this.setBoolean(paramName, val);
        }
    }

    private void setBoolean(ParameterName paramName, boolean val) throws DataException {
        if (this.supportsNamedParameter()) {
            this.doSetBoolean(paramName, val);
            return;
        }
        if (!this.setBooleanUsingHints(paramName, val)) {
            Object[] msgArgs = new Object[]{val, paramName};
            this.throwError("odaconsumer.CannotSetBooleanParameter", msgArgs, "setBoolean( ParameterName, boolean )");
        }
    }

    private boolean setBooleanUsingHints(ParameterName paramName, boolean val) throws DataException {
        int paramIndex = this.getIndexFromParamHints(paramName.getRomName());
        if (paramIndex <= 0) {
            return false;
        }
        this.doSetBoolean(paramIndex, val);
        return true;
    }

    private void setObject(ParameterName paramName, int paramIndex, Object value) throws DataException {
        if (paramName == null) {
            this.doSetObject(paramIndex, value);
        } else {
            this.setObject(paramName, value);
        }
    }

    private void setObject(ParameterName paramName, Object value) throws DataException {
        if (this.supportsNamedParameter()) {
            this.doSetObject(paramName, value);
            return;
        }
        if (!this.setObjectUsingHints(paramName, value)) {
            Object[] msgArgs = new Object[]{value, paramName};
            this.throwError("odaconsumer.CannotSetObjectParameter", msgArgs, "setObject( ParameterName, Object )");
        }
    }

    private boolean setObjectUsingHints(ParameterName paramName, Object value) throws DataException {
        int paramIndex = this.getIndexFromParamHints(paramName.getRomName());
        if (paramIndex <= 0) {
            return false;
        }
        this.doSetObject(paramIndex, value);
        return true;
    }

    private void setNull(ParameterName paramName, int paramIndex) throws DataException {
        if (paramName == null) {
            this.doSetNull(paramIndex);
        } else {
            this.setNull(paramName);
        }
    }

    private void setNull(ParameterName paramName) throws DataException {
        if (this.supportsNamedParameter()) {
            this.doSetNull(paramName);
            return;
        }
        if (!this.setNullUsingHints(paramName)) {
            Object[] msgArgs = new Object[]{paramName};
            this.throwError("odaconsumer.CannotSetNullParameter", msgArgs, "setNull( ParameterName )");
        }
    }

    private boolean setNullUsingHints(ParameterName paramName) throws DataException {
        int paramIndex = this.getIndexFromParamHints(paramName.getRomName());
        if (paramIndex <= 0) {
            return false;
        }
        this.doSetNull(paramIndex);
        return true;
    }

    private void doSetInt(int paramIndex, int i) throws DataException {
        try {
            this.getStatement().setInt(paramIndex, i);
        }
        catch (OdaException ex) {
            Object[] msgArgs = new Object[]{i, paramIndex};
            this.throwException((Throwable)ex, "odaconsumer.CannotSetIntParameter", msgArgs, "doSetInt( int, int )");
        }
        catch (UnsupportedOperationException ex) {
            Object[] msgArgs = new Object[]{i, paramIndex};
            this.throwException((Throwable)ex, "odaconsumer.CannotSetIntParameter", msgArgs, "doSetInt( int, int )");
        }
    }

    private void doSetInt(ParameterName paramName, int i) throws DataException {
        block3: {
            String effectiveParamName = paramName.getEffectiveName();
            try {
                this.getStatement().setInt(effectiveParamName, i);
            }
            catch (OdaException ex) {
                Object[] msgArgs = new Object[]{i, effectiveParamName};
                this.throwException((Throwable)ex, "odaconsumer.CannotSetIntParameter", msgArgs, "doSetInt( ParameterName, int )");
            }
            catch (UnsupportedOperationException ex) {
                if (this.setIntUsingHints(paramName, i)) break block3;
                Object[] msgArgs = new Object[]{i, effectiveParamName};
                this.throwException((Throwable)ex, "odaconsumer.CannotSetIntParameter", msgArgs, "doSetInt( ParameterName, int )");
            }
        }
    }

    private void doSetDouble(int paramIndex, double d) throws DataException {
        try {
            this.getStatement().setDouble(paramIndex, d);
        }
        catch (OdaException ex) {
            Object[] msgArgs = new Object[]{new Double(d), paramIndex};
            this.throwException((Throwable)ex, "odaconsumer.CannotSetDoubleParameter", msgArgs, "doSetDouble( int, double )");
        }
        catch (UnsupportedOperationException ex) {
            Object[] msgArgs = new Object[]{new Double(d), paramIndex};
            this.throwException((Throwable)ex, "odaconsumer.CannotSetDoubleParameter", msgArgs, "doSetDouble( int, double )");
        }
    }

    private void doSetDouble(ParameterName paramName, double d) throws DataException {
        block3: {
            String effectiveParamName = paramName.getEffectiveName();
            try {
                this.getStatement().setDouble(effectiveParamName, d);
            }
            catch (OdaException ex) {
                Object[] msgArgs = new Object[]{new Double(d), effectiveParamName};
                this.throwException((Throwable)ex, "odaconsumer.CannotSetDoubleParameter", msgArgs, "doSetDouble( ParameterName, double )");
            }
            catch (UnsupportedOperationException ex) {
                if (this.setDoubleUsingHints(paramName, d)) break block3;
                Object[] msgArgs = new Object[]{new Double(d), effectiveParamName};
                this.throwException((Throwable)ex, "odaconsumer.CannotSetDoubleParameter", msgArgs, "doSetDouble( ParameterName, double )");
            }
        }
    }

    private void doSetString(int paramIndex, String stringValue) throws DataException {
        try {
            this.getStatement().setString(paramIndex, stringValue);
        }
        catch (OdaException ex) {
            Object[] msgArgs = new Object[]{stringValue, paramIndex};
            this.throwException((Throwable)ex, "odaconsumer.CannotSetStringParameter", msgArgs, "doSetString( int, String )");
        }
        catch (UnsupportedOperationException ex) {
            Object[] msgArgs = new Object[]{stringValue, paramIndex};
            this.throwException((Throwable)ex, "odaconsumer.CannotSetStringParameter", msgArgs, "doSetString( int, String )");
        }
    }

    private void doSetString(ParameterName paramName, String stringValue) throws DataException {
        block3: {
            String effectiveParamName = paramName.getEffectiveName();
            try {
                this.getStatement().setString(effectiveParamName, stringValue);
            }
            catch (OdaException ex) {
                Object[] msgArgs = new Object[]{stringValue, effectiveParamName};
                this.throwException((Throwable)ex, "odaconsumer.CannotSetStringParameter", msgArgs, "doSetString( ParameterName, String )");
            }
            catch (UnsupportedOperationException ex) {
                if (this.setStringUsingHints(paramName, stringValue)) break block3;
                Object[] msgArgs = new Object[]{stringValue, effectiveParamName};
                this.throwException((Throwable)ex, "odaconsumer.CannotSetStringParameter", msgArgs, "doSetString( ParameterName, String )");
            }
        }
    }

    private void doSetBigDecimal(int paramIndex, BigDecimal decimal) throws DataException {
        try {
            this.getStatement().setBigDecimal(paramIndex, decimal);
        }
        catch (OdaException ex) {
            Object[] msgArgs = new Object[]{decimal, paramIndex};
            this.throwException((Throwable)ex, "odaconsumer.CannotSetBigDecimalParameter", msgArgs, "doSetBigDecimal( int, BigDecimal )");
        }
        catch (UnsupportedOperationException ex) {
            Object[] msgArgs = new Object[]{decimal, paramIndex};
            this.throwException((Throwable)ex, "odaconsumer.CannotSetBigDecimalParameter", msgArgs, "doSetBigDecimal( int, BigDecimal )");
        }
    }

    private void doSetBigDecimal(ParameterName paramName, BigDecimal decimal) throws DataException {
        block3: {
            String effectiveParamName = paramName.getEffectiveName();
            try {
                this.getStatement().setBigDecimal(effectiveParamName, decimal);
            }
            catch (OdaException ex) {
                Object[] msgArgs = new Object[]{decimal, effectiveParamName};
                this.throwException((Throwable)ex, "odaconsumer.CannotSetBigDecimalParameter", msgArgs, "doSetBigDecimal( ParameterName, BigDecimal )");
            }
            catch (UnsupportedOperationException ex) {
                if (this.setBigDecimalUsingHints(paramName, decimal)) break block3;
                Object[] msgArgs = new Object[]{decimal, effectiveParamName};
                this.throwException((Throwable)ex, "odaconsumer.CannotSetBigDecimalParameter", msgArgs, "doSetBigDecimal( ParameterName, BigDecimal )");
            }
        }
    }

    private void doSetDate(int paramIndex, Date date) throws DataException {
        try {
            this.getStatement().setDate(paramIndex, date);
        }
        catch (OdaException ex) {
            Object[] msgArgs = new Object[]{date, paramIndex};
            this.throwException((Throwable)ex, "odaconsumer.CannotSetDateParameter", msgArgs, "doSetDate( int, Date )");
        }
        catch (UnsupportedOperationException ex) {
            Object[] msgArgs = new Object[]{date, paramIndex};
            this.throwException((Throwable)ex, "odaconsumer.CannotSetDateParameter", msgArgs, "doSetDate( int, Date )");
        }
    }

    private void doSetDate(ParameterName paramName, Date date) throws DataException {
        block3: {
            String effectiveParamName = paramName.getEffectiveName();
            try {
                this.getStatement().setDate(effectiveParamName, date);
            }
            catch (OdaException ex) {
                Object[] msgArgs = new Object[]{date, effectiveParamName};
                this.throwException((Throwable)ex, "odaconsumer.CannotSetDateParameter", msgArgs, "doSetDate( ParameterName, Date )");
            }
            catch (UnsupportedOperationException ex) {
                if (this.setDateUsingHints(paramName, date)) break block3;
                Object[] msgArgs = new Object[]{date, effectiveParamName};
                this.throwException((Throwable)ex, "odaconsumer.CannotSetDateParameter", msgArgs, "doSetDate( ParameterName, Date )");
            }
        }
    }

    private void doSetTime(int paramIndex, Time time) throws DataException {
        try {
            this.getStatement().setTime(paramIndex, time);
        }
        catch (OdaException ex) {
            Object[] msgArgs = new Object[]{time, paramIndex};
            this.throwException((Throwable)ex, "odaconsumer.CannotSetTimeParameter", msgArgs, "doSetTime( int, Time )");
        }
        catch (UnsupportedOperationException ex) {
            Object[] msgArgs = new Object[]{time, paramIndex};
            this.throwException((Throwable)ex, "odaconsumer.CannotSetTimeParameter", msgArgs, "doSetTime( int, Time )");
        }
    }

    private void doSetTime(ParameterName paramName, Time time) throws DataException {
        block3: {
            String effectiveParamName = paramName.getEffectiveName();
            try {
                this.getStatement().setTime(effectiveParamName, time);
            }
            catch (OdaException ex) {
                Object[] msgArgs = new Object[]{time, effectiveParamName};
                this.throwException((Throwable)ex, "odaconsumer.CannotSetTimeParameter", msgArgs, "doSetTime( ParameterName, Time )");
            }
            catch (UnsupportedOperationException ex) {
                if (this.setTimeUsingHints(paramName, time)) break block3;
                Object[] msgArgs = new Object[]{time, effectiveParamName};
                this.throwException((Throwable)ex, "odaconsumer.CannotSetTimeParameter", msgArgs, "doSetTime( ParameterName, Time )");
            }
        }
    }

    private void doSetTimestamp(int paramIndex, Timestamp timestamp) throws DataException {
        try {
            this.getStatement().setTimestamp(paramIndex, timestamp);
        }
        catch (OdaException ex) {
            Object[] msgArgs = new Object[]{timestamp, paramIndex};
            this.throwException((Throwable)ex, "odaconsumer.CannotSetTimestampParameter", msgArgs, "doSetTimestamp( int, Timestamp )");
        }
        catch (UnsupportedOperationException ex) {
            Object[] msgArgs = new Object[]{timestamp, paramIndex};
            this.throwException((Throwable)ex, "odaconsumer.CannotSetTimestampParameter", msgArgs, "doSetTimestamp( int, Timestamp )");
        }
    }

    private void doSetTimestamp(ParameterName paramName, Timestamp timestamp) throws DataException {
        block3: {
            String effectiveParamName = paramName.getEffectiveName();
            try {
                this.getStatement().setTimestamp(effectiveParamName, timestamp);
            }
            catch (OdaException ex) {
                Object[] msgArgs = new Object[]{timestamp, effectiveParamName};
                this.throwException((Throwable)ex, "odaconsumer.CannotSetTimestampParameter", msgArgs, "doSetTimestamp( ParameterName, Timestamp )");
            }
            catch (UnsupportedOperationException ex) {
                if (this.setTimestampUsingHints(paramName, timestamp)) break block3;
                Object[] msgArgs = new Object[]{timestamp, effectiveParamName};
                this.throwException((Throwable)ex, "odaconsumer.CannotSetTimestampParameter", msgArgs, "doSetTimestamp( ParameterName, Timestamp )");
            }
        }
    }

    private void doSetBoolean(int paramIndex, boolean val) throws DataException {
        try {
            this.getStatement().setBoolean(paramIndex, val);
        }
        catch (OdaException ex) {
            Object[] msgArgs = new Object[]{val, paramIndex};
            this.throwException((Throwable)ex, "odaconsumer.CannotSetBooleanParameter", msgArgs, "doSetBoolean( int, boolean )");
        }
        catch (UnsupportedOperationException ex) {
            Object[] msgArgs = new Object[]{val, paramIndex};
            this.throwException((Throwable)ex, "odaconsumer.CannotSetBooleanParameter", msgArgs, "doSetBoolean( int, boolean )");
        }
    }

    private void doSetBoolean(ParameterName paramName, boolean val) throws DataException {
        block3: {
            String effectiveParamName = paramName.getEffectiveName();
            try {
                this.getStatement().setBoolean(effectiveParamName, val);
            }
            catch (OdaException ex) {
                Object[] msgArgs = new Object[]{val, effectiveParamName};
                this.throwException((Throwable)ex, "odaconsumer.CannotSetBooleanParameter", msgArgs, "doSetBoolean( ParameterName, boolean )");
            }
            catch (UnsupportedOperationException ex) {
                if (this.setBooleanUsingHints(paramName, val)) break block3;
                Object[] msgArgs = new Object[]{val, effectiveParamName};
                this.throwException((Throwable)ex, "odaconsumer.CannotSetBooleanParameter", msgArgs, "doSetBoolean( ParameterName, boolean )");
            }
        }
    }

    private void doSetObject(int paramIndex, Object value) throws DataException {
        try {
            this.getStatement().setObject(paramIndex, value);
        }
        catch (OdaException ex) {
            Object[] msgArgs = new Object[]{value, paramIndex};
            this.throwException((Throwable)ex, "odaconsumer.CannotSetObjectParameter", msgArgs, "doSetObject( int, Object )");
        }
        catch (UnsupportedOperationException ex) {
            Object[] msgArgs = new Object[]{value, paramIndex};
            this.throwException((Throwable)ex, "odaconsumer.CannotSetObjectParameter", msgArgs, "doSetObject( int, Object )");
        }
    }

    private void doSetObject(ParameterName paramName, Object value) throws DataException {
        block3: {
            String effectiveParamName = paramName.getEffectiveName();
            try {
                this.getStatement().setObject(effectiveParamName, value);
            }
            catch (OdaException ex) {
                Object[] msgArgs = new Object[]{value, effectiveParamName};
                this.throwException((Throwable)ex, "odaconsumer.CannotSetObjectParameter", msgArgs, "doSetObject( ParameterName, Object )");
            }
            catch (UnsupportedOperationException ex) {
                if (this.setObjectUsingHints(paramName, value)) break block3;
                Object[] msgArgs = new Object[]{value, effectiveParamName};
                this.throwException((Throwable)ex, "odaconsumer.CannotSetObjectParameter", msgArgs, "doSetObject( ParameterName, Object )");
            }
        }
    }

    private void doSetNull(int paramIndex) throws DataException {
        try {
            this.getStatement().setNull(paramIndex);
        }
        catch (OdaException ex) {
            Object[] msgArgs = new Object[]{paramIndex};
            this.throwException((Throwable)ex, "odaconsumer.CannotSetNullParameter", msgArgs, "doSetNull( int )");
        }
        catch (UnsupportedOperationException ex) {
            Object[] msgArgs = new Object[]{paramIndex};
            this.throwException((Throwable)ex, "odaconsumer.CannotSetNullParameter", msgArgs, "doSetNull( int )");
        }
    }

    private void doSetNull(ParameterName paramName) throws DataException {
        block3: {
            String effectiveParamName = paramName.getEffectiveName();
            try {
                this.getStatement().setNull(effectiveParamName);
            }
            catch (OdaException ex) {
                Object[] msgArgs = new Object[]{effectiveParamName};
                this.throwException((Throwable)ex, "odaconsumer.CannotSetNullParameter", msgArgs, "doSetNull( ParameterName )");
            }
            catch (UnsupportedOperationException ex) {
                if (this.setNullUsingHints(paramName)) break block3;
                Object[] msgArgs = new Object[]{effectiveParamName};
                this.throwException((Throwable)ex, "odaconsumer.CannotSetNullParameter", msgArgs, "doSetNull( ParameterName )");
            }
        }
    }

    static boolean hasValue(String value) {
        return value != null && value.length() > 0;
    }

    private SequentialResultSetHandler getSequentialResultHandler() {
        if (this.m_seqResultSetHdlr == null) {
            this.m_seqResultSetHdlr = new SequentialResultSetHandler(this);
        }
        return this.m_seqResultSetHdlr;
    }

    static final class CustomColumn {
        private String m_name;
        private Class m_type;

        CustomColumn(String name, Class type) {
            this.m_name = name;
            this.m_type = type;
        }

        private String getName() {
            return this.m_name;
        }

        private Class getType() {
            return this.m_type;
        }
    }

    private static final class ParameterName {
        private String m_romName;
        private String m_nativeName;
        private boolean m_hasCheckedNativeName = false;
        private PreparedStatement m_stmt;

        private ParameterName(String romName, PreparedStatement stmt) {
            this.m_romName = romName;
            this.m_stmt = stmt;
        }

        private String getRomName() {
            return this.m_romName;
        }

        private String getNativeName() {
            if (this.m_nativeName == null && !this.m_hasCheckedNativeName) {
                this.m_nativeName = this.m_stmt.getNativeNameFromParameterMetaData(this.m_romName);
                if (this.m_nativeName == null) {
                    this.m_nativeName = this.m_stmt.getNativeNameFromParamHints(this.m_romName);
                }
                this.m_hasCheckedNativeName = true;
            }
            return this.m_nativeName;
        }

        private String getEffectiveName() {
            String nativeName = this.getNativeName();
            return nativeName != null && nativeName.length() > 0 ? nativeName : this.getRomName();
        }

        private void logNullNativeName() {
            if (this.getNativeName() != null) {
                return;
            }
            PreparedStatement.getLogger().logp(Level.FINE, String.valueOf(sm_className) + ".ParameterName", "logNullNativeName()", "No native name available for parameter " + this.getRomName() + ".");
        }

        public String toString() {
            OdaDataException resourceMsgHandler = PreparedStatement.newException("odaconsumer.ParameterNames", new Object[]{this.m_romName, this.m_nativeName});
            return resourceMsgHandler.getLocalizedMessage();
        }
    }

    private static final class Property {
        private String m_name;
        private String m_value;

        private Property(String name, String value) {
            this.m_name = name;
            this.m_value = value;
        }

        private String getName() {
            return this.m_name;
        }

        private String getValue() {
            return this.m_value;
        }
    }

    private final class SequentialResultSetHandler {
        private final String m_nestedClassName = SequentialResultSetHandler.class.getName();
        private PreparedStatement m_stmt;
        private int m_currentResultSetNum = 1;
        private Map<Integer, ResultSet> m_resultSets;
        private Map<Integer, ProjectedColumns> m_seqProjectedColumns;
        private HashSet<Integer> m_incompleteProjectedColumns;
        private ExceptionHandler m_exceptionHandler;

        private SequentialResultSetHandler(PreparedStatement stmt) {
            this.m_stmt = stmt;
            this.m_resultSets = new HashMap<Integer, ResultSet>();
            this.m_seqProjectedColumns = new HashMap<Integer, ProjectedColumns>();
            this.m_incompleteProjectedColumns = new HashSet();
            this.m_exceptionHandler = new ExceptionHandler(this.m_nestedClassName);
        }

        private void resetResultSetsState() {
            this.m_currentResultSetNum = 1;
            this.closeAllResultSets();
        }

        private void closeAllResultSets() {
            for (Integer resultSetKey : this.m_resultSets.keySet()) {
                this.closeResultSet(resultSetKey);
            }
            this.m_resultSets.clear();
            this.m_incompleteProjectedColumns.addAll(this.m_seqProjectedColumns.keySet());
        }

        private void closeResultSet(Integer resultSetKey) {
            ResultSet rs = this.getCachedResultSet(resultSetKey);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (DataException dataException) {}
            if (this.m_seqProjectedColumns.containsKey(resultSetKey)) {
                this.m_incompleteProjectedColumns.add(resultSetKey);
            }
        }

        private void clearAndCloseResultSet(Integer resultSetKey) {
            this.closeResultSet(resultSetKey);
            this.m_resultSets.remove(resultSetKey);
        }

        private void refreshResultSetMetaData(Integer resultSetKey) throws DataException {
            ResultSet cachedRS = this.getCachedResultSet(resultSetKey);
            if (cachedRS == null) {
                return;
            }
            PreparedStatement.getLogger().entering(this.m_nestedClassName, "refreshResultSetMetaData(Integer)", resultSetKey);
            IResultSet odaRS = cachedRS.getRuntimeResultSet();
            ResultSet refreshedRS = new ResultSet(odaRS, this.doGetMetaData(resultSetKey, odaRS));
            this.cacheResultSet(resultSetKey, refreshedRS);
            PreparedStatement.getLogger().exiting(this.m_nestedClassName, "refreshResultSetMetaData(Integer)");
        }

        ResultSet getResultSet(int resultSetNum) throws DataException {
            if (PreparedStatement.getLogger().isLoggingEnterExitLevel()) {
                PreparedStatement.getLogger().entering(this.m_nestedClassName, "getResultSet(int)", (Object)resultSetNum);
            }
            Integer resultSetKey = resultSetNum;
            if (resultSetNum <= 0 || resultSetNum < this.m_currentResultSetNum) {
                this.throwInvalidArgException("getResultSet(int)", resultSetKey);
            }
            ResultSet rs = null;
            if (resultSetNum == this.m_currentResultSetNum && (rs = this.getCachedResultSet(resultSetKey)) != null) {
                PreparedStatement.getLogger().logp(Level.FINEST, this.m_nestedClassName, "getResultSet(int)", "Found cached result set.");
                PreparedStatement.getLogger().exiting(this.m_nestedClassName, "getResultSet(int)", rs);
                return rs;
            }
            if (!PreparedStatement.this.supportsMultipleResultSets()) {
                if (resultSetNum == 1) {
                    rs = this.m_stmt.getResultSet();
                    this.m_currentResultSetNum = resultSetNum;
                } else {
                    this.throwInvalidArgException("getResultSet(int)", resultSetKey);
                }
            } else {
                boolean hasMoreResults = this.moveToResultSet(resultSetNum);
                if (!hasMoreResults) {
                    this.throwInvalidArgException("getResultSet(int)", resultSetKey);
                }
                rs = this.doGetResultSet(resultSetKey);
            }
            this.cacheResultSet(resultSetKey, rs);
            PreparedStatement.getLogger().exiting(this.m_nestedClassName, "getResultSet(int)", rs);
            return rs;
        }

        private boolean moveToResultSet(int resultSetNum) throws DataException {
            int skipResultsCount = resultSetNum - this.m_currentResultSetNum;
            boolean hasMoreResults = true;
            int i = 0;
            while (hasMoreResults && i < skipResultsCount) {
                hasMoreResults = this.getMoreResults();
                ++i;
            }
            return hasMoreResults;
        }

        private ResultSet doGetResultSet(Integer resultSetKey) throws DataException {
            PreparedStatement.getLogger().entering(this.m_nestedClassName, "doGetResultSet(Integer)");
            IResultSet resultSet = null;
            try {
                resultSet = PreparedStatement.this.getAdvancedStatement().getResultSet();
            }
            catch (OdaException ex) {
                this.throwDataException(ex, "odaconsumer.CannotGetResultSet", "doGetResultSet(Integer)");
            }
            catch (UnsupportedOperationException ex) {
                this.throwDataException(ex, "odaconsumer.CannotGetResultSet", "doGetResultSet(Integer)");
            }
            ResultSet rs = resultSet != null ? new ResultSet(resultSet, this.doGetMetaData(resultSetKey, resultSet)) : null;
            PreparedStatement.getLogger().exiting(this.m_nestedClassName, "doGetResultSet(Integer)", rs);
            return rs;
        }

        private ResultSet getCachedResultSet(Integer resultSetNum) {
            return this.m_resultSets.get(resultSetNum);
        }

        private void cacheResultSet(Integer resultSetNum, ResultSet newResultSet) {
            this.m_resultSets.put(resultSetNum, newResultSet);
        }

        boolean getMoreResults() throws DataException {
            PreparedStatement.getLogger().entering(this.m_nestedClassName, "getMoreResults");
            if (!PreparedStatement.this.supportsMultipleResultSets()) {
                PreparedStatement.getLogger().exiting(this.m_nestedClassName, "getMoreResults", Boolean.FALSE);
                return false;
            }
            boolean hasMoreResults = false;
            try {
                hasMoreResults = PreparedStatement.this.getAdvancedStatement().getMoreResults();
            }
            catch (OdaException ex) {
                this.throwDataException(ex, "odaconsumer.CannotGetMoreResults", "getMoreResults");
            }
            catch (UnsupportedOperationException ex) {
                this.throwDataException(ex, "odaconsumer.CannotGetMoreResults", "getMoreResults");
            }
            if (hasMoreResults) {
                ++this.m_currentResultSetNum;
                this.closeAllResultSets();
            }
            if (PreparedStatement.getLogger().isLoggingEnterExitLevel()) {
                PreparedStatement.getLogger().exiting(this.m_nestedClassName, "getMoreResults", hasMoreResults);
            }
            return hasMoreResults;
        }

        void setColumnsProjection(int resultSetNum, String[] projectedNames) throws DataException {
            Integer resultSetKey = resultSetNum;
            if (PreparedStatement.getLogger().isLoggingEnterExitLevel()) {
                PreparedStatement.getLogger().entering(this.m_nestedClassName, "setColumnsProjection(int, String[])", new Object[]{resultSetKey, projectedNames});
            }
            this.validateMultipleResultsSupport();
            this.clearAndCloseResultSet(resultSetKey);
            this.getProjectedColumns(resultSetKey, null).setProjectedNames(projectedNames);
            PreparedStatement.getLogger().exiting(this.m_nestedClassName, "setColumnsProjection(int, String[])");
        }

        void declareCustomColumn(int resultSetNum, String columnName, Class columnType) throws DataException {
            Integer resultSetKey = resultSetNum;
            if (PreparedStatement.getLogger().isLoggingEnterExitLevel()) {
                PreparedStatement.getLogger().entering(this.m_nestedClassName, "declareCustomColumn(int, String, Class)", new Object[]{resultSetKey, columnName, columnType});
            }
            this.validateMultipleResultsSupport();
            assert (columnName != null);
            assert (columnName.length() != 0);
            this.clearAndCloseResultSet(resultSetKey);
            this.getProjectedColumns(resultSetKey, null).addCustomColumn(columnName, columnType);
            this.refreshResultSetMetaData(resultSetKey);
            PreparedStatement.getLogger().exiting(this.m_nestedClassName, "declareCustomColumn(int, String, Class)");
        }

        void addColumnHint(int resultSetNum, ColumnHint columnHint) throws DataException {
            Integer resultSetKey = resultSetNum;
            if (PreparedStatement.getLogger().isLoggingEnterExitLevel()) {
                PreparedStatement.getLogger().entering(this.m_nestedClassName, "addColumnHint(int, ColumnHint)", new Object[]{resultSetKey, columnHint});
            }
            this.validateMultipleResultsSupport();
            if (columnHint != null) {
                this.getProjectedColumns(resultSetKey, null).addHint(columnHint);
            }
            PreparedStatement.getLogger().exiting(this.m_nestedClassName, "addColumnHint(int, ColumnHint)");
        }

        private ProjectedColumns getProjectedColumns(Integer resultSetNum, IResultSet odaResultSet) throws DataException {
            boolean hasOdaRuntimeMetadata;
            PreparedStatement.getLogger().entering(this.m_nestedClassName, "getProjectedColumns(Integer,IResultSet)", resultSetNum);
            ProjectedColumns projectedColumns = this.m_seqProjectedColumns.get(resultSetNum);
            if (projectedColumns != null && !this.m_incompleteProjectedColumns.contains(resultSetNum)) {
                PreparedStatement.getLogger().exiting(this.m_nestedClassName, "getProjectedColumns(Integer,IResultSet)", projectedColumns);
                return projectedColumns;
            }
            IResultSetMetaData odaRuntimeMetadata = this.tryGetRuntimeMetaData(resultSetNum, odaResultSet);
            boolean bl = hasOdaRuntimeMetadata = odaRuntimeMetadata != null;
            if (!hasOdaRuntimeMetadata) {
                PreparedStatement.getLogger().logp(Level.INFO, this.m_nestedClassName, "getProjectedColumns(Integer,IResultSet)", "Using the statement's current result set for result set " + resultSetNum);
                odaRuntimeMetadata = this.m_stmt.getRuntimeMetaData();
            }
            ProjectedColumns newProjectedColumns = PreparedStatement.this.doGetProjectedColumns(odaRuntimeMetadata);
            if (projectedColumns == null) {
                projectedColumns = newProjectedColumns;
                if (!hasOdaRuntimeMetadata) {
                    this.m_incompleteProjectedColumns.add(resultSetNum);
                }
            } else if (this.m_incompleteProjectedColumns.contains(resultSetNum)) {
                PreparedStatement.this.updateProjectedColumns(newProjectedColumns, projectedColumns);
                projectedColumns = newProjectedColumns;
                if (hasOdaRuntimeMetadata) {
                    this.m_incompleteProjectedColumns.remove(resultSetNum);
                }
            }
            this.m_seqProjectedColumns.put(resultSetNum, projectedColumns);
            PreparedStatement.getLogger().exiting(this.m_nestedClassName, "getProjectedColumns(Integer,IResultSet)", projectedColumns);
            return projectedColumns;
        }

        private IResultSetMetaData tryGetRuntimeMetaData(Integer resultSetNum, IResultSet odaResultSet) throws DataException {
            if (odaResultSet != null) {
                return this.getRuntimeMetaData(odaResultSet);
            }
            if (resultSetNum == 1 && this.m_currentResultSetNum == 1) {
                try {
                    return this.m_stmt.getRuntimeMetaData();
                }
                catch (DataException dataException) {}
            }
            IResultSetMetaData rsmd = this.tryGetRuntimeMetaData(resultSetNum);
            return rsmd;
        }

        private IResultSetMetaData getRuntimeMetaData(IResultSet odaResultSet) throws DataException {
            IResultSetMetaData rsmd = null;
            try {
                rsmd = odaResultSet.getMetaData();
            }
            catch (OdaException ex) {
                this.throwDataException(ex, "odaconsumer.CannotGetResultSetMetaData", "getRuntimeMetaData(IResultSet)");
            }
            return rsmd;
        }

        private IResultSetMetaData tryGetRuntimeMetaData(Integer resultSetNum) {
            IResultSetMetaData rsmd = null;
            try {
                ResultSet rs = this.getResultSet(resultSetNum);
                if (rs != null) {
                    rsmd = rs.getRuntimeMetaData();
                }
            }
            catch (DataException dataException) {}
            return rsmd;
        }

        IResultClass getMetaData(int resultSetNum) throws DataException {
            if (PreparedStatement.getLogger().isLoggingEnterExitLevel()) {
                PreparedStatement.getLogger().entering(this.m_nestedClassName, "getMetaData(int)", (Object)resultSetNum);
            }
            this.validateMultipleResultsSupport();
            ResultSet resultset = this.getResultSet(resultSetNum);
            IResultClass resultClass = null;
            if (resultset != null) {
                resultClass = resultset.getMetaData();
            }
            PreparedStatement.getLogger().exiting(this.m_nestedClassName, "getMetaData(int)", resultClass);
            return resultClass;
        }

        private IResultClass doGetMetaData(Integer resultSetKey, IResultSet resultSet) throws DataException {
            PreparedStatement.getLogger().entering(this.m_nestedClassName, "doGetMetaData(Integer,IResultSet)", resultSetKey);
            List projectedColumns = this.getProjectedColumns(resultSetKey, resultSet).getColumnsMetadata();
            ResultClass resultClass = PreparedStatement.this.doGetResultClass(projectedColumns);
            PreparedStatement.getLogger().exiting(this.m_nestedClassName, "doGetMetaData(Integer,IResultSet)", resultClass);
            return resultClass;
        }

        private void validateMultipleResultsSupport() throws DataException {
            if (PreparedStatement.this.supportsMultipleResultSets()) {
                return;
            }
            this.throwDataException(new UnsupportedOperationException(), "odaconsumer.UnsupportedMultipleResultSets", "validateMultipleResultsSupport");
        }

        private void throwInvalidArgException(String methodName, Integer resultSetKey) throws OdaDataException {
            this.m_exceptionHandler.throwError("odaconsumer.InvalidArgument", new Object[]{methodName, resultSetKey}, methodName);
        }

        private void throwDataException(Throwable ex, String errorCode, String methodName) throws OdaDataException {
            this.m_exceptionHandler.throwException(ex, errorCode, methodName);
        }
    }
}

