/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util.filter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.CubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.util.DataJSObjectPopulator;
import org.eclipse.birt.data.engine.olap.util.DimensionJSEvalHelper;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.data.engine.olap.util.filter.DimensionFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFilterHelper;
import org.eclipse.birt.data.engine.olap.util.filter.TopBottomDimensionFilterEvalHelper;
import org.mozilla.javascript.Scriptable;

public abstract class BaseDimensionFilterEvalHelper
extends DimensionJSEvalHelper
implements IJSFilterHelper {
    protected DimLevel[] aggrLevels;
    protected ICubeFilterDefinition cubeFilter;
    protected ILevelDefinition[] axisLevels;
    protected Object[] axisValues;
    protected boolean isAxisFilter;

    public static IJSFilterHelper createFilterHelper(IBaseQueryResults outResults, Scriptable parentScope, ICubeQueryDefinition queryDefn, IFilterDefinition cubeFilter, ScriptContext cx) throws DataException {
        IConditionalExpression expr;
        if (cubeFilter.getExpression() instanceof IConditionalExpression && ((expr = (IConditionalExpression)cubeFilter.getExpression()).getOperator() == 14 || expr.getOperator() == 15 || expr.getOperator() == 16 || expr.getOperator() == 17)) {
            return new TopBottomDimensionFilterEvalHelper(outResults, parentScope, queryDefn, cubeFilter, cx);
        }
        return new DimensionFilterEvalHelper(outResults, parentScope, cx, queryDefn, cubeFilter);
    }

    protected void initialize(IBaseQueryResults outResults, Scriptable parentScope, ICubeQueryDefinition queryDefn, IFilterDefinition cubeFilter, ScriptContext cx) throws DataException {
        this.populaterFilterDefinition(cubeFilter);
        super.init(outResults, parentScope, queryDefn, cx, cubeFilter.getExpression());
    }

    private void populaterFilterDefinition(IFilterDefinition cubeFilter) throws DataException {
        this.cubeFilter = cubeFilter instanceof ICubeFilterDefinition ? (ICubeFilterDefinition)cubeFilter : new CubeFilterDefinition(cubeFilter.getExpression());
        this.axisLevels = this.cubeFilter.getAxisQualifierLevels();
        this.axisValues = this.cubeFilter.getAxisQualifierValues();
        if (this.axisLevels == null || this.axisValues == null || this.axisLevels.length != this.axisValues.length) {
            this.isAxisFilter = false;
        } else {
            int i = 0;
            while (i < this.axisLevels.length) {
                if (this.axisLevels[i] == null) {
                    throw new DataException("data.olap.axis.level.CantBeNull");
                }
                if (this.axisValues[i] == null) {
                    throw new DataException("data.olap.axis.value.CantBeNull", this.axisLevels[i].getName());
                }
                ++i;
            }
        }
        this.isAxisFilter = this.axisLevels != null && this.axisValues != null && this.axisLevels.length == this.axisValues.length;
    }

    protected void registerJSObjectPopulators() throws DataException {
        super.registerJSObjectPopulators();
        this.aggrLevels = this.populateAggrLevels();
        this.register(new DataJSObjectPopulator(this.outResults, this.scope, this.queryDefn.getBindings(), this.aggrLevels != null && this.aggrLevels.length > 0, this.cx));
    }

    protected DimLevel[] populateAggrLevels() throws DataException {
        String bindingName = OlapExpressionCompiler.getReferencedScriptObject(this.expr, "data");
        if (bindingName == null) {
            bindingName = OlapExpressionCompiler.getReferencedScriptObject(this.expr, "row");
        }
        if (bindingName == null) {
            return null;
        }
        return this.getAggregateOnLevels(bindingName);
    }

    private DimLevel[] getAggregateOnLevels(String bindingName) throws DataException {
        for (IBinding binding : this.queryDefn.getBindings()) {
            if (!binding.getBindingName().equals(bindingName)) continue;
            List aggrs = binding.getAggregatOns();
            if (aggrs.size() == 0) {
                if (OlapExpressionCompiler.getReferencedScriptObject(binding.getExpression(), "dimension") != null) {
                    return null;
                }
                IBinding directReferenceBinding = OlapExpressionUtil.getDirectMeasureBinding(binding, this.queryDefn.getBindings());
                if (directReferenceBinding != null) {
                    return this.getAggregateOnLevels(directReferenceBinding.getBindingName());
                }
                ArrayList levelList = new ArrayList();
                IEdgeDefinition rowEdge = this.queryDefn.getEdge(1);
                this.populateDimLevel(levelList, rowEdge);
                IEdgeDefinition colEdge = this.queryDefn.getEdge(2);
                this.populateDimLevel(levelList, colEdge);
                DimLevel[] levels = new DimLevel[levelList.size()];
                levelList.toArray(levels);
                return levels;
            }
            DimLevel[] levels = new DimLevel[aggrs.size()];
            int i = 0;
            while (i < aggrs.size()) {
                levels[i] = OlapExpressionUtil.getTargetDimLevel(aggrs.get(i).toString());
                ++i;
            }
            return levels;
        }
        return null;
    }

    private void populateDimLevel(List levelList, IEdgeDefinition edge) {
        if (edge == null) {
            return;
        }
        List<IDimensionDefinition> rowDims = edge.getDimensions();
        for (IDimensionDefinition dim : rowDims) {
            IHierarchyDefinition hirarchy = dim.getHierarchy().get(0);
            for (ILevelDefinition level : hirarchy.getLevels()) {
                levelList.add(new DimLevel(dim.getName(), level.getName()));
            }
        }
    }

    public DimLevel[] getAggrLevels() {
        return this.aggrLevels;
    }

    public String getDimensionName() {
        return this.dimName;
    }

    public ICubeFilterDefinition getCubeFilterDefinition() {
        return this.cubeFilter;
    }

    public boolean isAggregationFilter() {
        if (this.isAxisFilter) {
            return true;
        }
        return this.dimName == null;
    }

    protected IDimensionDefinition getTargetDimension() throws DataException {
        if (this.isAggregationFilter()) {
            ILevelDefinition targetLevel = this.cubeFilter.getTargetLevel();
            if (targetLevel == null) {
                throw new DataException("data.olap.ReferencedLevelNotFound");
            }
            IDimensionDefinition dimDefn = targetLevel.getHierarchy().getDimension();
            if (dimDefn == null) {
                throw new DataException("data.olap.ReferencedDimensionNotFound", this.dimName);
            }
            return dimDefn;
        }
        return super.getTargetDimension();
    }
}

