/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.util.regex.Pattern;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.launchConfigurations.AntWorkingDirectoryBlock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaJRETab;
import org.eclipse.jdt.internal.debug.ui.jres.JREDescriptor;
import org.eclipse.jdt.internal.debug.ui.launcher.VMArgumentsBlock;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;

public class AntJRETab
extends JavaJRETab {
    private static final String MAIN_TYPE_NAME = "org.eclipse.ant.internal.launching.remote.InternalAntRunner";
    private VMArgumentsBlock fVMArgumentsBlock = new VMArgumentsBlock();
    private AntWorkingDirectoryBlock fWorkingDirectoryBlock = new AntWorkingDirectoryBlock();

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "ant_jre_tab_context");
        Composite comp = (Composite)this.fJREBlock.getControl();
        ((GridData)comp.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)comp.getLayoutData()).verticalAlignment = 4;
        this.fVMArgumentsBlock.createControl(comp);
        ((GridData)this.fVMArgumentsBlock.getControl().getLayoutData()).horizontalSpan = 2;
        this.fWorkingDirectoryBlock.createControl(comp);
        ((GridData)this.fWorkingDirectoryBlock.getControl().getLayoutData()).horizontalSpan = 2;
    }

    protected JREDescriptor getDefaultJREDescriptor() {
        return new JREDescriptor(){

            public String getDescription() {
                return AntLaunchConfigurationMessages.AntJRETab_2;
            }
        };
    }

    protected JREDescriptor getSpecificJREDescriptor() {
        return new JREDescriptor(){

            public String getDescription() {
                return AntLaunchConfigurationMessages.AntJRETab_3;
            }
        };
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        boolean isDefaultJRE = this.fJREBlock.isDefaultJRE();
        this.fWorkingDirectoryBlock.setEnabled(!isDefaultJRE);
        this.fVMArgumentsBlock.setEnabled(!isDefaultJRE);
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
        if (isDefaultJRE) {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, null);
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
            configuration.setAttribute("org.eclipse.ant.ui.DEFAULT_VM_INSTALL", false);
        } else {
            super.performApply(configuration);
            IVMInstall vm = this.fJREBlock.getJRE();
            IPath path = this.fJREBlock.getPath();
            String id = JavaRuntime.getExecutionEnvironmentId((IPath)path);
            configuration.setAttribute("org.eclipse.ant.ui.DEFAULT_VM_INSTALL", vm == null || id != null ? false : vm.equals(this.getDefaultVMInstall((ILaunchConfiguration)configuration)));
            this.applySeparateVMAttributes(configuration);
            this.fVMArgumentsBlock.performApply(configuration);
            this.fWorkingDirectoryBlock.performApply(configuration);
        }
        this.setLaunchConfigurationWorkingCopy(configuration);
    }

    private void applySeparateVMAttributes(ILaunchConfigurationWorkingCopy configuration) {
        boolean userLogger;
        block7: {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, MAIN_TYPE_NAME);
            userLogger = false;
            try {
                String args = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", null);
                if (args == null) break block7;
                Pattern pattern = Pattern.compile("\\$\\{.*_prompt.*\\}");
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                String[] arguments = ExternalToolsUtil.parseStringIntoList((String)args);
                if (arguments == null) break block7;
                int i = 0;
                while (i < arguments.length) {
                    String resolved;
                    String arg = arguments[i];
                    if (arg.equals("-logger")) {
                        userLogger = true;
                        break;
                    }
                    if (!pattern.matcher(arg).find() && (resolved = manager.performStringSubstitution(arg, false)).equals("-logger")) {
                        userLogger = true;
                        break;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
        if (userLogger) {
            configuration.setAttribute("process_factory_id", null);
        } else {
            configuration.setAttribute("process_factory_id", "org.eclipse.ant.ui.remoteAntProcessFactory");
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        this.fVMArgumentsBlock.initializeFrom(configuration);
        this.fWorkingDirectoryBlock.initializeFrom(configuration);
        boolean separateVM = !this.fJREBlock.isDefaultJRE();
        this.fWorkingDirectoryBlock.setEnabled(separateVM);
        this.fVMArgumentsBlock.setEnabled(separateVM);
    }

    public boolean isValid(ILaunchConfiguration config) {
        return super.isValid(config) && this.fWorkingDirectoryBlock.isValid(config);
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.fWorkingDirectoryBlock.setLaunchConfigurationDialog(dialog);
        this.fVMArgumentsBlock.setLaunchConfigurationDialog(dialog);
    }

    public String getErrorMessage() {
        String m = super.getErrorMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getErrorMessage();
        }
        return m;
    }

    public String getMessage() {
        String m = super.getMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getMessage();
        }
        return m;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.setLaunchConfigurationWorkingCopy(workingCopy);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IVMInstall defaultVMInstall;
        super.setDefaults(config);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
        boolean usedefault = InstanceScope.INSTANCE.getNode("org.eclipse.ant.ui").getBoolean("workspacejre", false);
        if (!usedefault && (defaultVMInstall = this.getDefaultVMInstall((ILaunchConfiguration)config)) != null) {
            config.setAttribute("org.eclipse.ant.ui.DEFAULT_VM_INSTALL", false);
            this.setDefaultVMInstallAttributes(defaultVMInstall, config);
            this.applySeparateVMAttributes(config);
        }
    }

    private IVMInstall getDefaultVMInstall(ILaunchConfiguration config) {
        try {
            IJavaProject project = JavaRuntime.getJavaProject((ILaunchConfiguration)config);
            if (project != null) {
                return JavaRuntime.getVMInstall((IJavaProject)project);
            }
            return JavaRuntime.getDefaultVMInstall();
        }
        catch (CoreException coreException) {
            return JavaRuntime.getDefaultVMInstall();
        }
    }

    private void setDefaultVMInstallAttributes(IVMInstall defaultVMInstall, ILaunchConfigurationWorkingCopy config) {
        String vmName = defaultVMInstall.getName();
        String vmTypeID = defaultVMInstall.getVMInstallType().getId();
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, vmName);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, vmTypeID);
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

