/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.discovery.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptor;
import org.eclipse.mylyn.internal.discovery.ui.AbstractInstallJob;
import org.eclipse.mylyn.internal.discovery.ui.PrepareInstallProfileJob_e_3_5;
import org.eclipse.mylyn.internal.discovery.ui.PrepareInstallProfileJob_e_3_6;
import org.eclipse.mylyn.internal.discovery.ui.wizards.Messages;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DiscoveryUi {
    public static final String ID_PLUGIN = "org.eclipse.mylyn.discovery.ui";

    private DiscoveryUi() {
    }

    public static AbstractInstallJob createInstallJob() {
        List<ConnectorDescriptor> emptyList = Collections.emptyList();
        return DiscoveryUi.createInstallJob(emptyList);
    }

    public static AbstractInstallJob createInstallJob(List<ConnectorDescriptor> descriptors) {
        PrepareInstallProfileJob_e_3_6 runner = null;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.equinox.p2.engine");
        if (bundle != null && new VersionRange("[1.0.0,1.1.0)").isIncluded(bundle.getVersion())) {
            runner = new PrepareInstallProfileJob_e_3_5(descriptors);
        }
        if (runner == null) {
            runner = new PrepareInstallProfileJob_e_3_6(descriptors);
        }
        return runner;
    }

    public static boolean install(List<ConnectorDescriptor> descriptors, IRunnableContext context) {
        try {
            AbstractInstallJob runner = DiscoveryUi.createInstallJob(descriptors);
            context.run(true, true, (IRunnableWithProgress)runner);
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, ID_PLUGIN, NLS.bind((String)Messages.ConnectorDiscoveryWizard_installProblems, (Object[])new Object[]{e.getCause().getMessage()}), e.getCause());
            StatusManager.getManager().handle((IStatus)status, 7);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }
}

