/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import java.util.HashMap;
import java.util.Locale;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEmitterAdapter;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManager;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManagerFactory;

public class LayoutEngineContext {
    protected int maxWidth;
    protected int maxHeight;
    protected String format;
    protected IReportContent report;
    protected IContent unresolvedContent;
    protected Locale locale;
    protected long totalPage = 0L;
    protected long pageCount = 0L;
    protected long pageNumber = 0L;
    protected boolean autoPageBreak = true;
    protected LayoutEmitterAdapter emitter;
    protected boolean isFinished;
    protected boolean fitToPage = false;
    protected boolean pageBreakPaginationOnly = false;
    protected int pageOverflow = 4;
    protected int preferenceWidth = 0;
    protected boolean textWrapping = true;
    protected boolean fontSubstitution = true;
    protected boolean bidiProcessing = true;
    protected boolean enableHyphenation = false;
    private FontMappingManager fontManager;
    private int dpi = 0;
    private int totalPageTemplateWidth;
    private HashMap cachedTableHeaders = null;
    private HashMap cachedGroupHeaders = null;

    public boolean isFinished() {
        return this.isFinished;
    }

    public void setFinished(boolean isFinished) {
        this.isFinished = isFinished;
    }

    public void setEmitter(LayoutEmitterAdapter emitter) {
        this.emitter = emitter;
    }

    public void setAutoPageBreak(boolean autoPageBreak) {
        this.autoPageBreak = autoPageBreak;
    }

    public void addUnresolvedContent(IContent content) {
        this.unresolvedContent = content;
    }

    public IContent getUnresolvedContent() {
        return this.unresolvedContent;
    }

    public IReportContent getReport() {
        return this.report;
    }

    public void setReport(IReportContent report) {
        this.report = report;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxHeight(int height) {
        this.maxHeight = height;
    }

    public void setMaxWidth(int width) {
        this.maxWidth = width;
    }

    public void setFitToPage(boolean fitToPage) {
        this.fitToPage = fitToPage;
    }

    public boolean fitToPage() {
        return this.fitToPage;
    }

    public void setPagebreakPaginationOnly(boolean pageBreakPaginationOnly) {
        this.pageBreakPaginationOnly = pageBreakPaginationOnly;
        this.setAutoPageBreak(!pageBreakPaginationOnly);
    }

    public boolean pagebreakPaginationOnly() {
        return this.pageBreakPaginationOnly;
    }

    public int getPageOverflow() {
        return this.pageOverflow;
    }

    public void setPageOverflow(int pageOverflow) {
        this.pageOverflow = pageOverflow;
        if (pageOverflow != 4) {
            this.autoPageBreak = false;
        }
    }

    public void setPreferenceWidth(int preferenceWidth) {
        this.preferenceWidth = preferenceWidth;
    }

    public int getPreferenceWidth() {
        return this.preferenceWidth;
    }

    public void setTextWrapping(boolean textWrapping) {
        this.textWrapping = textWrapping;
    }

    public boolean getTextWrapping() {
        return this.textWrapping;
    }

    public void setFontSubstitution(boolean fontSubstitution) {
        this.fontSubstitution = fontSubstitution;
    }

    public boolean getFontSubstitution() {
        return this.fontSubstitution;
    }

    public void setBidiProcessing(boolean bidiProcessing) {
        this.bidiProcessing = bidiProcessing;
    }

    public boolean getBidiProcessing() {
        return this.bidiProcessing;
    }

    public boolean isEnableHyphenation() {
        return this.enableHyphenation;
    }

    public void setEnableHyphenation(boolean enableHyphenation) {
        this.enableHyphenation = enableHyphenation;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public FontMappingManager getFontManager() {
        if (this.fontManager == null) {
            this.fontManager = FontMappingManagerFactory.getInstance().getFontMappingManager(this.format, this.locale);
        }
        return this.fontManager;
    }

    public int getDpi() {
        return this.dpi;
    }

    public void setDpi(int dpi) {
        this.dpi = dpi;
    }

    public void setTotalPageTemplateWidth(int totalPageTemplateWidth) {
        this.totalPageTemplateWidth = totalPageTemplateWidth;
    }

    public int getTotalPageTemplateWidth() {
        return this.totalPageTemplateWidth;
    }

    public void setCachedHeaderMap(HashMap tableHeaders, HashMap groupHeaders) {
        this.cachedTableHeaders = tableHeaders;
        this.cachedGroupHeaders = groupHeaders;
    }

    protected ITableBandContent getWrappedTableHeader(InstanceID id) {
        Object cachedHeaders;
        if (this.cachedTableHeaders != null && (cachedHeaders = this.cachedTableHeaders.get(id)) != null) {
            return (ITableBandContent)cachedHeaders;
        }
        return null;
    }

    protected ITableBandContent getWrappedGroupHeader(InstanceID id) {
        Object cachedHeaders;
        if (this.cachedGroupHeaders != null && (cachedHeaders = this.cachedGroupHeaders.get(id)) != null) {
            return (ITableBandContent)cachedHeaders;
        }
        return null;
    }
}

