/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.BaseFont;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.layout.pdf.font.CompositeFont;
import org.eclipse.birt.report.engine.layout.pdf.font.CompositeFontConfig;
import org.eclipse.birt.report.engine.layout.pdf.font.FontConfigReader;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingConfig;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManager;
import org.eclipse.birt.report.engine.util.SecurityUtil;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

public class FontMappingManagerFactory {
    protected static Logger logger = Logger.getLogger(FontConfigReader.class.getName());
    protected static FontMappingManagerFactory instance;
    protected HashSet fontPathes = new HashSet();
    protected HashMap fontEncodings = new HashMap();
    protected HashMap cachedConfigs = new HashMap();
    protected HashMap cachedManagers = new HashMap();
    static final String CONFIG_NAME = "fontsConfig";
    HashMap cachedCompositeFonts = new HashMap();
    private HashMap baseFonts = new HashMap();

    public static synchronized FontMappingManagerFactory getInstance() {
        if (instance == null) {
            instance = new FontMappingManagerFactory();
        }
        return instance;
    }

    protected FontMappingManagerFactory() {
        this.registerJavaFonts();
        String embeddedFonts = this.getEmbededFontPath();
        if (embeddedFonts != null) {
            this.registerFontPath(embeddedFonts);
        }
    }

    public synchronized FontMappingManager getFontMappingManager(String format, Locale locale) {
        FontMappingManager manager;
        HashMap<Locale, FontMappingManager> managers = (HashMap<Locale, FontMappingManager>)this.cachedManagers.get(format);
        if (managers == null) {
            managers = new HashMap<Locale, FontMappingManager>();
            this.cachedManagers.put(format, managers);
        }
        if ((manager = (FontMappingManager)managers.get(locale)) == null) {
            manager = this.createFontMappingManager(format, locale);
            managers.put(locale, manager);
        }
        return manager;
    }

    public FontMappingManager createFontMappingManager(FontMappingConfig config, Locale locale) {
        this.registerJavaFonts();
        for (String fontPath : config.fontPaths) {
            if (this.fontPathes.contains(fontPath)) continue;
            this.fontPathes.add(fontPath);
            this.registerFontPath(fontPath);
        }
        this.fontEncodings.putAll(config.fontEncodings);
        return new FontMappingManager(this, null, config, locale);
    }

    private void registerJavaFonts() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String javaHome = System.getProperty("java.home");
                String fontsFolder = String.valueOf(javaHome) + File.separatorChar + "lib" + File.separatorChar + "fonts";
                FontFactory.registerDirectory((String)fontsFolder);
                return null;
            }
        });
    }

    protected FontMappingManager createFontMappingManager(String format, Locale locale) {
        String formatString = format.toLowerCase();
        String[] configNames = new String[19];
        int count = 0;
        String osgiName = this.getOSGIOSName();
        String osName = this.getOSName();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuffer sb = new StringBuffer();
        configNames[count++] = sb.append(CONFIG_NAME).toString();
        if (osgiName != null) {
            configNames[count++] = sb.append('_').append(osgiName).toString();
            configNames[count++] = sb.append('_').append(language).toString();
            configNames[count++] = sb.append('_').append(country).toString();
            configNames[count++] = sb.append('_').append(variant).toString();
        }
        if (osName != null && !osName.equals(osgiName)) {
            sb.setLength(0);
            sb.append(CONFIG_NAME);
            configNames[count++] = sb.append('_').append(osName).toString();
            configNames[count++] = sb.append('_').append(language).toString();
            configNames[count++] = sb.append('_').append(country).toString();
            configNames[count++] = sb.append('_').append(variant).toString();
        }
        sb.setLength(0);
        configNames[count++] = sb.append(CONFIG_NAME).append('_').append(formatString).toString();
        if (osgiName != null) {
            configNames[count++] = sb.append('_').append(osgiName).toString();
            configNames[count++] = sb.append('_').append(language).toString();
            configNames[count++] = sb.append('_').append(country).toString();
            configNames[count++] = sb.append('_').append(variant).toString();
        }
        if (osName != null && !osName.equals(osgiName)) {
            sb.setLength(0);
            sb.append(CONFIG_NAME).append('_').append(formatString);
            configNames[count++] = sb.append('_').append(osName).toString();
            configNames[count++] = sb.append('_').append(language).toString();
            configNames[count++] = sb.append('_').append(country).toString();
            configNames[count++] = sb.append('_').append(variant).toString();
        }
        FontMappingManager manager = null;
        int i = 0;
        while (i < count) {
            FontMappingConfig config = this.loadFontMappingConfig(configNames[i]);
            if (config != null) {
                manager = this.createFontMappingManager(manager, config, locale);
            }
            ++i;
        }
        return manager;
    }

    protected FontMappingManager createFontMappingManager(FontMappingManager parent, FontMappingConfig config, Locale locale) {
        FontMappingManager manager;
        HashMap<Locale, FontMappingManager> managers = (HashMap<Locale, FontMappingManager>)this.cachedManagers.get(config);
        if (managers == null) {
            managers = new HashMap<Locale, FontMappingManager>();
            this.cachedManagers.put(config, managers);
        }
        if ((manager = (FontMappingManager)managers.get(locale)) == null) {
            manager = new FontMappingManager(this, parent, config, locale);
            managers.put(locale, manager);
        }
        return manager;
    }

    private String getOSName() {
        String osName = SecurityUtil.getSystemProperty("os.name");
        if (osName != null) {
            return osName.replace(' ', '_');
        }
        return null;
    }

    private String getOSGIOSName() {
        String osName = Platform.getOS();
        if ("unknown".equals(osName)) {
            return null;
        }
        return osName;
    }

    protected FontMappingConfig getFontMappingConfig(String configName) {
        FontMappingConfig config = (FontMappingConfig)this.cachedConfigs.get(configName);
        if (config == null && !this.cachedConfigs.containsKey(configName)) {
            config = this.loadFontMappingConfig(configName);
            this.cachedConfigs.put(configName, config);
        }
        return config;
    }

    protected FontMappingConfig loadFontMappingConfig(String configName) {
        URL url = this.getConfigURL(configName);
        if (url != null) {
            try {
                long start = System.currentTimeMillis();
                FontMappingConfig config = new FontConfigReader().parseConfig(url);
                long end = System.currentTimeMillis();
                logger.info("load font config in " + url + " cost " + (end - start) + "ms");
                if (config != null) {
                    for (String fontPath : config.fontPaths) {
                        if (this.fontPathes.contains(fontPath)) continue;
                        this.fontPathes.add(fontPath);
                        this.registerFontPath(fontPath);
                    }
                    this.fontEncodings.putAll(config.fontEncodings);
                    return config;
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, String.valueOf(configName) + ":" + ex.getMessage(), ex);
            }
        }
        return null;
    }

    protected URL getConfigURL(String configName) {
        String fileName = String.valueOf(configName) + ".xml";
        Bundle bundle = org.eclipse.core.runtime.Platform.getBundle((String)"org.eclipse.birt.report.engine.fonts");
        if (bundle != null) {
            return bundle.getEntry(fileName);
        }
        return this.getClass().getClassLoader().getResource(fileName);
    }

    CompositeFont createCompositeFont(FontMappingManager manager, CompositeFontConfig fontConfig, String[] sequence) {
        CompositeFont font;
        HashMap<String[], CompositeFont> fonts = (HashMap<String[], CompositeFont>)this.cachedCompositeFonts.get(fontConfig);
        if (fonts == null) {
            fonts = new HashMap<String[], CompositeFont>();
            this.cachedCompositeFonts.put(fontConfig, fonts);
        }
        if ((font = (CompositeFont)fonts.get(sequence)) == null) {
            font = new CompositeFont(manager, fontConfig, sequence);
            fonts.put(sequence, font);
        }
        return font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseFont createFont(String familyName, int fontStyle) {
        String key = String.valueOf(familyName) + fontStyle;
        BaseFont bf = null;
        HashMap hashMap = this.baseFonts;
        synchronized (hashMap) {
            if (this.baseFonts.containsKey(key)) {
                bf = (BaseFont)this.baseFonts.get(key);
            } else {
                try {
                    String fontEncoding = (String)this.fontEncodings.get(familyName);
                    if (fontEncoding == null) {
                        fontEncoding = "Identity-H";
                    }
                    bf = FontFactory.getFont((String)familyName, (String)fontEncoding, (boolean)true, (float)14.0f, (int)fontStyle).getBaseFont();
                }
                catch (Throwable de) {
                    logger.log(Level.WARNING, de.getMessage(), de);
                }
                this.baseFonts.put(key, bf);
            }
            if (bf == null && fontStyle != 0) {
                return this.createFont(familyName, 0);
            }
        }
        return bf;
    }

    private void registerFontPath(final String fontPath) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                long start = System.currentTimeMillis();
                File file = new File(fontPath);
                if (file.exists()) {
                    if (file.isDirectory()) {
                        FontFactory.registerDirectory((String)fontPath);
                    } else {
                        FontFactory.register((String)fontPath);
                    }
                }
                long end = System.currentTimeMillis();
                logger.info("register fonts in " + fontPath + " cost:" + (end - start) + "ms");
                return null;
            }
        });
    }

    protected String getEmbededFontPath() {
        Bundle bundle = org.eclipse.core.runtime.Platform.getBundle((String)"org.eclipse.birt.report.engine.fonts");
        if (bundle == null) {
            return null;
        }
        Path path = new Path("/fonts");
        URL fileURL = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (fileURL == null) {
            return null;
        }
        String fontPath = null;
        try {
            fontPath = FileLocator.toFileURL((URL)fileURL).getPath();
            if (fontPath != null && fontPath.length() >= 3 && fontPath.charAt(2) == ':') {
                return fontPath.substring(1);
            }
            return fontPath;
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, ioe.getMessage(), ioe);
            return null;
        }
    }
}

