/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.core.data.Messages;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;

public class DefaultTaskSchema {
    private static Map<String, Field> fieldByKey = new HashMap<String, Field>();
    public static final EnumSet<Flag> NO_FLAGS = EnumSet.noneOf(Flag.class);
    public static final Field ADD_SELF_CC = DefaultTaskSchema.createField("task.common.addselfcc", Messages.DefaultTaskSchema_Add_Self_to_CC_Label, "boolean");
    public static final Field ATTACHMENT_AUTHOR = DefaultTaskSchema.createField("task.common.attachment.author", Messages.DefaultTaskSchema_Author_Label, "person");
    public static final Field ATTACHMENT_CONTENT_TYPE = DefaultTaskSchema.createField("task.common.attachment.ctype", Messages.DefaultTaskSchema_Content_Type_Label, "shortText");
    public static final Field ATTACHMENT_DATE = DefaultTaskSchema.createField("task.common.attachment.date", Messages.DefaultTaskSchema_Created_Label, "dateTime", Flag.READ_ONLY);
    public static final Field ATTACHMENT_DESCRIPTION = DefaultTaskSchema.createField("task.common.attachment.description", Messages.DefaultTaskSchema_Description_Label, "shortRichText");
    public static final Field ATTACHMENT_FILENAME = DefaultTaskSchema.createField("filename", Messages.DefaultTaskSchema_Filename_Label, "shortText");
    public static final Field ATTACHMENT_ID = DefaultTaskSchema.createField("task.common.attachment.id", Messages.DefaultTaskSchema_ID_Label, "shortText", Flag.READ_ONLY);
    public static final Field ATTACHMENT_IS_DEPRECATED = DefaultTaskSchema.createField("task.common.attachment.deprecated", Messages.DefaultTaskSchema_Deprecated_Label, "boolean");
    public static final Field ATTACHMENT_IS_PATCH = DefaultTaskSchema.createField("task.common.attachment.patch", Messages.DefaultTaskSchema_Patch_Label, "boolean");
    public static final Field ATTACHMENT_REPLACE_EXISTING = DefaultTaskSchema.createField("task.common.attachment.replaceExisting", Messages.DefaultTaskSchema_Replace_existing_attachment, "boolean");
    public static final Field ATTACHMENT_SIZE = DefaultTaskSchema.createField("task.common.attachment.size", Messages.DefaultTaskSchema_Size_Label, "long", Flag.READ_ONLY);
    public static final Field ATTACHMENT_URL = DefaultTaskSchema.createField("task.common.attachment.url", Messages.DefaultTaskSchema_URL_Label, "url");
    public static final Field COMMENT_ATTACHMENT_ID = DefaultTaskSchema.createField("task.common.comment.attachment.id", Messages.DefaultTaskSchema_Attachment_ID_Label, "shortText", Flag.READ_ONLY);
    public static final Field COMMENT_AUTHOR = DefaultTaskSchema.createField("task.common.comment.author", Messages.DefaultTaskSchema_Author_Label, "person", Flag.READ_ONLY);
    public static final Field COMMENT_DATE = DefaultTaskSchema.createField("task.common.comment.date", Messages.DefaultTaskSchema_Created_Label, "dateTime", Flag.READ_ONLY);
    public static final Field COMMENT_HAS_ATTACHMENT = DefaultTaskSchema.createField("task.common.comment.attachment", Messages.DefaultTaskSchema_Attachment_Label, "boolean", Flag.READ_ONLY);
    public static final Field COMMENT_NUMBER = DefaultTaskSchema.createField("task.common.comment.number", Messages.DefaultTaskSchema_Number_Label, "integer", Flag.READ_ONLY);
    public static final Field COMMENT_TEXT = DefaultTaskSchema.createField("task.common.comment.text", Messages.DefaultTaskSchema_Description_Label, "longRichText", Flag.READ_ONLY);
    public static final Field COMMENT_URL = DefaultTaskSchema.createField("task.common.comment.url", Messages.DefaultTaskSchema_URL_Label, "url", Flag.READ_ONLY);
    public static final Field COMPONENT = DefaultTaskSchema.createField("task.common.component", Messages.DefaultTaskSchema_Component_Label, "singleSelect", Flag.ATTRIBUTE);
    public static final Field DATE_COMPLETION = DefaultTaskSchema.createField("task.common.date.completed", Messages.DefaultTaskSchema_Completion_Label, "date", Flag.READ_ONLY);
    public static final Field DATE_CREATION = DefaultTaskSchema.createField("task.common.date.created", Messages.DefaultTaskSchema_Created_Label, "date", Flag.READ_ONLY);
    public static final Field DATE_DUE = DefaultTaskSchema.createField("task.common.date.due", Messages.DefaultTaskSchema_Due_Label, "date");
    public static final Field DATE_MODIFICATION = DefaultTaskSchema.createField("task.common.date.modified", Messages.DefaultTaskSchema_Modified_Label, "date", Flag.READ_ONLY);
    public static final Field DESCRIPTION = DefaultTaskSchema.createField("task.common.description", Messages.DefaultTaskSchema_Description_Label, "longRichText");
    public static final Field KEYWORDS = DefaultTaskSchema.createField("task.common.keywords", Messages.DefaultTaskSchema_Keywords_Label, "multiSelect", Flag.ATTRIBUTE);
    public static final Field NEW_COMMENT = DefaultTaskSchema.createField("task.common.comment.new", Messages.DefaultTaskSchema_Rank_Label, "longRichText");
    public static final Field PRIORITY = DefaultTaskSchema.createField("task.common.priority", Messages.DefaultTaskSchema_Priority_Label, "singleSelect", Flag.ATTRIBUTE);
    public static final Field PRODUCT = DefaultTaskSchema.createField("task.common.product", Messages.DefaultTaskSchema_Product_Label, "singleSelect", Flag.ATTRIBUTE);
    public static final Field RANK = DefaultTaskSchema.createField("task.common.rank", Messages.DefaultTaskSchema_Rank_Label, "integer", Flag.READ_ONLY);
    public static final Field RESOLUTION = DefaultTaskSchema.createField("task.common.resolution", Messages.DefaultTaskSchema_Resolution_Label, "singleSelect", Flag.READ_ONLY);
    public static final Field SEVERITY = DefaultTaskSchema.createField("task.common.severity", Messages.DefaultTaskSchema_Severity_Label, "singleSelect", Flag.ATTRIBUTE);
    public static final Field STATUS = DefaultTaskSchema.createField("task.common.status", Messages.DefaultTaskSchema_Status_Label, "shortText", Flag.READ_ONLY);
    public static final Field SUMMARY = DefaultTaskSchema.createField("task.common.summary", Messages.DefaultTaskSchema_Summary_Label, "shortRichText");
    public static final Field TASK_KEY = DefaultTaskSchema.createField("task.common.key", Messages.DefaultTaskSchema_Key_Label, "shortText", Flag.READ_ONLY);
    public static final Field TASK_KIND = DefaultTaskSchema.createField("task.common.kind", Messages.DefaultTaskSchema_Kind_Label, "singleSelect", Flag.ATTRIBUTE);
    public static final Field USER_ASSIGNED = DefaultTaskSchema.createField("task.common.user.assigned", Messages.DefaultTaskSchema_Owner_Label, "person", Flag.PEOPLE);
    public static final Field USER_REPORTER = DefaultTaskSchema.createField("task.common.user.reporter", Messages.DefaultTaskSchema_Reporter_Label, "person", Flag.PEOPLE);
    public static final Field TASK_URL = DefaultTaskSchema.createField("task.common.url", Messages.DefaultTaskSchema_URL_Label, "url", Flag.READ_ONLY);

    public static Field getField(String taskKey) {
        return fieldByKey.get(taskKey);
    }

    protected static Field createField(String key, String label, String type) {
        return DefaultTaskSchema.createField(key, label, type, null);
    }

    protected static Field createField(String key, String label, String type, Flag ... flags) {
        Field field = new Field(key, label, type, flags);
        fieldByKey.put(key, field);
        return field;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Field {
        private EnumSet<Flag> flags;
        private final String key;
        private final String label;
        private final String type;

        protected Field(String key, String label, String type) {
            this(key, label, type, null);
        }

        protected Field(String key, String label, String type, Flag ... flags) {
            Assert.isNotNull((Object)key);
            Assert.isNotNull((Object)label);
            Assert.isNotNull((Object)type);
            this.key = key;
            this.label = label;
            this.type = type;
            this.flags = flags == null ? NO_FLAGS : EnumSet.copyOf(Arrays.asList(flags));
        }

        public TaskAttribute createAttribute(TaskAttribute parent) {
            TaskAttribute attribute = parent.createMappedAttribute(this.getKey());
            TaskAttributeMetaData metaData = attribute.getMetaData();
            metaData.setLabel(this.getLabel());
            metaData.setType(this.getType());
            metaData.setReadOnly(this.isReadOnly());
            metaData.setKind(this.getKind());
            Map<String, String> options = this.getDefaultOptions();
            if (options != null) {
                for (Map.Entry<String, String> option : options.entrySet()) {
                    attribute.putOption(option.getKey(), option.getValue());
                }
            }
            return attribute;
        }

        public Map<String, String> getDefaultOptions() {
            return Collections.emptyMap();
        }

        public String getKey() {
            return this.key;
        }

        public String getKind() {
            if (this.flags.contains((Object)Flag.ATTRIBUTE)) {
                return "task.common.kind.default";
            }
            if (this.flags.contains((Object)Flag.PEOPLE)) {
                return "task.common.kind.people";
            }
            if (this.flags.contains((Object)Flag.OPERATION)) {
                return "task.common.kind.operation";
            }
            return null;
        }

        public String getLabel() {
            return this.label;
        }

        public String getType() {
            return this.type;
        }

        public boolean isReadOnly() {
            return this.flags.contains((Object)Flag.READ_ONLY);
        }

        public String toString() {
            return this.getLabel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        ATTRIBUTE,
        PEOPLE,
        READ_ONLY,
        OPERATION;

    }
}

