/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.notifications;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.internal.tasks.core.notifications.ServiceMessage;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMessageXmlHandler
extends DefaultHandler {
    private static final String TAG_MESSAGE = "ServiceMessage";
    private StringBuilder characters;
    private final List<ServiceMessage> messages = new ArrayList<ServiceMessage>();
    private ServiceMessage message;

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (TAG_MESSAGE.equals(qName.trim())) {
            this.message = new ServiceMessage();
        }
        this.characters = new StringBuilder();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.message == null) {
            return;
        }
        if (TAG_MESSAGE.equals(qName.trim())) {
            if (this.message.isValid()) {
                this.messages.add(this.message);
            }
        } else {
            String parsedText = this.characters.toString();
            try {
                ServiceMessage.Element element = ServiceMessage.Element.valueOf(qName.trim().toUpperCase());
                switch (element) {
                    case ID: {
                        this.message.setId(parsedText);
                        break;
                    }
                    case DESCRIPTION: {
                        this.message.setDescription(parsedText);
                        break;
                    }
                    case TITLE: {
                        this.message.setTitle(parsedText);
                        break;
                    }
                    case URL: {
                        this.message.setUrl(parsedText);
                        break;
                    }
                    case IMAGE: {
                        this.message.setImage(parsedText);
                        break;
                    }
                    case VERSION: {
                        this.message.setVersion(parsedText);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public List<ServiceMessage> getMessages() {
        return new ArrayList<ServiceMessage>(this.messages);
    }
}

