/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.ui.notifications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationAction;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationCategory;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationEvent;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationHandler;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationSinkDescriptor;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationsExtensionReader;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationModel {
    private boolean dirty;
    private final Map<String, NotificationHandler> handlerByEventId = new HashMap<String, NotificationHandler>();

    public NotificationModel(IMemento memento) {
    }

    public Collection<NotificationCategory> getCategories() {
        return NotificationsExtensionReader.getCategories();
    }

    public NotificationHandler getNotificationHandler(String eventId) {
        return this.handlerByEventId.get(eventId);
    }

    public NotificationHandler getOrCreateNotificationHandler(NotificationEvent event) {
        NotificationHandler handler = this.getNotificationHandler(event.getId());
        if (handler == null) {
            handler = new NotificationHandler(event, this.getActions(event));
            this.handlerByEventId.put(event.getId(), handler);
        }
        return handler;
    }

    private List<NotificationAction> getActions(NotificationEvent event) {
        List<NotificationSinkDescriptor> descriptors = NotificationsExtensionReader.getSinks();
        ArrayList<NotificationAction> actions = new ArrayList<NotificationAction>(descriptors.size());
        for (NotificationSinkDescriptor descriptor : descriptors) {
            NotificationAction action = new NotificationAction(descriptor);
            action.setSelected(event.isSelected());
            actions.add(action);
        }
        return actions;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void save(IMemento memento) {
        this.setDirty(false);
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setNotificationHandler(String eventId, NotificationHandler handler) {
        this.handlerByEventId.put(eventId, handler);
        this.setDirty(true);
    }
}

