/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.ui.notifications;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.ui.notifications.AbstractNotification;
import org.eclipse.mylyn.commons.ui.notifications.INotificationService;
import org.eclipse.mylyn.commons.ui.notifications.NotificationSink;
import org.eclipse.mylyn.commons.ui.notifications.NotificationSinkEvent;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationSinkDescriptor;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationsExtensionReader;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationsPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationService
implements INotificationService {
    @Override
    public void notify(List<? extends AbstractNotification> notifications) {
        if (!NotificationsPlugin.getDefault().getPreferenceStore().getBoolean("notifications.enabled")) {
            return;
        }
        List<NotificationSinkDescriptor> descriptors = NotificationsExtensionReader.getSinks();
        for (NotificationSinkDescriptor descriptor : descriptors) {
            final NotificationSink sink = descriptor.getSink();
            if (sink == null) continue;
            final NotificationSinkEvent event = new NotificationSinkEvent(new ArrayList<AbstractNotification>(notifications));
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.commons.notifications", "Sink failed: " + sink.getClass(), e));
                }

                public void run() throws Exception {
                    sink.notify(event);
                }
            });
        }
    }
}

