/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.ui.notifications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationCategory;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationEvent;
import org.eclipse.mylyn.internal.commons.ui.notifications.NotificationSinkDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationsExtensionReader {
    private static boolean errorLogged = false;
    static List<NotificationSinkDescriptor> sinks;

    public static Collection<NotificationCategory> getCategories() {
        IExtension[] extensions;
        HashMap<String, NotificationCategory> categoryById = new HashMap<String, NotificationCategory>();
        MultiStatus result = new MultiStatus("org.eclipse.mylyn.commons.notifications", 0, "Notifcation extensions failed to load", null);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint repositoriesExtensionPoint = registry.getExtensionPoint("org.eclipse.mylyn.commons.notifications.notifications");
        IExtension[] iExtensionArray = extensions = repositoriesExtensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status;
            IConfigurationElement element;
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                element = iConfigurationElementArray[n4];
                if ("category".equals(element.getName())) {
                    NotificationCategory category = new NotificationCategory(element);
                    status = category.validate();
                    if (status.isOK()) {
                        categoryById.put(category.getId(), category);
                    } else {
                        result.add(status);
                    }
                }
                ++n4;
            }
            iConfigurationElementArray = elements;
            n3 = elements.length;
            n4 = 0;
            while (n4 < n3) {
                element = iConfigurationElementArray[n4];
                if ("event".equals(element.getName())) {
                    NotificationEvent event = new NotificationEvent(element);
                    status = event.validate();
                    if (status.isOK()) {
                        NotificationCategory category = (NotificationCategory)categoryById.get(event.getCategoryId());
                        if (category != null) {
                            category.addEvent(event);
                        } else {
                            result.add((IStatus)new Status(4, "org.eclipse.mylyn.commons.notifications", NLS.bind((String)"Extension {0} contributed by {1} specify unknown category ''{2}''", (Object[])new String[]{element.getNamespaceIdentifier(), element.getContributor().getName(), event.getCategoryId()})));
                        }
                    } else {
                        result.add(status);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        if (!result.isOK() && !errorLogged) {
            StatusManager.getManager().handle((IStatus)result);
            errorLogged = true;
        }
        return categoryById.values();
    }

    public static List<NotificationSinkDescriptor> getSinks() {
        IExtension[] extensions;
        if (sinks != null) {
            return sinks;
        }
        sinks = new ArrayList<NotificationSinkDescriptor>();
        MultiStatus result = new MultiStatus("org.eclipse.mylyn.commons.notifications", 0, "Notifcation extensions failed to load", null);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint repositoriesExtensionPoint = registry.getExtensionPoint("org.eclipse.mylyn.commons.notifications.notifications");
        IExtension[] iExtensionArray = extensions = repositoriesExtensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if ("sink".equals(element.getName())) {
                    NotificationSinkDescriptor descriptor = new NotificationSinkDescriptor(element);
                    IStatus status = descriptor.validate();
                    if (status.isOK()) {
                        sinks.add(descriptor);
                    } else {
                        result.add(status);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        if (!result.isOK()) {
            StatusManager.getManager().handle((IStatus)result);
        }
        return sinks;
    }
}

