/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IGroupInstanceInfo;
import org.eclipse.birt.data.engine.api.IInputParameterBinding;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryExecutionHints;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.ExprUtil;
import org.eclipse.birt.data.engine.impl.document.FilterDefnUtil;
import org.eclipse.birt.data.engine.impl.document.GroupDefnUtil;

public class QueryCompUtil {
    public static boolean isIVQueryDefnEqual(int mode, IBaseQueryDefinition originalQuery, IBaseQueryDefinition newQuery) throws DataException {
        if (originalQuery == newQuery) {
            return true;
        }
        if (originalQuery == null || newQuery == null) {
            return false;
        }
        if (!(originalQuery instanceof IQueryDefinition) || !(newQuery instanceof IQueryDefinition)) {
            return false;
        }
        if (((IQueryDefinition)newQuery).getDataSetName() == null) {
            return false;
        }
        return QueryCompUtil.isQueryDefnEqual(mode, originalQuery, newQuery, true, true);
    }

    public static boolean isQueryDefnEqual(int mode, IBaseQueryDefinition qd1, IBaseQueryDefinition qd2, boolean onIVMode, boolean isSubQueryNameCared) throws DataException {
        if (qd1 == qd2) {
            return true;
        }
        if (qd1 == null || qd2 == null) {
            return false;
        }
        if (!QueryCompUtil.isEqualSorts(qd1.getSorts(), qd2.getSorts())) {
            return false;
        }
        if (!QueryCompUtil.isEqualFilters(qd1.getFilters(), qd2.getFilters())) {
            return false;
        }
        if (!QueryCompUtil.isEqualBindings(qd1.getBindings(), qd2.getBindings())) {
            return false;
        }
        if (!QueryCompUtil.isEqualGroups(qd1.getGroups(), qd2.getGroups(), onIVMode)) {
            return false;
        }
        if (qd1.usesDetails() != qd2.usesDetails()) {
            return false;
        }
        if (qd1.getMaxRows() != qd2.getMaxRows()) {
            return false;
        }
        if (mode == 2 && qd1.cacheQueryResults() != qd2.cacheQueryResults()) {
            return false;
        }
        if (!QueryCompUtil.isSubQueryEquals(qd1.getSubqueries(), qd2.getSubqueries(), onIVMode)) {
            return false;
        }
        if (qd1 instanceof IQueryDefinition && qd2 instanceof IQueryDefinition) {
            IQueryExecutionHints hint2;
            IQueryExecutionHints hint1;
            IQueryDefinition queryDefn1 = (IQueryDefinition)qd1;
            IQueryDefinition queryDefn2 = (IQueryDefinition)qd2;
            if (!onIVMode) {
                if (!QueryCompUtil.isEqualString(queryDefn1.getDataSetName(), queryDefn2.getDataSetName())) {
                    return false;
                }
                if (!QueryCompUtil.isInputParameterBindingEquals(queryDefn1.getInputParamBindings(), queryDefn2.getInputParamBindings())) {
                    return false;
                }
                if (!QueryCompUtil.isColumnProjectionEquals(queryDefn1.getColumnProjection(), queryDefn2.getColumnProjection())) {
                    return false;
                }
            }
            if (!QueryCompUtil.compareHints(hint1 = queryDefn1.getQueryExecutionHints(), hint2 = queryDefn2.getQueryExecutionHints())) {
                return false;
            }
        }
        if (qd1 instanceof ISubqueryDefinition && qd2 instanceof ISubqueryDefinition) {
            ISubqueryDefinition subQueryDefn1 = (ISubqueryDefinition)qd1;
            ISubqueryDefinition subQueryDefn2 = (ISubqueryDefinition)qd2;
            if (isSubQueryNameCared && !QueryCompUtil.isEqualString(subQueryDefn1.getName(), subQueryDefn2.getName())) {
                return false;
            }
            if (subQueryDefn1.applyOnGroup() != subQueryDefn2.applyOnGroup()) {
                return false;
            }
        }
        return true;
    }

    private static boolean compareHints(IQueryExecutionHints hint1, IQueryExecutionHints hint2) {
        if (hint1 == hint2) {
            return true;
        }
        if (hint1 == null || hint2 == null) {
            return false;
        }
        if (hint1.doSortBeforeGrouping() != hint2.doSortBeforeGrouping()) {
            return false;
        }
        if (hint1.getTargetGroupInstances().size() != hint2.getTargetGroupInstances().size()) {
            return false;
        }
        int i = 0;
        while (i < hint1.getTargetGroupInstances().size()) {
            IGroupInstanceInfo info1 = hint1.getTargetGroupInstances().get(i);
            IGroupInstanceInfo info2 = hint2.getTargetGroupInstances().get(i);
            if (info1.getGroupLevel() != info2.getGroupLevel()) {
                return false;
            }
            if (info1.getRowId() != info2.getRowId()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isColumnProjectionEquals(String[] columnProjection1, String[] columnProjection2) {
        if (columnProjection1 == columnProjection2) {
            return true;
        }
        if (columnProjection1 == null || columnProjection2 == null) {
            return false;
        }
        if (columnProjection1.length != columnProjection2.length) {
            return false;
        }
        int i = 0;
        while (i < columnProjection1.length) {
            if (!QueryCompUtil.isEqualString(columnProjection1[i], columnProjection2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isInputParameterBindingEquals(Collection inputParamBindings1, Collection inputParamBindings2) {
        if (inputParamBindings1 == inputParamBindings2) {
            return true;
        }
        if (inputParamBindings1 == null || inputParamBindings2 == null) {
            return false;
        }
        if (inputParamBindings1.size() != inputParamBindings2.size()) {
            return false;
        }
        Iterator it1 = inputParamBindings1.iterator();
        Iterator it2 = inputParamBindings2.iterator();
        while (it1.hasNext()) {
            IInputParameterBinding binding1 = (IInputParameterBinding)it1.next();
            IInputParameterBinding binding2 = (IInputParameterBinding)it2.next();
            if (!QueryCompUtil.isTwoExpressionEqual(binding1.getExpr(), binding2.getExpr())) {
                return false;
            }
            if (!QueryCompUtil.isEqualString(binding1.getName(), binding2.getName())) {
                return false;
            }
            if (binding1.getPosition() == binding2.getPosition()) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqualGroups(List group1, List group2, boolean onIVMode) throws DataException {
        if (group1 == group2) {
            return true;
        }
        if (group1 == null || group2 == null) {
            return false;
        }
        if (group1.size() != group2.size()) {
            return false;
        }
        int i = 0;
        while (i < group1.size()) {
            IGroupDefinition groupDefn1 = (IGroupDefinition)group1.get(i);
            IGroupDefinition groupDefn2 = (IGroupDefinition)group2.get(i);
            if (!QueryCompUtil.isEqualString(groupDefn1.getName(), groupDefn2.getName())) {
                return false;
            }
            if (!QueryCompUtil.isEqualFilters(groupDefn1.getFilters(), groupDefn2.getFilters())) {
                return false;
            }
            if (!QueryCompUtil.isEqualSorts(groupDefn1.getSorts(), groupDefn2.getSorts())) {
                return false;
            }
            if (groupDefn1.getInterval() != groupDefn2.getInterval()) {
                return false;
            }
            if (groupDefn1.getIntervalRange() != groupDefn2.getIntervalRange()) {
                return false;
            }
            if (!QueryCompUtil.isEqualString(groupDefn1.getIntervalStart(), groupDefn2.getIntervalStart())) {
                return false;
            }
            if (!QueryCompUtil.isEqualString(groupDefn1.getKeyColumn(), groupDefn2.getKeyColumn())) {
                return false;
            }
            if (!QueryCompUtil.isEqualString(groupDefn1.getKeyExpression(), groupDefn2.getKeyExpression())) {
                return false;
            }
            if (groupDefn1.getSortDirection() != groupDefn2.getSortDirection()) {
                return false;
            }
            if (!QueryCompUtil.isSubQueryEquals(groupDefn1.getSubqueries(), groupDefn2.getSubqueries(), onIVMode)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isSubQueryEquals(Collection subQueries1, Collection subQueries2, boolean onIVMode) throws DataException {
        if (subQueries1 == subQueries2) {
            return true;
        }
        if (subQueries1 == null || subQueries2 == null) {
            return false;
        }
        if (subQueries1.size() != subQueries2.size()) {
            return false;
        }
        Iterator it1 = subQueries1.iterator();
        Iterator it2 = subQueries2.iterator();
        while (it1.hasNext()) {
            ISubqueryDefinition sub2;
            ISubqueryDefinition sub1 = (ISubqueryDefinition)it1.next();
            if (QueryCompUtil.isQueryDefnEqual(-1, sub1, sub2 = (ISubqueryDefinition)it2.next(), onIVMode, true)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqualBindings(Map rs1, Map rs2) throws DataException {
        if (rs1 == rs2) {
            return true;
        }
        if (rs1 == null || rs2 == null) {
            return false;
        }
        if (rs1.size() != rs2.size()) {
            return false;
        }
        for (Object key : rs1.keySet()) {
            Object oldObj = rs1.get(key);
            Object newObj = rs2.get(key);
            if (oldObj != null && newObj != null) {
                if (QueryCompUtil.isTwoBindingEqual((IBinding)newObj, (IBinding)oldObj)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean isTwoBindingEqual(IBinding b1, IBinding b2) throws DataException {
        if (!QueryCompUtil.isTwoExpressionEqual(b1.getExpression(), b2.getExpression())) {
            return false;
        }
        if (!QueryCompUtil.isEqualString(b1.getAggrFunction(), b2.getAggrFunction())) {
            return false;
        }
        if (b1.getDataType() != b2.getDataType()) {
            return false;
        }
        if (!QueryCompUtil.isTwoExpressionEqual(b1.getFilter(), b2.getFilter())) {
            return false;
        }
        if (b1.getAggregatOns().size() != b2.getAggregatOns().size()) {
            return false;
        }
        int i = 0;
        while (i < b1.getAggregatOns().size()) {
            if (!QueryCompUtil.isEqualString(b1.getAggregatOns().get(i).toString(), b2.getAggregatOns().get(i).toString())) {
                return false;
            }
            ++i;
        }
        if (b1.getArguments().size() != b2.getArguments().size()) {
            return false;
        }
        i = 0;
        while (i < b1.getArguments().size()) {
            if (!QueryCompUtil.isTwoExpressionEqual((IBaseExpression)b1.getArguments().get(i), (IBaseExpression)b2.getArguments().get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isTwoExpressionEqual(IBaseExpression obj1, IBaseExpression obj2) {
        if (obj1 == null && obj2 != null) {
            return false;
        }
        if (obj1 != null && obj2 == null) {
            return false;
        }
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 instanceof IScriptExpression) {
            return QueryCompUtil.isTwoExpressionEqual((IScriptExpression)obj1, (IScriptExpression)obj2);
        }
        if (obj1 instanceof IConditionalExpression) {
            return QueryCompUtil.isTwoExpressionEqual((IConditionalExpression)obj1, (IConditionalExpression)obj2);
        }
        return false;
    }

    private static boolean isTwoExpressionEqual(IScriptExpression obj1, IScriptExpression obj2) {
        if (obj1 == null && obj2 != null) {
            return false;
        }
        if (obj1 != null && obj2 == null) {
            return false;
        }
        if (obj1 == null && obj2 == null) {
            return true;
        }
        return QueryCompUtil.isEqualString(obj1.getText(), obj2.getText()) && QueryCompUtil.isEqualString(obj1.getGroupName(), obj2.getGroupName()) && QueryCompUtil.isEqualString(obj1.getText(), obj2.getText()) && (obj1.getDataType() == obj2.getDataType() || QueryCompUtil.isUnknowOrAny(obj1, obj2) || QueryCompUtil.isUnknowOrAny(obj2, obj1));
    }

    private static boolean isUnknowOrAny(IScriptExpression obj1, IScriptExpression obj2) {
        return obj1.getDataType() == -1 && obj2.getDataType() == 0;
    }

    private static boolean isTwoExpressionEqual(IConditionalExpression obj1, IConditionalExpression obj2) {
        if (obj1.getOperator() != obj2.getOperator()) {
            return false;
        }
        return QueryCompUtil.isEqualString(obj1.getGroupName(), obj2.getGroupName()) && QueryCompUtil.isTwoExpressionEqual(obj1.getExpression(), obj2.getExpression()) && QueryCompUtil.isTwoExpressionEqual(obj1.getOperand1(), obj2.getOperand1()) && QueryCompUtil.isTwoExpressionEqual(obj1.getOperand2(), obj2.getOperand2());
    }

    public static boolean isCompatibleSQs(Collection oldSubQueryDefns, Collection newSubQueryDefns) {
        if (oldSubQueryDefns == newSubQueryDefns) {
            return true;
        }
        if (oldSubQueryDefns == null) {
            return newSubQueryDefns.size() == 0;
        }
        if (newSubQueryDefns == null) {
            return true;
        }
        if (oldSubQueryDefns.size() < newSubQueryDefns.size()) {
            return false;
        }
        Iterator oldIt = oldSubQueryDefns.iterator();
        Iterator newIt = newSubQueryDefns.iterator();
        while (newIt.hasNext()) {
            ISubqueryDefinition oldSub = (ISubqueryDefinition)oldIt.next();
            ISubqueryDefinition newSub = (ISubqueryDefinition)newIt.next();
            if (!QueryCompUtil.isEqualFilters(oldSub.getFilters(), newSub.getFilters())) {
                return false;
            }
            if (!QueryCompUtil.isEqualSorts(oldSub.getSorts(), newSub.getSorts())) {
                return false;
            }
            if (!GroupDefnUtil.isEqualGroups(oldSub.getGroups(), newSub.getGroups())) {
                return false;
            }
            if (QueryCompUtil.isCompatibleExprMap(oldSub.getBindings(), newSub.getBindings())) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqualFilters(List oldFilter, List newFilter) {
        if (oldFilter == newFilter) {
            return true;
        }
        if (oldFilter.size() != newFilter.size()) {
            return false;
        }
        Iterator oldIt = oldFilter.iterator();
        Iterator newIt = newFilter.iterator();
        while (oldIt.hasNext()) {
            IFilterDefinition newDefn;
            IFilterDefinition oldDefn = (IFilterDefinition)oldIt.next();
            if (FilterDefnUtil.isEqualFilter(oldDefn, newDefn = (IFilterDefinition)newIt.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualSorts(List oldSorts, List newSorts) {
        if (oldSorts == newSorts) {
            return true;
        }
        if (oldSorts.size() != newSorts.size()) {
            return false;
        }
        Iterator oldIt = oldSorts.iterator();
        Iterator newIt = newSorts.iterator();
        while (oldIt.hasNext()) {
            ISortDefinition oldDefn = (ISortDefinition)oldIt.next();
            ISortDefinition newDefn = (ISortDefinition)newIt.next();
            if (QueryCompUtil.isEqualString(oldDefn.getColumn(), newDefn.getColumn()) && ExprUtil.isEqualExpression(oldDefn.getExpression(), newDefn.getExpression()) && oldDefn.getSortDirection() == newDefn.getSortDirection() && oldDefn.getSortStrength() == newDefn.getSortStrength() && !QueryCompUtil.isLocaleDeferent(oldDefn, newDefn)) continue;
            return false;
        }
        return true;
    }

    private static boolean isLocaleDeferent(ISortDefinition oldDefn, ISortDefinition newDefn) {
        if (oldDefn.getSortLocale() == newDefn.getSortLocale()) {
            return false;
        }
        if (oldDefn.getSortLocale() == null || newDefn.getSortLocale() == null) {
            return true;
        }
        return !oldDefn.getSortLocale().equals((Object)newDefn.getSortLocale());
    }

    private static boolean isCompatibleExprMap(Map oldExprMap, Map newExprMap) {
        if (oldExprMap == newExprMap) {
            return true;
        }
        if (oldExprMap == null) {
            return newExprMap.size() == 0;
        }
        return oldExprMap.size() >= newExprMap.size();
    }

    private static boolean isEqualString(Object ob1, Object ob2) {
        if (ob1 == ob2) {
            return true;
        }
        if (ob1 == null || ob2 == null) {
            return false;
        }
        return ob1.equals(ob2);
    }
}

