/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.IllegalOperationException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.command.GroupElementCommand;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.ReferencableStructure;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.namespace.AbstractNameHelper;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.interfaces.ISupportThemeElement;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.elements.olap.Hierarchy;
import org.eclipse.birt.report.model.elements.olap.Level;
import org.eclipse.birt.report.model.elements.olap.Measure;
import org.eclipse.birt.report.model.elements.olap.MeasureGroup;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.ElementFactoryUtil;
import org.eclipse.birt.report.model.util.ModelUtil;

class ElementExporterImpl {
    private static Logger logger = Logger.getLogger(ElementExporterImpl.class.getName());
    protected ModuleHandle targetModuleHandle;
    private Map<DesignElementHandle, DesignElementHandle> propBindingMap = new HashMap<DesignElementHandle, DesignElementHandle>();

    ElementExporterImpl(LibraryHandle libraryHandle) {
        this.targetModuleHandle = libraryHandle;
    }

    ElementExporterImpl(ReportDesignHandle designHandle) {
        this.targetModuleHandle = designHandle;
    }

    ElementExporterImpl() {
    }

    void checkElementToExport(DesignElementHandle elementToExport, boolean ignoreName) {
        ModuleHandle root = elementToExport.getRoot();
        if (!this.isSupportedExporting(root)) {
            throw new IllegalArgumentException("The element to export must be in design file.");
        }
        if (StringUtil.isBlank(elementToExport.getName()) && !ignoreName) {
            throw new IllegalArgumentException("The element must have name defined.");
        }
    }

    protected boolean isSupportedExporting(ModuleHandle rootToExport) {
        if (this.targetModuleHandle == null) {
            return true;
        }
        if (this.targetModuleHandle instanceof LibraryHandle) {
            return rootToExport instanceof ReportDesignHandle;
        }
        return false;
    }

    static void checkStructureToExport(StructureHandle structToExport, boolean ignoreName) {
        String memberName = null;
        String propName = null;
        String structName = structToExport.getDefn().getName();
        if ("EmbeddedImage".equals(structName)) {
            propName = "images";
            memberName = "name";
        } else if ("CustomColor".equals(structName)) {
            propName = "colorPalette";
            memberName = "name";
        } else if ("ConfigVar".equals(structName)) {
            propName = "configVars";
            memberName = "name";
        } else {
            throw new IllegalArgumentException("The structure \"" + structName + "\" is not allowed to export.");
        }
        Object value = structToExport.getMember(memberName).getValue();
        if (StringUtil.isBlank((String)value) && !ignoreName) {
            throw new IllegalArgumentException("The structure \"" + structName + "\" must have member \"" + memberName + "\" defined.");
        }
        boolean found = false;
        ModuleHandle moduleHandle = structToExport.getElementHandle().getModuleHandle();
        PropertyHandle propertyHandle = moduleHandle.getPropertyHandle(propName);
        ArrayList list = propertyHandle.getListValue();
        if (list != null) {
            for (Structure struct : list) {
                if (struct != structToExport.getStructure()) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new IllegalArgumentException("The structure to export must be in design file.");
        }
    }

    private void checkOperation() {
        if (!(this.targetModuleHandle instanceof LibraryHandle)) {
            throw new IllegalOperationException("Only library handle supports this exporting operation!");
        }
    }

    protected void exportStructure(StructureHandle structToExport, boolean canOverride) throws SemanticException {
        Object value;
        Object nameValue;
        this.checkOperation();
        String structName = structToExport.getDefn().getName();
        String nameMemberName = null;
        ReferencableStructure newStruct = null;
        PropertyHandle newPropertyHandle = null;
        if ("EmbeddedImage".equals(structName)) {
            nameMemberName = "name";
            newStruct = StructureFactory.createEmbeddedImage();
            newPropertyHandle = this.targetModuleHandle.getPropertyHandle("images");
        } else if ("CustomColor".equals(structName)) {
            nameMemberName = "name";
            newStruct = StructureFactory.createCustomColor();
            newPropertyHandle = this.targetModuleHandle.getPropertyHandle("colorPalette");
        } else if ("ConfigVar".equals(structName)) {
            nameMemberName = "name";
            newStruct = StructureFactory.createConfigVar();
            newPropertyHandle = this.targetModuleHandle.getPropertyHandle("configVars");
        } else {
            throw new IllegalArgumentException("The structure \"" + structName + "\" is not allowed to export.");
        }
        assert (newStruct != null);
        assert (newPropertyHandle != null);
        if (canOverride && (nameValue = structToExport.getMember(nameMemberName).getValue()) != null) {
            Iterator iter = newPropertyHandle.iterator();
            while (iter.hasNext()) {
                StructureHandle structureHandle = (StructureHandle)iter.next();
                value = structureHandle.getMember(nameMemberName).getValue();
                if (!nameValue.equals(value)) continue;
                IStructure struct = structureHandle.getStructure();
                newPropertyHandle.removeItem(struct);
                break;
            }
        }
        Iterator<IPropertyDefn> iter = structToExport.getDefn().propertiesIterator();
        while (iter.hasNext()) {
            PropertyDefn memberDefn = (PropertyDefn)iter.next();
            String memberName = memberDefn.getName();
            if ("libReference".equals(memberName)) continue;
            value = structToExport.getMember(memberName).getValue();
            Object valueToSet = ModelUtil.copyValue(memberDefn, value);
            newStruct.setProperty(memberName, valueToSet);
        }
        newPropertyHandle.addItem(newStruct);
    }

    protected void findAndDropDuplicatedElement(DesignElementHandle handle) throws SemanticException {
        if (handle.getName() != null && this.dropDuplicatedElement(handle.getElement())) {
            return;
        }
        ContentIterator iter = new ContentIterator(handle.getModule(), handle.getElement());
        while (iter.hasNext()) {
            DesignElement element = iter.next();
            if (element.getName() == null) continue;
            this.dropDuplicatedElement(element);
        }
    }

    protected final boolean dropDuplicatedElement(DesignElement element) throws SemanticException {
        DesignElement targetElement;
        int nameSpaceID = ((ElementDefn)element.getDefn()).getNameSpaceID();
        Module targetModule = this.targetModuleHandle.getModule();
        NameSpace nameSpace = targetModule.getNameHelper().getNameSpace(nameSpaceID);
        DesignElement duplicateElement = nameSpace.getElement(element.getName());
        if (duplicateElement == null) {
            if (this.isOLAPElement(element)) {
                nameSpace = ((AbstractNameHelper)targetModule.getNameHelper()).getCachedNameSpace(nameSpaceID);
                duplicateElement = nameSpace.getElement(element.getName());
            } else {
                return false;
            }
        }
        if ((targetElement = ElementExporterImpl.getDropTarget(duplicateElement)) == null) {
            return false;
        }
        if (this.isOLAPElement(targetElement)) {
            targetModule.makeUniqueName(element);
            if (element instanceof Hierarchy) {
                Dimension targetDimension = (Dimension)element.getContainer();
                if (targetElement.getName().equals(targetDimension.getStringProperty(targetModule, "defaultHierarchy"))) {
                    targetDimension.setDefaultHierarchy((Hierarchy)element);
                }
            }
            return false;
        }
        if (!ElementExporterImpl.canDropInContext(targetElement)) {
            throw new SemanticException(element, new String[]{element.getName()}, "Error.SemanticException.EXPORT_ELEMENT_FAIL");
        }
        targetElement.getHandle(this.targetModuleHandle.getModule()).drop();
        return true;
    }

    private boolean isOLAPElement(DesignElement element) {
        return element instanceof Dimension || element instanceof Hierarchy || element instanceof Level || element instanceof MeasureGroup || element instanceof Measure;
    }

    static DesignElement getDropTarget(DesignElement element) {
        if (element == null) {
            return null;
        }
        int nameSpaceID = ((ElementDefn)element.getDefn()).getNameSpaceID();
        if (nameSpaceID != 8 && nameSpaceID != 10 && nameSpaceID != 1) {
            return element;
        }
        DesignElement container = element.getContainer();
        while (container != null) {
            if (container instanceof ExtendedItem && element instanceof ExtendedItem) {
                ExtendedItem item = (ExtendedItem)container;
                Object dataset = item.getProperty(item.getRoot(), "dataSet");
                Object cube = item.getProperty(item.getRoot(), "cube");
                if (dataset != null || cube != null) {
                    return item;
                }
            }
            container = container.getContainer();
        }
        return element;
    }

    static boolean canDropInContext(DesignElement element) {
        assert (element != null);
        DesignElement container = element.getContainer();
        while (container != null) {
            if (container instanceof ExtendedItem) {
                return !(element instanceof ExtendedItem);
            }
            container = container.getContainer();
        }
        return true;
    }

    protected void exportElement(DesignElementHandle elementToExport, boolean canOverride) throws SemanticException {
        if (elementToExport instanceof StyleHandle) {
            this.exportStyle((StyleHandle)elementToExport, canOverride);
            return;
        }
        int slotID = this.getExportSlotID(elementToExport);
        if (this.targetModuleHandle.getDefn().getSlot(slotID) == null) {
            return;
        }
        DesignElementHandle newElementHandle = this.duplicateElement(elementToExport, false);
        if (canOverride) {
            this.findAndDropDuplicatedElement(newElementHandle);
        }
        SlotHandle slotHandle = this.targetModuleHandle.getSlot(slotID);
        this.addToSlot(slotHandle, newElementHandle);
        if (this.propBindingMap.keySet().contains(elementToExport)) {
            this.propBindingMap.put(elementToExport, newElementHandle);
        }
    }

    protected int getExportSlotID(DesignElementHandle elementToExport) {
        if (elementToExport == null) {
            return -1;
        }
        int slotID = this.getTopContainerSlot(elementToExport.getElement());
        if (slotID == 6) {
            slotID = 5;
        } else if (slotID == 4 && elementToExport.getContainer() != elementToExport.getModuleHandle()) {
            slotID = 5;
        } else if (slotID == 9) {
            slotID = 6;
        }
        return slotID;
    }

    protected void exportStyle(StyleHandle elementToExport, boolean canOverride) throws SemanticException {
        this.checkOperation();
        SlotHandle themes = ((LibraryHandle)this.targetModuleHandle).getThemes();
        String defaultThemeName = ModelMessages.getMessage("Theme.defaultThemeName");
        NameSpace nameSpace = this.targetModuleHandle.getModule().getNameHelper().getNameSpace(6);
        Theme theme = (Theme)nameSpace.getElement(defaultThemeName);
        ThemeHandle themeHandle = null;
        if (theme == null) {
            themeHandle = this.targetModuleHandle.getElementFactory().newTheme(defaultThemeName);
            themes.add(themeHandle);
        } else {
            themeHandle = (ThemeHandle)theme.getHandle(this.targetModuleHandle.getModule());
        }
        this.exportStyle(elementToExport, themeHandle, canOverride);
    }

    protected void exportStyle(StyleHandle elementToExport, ThemeHandle theme, boolean canOverride) throws SemanticException {
        StyleHandle style;
        assert (theme != null);
        if (canOverride && (style = theme.findStyle(elementToExport.getName())) != null) {
            style.drop();
        }
        DesignElementHandle newElementHandle = this.duplicateElement(elementToExport, false);
        this.addToSlot(theme.getStyles(), newElementHandle);
    }

    private void changePropertyBindingID(ReportDesignHandle designToExport) {
        List propertyBindings = this.targetModuleHandle.getListProperty("propertyBindings");
        if (propertyBindings == null) {
            return;
        }
        for (PropertyBinding struct : propertyBindings) {
            long id = struct.getID().longValue();
            DesignElementHandle tempHandle = designToExport.getElementByID(id);
            DesignElementHandle tempCopyInLibHandle = this.propBindingMap.get(tempHandle);
            if (tempCopyInLibHandle == null) continue;
            struct.setID(tempCopyInLibHandle.getID());
        }
    }

    private void initPropBindingList(ReportDesignHandle designToExport) {
        List propertyBindings = designToExport.getListProperty("propertyBindings");
        int i = 0;
        while (propertyBindings != null && i < propertyBindings.size()) {
            PropertyBinding struct = (PropertyBinding)propertyBindings.get(i);
            long id = struct.getID().longValue();
            DesignElementHandle tempHandle = designToExport.getElementByID(id);
            if (tempHandle != null && !this.propBindingMap.keySet().contains(tempHandle)) {
                this.propBindingMap.put(tempHandle, null);
            }
            ++i;
        }
    }

    void exportDesign(ReportDesignHandle designToExport, boolean canOverride, boolean genDefaultName) throws SemanticException {
        ModelUtil.duplicateProperties(designToExport, this.targetModuleHandle, false, false);
        this.initPropBindingList(designToExport);
        int slotCount = designToExport.getDefn().getSlotCount();
        int i = 0;
        while (i < slotCount) {
            SlotHandle sourceSlotHandle = designToExport.getSlot(i);
            Iterator iter = sourceSlotHandle.iterator();
            ArrayList<DesignElementHandle> noNameList = new ArrayList<DesignElementHandle>();
            while (iter.hasNext()) {
                DesignElementHandle contentHandle = (DesignElementHandle)iter.next();
                if (StringUtil.isBlank(contentHandle.getName())) {
                    noNameList.add(contentHandle);
                    continue;
                }
                this.exportElement(contentHandle, canOverride);
            }
            for (DesignElementHandle contentHandle : noNameList) {
                if (!genDefaultName) {
                    String typeName = contentHandle.getDefn().getDisplayName();
                    String location = contentHandle.getElement().getIdentifier();
                    throw new IllegalArgumentException("The element [type=\"" + typeName + "\"," + "location=\"" + location + "\"] must have name defined.");
                }
                this.exportElement(contentHandle, canOverride);
            }
            ++i;
        }
        this.changePropertyBindingID(designToExport);
    }

    protected final int getTopContainerSlot(DesignElement element) {
        int slotID = element.getContainerInfo().getSlotID();
        DesignElement container = element.getContainer();
        while (!(container instanceof Module)) {
            slotID = container.getContainerInfo().getSlotID();
            container = container.getContainer();
            assert (container != null);
        }
        return slotID;
    }

    protected DesignElementHandle createNewElement(DesignElementHandle elementHandle) {
        String elementName = elementHandle.getDefn().getName();
        String name = elementHandle.getName();
        return ElementFactoryUtil.newElement(this.targetModuleHandle.getModule(), elementName, name, false);
    }

    protected final DesignElementHandle duplicateElement(DesignElementHandle elementHandle, boolean onlyFactoryProperty) throws SemanticException {
        DesignElementHandle newElementHandle = this.createNewElement(elementHandle);
        if (newElementHandle == null) {
            logger.severe("Cannot create the element instance for " + elementHandle.getDefn().getName());
            assert (false);
            return null;
        }
        ModelUtil.duplicateProperties(elementHandle, newElementHandle, onlyFactoryProperty, true);
        if (newElementHandle.getElement() instanceof ISupportThemeElement) {
            newElementHandle.setProperty("theme", null);
        }
        this.duplicateSlots(elementHandle, newElementHandle);
        if (!onlyFactoryProperty && newElementHandle.getName() == null) {
            this.targetModuleHandle.getModule().makeUniqueName(newElementHandle.getElement());
        }
        return newElementHandle;
    }

    private void duplicateSlots(DesignElementHandle source, DesignElementHandle destination) throws SemanticException {
        DesignElementHandle newContentHandle;
        int slotCount = source.getDefn().getSlotCount();
        int i = 0;
        while (i < slotCount) {
            SlotHandle sourceSlotHandle = source.getSlot(i);
            SlotHandle destinationSlotHandle = destination.getSlot(i);
            Iterator iter = sourceSlotHandle.iterator();
            while (iter.hasNext()) {
                DesignElementHandle contentHandle = (DesignElementHandle)iter.next();
                newContentHandle = this.duplicateElement(contentHandle, true);
                if (source instanceof ListingHandle && i == 1) {
                    Object bindingRef = source.getProperty("dataBindingRef");
                    if (bindingRef != null) {
                        GroupElementCommand cmd = new GroupElementCommand(destination.getModule(), new ContainerContext(destination.getElement(), i));
                        cmd.setupSharedDataGroups(source.getElement());
                        continue;
                    }
                    this.addToSlot(destinationSlotHandle, newContentHandle);
                    continue;
                }
                this.addToSlot(destinationSlotHandle, newContentHandle);
            }
            ++i;
        }
        List<IElementPropertyDefn> props = source.getElement().getDefn().getContents();
        int i2 = 0;
        while (i2 < props.size()) {
            String propName;
            Object value;
            IPropertyDefn propDefn = props.get(i2);
            if (propDefn.getTypeCode() == 23 && (value = source.getProperty(propName = propDefn.getName())) != null) {
                if (propDefn.isList()) {
                    int j = 0;
                    while (j < ((List)value).size()) {
                        DesignElementHandle contentHandle = (DesignElementHandle)((ArrayList)value).get(j);
                        DesignElementHandle newContentHandle2 = this.duplicateElement(contentHandle, true);
                        destination.add(propName, newContentHandle2);
                        ++j;
                    }
                } else {
                    newContentHandle = this.duplicateElement((DesignElementHandle)value, true);
                    destination.add(propName, newContentHandle);
                }
            }
            ++i2;
        }
    }

    private void addToSlot(SlotHandle slotHandle, DesignElementHandle contentHandle) throws SemanticException {
        slotHandle.add(contentHandle);
    }
}

