/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.AggregationCellProviderWrapper;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.AggregationDialog;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.TotalProvider;
import org.eclipse.birt.report.item.crosstab.ui.extension.IAggregationCellViewProvider;
import org.eclipse.birt.report.item.crosstab.ui.extension.SwitchCellInfo;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;

public class SubTotalProvider
extends TotalProvider
implements ITableLabelProvider,
IStructuredContentProvider,
ICellModifier {
    private CellEditor[] cellEditor;
    TableViewer viewer;
    private String[] comboItems = null;
    private String[] viewNames;
    private CrosstabReportItemHandle crosstab;
    private AggregationCellProviderWrapper cellProviderWrapper;
    private static String[] positionItems = null;
    private static String[] positionValues = null;
    private static IChoiceSet choiceSet = ChoiceSetFactory.getElementChoiceSet((String)"LevelView", (String)"aggregationHeaderLocation");
    private String[] columnNames = new String[]{"", Messages.getString("SubTotalProvider.Column.AggregateOn"), Messages.getString("SubTotalProvider.Column.View"), Messages.getString("SubTotalProvider.Column.Position")};

    static {
        IChoice[] choices = choiceSet.getChoices((Comparator)new AlphabeticallyComparator());
        positionItems = new String[choices.length];
        positionValues = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            SubTotalProvider.positionValues[i] = choices[i].getName();
            SubTotalProvider.positionItems[i] = choices[i].getDisplayName();
            ++i;
        }
    }

    private void initializeItems(AggregationDialog.SubTotalInfo subTotalInfo) {
        ArrayList<String> viewNameList = new ArrayList<String>();
        ArrayList<String> itemList = new ArrayList<String>();
        AggregationCellHandle cell = this.getAggregationCell(subTotalInfo);
        if (cell != null && this.cellProviderWrapper.getMatchProvider(cell) == null) {
            itemList.add("");
            viewNameList.add("");
        }
        IAggregationCellViewProvider[] providers = this.cellProviderWrapper.getAllProviders();
        int i = 0;
        while (i < providers.length) {
            IAggregationCellViewProvider tmp = providers[i];
            if (tmp != null) {
                SwitchCellInfo info = new SwitchCellInfo(this.crosstab, 2);
                info.setSubTotalInfo(subTotalInfo);
                if (providers[i].canSwitch(info)) {
                    String displayName = tmp.getViewDisplayName();
                    viewNameList.add(tmp.getViewName());
                    itemList.add(Messages.getString("GrandTotalProvider.ShowAs", new String[]{displayName}));
                }
            }
            ++i;
        }
        this.comboItems = itemList.toArray(new String[itemList.size()]);
        this.viewNames = viewNameList.toArray(new String[viewNameList.size()]);
    }

    public SubTotalProvider(TableViewer viewer, CrosstabReportItemHandle crosstab, int axis) {
        this.viewer = viewer;
        this.crosstab = crosstab;
        this.cellProviderWrapper = new AggregationCellProviderWrapper(crosstab);
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        AggregationDialog.SubTotalInfo info = (AggregationDialog.SubTotalInfo)element;
        switch (columnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                return String.valueOf(info.getLevel().getName()) + "- " + (info.getAggregateOnMeasureDisplayName() == null ? "" : info.getAggregateOnMeasureDisplayName());
            }
            case 2: {
                int index;
                this.initializeItems(info);
                ((ComboBoxCellEditor)this.cellEditor[2]).setItems(this.comboItems);
                String expectedView = info.getExpectedView();
                if (expectedView == null) {
                    expectedView = "";
                }
                if ((index = Arrays.asList(this.viewNames).indexOf(expectedView)) < 0) {
                    index = 0;
                    info.setExpectedView(this.viewNames[index]);
                }
                return this.comboItems[index];
            }
            case 3: {
                int posIndex;
                String position = info.getPosition();
                if (position == null) {
                    position = "";
                }
                if ((posIndex = Arrays.asList(positionValues).indexOf(position)) < 0) {
                    info.setPosition(positionValues[0]);
                }
                return positionItems[posIndex];
            }
        }
        return "";
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            return ((List)inputElement).toArray();
        }
        return new Object[0];
    }

    public CellEditor[] getCellEditors() {
        if (this.cellEditor != null) {
            return this.cellEditor;
        }
        ComboBoxCellEditor comboCell = new ComboBoxCellEditor((Composite)this.viewer.getTable(), new String[0], 8);
        ComboBoxCellEditor positionCell = new ComboBoxCellEditor((Composite)this.viewer.getTable(), positionItems, 8);
        CellEditor[] cellEditorArray = new CellEditor[4];
        cellEditorArray[2] = comboCell;
        cellEditorArray[3] = positionCell;
        this.cellEditor = cellEditorArray;
        return this.cellEditor;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public int[] columnWidths() {
        return new int[]{20, 210, 120, 120};
    }

    public boolean canModify(Object element, String property) {
        if (Arrays.asList(this.columnNames).indexOf(property) == 2 || Arrays.asList(this.columnNames).indexOf(property) == 3) {
            if (this.viewer instanceof CheckboxTableViewer) {
                return ((CheckboxTableViewer)this.viewer).getChecked(element);
            }
            return true;
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        if (element instanceof Item) {
            element = ((Item)element).getData();
        }
        Integer value = null;
        int index = Arrays.asList(this.columnNames).indexOf(property);
        switch (index) {
            case 1: {
                break;
            }
            case 2: {
                this.initializeItems((AggregationDialog.SubTotalInfo)element);
                ((ComboBoxCellEditor)this.cellEditor[2]).setItems(this.comboItems);
                String expectedView = ((AggregationDialog.SubTotalInfo)element).getExpectedView();
                if (expectedView == null || expectedView.length() == 0) {
                    return 0;
                }
                int sel = Arrays.asList(this.viewNames).indexOf(expectedView);
                value = sel <= 0 ? Integer.valueOf(0) : Integer.valueOf(sel);
                break;
            }
            case 3: {
                String pos = ((AggregationDialog.SubTotalInfo)element).getPosition();
                if (pos == null || pos.length() == 0) {
                    return 0;
                }
                int posIndex = Arrays.asList(positionValues).indexOf(pos);
                value = posIndex <= 0 ? Integer.valueOf(0) : Integer.valueOf(posIndex);
            }
        }
        return value;
    }

    public void modify(Object element, String property, Object value) {
        if (element instanceof Item) {
            element = ((Item)element).getData();
        }
        int index = Arrays.asList(this.columnNames).indexOf(property);
        switch (index) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                int sel = (Integer)value;
                if (sel == 0) {
                    ((AggregationDialog.SubTotalInfo)element).setExpectedView("");
                    break;
                }
                ((AggregationDialog.SubTotalInfo)element).setExpectedView(this.viewNames[sel]);
                break;
            }
            case 3: {
                int posIndex = (Integer)value;
                ((AggregationDialog.SubTotalInfo)element).setPosition(positionValues[posIndex]);
            }
        }
        this.viewer.refresh();
    }

    private LevelViewHandle findLevelViewHandle(LevelHandle handle) {
        LevelViewHandle levelView;
        DimensionViewHandle tmpDimView;
        int dimCount = this.crosstab.getDimensionCount(0);
        int i = 0;
        while (i < dimCount) {
            tmpDimView = this.crosstab.getDimension(0, i);
            levelView = tmpDimView.getLevel(handle.getQualifiedName());
            if (levelView != null) {
                return levelView;
            }
            ++i;
        }
        dimCount = this.crosstab.getDimensionCount(1);
        i = 0;
        while (i < dimCount) {
            tmpDimView = this.crosstab.getDimension(1, i);
            levelView = tmpDimView.getLevel(handle.getQualifiedName());
            if (levelView != null) {
                return levelView;
            }
            ++i;
        }
        return null;
    }

    private AggregationCellHandle getAggregationCell(AggregationDialog.SubTotalInfo subTotalInfo) {
        AggregationCellHandle cell = null;
        LevelHandle level = subTotalInfo.getLevel();
        if (level == null) {
            return cell;
        }
        MeasureViewHandle measureView = this.crosstab.getMeasure(subTotalInfo.getAggregateOnMeasureName());
        LevelViewHandle levelView = this.findLevelViewHandle(level);
        if (measureView == null || levelView == null) {
            return cell;
        }
        String rowDimension = null;
        String rowLevel = null;
        String colDimension = null;
        String colLevel = null;
        int axisType = levelView.getAxisType();
        int counterAxisType = CrosstabUtil.getOppositeAxisType((int)levelView.getAxisType());
        DimensionViewHandle counterDimension = this.crosstab.getDimension(counterAxisType, this.crosstab.getDimensionCount(counterAxisType) - 1);
        String counterDimensionName = null;
        String counterLevelName = null;
        if (counterDimension != null) {
            counterDimensionName = counterDimension.getCubeDimensionName();
            counterLevelName = counterDimension.getLevel(counterDimension.getLevelCount() - 1).getCubeLevelName();
        }
        String dimensionName = ((DimensionViewHandle)levelView.getContainer()).getCubeDimensionName();
        String levelName = levelView.getCubeLevelName();
        if (levelName == null || dimensionName == null) {
            return cell;
        }
        if (axisType == 0) {
            rowDimension = dimensionName;
            rowLevel = levelName;
            colDimension = counterDimensionName;
            colLevel = counterLevelName;
        } else if (axisType == 1) {
            colDimension = dimensionName;
            colLevel = levelName;
            rowDimension = counterDimensionName;
            rowLevel = counterLevelName;
        }
        cell = measureView.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
        return cell;
    }
}

