/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.framework;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.birt.core.framework.IPlatformContext;
import org.eclipse.birt.core.framework.PlatformConfig;

public class PlatformFileContext
implements IPlatformContext {
    protected String root;
    protected String[] arguments;

    public PlatformFileContext() {
        this.root = this.getSystemBirtHome();
        this.arguments = null;
    }

    public PlatformFileContext(PlatformConfig config) {
        assert (config != null);
        this.root = config.getBIRTHome();
        if (this.root == null) {
            this.root = this.getSystemBirtHome();
        }
        this.arguments = config.getOSGiArguments();
    }

    public String getPlatform() {
        return this.root;
    }

    public String[] getLaunchArguments() {
        return this.arguments;
    }

    private String getSystemBirtHome() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String home = System.getProperty("BIRT_HOME");
                if (home == null || "".equals(home)) {
                    return null;
                }
                return home;
            }
        });
    }
}

