/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.page;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionConverter;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.RenameInputDialog;
import org.eclipse.birt.report.designer.internal.ui.views.outline.ListenerElementVisitor;
import org.eclipse.birt.report.designer.ui.cubebuilder.dialog.DateLevelDialog;
import org.eclipse.birt.report.designer.ui.cubebuilder.dialog.GroupDialog;
import org.eclipse.birt.report.designer.ui.cubebuilder.dialog.GroupRenameDialog;
import org.eclipse.birt.report.designer.ui.cubebuilder.dialog.LevelPropertyDialog;
import org.eclipse.birt.report.designer.ui.cubebuilder.dialog.MeasureDialog;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.CubeContentProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.CubeLabelProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.DataContentProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.OlapUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.UIHelper;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.VirtualField;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.widget.TreeViewerBackup;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularDimensionHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.birt.report.model.api.olap.TabularMeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.TabularMeasureHandle;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;

public class CubeGroupContent
extends Composite
implements Listener {
    private TreeItem[] dragSourceItems = new TreeItem[1];
    private TreeViewer dataFieldsViewer;
    private TabularCubeHandle input;
    private TreeViewer groupViewer;
    private DataSetHandle[] datasets = new DataSetHandle[1];
    TreeListener groupTreeListener = new TreeListener(){

        public void treeCollapsed(TreeEvent e) {
            Item item = (Item)e.item;
            if (CubeGroupContent.this.groupBackup != null) {
                CubeGroupContent.this.groupBackup.updateCollapsedStatus(CubeGroupContent.this.groupViewer, item.getData());
            }
        }

        public void treeExpanded(TreeEvent e) {
            Item item = (Item)e.item;
            if (CubeGroupContent.this.groupBackup != null) {
                CubeGroupContent.this.groupBackup.updateExpandedStatus(CubeGroupContent.this.groupViewer, item.getData());
            }
        }
    };
    TreeListener dataTreeListener = new TreeListener(){

        public void treeCollapsed(TreeEvent e) {
            Item item = (Item)e.item;
            if (CubeGroupContent.this.dataBackup != null) {
                CubeGroupContent.this.dataBackup.updateCollapsedStatus(CubeGroupContent.this.dataFieldsViewer, item.getData());
            }
        }

        public void treeExpanded(TreeEvent e) {
            Item item = (Item)e.item;
            if (CubeGroupContent.this.dataBackup != null) {
                CubeGroupContent.this.dataBackup.updateExpandedStatus(CubeGroupContent.this.dataFieldsViewer, item.getData());
            }
        }
    };
    private Button addBtn;
    private Button delBtn;
    private int operations = 7;
    private Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
    private Button editBtn;
    private ListenerElementVisitor visitor;
    private DataContentProvider dataContentProvider = new DataContentProvider();
    private CubeLabelProvider cubeLabelProvider;
    private TreeViewerBackup dataBackup;
    private TreeViewerBackup groupBackup;
    private Button addButton;
    private Button removeButton;

    public CubeGroupContent(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(4, false);
        layout.marginTop = 0;
        this.setLayout((Layout)layout);
        this.createContent();
    }

    public void dispose() {
        this.dataBackup.dispose();
        this.groupBackup.dispose();
        if (this.visitor != null) {
            if (this.input != null) {
                this.visitor.removeListener((DesignElementHandle)this.input);
            }
            this.visitor.dispose();
            this.visitor = null;
        }
        super.dispose();
    }

    public void setInput(TabularCubeHandle cube) {
        if (this.input != null) {
            this.getListenerElementVisitor().removeListener((DesignElementHandle)this.input);
        }
        this.input = cube;
    }

    public void setInput(TabularCubeHandle cube, DataSetHandle dataset) {
        this.input = cube;
        this.datasets[0] = dataset;
    }

    public void createContent() {
        this.createDataField();
        this.createMoveButtonsField();
        this.createGroupField();
        this.createOperationField();
    }

    private void createOperationField() {
        Composite operationField = new Composite((Composite)this, 0);
        operationField.setLayout((Layout)new GridLayout());
        operationField.setLayout((Layout)new GridLayout());
        String[] btnTexts = new String[]{Messages.getString("GroupsPage.Button.Add"), Messages.getString("GroupsPage.Button.Edit"), Messages.getString("GroupsPage.Button.Delete")};
        this.addBtn = new Button(operationField, 8);
        this.addBtn.setEnabled(false);
        this.addBtn.setText(btnTexts[0]);
        this.addBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CubeGroupContent.this.handleAddEvent();
            }
        });
        this.editBtn = new Button(operationField, 8);
        this.editBtn.setText(btnTexts[1]);
        this.editBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CubeGroupContent.this.handleEditEvent();
            }
        });
        this.delBtn = new Button(operationField, 8);
        this.delBtn.setText(btnTexts[2]);
        this.delBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CubeGroupContent.this.handleDelEvent();
            }
        });
        int width = UIUtil.getMaxStringWidth((String[])btnTexts, (Control)operationField) + 10;
        if (width < 60) {
            width = 60;
        }
        this.layoutButton(this.addBtn, width);
        this.layoutButton(this.editBtn, width);
        this.layoutButton(this.delBtn, width);
        this.addBtn.setEnabled(false);
        this.editBtn.setEnabled(false);
        this.delBtn.setEnabled(false);
        GridData data = (GridData)this.addBtn.getLayoutData();
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 1024;
        data = (GridData)this.delBtn.getLayoutData();
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 128;
    }

    private void layoutButton(Button button, int width) {
        GridData gd = new GridData();
        gd.widthHint = width;
        button.setLayoutData((Object)gd);
    }

    private void createGroupField() {
        Composite groupField = new Composite((Composite)this, 0);
        groupField.setLayoutData((Object)new GridData(1808));
        groupField.setLayout((Layout)new GridLayout());
        Label groupLabel = new Label(groupField, 0);
        groupLabel.setText(Messages.getString("GroupsPage.Label.Group"));
        this.groupViewer = new TreeViewer(groupField, 2820);
        this.groupViewer.getTree().setLayoutData((Object)new GridData(1808));
        ((GridData)this.groupViewer.getTree().getLayoutData()).heightHint = 250;
        ((GridData)this.groupViewer.getTree().getLayoutData()).widthHint = 200;
        this.groupViewer.setLabelProvider((IBaseLabelProvider)this.getCubeLabelProvider());
        this.groupViewer.setContentProvider((IContentProvider)new CubeContentProvider());
        this.groupViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CubeGroupContent.this.updateButtons();
            }
        });
        this.groupViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    try {
                        if (CubeGroupContent.this.delBtn.isEnabled()) {
                            CubeGroupContent.this.handleDelEvent();
                        }
                    }
                    catch (Exception e1) {
                        ExceptionUtil.handle((Throwable)e1);
                    }
                }
            }
        });
        this.groupViewer.getTree().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (CubeGroupContent.this.editBtn.isEnabled()) {
                    CubeGroupContent.this.handleEditEvent();
                }
            }
        });
        this.groupViewer.getTree().addListener(42, new org.eclipse.swt.widgets.Listener(){

            public void handleEvent(Event e) {
                TreeItem item = (TreeItem)e.item;
                Color gray = Display.getCurrent().getSystemColor(16);
                if (item != null) {
                    if (item.getData() != null) {
                        if (CubeGroupContent.this.checkSharedDimension(item.getData()) && item.getData() instanceof LevelHandle) {
                            item.setForeground(gray);
                        } else {
                            item.setForeground(item.getParent().getForeground());
                        }
                    } else {
                        item.setForeground(item.getParent().getForeground());
                    }
                }
            }
        });
        DragSource fieldsSource = new DragSource((Control)this.groupViewer.getTree(), this.operations);
        fieldsSource.setTransfer(this.types);
        fieldsSource.addDragListener((DragSourceListener)new CustomDragListener(this.groupViewer));
        DropTarget target = new DropTarget((Control)this.groupViewer.getTree(), this.operations);
        target.setTransfer(this.types);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                event.feedback = 24;
                if (OlapUtil.isFromLibrary(CubeGroupContent.this.input)) {
                    event.detail = 0;
                    return;
                }
                if (event.item != null) {
                    DimensionHandle dimension;
                    TreeItem item = (TreeItem)event.item;
                    Object element = item.getData();
                    event.detail = 2;
                    Object obj = CubeGroupContent.this.dragSourceItems[0].getData();
                    ResultSetColumnHandle dataField = null;
                    DataSetHandle dataset = null;
                    if (obj == null || obj instanceof DataSetHandle || obj instanceof VirtualField && ((VirtualField)obj).getType().equals("other") || obj instanceof VirtualField && ((VirtualField)obj).getType().equals("shared dimensions")) {
                        event.detail = 0;
                        return;
                    }
                    if (CubeGroupContent.this.checkSharedDimension(element)) {
                        event.detail = 0;
                        return;
                    }
                    if (obj instanceof ResultSetColumnHandle) {
                        DataSetHandle primary;
                        dataField = (ResultSetColumnHandle)obj;
                        dataset = (DataSetHandle)dataField.getElementHandle();
                        if (element instanceof LevelHandle) {
                            DataSetHandle temp = OlapUtil.getHierarchyDataset((TabularHierarchyHandle)((LevelHandle)element).getContainer());
                            if (temp != null && dataset != null && dataset != temp) {
                                event.detail = 0;
                                return;
                            }
                            DesignElementHandle hierarchy = ((TabularLevelHandle)element).getContainer();
                            DimensionHandle dimension2 = (DimensionHandle)hierarchy.getContainer();
                            if (dimension2.isTimeType()) {
                                event.detail = 0;
                                return;
                            }
                        } else if (element instanceof DimensionHandle || element instanceof VirtualField && ((VirtualField)element).getType().equals("level")) {
                            dimension = null;
                            dimension = element instanceof DimensionHandle ? (DimensionHandle)element : (DimensionHandle)((VirtualField)element).getModel();
                            if (dimension.isTimeType() && (dimension.getDefaultHierarchy().getLevelCount() != 0 || !CubeGroupContent.this.isDateType(dataField.getDataType()))) {
                                event.detail = 0;
                                return;
                            }
                            DataSetHandle temp = OlapUtil.getHierarchyDataset((TabularHierarchyHandle)dimension.getDefaultHierarchy());
                            if (temp != null && dataset != null && dataset != temp) {
                                event.detail = 0;
                                return;
                            }
                        } else if ((element instanceof MeasureGroupHandle || element instanceof VirtualField && ((VirtualField)element).getType().equals("measure") || element instanceof MeasureHandle || element instanceof VirtualField && ((VirtualField)element).getType().equals("measureGroup") || element instanceof PropertyHandle && ((PropertyHandle)element).getPropertyDefn().getName().equals("measureGroups")) && ((primary = CubeGroupContent.this.input.getDataSet()) == null || primary != dataset)) {
                            event.detail = 0;
                            return;
                        }
                    }
                    if (obj instanceof DimensionHandle) {
                        dimension = (DimensionHandle)obj;
                        if (dimension.getContainer() instanceof TabularCubeHandle) {
                            event.detail = 0;
                            return;
                        }
                        if (!(element instanceof PropertyHandle && ((PropertyHandle)element).getPropertyDefn().getName().equals("dimensions") || element instanceof VirtualField && ((VirtualField)element).getType().equals("dimension"))) {
                            event.detail = 0;
                            return;
                        }
                    }
                    if (obj instanceof LevelHandle && (!(element instanceof LevelHandle) || element == obj || ((LevelHandle)obj).getContainer() != ((LevelHandle)element).getContainer())) {
                        event.detail = 0;
                        return;
                    }
                    Point pt = Display.getCurrent().map(null, (Control)CubeGroupContent.this.groupViewer.getTree(), event.x, event.y);
                    Rectangle bounds = item.getBounds();
                    event.feedback = pt.y < bounds.y + bounds.height / 3 ? (event.feedback |= 2) : (pt.y > bounds.y + 2 * bounds.height / 3 ? (event.feedback |= 4) : (event.feedback |= 1));
                } else {
                    event.detail = 0;
                }
            }

            /*
             * Unable to fully structure code
             */
            public void drop(DropTargetEvent event) {
                if (event.data == null) {
                    event.detail = 0;
                    return;
                }
                obj = CubeGroupContent.access$4(CubeGroupContent.this)[0].getData();
                dataField = null;
                dataset = null;
                if (obj == null || obj instanceof DataSetHandle) {
                    event.detail = 0;
                    return;
                }
                item = (TreeItem)event.item;
                element = item.getData();
                if (obj instanceof DimensionHandle && (element instanceof VirtualField && ((VirtualField)element).getType().equals("dimension") || element instanceof PropertyHandle && ((PropertyHandle)element).getPropertyDefn().getName().equals("dimensions"))) {
                    stack = SessionHandleAdapter.getInstance().getCommandStack();
                    stack.startTrans("");
                    try {
                        dimension = DesignElementFactory.getInstance().newTabularDimension(null);
                        CubeGroupContent.access$11(CubeGroupContent.this).add("dimensions", (DesignElementHandle)dimension);
                        dimension.setSharedDimension((DimensionHandle)obj);
                        stack.commit();
                    }
                    catch (SemanticException e) {
                        stack.rollback();
                        CubeGroupContent.this.refresh();
                        ExceptionUtil.handle((Throwable)e);
                    }
                }
                if (obj instanceof ResultSetColumnHandle) {
                    dataField = (ResultSetColumnHandle)obj;
                    dataset = (DataSetHandle)dataField.getElementHandle();
                    if (event.item == null) {
                        event.detail = 0;
                        return;
                    }
                    pt = Display.getCurrent().map(null, (Control)CubeGroupContent.access$1(CubeGroupContent.this).getTree(), event.x, event.y);
                    bounds = item.getBounds();
                    isValidName = UIUtil.validateDimensionName((String)OlapUtil.getDataFieldDisplayName(dataField));
                    if (pt.y < bounds.y + bounds.height / 3) {
                        if (element instanceof MeasureHandle) {
                            stack = SessionHandleAdapter.getInstance().getCommandStack();
                            stack.startTrans("");
                            try {
                                measure = DesignElementFactory.getInstance().newTabularMeasure(OlapUtil.getDataFieldDisplayName(dataField));
                                expression = new Expression((Object)ExpressionUtility.getExpression((Object)dataField, (IExpressionConverter)ExpressionUtility.getExpressionConverter((String)UIUtil.getDefaultScriptType())), UIUtil.getDefaultScriptType());
                                measure.setExpressionProperty("measureExpression", expression);
                                column = OlapUtil.getColumnHintHandle(dataField);
                                if (column != null) {
                                    measure.setAlignment(column.getHorizontalAlign());
                                    measure.setFormat(column.getValueFormat());
                                }
                                CubeGroupContent.access$13(CubeGroupContent.this, dataField, measure);
                                ((MeasureHandle)element).getContainer().add("measures", (DesignElementHandle)measure);
                                if (!isValidName.booleanValue()) {
                                    dialog = new MeasureDialog(false);
                                    dialog.setInput(measure);
                                    if (dialog.open() == 1) {
                                        SessionHandleAdapter.getInstance().getCommandStack().rollback();
                                    }
                                } else {
                                    stack.commit();
                                }
                            }
                            catch (SemanticException e) {
                                stack.rollback();
                                CubeGroupContent.this.refresh();
                                ExceptionUtil.handle((Throwable)e);
                            }
                            return;
                        }
                        if (element instanceof LevelHandle) {
                            hierarchy = ((TabularLevelHandle)element).getContainer();
                            dimension = (DimensionHandle)hierarchy.getContainer();
                            if (dimension.isTimeType()) {
                                event.detail = 0;
                                return;
                            }
                            index = ((LevelHandle)element).getIndex();
                            stack = SessionHandleAdapter.getInstance().getCommandStack();
                            stack.startTrans("");
                            try {
                                level = DesignElementFactory.getInstance().newTabularLevel(dimension, OlapUtil.getDataFieldDisplayName(dataField));
                                level.setColumnName(dataField.getColumnName());
                                level.setDataType(dataField.getDataType());
                                ((LevelHandle)element).getContainer().add("levels", (DesignElementHandle)level, index);
                                column = OlapUtil.getColumnHintHandle(dataField);
                                if (column != null) {
                                    level.setAlignment(column.getHorizontalAlign());
                                    level.setFormat(column.getValueFormat());
                                }
                                if (!isValidName.booleanValue()) {
                                    dialog = new LevelPropertyDialog(true);
                                    dialog.setInput(level);
                                    if (dialog.open() == 1) {
                                        SessionHandleAdapter.getInstance().getCommandStack().rollback();
                                    }
                                } else {
                                    stack.commit();
                                }
                            }
                            catch (SemanticException e) {
                                stack.rollback();
                                CubeGroupContent.this.refresh();
                                ExceptionUtil.handle((Throwable)e);
                            }
                            return;
                        }
                    }
                    if (element instanceof MeasureHandle) {
                        if (!CubeGroupContent.access$14(CubeGroupContent.this, dataField)) {
                            return;
                        }
                        stack = SessionHandleAdapter.getInstance().getCommandStack();
                        stack.startTrans("");
                        try {
                            measure = DesignElementFactory.getInstance().newTabularMeasure(OlapUtil.getDataFieldDisplayName(dataField));
                            expression = new Expression((Object)ExpressionUtility.getExpression((Object)dataField, (IExpressionConverter)ExpressionUtility.getExpressionConverter((String)UIUtil.getDefaultScriptType())), UIUtil.getDefaultScriptType());
                            measure.setExpressionProperty("measureExpression", expression);
                            column = OlapUtil.getColumnHintHandle(dataField);
                            if (column != null) {
                                measure.setAlignment(column.getHorizontalAlign());
                                measure.setFormat(column.getValueFormat());
                            }
                            CubeGroupContent.access$13(CubeGroupContent.this, dataField, measure);
                            ((MeasureHandle)element).getContainer().add("measures", (DesignElementHandle)measure);
                            if (!isValidName.booleanValue()) {
                                dialog = new MeasureDialog(false);
                                dialog.setInput(measure);
                                if (dialog.open() != 1) ** GOTO lbl242
                                SessionHandleAdapter.getInstance().getCommandStack().rollback();
                            }
                            stack.commit();
                        }
                        catch (SemanticException e) {
                            stack.rollback();
                            CubeGroupContent.this.refresh();
                            ExceptionUtil.handle((Throwable)e);
                            return;
                        }
                    } else if (element instanceof MeasureGroupHandle != false || element instanceof VirtualField != false && ((VirtualField)element).getType().equals("measure") != false || element instanceof VirtualField != false && ((VirtualField)element).getType().equals("measureGroup") != false || element instanceof PropertyHandle && ((PropertyHandle)element).getPropertyDefn().getName().equals("measureGroups")) {
                        if (!CubeGroupContent.access$14(CubeGroupContent.this, dataField)) {
                            return;
                        }
                        measureGroup = null;
                        stack = SessionHandleAdapter.getInstance().getCommandStack();
                        stack.startTrans("");
                        try {
                            if (element instanceof VirtualField && ((VirtualField)element).getType().equals("measureGroup") || element instanceof PropertyHandle && ((PropertyHandle)element).getPropertyDefn().getName().equals("measureGroups")) {
                                measureGroup = DesignElementFactory.getInstance().newTabularMeasureGroup(null);
                                CubeGroupContent.access$11(CubeGroupContent.this).add("measureGroups", (DesignElementHandle)measureGroup);
                            } else {
                                measureGroup = element instanceof MeasureGroupHandle != false ? (MeasureGroupHandle)element : (MeasureGroupHandle)((VirtualField)element).getModel();
                            }
                            measure = DesignElementFactory.getInstance().newTabularMeasure(OlapUtil.getDataFieldDisplayName(dataField));
                            expression = new Expression((Object)ExpressionUtility.getExpression((Object)dataField, (IExpressionConverter)ExpressionUtility.getExpressionConverter((String)UIUtil.getDefaultScriptType())), UIUtil.getDefaultScriptType());
                            measure.setExpressionProperty("measureExpression", expression);
                            column = OlapUtil.getColumnHintHandle(dataField);
                            if (column != null) {
                                measure.setAlignment(column.getHorizontalAlign());
                                measure.setFormat(column.getValueFormat());
                            }
                            CubeGroupContent.access$13(CubeGroupContent.this, dataField, measure);
                            measureGroup.add("measures", (DesignElementHandle)measure);
                            if (!isValidName.booleanValue()) {
                                dialog = new MeasureDialog(false);
                                dialog.setInput(measure);
                                if (dialog.open() != 1) ** GOTO lbl242
                                SessionHandleAdapter.getInstance().getCommandStack().rollback();
                            }
                            stack.commit();
                        }
                        catch (SemanticException e) {
                            stack.rollback();
                            CubeGroupContent.this.refresh();
                            ExceptionUtil.handle((Throwable)e);
                            return;
                        }
                    } else if (element instanceof LevelHandle) {
                        hierarchy = (TabularHierarchyHandle)((LevelHandle)element).getContainer();
                        dimension = (DimensionHandle)hierarchy.getContainer();
                        if (dimension.isTimeType()) {
                            event.detail = 0;
                            return;
                        }
                        stack = SessionHandleAdapter.getInstance().getCommandStack();
                        stack.startTrans("");
                        try {
                            index = ((LevelHandle)element).getIndex();
                            level = DesignElementFactory.getInstance().newTabularLevel(dimension, OlapUtil.getDataFieldDisplayName(dataField));
                            level.setColumnName(dataField.getColumnName());
                            level.setDataType(dataField.getDataType());
                            column = OlapUtil.getColumnHintHandle(dataField);
                            if (column != null) {
                                level.setAlignment(column.getHorizontalAlign());
                                level.setFormat(column.getValueFormat());
                            }
                            ((LevelHandle)element).getContainer().add("levels", (DesignElementHandle)level, index + 1);
                            if (!isValidName.booleanValue()) {
                                dialog = new LevelPropertyDialog(true);
                                dialog.setInput(level);
                                if (dialog.open() != 1) ** GOTO lbl242
                                SessionHandleAdapter.getInstance().getCommandStack().rollback();
                            }
                            stack.commit();
                        }
                        catch (SemanticException e) {
                            stack.rollback();
                            CubeGroupContent.this.refresh();
                            ExceptionUtil.handle((Throwable)e);
                            return;
                        }
                    } else if (element instanceof DimensionHandle != false || element instanceof VirtualField != false && ((VirtualField)element).getType().equals("level") != false || element instanceof VirtualField != false && ((VirtualField)element).getType().equals("dimension") != false || element instanceof PropertyHandle && ((PropertyHandle)element).getPropertyDefn().getName().equals("dimensions")) {
                        dimension = null;
                        stack = SessionHandleAdapter.getInstance().getCommandStack();
                        stack.startTrans("");
                        try {
                            if (element instanceof VirtualField && ((VirtualField)element).getType().equals("dimension") || element instanceof PropertyHandle && ((PropertyHandle)element).getPropertyDefn().getName().equals("dimensions")) {
                                dimension = DesignElementFactory.getInstance().newTabularDimension(null);
                                CubeGroupContent.access$11(CubeGroupContent.this).add("dimensions", (DesignElementHandle)dimension);
                                if (!CubeGroupContent.access$12(CubeGroupContent.this, dataField.getDataType()) && (inputDialog = CubeGroupContent.access$15(CubeGroupContent.this, dimension, Messages.getString("CubeGroupContent.Group.Add.Title"), Messages.getString("CubeGroupContent.Group.Add.Message"))).open() != 0) {
                                    stack.rollback();
                                    CubeGroupContent.this.refresh();
                                    return;
                                }
                            } else {
                                dimension = element instanceof DimensionHandle != false ? (DimensionHandle)element : (DimensionHandle)((VirtualField)element).getModel();
                            }
                            if (dimension.isTimeType() && dimension.getDefaultHierarchy().getLevelCount() > 0) {
                                event.detail = 0;
                                stack.rollback();
                                return;
                            }
                            hierarchy = (TabularHierarchyHandle)dimension.getDefaultHierarchy();
                            if (hierarchy.getDataSet() == null && hierarchy.getLevelCount() == 0 && dataset != null && dataset != CubeGroupContent.access$11(CubeGroupContent.this).getDataSet()) {
                                hierarchy.setDataSet(dataset);
                            }
                            if (CubeGroupContent.access$12(CubeGroupContent.this, dataField.getDataType()) && hierarchy.getLevelCount() == 0) {
                                dialog = new GroupDialog(true);
                                dialog.setInput(hierarchy, dataField);
                                if (dialog.open() != 0) {
                                    stack.rollback();
                                } else if (!isValidName.booleanValue()) {
                                    level = (TabularLevelHandle)hierarchy.getLevel(dataField.getColumnName());
                                    dialog2 = new LevelPropertyDialog(false);
                                    dialog2.setInput(level);
                                    if (dialog2.open() == 1) {
                                        SessionHandleAdapter.getInstance().getCommandStack().rollback();
                                    }
                                } else {
                                    stack.commit();
                                }
                            } else {
                                level = DesignElementFactory.getInstance().newTabularLevel(dimension, OlapUtil.getDataFieldDisplayName(dataField));
                                level.setColumnName(dataField.getColumnName());
                                level.setDataType(dataField.getDataType());
                                column = OlapUtil.getColumnHintHandle(dataField);
                                if (column != null) {
                                    level.setAlignment(column.getHorizontalAlign());
                                    level.setFormat(column.getValueFormat());
                                }
                                hierarchy.add("levels", (DesignElementHandle)level);
                                if (!isValidName.booleanValue()) {
                                    dialog = new LevelPropertyDialog(true);
                                    dialog.setInput(level);
                                    if (dialog.open() == 1) {
                                        SessionHandleAdapter.getInstance().getCommandStack().rollback();
                                    }
                                } else {
                                    stack.commit();
                                }
                            }
                        }
                        catch (SemanticException e) {
                            stack.rollback();
                            CubeGroupContent.this.refresh();
                            ExceptionUtil.handle((Throwable)e);
                            return;
                        }
                    }
                }
lbl242:
                // 18 sources

                if (obj instanceof LevelHandle) {
                    oldIndex = ((LevelHandle)obj).getIndex();
                    if (event.item == null) {
                        event.detail = 0;
                        return;
                    }
                    pt = Display.getCurrent().map(null, (Control)CubeGroupContent.access$1(CubeGroupContent.this).getTree(), event.x, event.y);
                    bounds = item.getBounds();
                    if (element instanceof LevelHandle) {
                        newIndex = ((LevelHandle)element).getIndex();
                        if (newIndex < oldIndex) {
                            newIndex = pt.y < bounds.y + bounds.height / 3 ? ((LevelHandle)element).getIndex() : ((LevelHandle)element).getIndex() + 1;
                        } else if (newIndex > oldIndex) {
                            newIndex = pt.y < bounds.y + bounds.height / 3 ? ((LevelHandle)element).getIndex() - 1 : ((LevelHandle)element).getIndex();
                        }
                        stack = SessionHandleAdapter.getInstance().getCommandStack();
                        stack.startTrans("");
                        try {
                            ((LevelHandle)obj).moveTo(newIndex);
                            stack.commit();
                        }
                        catch (SemanticException e) {
                            stack.rollback();
                            CubeGroupContent.this.refresh();
                            ExceptionUtil.handle((Throwable)e);
                            return;
                        }
                        CubeGroupContent.access$1(CubeGroupContent.this).expandToLevel(obj, -1);
                        CubeGroupContent.access$1(CubeGroupContent.this).setSelection((ISelection)new StructuredSelection(obj), true);
                    }
                }
                CubeGroupContent.this.refresh();
            }
        });
    }

    private void createMoveButtonsField() {
        Composite buttonsField = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        buttonsField.setLayout((Layout)layout);
        this.addButton = new Button(buttonsField, 8);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CubeGroupContent.this.handleAddEvent();
            }
        });
        this.removeButton = new Button(buttonsField, 8);
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CubeGroupContent.this.handleDelEvent();
            }
        });
        this.addButton.setText(">");
        this.addButton.setToolTipText(Messages.getString("GroupsPage.ArrowButton.Add.Tooltip"));
        this.removeButton.setText("<");
        this.removeButton.setToolTipText(Messages.getString("GroupsPage.ArrowButton.Remove.Tooltip"));
        GridData gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = Math.max(25, this.addButton.computeSize((int)-1, (int)-1).x);
        gd.verticalAlignment = 1024;
        this.addButton.setLayoutData((Object)gd);
        gd = new GridData();
        gd.widthHint = Math.max(25, this.removeButton.computeSize((int)-1, (int)-1).x);
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 128;
        this.removeButton.setLayoutData((Object)gd);
    }

    private void createDataField() {
        Composite dataField = new Composite((Composite)this, 0);
        dataField.setLayoutData((Object)new GridData(1808));
        dataField.setLayout((Layout)new GridLayout());
        Label dataLabel = new Label(dataField, 0);
        dataLabel.setText(Messages.getString("GroupsPage.Label.DataField"));
        this.dataFieldsViewer = new TreeViewer(dataField, 2820);
        this.cubeLabelProvider = this.getCubeLabelProvider();
        this.dataFieldsViewer.setLabelProvider((IBaseLabelProvider)this.cubeLabelProvider);
        this.dataFieldsViewer.setContentProvider((IContentProvider)this.dataContentProvider);
        this.dataFieldsViewer.setAutoExpandLevel(3);
        GridData gd = new GridData(1808);
        this.dataFieldsViewer.getTree().setLayoutData((Object)gd);
        ((GridData)this.dataFieldsViewer.getTree().getLayoutData()).heightHint = 250;
        ((GridData)this.dataFieldsViewer.getTree().getLayoutData()).widthHint = 200;
        this.dataFieldsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CubeGroupContent.this.updateButtons();
            }
        });
        DragSource fieldsSource = new DragSource((Control)this.dataFieldsViewer.getTree(), this.operations);
        fieldsSource.setTransfer(this.types);
        fieldsSource.addDragListener((DragSourceListener)new CustomDragListener(this.dataFieldsViewer));
    }

    private CubeLabelProvider getCubeLabelProvider() {
        Object label = ElementAdapterManager.getAdapter((Object)((Object)this), CubeLabelProvider.class);
        if (label instanceof CubeLabelProvider) {
            return (CubeLabelProvider)((Object)label);
        }
        return new CubeLabelProvider();
    }

    public void load() {
        if (this.input != null) {
            this.dataFieldsViewer.getTree().removeTreeListener(this.dataTreeListener);
            if (this.datasets[0] != null) {
                this.dataFieldsViewer.setInput((Object)this.datasets);
            } else if (this.input.getDataSet() != null) {
                this.cubeLabelProvider.setInput(this.input);
                this.dataFieldsViewer.setInput((Object)this.input);
            }
            this.dataFieldsViewer.refresh();
            if (this.dataBackup != null) {
                this.dataBackup.restoreBackup(this.dataFieldsViewer);
            } else {
                this.dataBackup = new TreeViewerBackup();
                this.dataFieldsViewer.expandToLevel(2);
                this.dataBackup.updateStatus(this.dataFieldsViewer);
            }
            this.dataFieldsViewer.getTree().addTreeListener(this.dataTreeListener);
            this.groupViewer.getTree().removeTreeListener(this.groupTreeListener);
            this.groupViewer.setInput((Object)this.input);
            this.dataFieldsViewer.refresh();
            if (this.groupBackup != null) {
                this.groupBackup.restoreBackup(this.groupViewer);
            } else {
                this.groupBackup = new TreeViewerBackup();
                this.groupViewer.expandToLevel(4);
                this.groupBackup.updateStatus(this.groupViewer);
            }
            this.groupViewer.getTree().addTreeListener(this.groupTreeListener);
            this.getListenerElementVisitor().addListener((DesignElementHandle)this.input);
            this.updateButtons();
        }
    }

    private ListenerElementVisitor getListenerElementVisitor() {
        if (this.visitor == null) {
            this.visitor = new ListenerElementVisitor((Listener)this);
        }
        return this.visitor;
    }

    protected void updateButtons() {
        this.groupViewer.refresh();
        TreeSelection selections = (TreeSelection)this.groupViewer.getSelection();
        ResultSetColumnHandle dataField = null;
        if (selections.size() == 1) {
            Iterator iter = selections.iterator();
            Object obj = iter.next();
            TreeSelection dataSelection = (TreeSelection)this.dataFieldsViewer.getSelection();
            DataSetHandle dataset = null;
            if (dataSelection.size() == 1 && dataSelection.getFirstElement() != null && dataSelection.getFirstElement() instanceof ResultSetColumnHandle) {
                dataField = (ResultSetColumnHandle)dataSelection.getFirstElement();
                dataset = (DataSetHandle)dataField.getElementHandle();
            }
            if (dataField == null || dataset == null) {
                this.addBtn.setEnabled(false);
            }
            if (obj instanceof DimensionHandle || obj instanceof LevelHandle || obj instanceof MeasureHandle || obj instanceof MeasureGroupHandle || obj instanceof VirtualField) {
                if (this.checkSharedDimension(obj)) {
                    this.addBtn.setEnabled(false);
                    this.delBtn.setEnabled(false);
                    this.editBtn.setEnabled(false);
                    if (obj instanceof DimensionHandle) {
                        this.delBtn.setEnabled(true);
                    }
                    this.removeButton.setEnabled(this.delBtn.isEnabled());
                    this.addButton.setEnabled(this.addBtn.isEnabled());
                    return;
                }
                DimensionHandle dimenTemp = null;
                if (obj instanceof DimensionHandle) {
                    dimenTemp = (DimensionHandle)obj;
                } else if (obj instanceof VirtualField && ((VirtualField)obj).getType().equals("level")) {
                    dimenTemp = (DimensionHandle)((VirtualField)obj).getModel();
                } else if (obj instanceof LevelHandle) {
                    DesignElementHandle hierarchy = ((LevelHandle)obj).getContainer();
                    dimenTemp = (DimensionHandle)hierarchy.getContainer();
                } else {
                    this.addBtn.setEnabled(true);
                }
                if (dimenTemp != null) {
                    DataSetHandle table = OlapUtil.getHierarchyDataset((TabularHierarchyHandle)dimenTemp.getDefaultHierarchy());
                    if (table == null && dataField != null) {
                        this.addBtn.setEnabled(true);
                    } else if (table != null && dataset != table) {
                        this.addBtn.setEnabled(false);
                    } else {
                        if (dimenTemp.isTimeType() && dataField != null) {
                            if (this.isDateType(dataField.getDataType()) && dimenTemp.getDefaultHierarchy().getLevelCount() == 0) {
                                this.addBtn.setEnabled(true);
                            } else {
                                this.addBtn.setEnabled(false);
                            }
                        }
                        if (!dimenTemp.isTimeType() && dataField != null) {
                            this.addBtn.setEnabled(true);
                        }
                    }
                }
                if (obj instanceof MeasureGroupHandle || obj instanceof VirtualField && ((VirtualField)obj).getType().equals("measure") || obj instanceof MeasureHandle) {
                    this.addBtn.setEnabled(true);
                }
                if (obj instanceof LevelHandle) {
                    DimensionHandle dimension = (DimensionHandle)((LevelHandle)obj).getContainer().getContainer();
                    if (dimension.isTimeType()) {
                        this.delBtn.setEnabled(true);
                    } else {
                        this.delBtn.setEnabled(true);
                    }
                } else if (obj instanceof VirtualField) {
                    this.delBtn.setEnabled(false);
                } else {
                    this.delBtn.setEnabled(true);
                }
            } else {
                this.delBtn.setEnabled(false);
            }
            if (obj instanceof CubeHandle) {
                this.addBtn.setEnabled(false);
            } else if (obj instanceof PropertyHandle) {
                this.addBtn.setEnabled(true);
            }
            if (obj instanceof LevelHandle) {
                TabularLevelHandle level = (TabularLevelHandle)obj;
                if (level.attributesIterator() != null && level.attributesIterator().hasNext()) {
                    String name = String.valueOf(level.getName()) + " (";
                    Iterator attrIter = level.attributesIterator();
                    while (attrIter.hasNext()) {
                        name = String.valueOf(name) + ((LevelAttributeHandle)attrIter.next()).getName();
                        if (!attrIter.hasNext()) continue;
                        name = String.valueOf(name) + ", ";
                    }
                    name = String.valueOf(name) + ")";
                    this.groupViewer.getTree().getSelection()[0].setText(name);
                }
                this.editBtn.setEnabled(true);
            } else if (obj instanceof DimensionHandle || obj instanceof MeasureGroupHandle || obj instanceof MeasureHandle) {
                this.editBtn.setEnabled(true);
            } else {
                this.editBtn.setEnabled(false);
            }
            if (OlapUtil.isFromLibrary(this.input)) {
                this.addBtn.setEnabled(false);
                this.delBtn.setEnabled(false);
            }
        } else {
            this.addBtn.setEnabled(false);
            this.delBtn.setEnabled(false);
            this.editBtn.setEnabled(false);
        }
        this.removeButton.setEnabled(this.delBtn.isEnabled());
        this.addButton.setEnabled(this.addBtn.isEnabled());
    }

    private void handleDelEvent() {
        if (OlapUtil.isFromLibrary(this.input)) {
            return;
        }
        TreeSelection slections = (TreeSelection)this.groupViewer.getSelection();
        for (Object obj : slections) {
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans("");
            try {
                MeasureHandle measure;
                boolean hasExecuted;
                if (obj instanceof DimensionHandle) {
                    DimensionHandle dimension = (DimensionHandle)obj;
                    hasExecuted = OlapUtil.enableDrop(dimension);
                    if (hasExecuted) {
                        UIHelper.dropDimensionProperties(dimension);
                        dimension.dropAndClear();
                    }
                } else if (obj instanceof LevelHandle) {
                    LevelHandle level = (LevelHandle)obj;
                    TabularHierarchyHandle hierarchy = (TabularHierarchyHandle)level.getContainer();
                    DimensionHandle dimension = (DimensionHandle)hierarchy.getContainer();
                    boolean hasExecuted2 = OlapUtil.enableDrop(level);
                    if (hasExecuted2) {
                        level.dropAndClear();
                    }
                    if (hierarchy.getContentCount("levels") == 0) {
                        dimension.setTimeType(false);
                        hierarchy.setDataSet(null);
                    }
                } else if (obj instanceof MeasureGroupHandle) {
                    MeasureGroupHandle measureGroup = (MeasureGroupHandle)obj;
                    hasExecuted = OlapUtil.enableDrop(measureGroup);
                    if (hasExecuted) {
                        measureGroup.dropAndClear();
                    }
                } else if (obj instanceof MeasureHandle && (hasExecuted = OlapUtil.enableDrop(measure = (MeasureHandle)obj))) {
                    measure.dropAndClear();
                }
                stack.commit();
            }
            catch (SemanticException e) {
                stack.rollback();
                this.refresh();
                ExceptionUtil.handle((Throwable)e);
            }
        }
        this.updateButtons();
    }

    private void handleAddEvent() {
        if (OlapUtil.isFromLibrary(this.input)) {
            return;
        }
        TreeSelection slections = (TreeSelection)this.groupViewer.getSelection();
        for (Object obj : slections) {
            block24: {
                GroupRenameDialog inputDialog;
                CommandStack stack;
                TreeSelection dataFields = (TreeSelection)this.dataFieldsViewer.getSelection();
                Iterator iterator = dataFields.iterator();
                Object dataField = null;
                while (iterator.hasNext()) {
                    Object temp = iterator.next();
                    if (!(temp instanceof ResultSetColumnHandle) && !(temp instanceof DimensionHandle)) continue;
                    dataField = temp;
                }
                if (dataField instanceof ResultSetColumnHandle) {
                    this.handleDataAddEvent();
                    continue;
                }
                if (obj instanceof MeasureGroupHandle || obj instanceof VirtualField && ((VirtualField)obj).getType().equals("measure")) {
                    MeasureGroupHandle measureGroup = null;
                    measureGroup = obj instanceof MeasureGroupHandle ? (MeasureGroupHandle)obj : (MeasureGroupHandle)((VirtualField)obj).getModel();
                    stack = SessionHandleAdapter.getInstance().getCommandStack();
                    stack.startTrans("");
                    TabularMeasureHandle measure = DesignElementFactory.getInstance().newTabularMeasure(null);
                    try {
                        measureGroup.add("measures", (DesignElementHandle)measure);
                        MeasureDialog dialog = new MeasureDialog(true);
                        dialog.setInput(measure);
                        if (dialog.open() == 1) {
                            stack.rollback();
                        } else {
                            stack.commit();
                        }
                    }
                    catch (SemanticException e1) {
                        ExceptionUtil.handle((Throwable)e1);
                        stack.rollback();
                    }
                    this.refresh();
                    return;
                }
                if (obj instanceof MeasureHandle) {
                    CommandStack stack2 = SessionHandleAdapter.getInstance().getCommandStack();
                    stack2.startTrans("");
                    TabularMeasureHandle measure = DesignElementFactory.getInstance().newTabularMeasure(null);
                    try {
                        ((MeasureHandle)obj).getContainer().add("measures", (DesignElementHandle)measure);
                        MeasureDialog dialog = new MeasureDialog(true);
                        dialog.setInput(measure);
                        if (dialog.open() == 1) {
                            stack2.rollback();
                        } else {
                            stack2.commit();
                        }
                    }
                    catch (SemanticException e1) {
                        ExceptionUtil.handle((Throwable)e1);
                        stack2.rollback();
                    }
                    this.refresh();
                    return;
                }
                if (!(obj instanceof PropertyHandle) && (!(obj instanceof VirtualField) || !(((VirtualField)obj).getModel() instanceof PropertyHandle))) continue;
                PropertyHandle model = obj instanceof PropertyHandle ? (PropertyHandle)obj : (PropertyHandle)((VirtualField)obj).getModel();
                if (model.getPropertyDefn().getName().equals("dimensions")) {
                    stack = SessionHandleAdapter.getInstance().getCommandStack();
                    stack.startTrans("");
                    TabularDimensionHandle dimension = DesignElementFactory.getInstance().newTabularDimension(null);
                    try {
                        if (dataField instanceof DimensionHandle) {
                            model.getElementHandle().add("dimensions", (DesignElementHandle)dimension);
                            dimension.setSharedDimension((DimensionHandle)dataField);
                            stack.commit();
                            this.refresh();
                            continue;
                        }
                        model.getElementHandle().add("dimensions", (DesignElementHandle)dimension);
                    }
                    catch (SemanticException e1) {
                        stack.rollback();
                        ExceptionUtil.handle((Throwable)e1);
                        this.refresh();
                        continue;
                    }
                    inputDialog = this.createRenameDialog((DimensionHandle)dimension, Messages.getString("CubeGroupContent.Group.Add.Title"), Messages.getString("CubeGroupContent.Group.Add.Message"));
                    if (inputDialog.open() != 0) {
                        stack.rollback();
                        this.refresh();
                        continue;
                    }
                    stack.commit();
                    this.refresh();
                    continue;
                }
                if (!model.getPropertyDefn().getName().equals("measureGroups")) continue;
                stack = SessionHandleAdapter.getInstance().getCommandStack();
                stack.startTrans("");
                TabularMeasureGroupHandle measureGroup = DesignElementFactory.getInstance().newTabularMeasureGroup(null);
                try {
                    model.getElementHandle().add("measureGroups", (DesignElementHandle)measureGroup);
                }
                catch (SemanticException e1) {
                    stack.rollback();
                    ExceptionUtil.handle((Throwable)e1);
                    this.refresh();
                    continue;
                }
                inputDialog = new RenameInputDialog(this.getShell(), Messages.getString("CubeGroupContent.Measure.Add.Title"), Messages.getString("CubeGroupContent.Message.Add.Message"), measureGroup.getName(), "org.eclipse.birt.cshelp.SummaryFieldDialog_ID");
                inputDialog.create();
                if (inputDialog.open() == 0) {
                    try {
                        measureGroup.setName(inputDialog.getResult().toString().trim());
                        stack.commit();
                        break block24;
                    }
                    catch (Exception e1) {
                        ExceptionUtil.handle((Throwable)e1);
                        stack.rollback();
                        this.refresh();
                        continue;
                    }
                }
                stack.rollback();
                this.refresh();
                continue;
            }
            this.refresh();
        }
    }

    private boolean isDateType(String dataType) {
        return dataType.equals("date-time") || dataType.equals("date") || dataType.equals("time");
    }

    protected void handleDataAddEvent() {
        if (OlapUtil.isFromLibrary(this.input)) {
            return;
        }
        TreeSelection dataFields = (TreeSelection)this.dataFieldsViewer.getSelection();
        for (Object temp : dataFields) {
            if (!(temp instanceof ResultSetColumnHandle)) continue;
            ResultSetColumnHandle dataField = (ResultSetColumnHandle)temp;
            Boolean isValidName = UIUtil.validateDimensionName((String)OlapUtil.getDataFieldDisplayName(dataField));
            DataSetHandle dataset = (DataSetHandle)dataField.getElementHandle();
            DataSetHandle primary = this.input.getDataSet();
            TreeSelection slections = (TreeSelection)this.groupViewer.getSelection();
            for (Object obj : slections) {
                CommandStack stack;
                TabularLevelHandle level;
                TabularDimensionHandle dimension;
                if (obj instanceof TabularLevelHandle) {
                    CommandStack stack2;
                    block54: {
                        DataSetHandle dasetTemp;
                        TabularHierarchyHandle hierarchy = (TabularHierarchyHandle)((TabularLevelHandle)obj).getContainer();
                        dimension = (TabularDimensionHandle)hierarchy.getContainer();
                        if (dimension.isTimeType() || (dasetTemp = OlapUtil.getHierarchyDataset(hierarchy)) != null && dataset != null && dataset != dasetTemp) continue;
                        stack2 = SessionHandleAdapter.getInstance().getCommandStack();
                        stack2.startTrans("");
                        level = DesignElementFactory.getInstance().newTabularLevel((DimensionHandle)dimension, OlapUtil.getDataFieldDisplayName(dataField));
                        try {
                            level.setColumnName(dataField.getColumnName());
                            level.setDataType(dataField.getDataType());
                            ((TabularLevelHandle)obj).getContainer().add("levels", (DesignElementHandle)level, ((TabularLevelHandle)obj).getIndex() + 1);
                            ColumnHintHandle column = OlapUtil.getColumnHintHandle(dataField);
                            if (column == null) break block54;
                            level.setAlignment(column.getHorizontalAlign());
                            level.setFormat(column.getValueFormat());
                        }
                        catch (SemanticException e) {
                            stack2.rollback();
                            this.refresh();
                            ExceptionUtil.handle((Throwable)e);
                            continue;
                        }
                    }
                    if (!isValidName.booleanValue()) {
                        LevelPropertyDialog dialog = new LevelPropertyDialog(true);
                        dialog.setInput(level);
                        if (dialog.open() == 1) {
                            SessionHandleAdapter.getInstance().getCommandStack().rollback();
                        }
                    } else {
                        stack2.commit();
                    }
                    this.refresh();
                    return;
                }
                if (obj instanceof DimensionHandle || obj instanceof VirtualField && ((VirtualField)obj).getType().equals("level") || obj instanceof VirtualField && ((VirtualField)obj).getType().equals("dimension") || obj instanceof PropertyHandle && ((PropertyHandle)obj).getPropertyDefn().getName().equals("dimensions")) {
                    TabularHierarchyHandle hierarchy;
                    block56: {
                        block55: {
                            stack = SessionHandleAdapter.getInstance().getCommandStack();
                            stack.startTrans("");
                            dimension = null;
                            if (obj instanceof VirtualField && ((VirtualField)obj).getType().equals("dimension") || obj instanceof PropertyHandle && ((PropertyHandle)obj).getPropertyDefn().getName().equals("dimensions")) {
                                dimension = DesignElementFactory.getInstance().newTabularDimension(null);
                                try {
                                    GroupRenameDialog inputDialog;
                                    this.input.add("dimensions", (DesignElementHandle)dimension);
                                    if (!this.isDateType(dataField.getDataType()) && (inputDialog = this.createRenameDialog((DimensionHandle)dimension, Messages.getString("CubeGroupContent.Group.Add.Title"), Messages.getString("CubeGroupContent.Group.Add.Message"))).open() != 0) {
                                        stack.rollback();
                                        this.refresh();
                                    }
                                    break block55;
                                }
                                catch (SemanticException e) {
                                    stack.rollback();
                                    this.refresh();
                                    ExceptionUtil.handle((Throwable)e);
                                }
                                continue;
                            }
                            dimension = obj instanceof TabularDimensionHandle ? (TabularDimensionHandle)obj : (TabularDimensionHandle)((VirtualField)obj).getModel();
                        }
                        if (dimension.isTimeType()) {
                            if (dimension.getDefaultHierarchy().getLevelCount() <= 0 && this.isDateType(dataField.getDataType())) continue;
                            stack.rollback();
                            continue;
                        }
                        hierarchy = (TabularHierarchyHandle)dimension.getContent("hierarchies", 0);
                        DataSetHandle dasetTemp = OlapUtil.getHierarchyDataset(hierarchy);
                        if (dasetTemp != null && dataset != null && dataset != dasetTemp) {
                            stack.rollback();
                            continue;
                        }
                        if (hierarchy.getDataSet() == null) {
                            try {
                                if (hierarchy.getLevelCount() != 0 || dataset == primary) break block56;
                                hierarchy.setDataSet(dataset);
                            }
                            catch (SemanticException e) {
                                stack.rollback();
                                this.refresh();
                                ExceptionUtil.handle((Throwable)e);
                                continue;
                            }
                        }
                    }
                    try {
                        if (this.isDateType(dataField.getDataType()) && hierarchy.getLevelCount() == 0) {
                            GroupDialog dialog = new GroupDialog(true);
                            dialog.setInput(hierarchy, dataField);
                            if (dialog.open() == 1) {
                                stack.rollback();
                            } else if (!isValidName.booleanValue()) {
                                TabularLevelHandle level2 = (TabularLevelHandle)hierarchy.getLevel(OlapUtil.getDataFieldDisplayName(dataField));
                                LevelPropertyDialog dialog2 = new LevelPropertyDialog(false);
                                dialog2.setInput(level2);
                                if (dialog2.open() == 1) {
                                    SessionHandleAdapter.getInstance().getCommandStack().rollback();
                                }
                            } else {
                                stack.commit();
                            }
                        } else {
                            level = DesignElementFactory.getInstance().newTabularLevel((DimensionHandle)dimension, OlapUtil.getDataFieldDisplayName(dataField));
                            level.setColumnName(dataField.getColumnName());
                            level.setDataType(dataField.getDataType());
                            ColumnHintHandle column = OlapUtil.getColumnHintHandle(dataField);
                            if (column != null) {
                                level.setAlignment(column.getHorizontalAlign());
                                level.setFormat(column.getValueFormat());
                            }
                            hierarchy.add("levels", (DesignElementHandle)level);
                            if (!isValidName.booleanValue()) {
                                LevelPropertyDialog dialog = new LevelPropertyDialog(true);
                                dialog.setInput(level);
                                if (dialog.open() == 1) {
                                    SessionHandleAdapter.getInstance().getCommandStack().rollback();
                                }
                            } else {
                                stack.commit();
                            }
                        }
                    }
                    catch (SemanticException e) {
                        stack.rollback();
                        ExceptionUtil.handle((Throwable)e);
                    }
                    this.refresh();
                    return;
                }
                if (obj instanceof MeasureGroupHandle || obj instanceof VirtualField && ((VirtualField)obj).getType().equals("measure") || obj instanceof VirtualField && ((VirtualField)obj).getType().equals("measureGroup") || obj instanceof PropertyHandle && ((PropertyHandle)obj).getPropertyDefn().getName().equals("measureGroups")) {
                    CommandStack stack3;
                    MeasureGroupHandle measureGroup;
                    block57: {
                        if (!this.checkColumnDataType(dataField)) {
                            return;
                        }
                        measureGroup = null;
                        stack3 = SessionHandleAdapter.getInstance().getCommandStack();
                        stack3.startTrans("");
                        if (obj instanceof VirtualField && ((VirtualField)obj).getType().equals("measureGroup") || obj instanceof PropertyHandle && ((PropertyHandle)obj).getPropertyDefn().getName().equals("measureGroups")) {
                            measureGroup = DesignElementFactory.getInstance().newTabularMeasureGroup(null);
                            try {
                                this.input.add("measureGroups", (DesignElementHandle)measureGroup);
                                break block57;
                            }
                            catch (SemanticException e) {
                                stack3.rollback();
                                this.refresh();
                                ExceptionUtil.handle((Throwable)e);
                                continue;
                            }
                        }
                        measureGroup = obj instanceof MeasureGroupHandle ? (MeasureGroupHandle)obj : (MeasureGroupHandle)((VirtualField)obj).getModel();
                    }
                    TabularMeasureHandle measure = DesignElementFactory.getInstance().newTabularMeasure(OlapUtil.getDataFieldDisplayName(dataField));
                    try {
                        if (dataset != null && primary != null && dataset == primary) {
                            Expression expression = new Expression((Object)ExpressionUtility.getExpression((Object)dataField, (IExpressionConverter)ExpressionUtility.getExpressionConverter((String)UIUtil.getDefaultScriptType())), UIUtil.getDefaultScriptType());
                            measure.setExpressionProperty("measureExpression", expression);
                            ColumnHintHandle column = OlapUtil.getColumnHintHandle(dataField);
                            if (column != null) {
                                measure.setAlignment(column.getHorizontalAlign());
                                measure.setFormat(column.getValueFormat());
                            }
                        }
                        this.initMeasure(dataField, measure);
                        measureGroup.add("measures", (DesignElementHandle)measure);
                        if (!isValidName.booleanValue() || measure.getMeasureExpression() == null) {
                            MeasureDialog dialog = new MeasureDialog(false);
                            dialog.setInput(measure);
                            if (dialog.open() == 1) {
                                stack3.rollback();
                            } else {
                                stack3.commit();
                            }
                        } else {
                            stack3.commit();
                        }
                    }
                    catch (SemanticException e1) {
                        stack3.rollback();
                        ExceptionUtil.handle((Throwable)e1);
                    }
                    this.refresh();
                    return;
                }
                if (!(obj instanceof MeasureHandle)) continue;
                if (!this.checkColumnDataType(dataField)) {
                    return;
                }
                stack = SessionHandleAdapter.getInstance().getCommandStack();
                stack.startTrans("");
                TabularMeasureHandle measure = DesignElementFactory.getInstance().newTabularMeasure(OlapUtil.getDataFieldDisplayName(dataField));
                try {
                    if (dataset != null && primary != null && dataset == primary) {
                        Expression expression = new Expression((Object)ExpressionUtility.getExpression((Object)dataField, (IExpressionConverter)ExpressionUtility.getExpressionConverter((String)UIUtil.getDefaultScriptType())), UIUtil.getDefaultScriptType());
                        measure.setExpressionProperty("measureExpression", expression);
                        ColumnHintHandle column = OlapUtil.getColumnHintHandle(dataField);
                        if (column != null) {
                            measure.setAlignment(column.getHorizontalAlign());
                            measure.setFormat(column.getValueFormat());
                        }
                    }
                    this.initMeasure(dataField, measure);
                    ((MeasureHandle)obj).getContainer().add("measures", (DesignElementHandle)measure);
                    if (!isValidName.booleanValue() || measure.getMeasureExpression() == null) {
                        MeasureDialog dialog = new MeasureDialog(false);
                        dialog.setInput(measure);
                        if (dialog.open() == 1) {
                            stack.rollback();
                        } else {
                            stack.commit();
                        }
                    } else {
                        stack.commit();
                    }
                }
                catch (SemanticException e1) {
                    stack.rollback();
                    ExceptionUtil.handle((Throwable)e1);
                }
                this.refresh();
                return;
            }
        }
    }

    private void initMeasure(ResultSetColumnHandle dataField, TabularMeasureHandle measure) throws SemanticException {
        String dataType = dataField.getDataType();
        measure.setDataType(dataType);
        if ("integer".equals(dataType) || "float".equals(dataType) || "decimal".equals(dataType)) {
            return;
        }
        IAggrFunction countFunction = this.getCountFunction();
        if (countFunction != null) {
            measure.setFunction(countFunction.getName());
            measure.setDataType("integer");
        }
    }

    private IAggrFunction getCountFunction() {
        IAggrFunction countFunction = null;
        try {
            String countFunctionName = DataAdapterUtil.adaptModelAggregationType((String)"count");
            List aggrInfoList = DataUtil.getAggregationManager().getAggregations(2);
            int i = 0;
            while (i < aggrInfoList.size()) {
                IAggrFunction function = (IAggrFunction)aggrInfoList.get(i);
                if (function.getDisplayName().equals(countFunctionName)) {
                    countFunction = function;
                    break;
                }
                ++i;
            }
        }
        catch (BirtException e) {
            ExceptionUtil.handle((Throwable)e);
        }
        return countFunction;
    }

    private GroupRenameDialog createRenameDialog(DimensionHandle handle, String title, String message) {
        GroupRenameDialog inputDialog = new GroupRenameDialog(this.getShell(), title, message);
        inputDialog.setInput(handle);
        return inputDialog;
    }

    private InputDialog createInputDialog(ReportElementHandle handle, String title, String message) {
        InputDialog inputDialog = new InputDialog(this.getShell(), title, message, handle.getName(), null){

            public int open() {
                return super.open();
            }
        };
        inputDialog.create();
        return inputDialog;
    }

    private boolean checkColumnDataType(ResultSetColumnHandle dataField) {
        if (dataField.getDataType().equals("any")) {
            MessageDialog dialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString("CubeGroupContent.MeasureDataTypeErrorDialog.Title"), null, Messages.getFormattedString("CubeGroupContent.MeasureDataTypeErrorDialog.Message", new Object[]{OlapUtil.getDataFieldDisplayName(dataField)}), 4, new String[]{IDialogConstants.OK_LABEL}, 0);
            dialog.open();
            return false;
        }
        return true;
    }

    public void refresh() {
        this.updateButtons();
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (this.groupViewer == null || this.groupViewer.getControl().isDisposed()) {
            return;
        }
        this.groupViewer.refresh();
        this.expandNodeAfterCreation(ev);
        this.groupBackup.updateStatus(this.groupViewer);
        this.getListenerElementVisitor().addListener(focus);
    }

    private void expandNodeAfterCreation(NotificationEvent ev) {
        IDesignElement element;
        if (ev instanceof ContentEvent && ev.getEventType() == 0 && ((ContentEvent)ev).getAction() == 1 && (element = ((ContentEvent)ev).getContent()) != null) {
            DesignElementHandle handle = element.getHandle(this.input.getModule());
            this.groupViewer.expandToLevel((Object)handle, -1);
            this.groupViewer.setSelection((ISelection)new StructuredSelection((Object)handle), true);
            this.updateButtons();
        }
    }

    private void handleEditEvent() {
        TreeSelection slections = (TreeSelection)this.groupViewer.getSelection();
        for (Object obj : slections) {
            TitleAreaDialog dialog;
            CommandStack stack;
            TabularLevelHandle level;
            if (obj instanceof TabularLevelHandle) {
                level = (TabularLevelHandle)obj;
                if (((DimensionHandle)level.getContainer().getContainer()).isTimeType()) {
                    stack = SessionHandleAdapter.getInstance().getCommandStack();
                    stack.startTrans("");
                    dialog = new DateLevelDialog();
                    dialog.setInput(this.input, level);
                    if (dialog.open() == 0) {
                        stack.commit();
                        this.refresh();
                        continue;
                    }
                    stack.rollback();
                    continue;
                }
                stack = SessionHandleAdapter.getInstance().getCommandStack();
                stack.startTrans("");
                dialog = new LevelPropertyDialog(false);
                dialog.setInput(level);
                if (dialog.open() == 0) {
                    stack.commit();
                    this.refresh();
                    continue;
                }
                stack.rollback();
                continue;
            }
            if (obj instanceof TabularMeasureHandle) {
                level = (TabularMeasureHandle)obj;
                stack = SessionHandleAdapter.getInstance().getCommandStack();
                stack.startTrans("");
                dialog = new MeasureDialog(false);
                dialog.setInput((TabularMeasureHandle)level);
                if (dialog.open() == 0) {
                    stack.commit();
                    this.refresh();
                    continue;
                }
                stack.rollback();
                continue;
            }
            if (obj instanceof DimensionHandle && ((DimensionHandle)obj).isTimeType() && ((DimensionHandle)obj).getDefaultHierarchy().getLevelCount() > 0 && !this.checkSharedDimension(obj)) {
                CommandStack stack2 = SessionHandleAdapter.getInstance().getCommandStack();
                stack2.startTrans("");
                GroupDialog dialog2 = new GroupDialog(false);
                dialog2.setInput((TabularHierarchyHandle)((DimensionHandle)obj).getDefaultHierarchy());
                if (dialog2.open() == 0) {
                    stack2.commit();
                    continue;
                }
                stack2.rollback();
                continue;
            }
            String title = Messages.getString("RenameInputDialog.DialogTitle");
            String message = Messages.getString("RenameInputDialog.DialogMessage");
            if (obj instanceof DimensionHandle) {
                title = Messages.getString("CubeGroupContent.Group.Edit.Title");
                message = Messages.getString("CubeGroupContent.Group.Edit.Message");
                CommandStack stack3 = SessionHandleAdapter.getInstance().getCommandStack();
                stack3.startTrans("");
                GroupRenameDialog inputDialog = this.createRenameDialog((DimensionHandle)obj, title, message);
                if (inputDialog.open() == 0) {
                    stack3.commit();
                    continue;
                }
                stack3.rollback();
                continue;
            }
            if (!(obj instanceof MeasureGroupHandle)) continue;
            RenameInputDialog inputDialog = new RenameInputDialog(this.getShell(), Messages.getString("CubeGroupContent.Measure.Edit.Title"), Messages.getString("CubeGroupContent.Measure.Edit.Message"), ((ReportElementHandle)obj).getName(), "org.eclipse.birt.cshelp.SummaryFieldDialog_ID");
            inputDialog.create();
            if (inputDialog.open() != 0) continue;
            try {
                ((DesignElementHandle)obj).setName(inputDialog.getResult().toString().trim());
            }
            catch (NameException e1) {
                ExceptionUtil.handle((Throwable)e1);
            }
        }
        this.updateButtons();
    }

    private boolean checkSharedDimension(Object element) {
        DimensionHandle tempDimension = null;
        if (element instanceof LevelHandle) {
            tempDimension = (DimensionHandle)((LevelHandle)element).getContainer().getContainer();
        } else if (element instanceof DimensionHandle) {
            tempDimension = (DimensionHandle)element;
        }
        return tempDimension != null && (!(tempDimension.getContainer() instanceof CubeHandle) || tempDimension instanceof TabularDimensionHandle && ((TabularDimensionHandle)tempDimension).getSharedDimension() != null);
    }

    static /* synthetic */ void access$13(CubeGroupContent cubeGroupContent, ResultSetColumnHandle resultSetColumnHandle, TabularMeasureHandle tabularMeasureHandle) throws SemanticException {
        cubeGroupContent.initMeasure(resultSetColumnHandle, tabularMeasureHandle);
    }

    static /* synthetic */ boolean access$14(CubeGroupContent cubeGroupContent, ResultSetColumnHandle resultSetColumnHandle) {
        return cubeGroupContent.checkColumnDataType(resultSetColumnHandle);
    }

    static /* synthetic */ GroupRenameDialog access$15(CubeGroupContent cubeGroupContent, DimensionHandle dimensionHandle, String string, String string2) {
        return cubeGroupContent.createRenameDialog(dimensionHandle, string, string2);
    }

    class CustomDragListener
    implements DragSourceListener {
        private TreeViewer viewer;

        CustomDragListener(TreeViewer viewer) {
            this.viewer = viewer;
        }

        public void dragFinished(DragSourceEvent event) {
        }

        public void dragSetData(DragSourceEvent event) {
            event.data = CubeGroupContent.this.dragSourceItems[0].getText();
        }

        public void dragStart(DragSourceEvent event) {
            TreeItem[] selection = this.viewer.getTree().getSelection();
            if (selection.length > 0) {
                if (this.viewer == CubeGroupContent.this.dataFieldsViewer) {
                    ((CubeGroupContent)CubeGroupContent.this).dragSourceItems[0] = selection[0];
                } else if (this.viewer == CubeGroupContent.this.groupViewer && selection[0].getData() != null && selection[0].getData() instanceof LevelHandle) {
                    ((CubeGroupContent)CubeGroupContent.this).dragSourceItems[0] = selection[0];
                } else {
                    event.doit = false;
                }
            } else {
                event.doit = false;
            }
        }
    }
}

