/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.outline.providers;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.StyleNodeProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.model.api.CssSharedStyleHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.css.StyleSheetException;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;

public class CssSharedStyleNodeProvider
extends StyleNodeProvider {
    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
    }

    protected boolean performEdit(ReportElementHandle handle) {
        return false;
    }

    public Image getNodeIcon(Object model) {
        CssSharedStyleHandle handle = (CssSharedStyleHandle)model;
        if (handle.getCssStyleSheetHandle() != null && handle.getCssStyleSheetHandle().getContainerHandle() != null) {
            return ReportPlatformUIImages.getImage((String)"Style_LINK");
        }
        return super.getNodeIcon(model);
    }

    public String getNodeTooltip(Object model) {
        CssStyleSheetHandle uriCss;
        String cssURITooltip;
        CssSharedStyleHandle handle;
        block9: {
            handle = (CssSharedStyleHandle)model;
            CssStyleSheetHandle css = handle.getCssStyleSheetHandle();
            DesignElementHandle container = css.getContainerHandle();
            if (container == null) {
                return handle.getName();
            }
            cssURITooltip = Messages.getString((String)"CssStyleSheetNodeProvider.Tooltip.URI");
            IncludedCssStyleSheetHandle includedCssStyleSheet = null;
            uriCss = null;
            if (container instanceof ReportDesignHandle) {
                includedCssStyleSheet = ((ReportDesignHandle)container).findIncludedCssStyleSheetHandleByFileName(css.getFileName());
            } else if (container instanceof ThemeHandle) {
                includedCssStyleSheet = ((ThemeHandle)container).findIncludedCssStyleSheetHandleByName(css.getFileName());
            }
            if (includedCssStyleSheet == null || includedCssStyleSheet.getExternalCssURI() == null || includedCssStyleSheet.getExternalCssURI().length() == 0) {
                return handle.getName();
            }
            try {
                uriCss = SessionHandleAdapter.getInstance().getReportDesignHandle().openCssStyleSheet(includedCssStyleSheet.getExternalCssURI());
                if (uriCss == null) {
                    return handle.getName();
                }
            }
            catch (StyleSheetException styleSheetException) {
                if (uriCss != null) break block9;
                return handle.getName();
            }
        }
        if (uriCss.findStyle(handle.getName()) != null) {
            return String.valueOf(handle.getName()) + " " + cssURITooltip;
        }
        return handle.getName();
    }
}

