/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.resource;

import java.io.File;
import java.io.IOException;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileFolderSelectionDialog;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.ReportResourceChangeEvent;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.views.IReportResourceSynchronizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class NewResourceFileDialog
extends ResourceFileFolderSelectionDialog {
    private Text text;
    private String ext = ".properties";
    protected String newFileName = "";
    private Status OKStatus = new Status(0, "org.eclipse.birt.report.designer.ui", 0, "", null);
    private Status ErrorStatus = new Status(4, "org.eclipse.birt.report.designer.ui", 4, Messages.getString((String)"NewResourceFileDialog.ErrorMessage"), null);
    private Status ErrorStatusNoSelection = new Status(4, "org.eclipse.birt.report.designer.ui", 4, Messages.getString((String)""), null);
    private Status ErrorStatusInvalid = new Status(4, "org.eclipse.birt.report.designer.ui", 4, Messages.getString((String)"NewResourceFileDialog.ErrorMessageInvalid"), null);

    public NewResourceFileDialog() {
        super(true, new String[]{"*.properties"});
        this.setDoubleClickSelects(true);
        this.setValidator(new Validator());
        this.setAllowMultiple(false);
        this.setTitle(Messages.getString((String)"ModulePage.Resourcefile.Dialog.Title"));
        this.setMessage(Messages.getString((String)"ModulePage.Resourcefile.Dialog.Message"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite rt = (Composite)super.createDialogArea(parent);
        rt.setLayoutData((Object)new GridData(1808));
        Composite pane = new Composite(rt, 0);
        pane.setLayoutData((Object)new GridData(768));
        pane.setLayout((Layout)new GridLayout(2, false));
        pane.setLayoutData((Object)new GridData(768));
        Label lb = new Label(pane, 0);
        lb.setText(Messages.getString((String)"NewResourceFileDialog.label.NewFile"));
        this.text = new Text(pane, 2048);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewResourceFileDialog.this.newFileName = NewResourceFileDialog.this.text.getText();
                NewResourceFileDialog.this.updateOKStatus();
            }
        });
        this.configViewer();
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.NewResourceFileDialog_ID");
        return rt;
    }

    private void configViewer() {
        this.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object object = ((StructuredSelection)event.getSelection()).getFirstElement();
                if (object instanceof ResourceEntry) {
                    ResourceEntry entry = (ResourceEntry)object;
                    if (entry.getURL() != null && entry.getURL().getProtocol().equals("file")) {
                        File file = new File(entry.getURL().getPath());
                        NewResourceFileDialog.this.text.setEnabled(file.isDirectory());
                    } else {
                        NewResourceFileDialog.this.text.setText("");
                        NewResourceFileDialog.this.text.setEnabled(false);
                    }
                } else {
                    NewResourceFileDialog.this.text.setText("");
                    NewResourceFileDialog.this.text.setEnabled(false);
                }
            }
        });
    }

    protected void okPressed() {
        super.okPressed();
        Object[] selected = this.getResult();
        if (selected.length > 0 && !this.newFileName.equals("")) {
            ResourceEntry entry = (ResourceEntry)selected[0];
            File file = new File(entry.getURL().getPath());
            if (file.isFile()) {
                return;
            }
            try {
                File newFile = new File(file, this.newFileName);
                newFile.createNewFile();
                IReportResourceSynchronizer synchronizer = ReportPlugin.getDefault().getResourceSynchronizerService();
                if (synchronizer != null) {
                    synchronizer.notifyResourceChanged(new ReportResourceChangeEvent((Object)this, Path.fromOSString((String)newFile.getAbsolutePath()), 1));
                }
            }
            catch (IOException e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    public String getPath() {
        Object[] selected = this.getResult();
        if (selected.length > 0 && !this.newFileName.equals("")) {
            String path = super.getPath();
            ResourceEntry entry = (ResourceEntry)selected[0];
            File file = new File(entry.getURL().getPath());
            if (file.isFile()) {
                return path;
            }
            return String.valueOf(path) + (path.equals("") || path.endsWith("/") ? "" : "/") + this.newFileName;
        }
        return super.getPath();
    }

    private class Validator
    implements ISelectionStatusValidator {
        private Validator() {
        }

        public IStatus validate(Object[] selection) {
            int nSelected = selection.length;
            if (nSelected == 0) {
                return NewResourceFileDialog.this.ErrorStatusNoSelection;
            }
            if (nSelected > 1) {
                return NewResourceFileDialog.this.ErrorStatus;
            }
            if (selection[0] instanceof ResourceEntry && ((ResourceEntry)selection[0]).isFile()) {
                return NewResourceFileDialog.this.OKStatus;
            }
            if (NewResourceFileDialog.this.newFileName == null || !NewResourceFileDialog.this.newFileName.toLowerCase().endsWith(NewResourceFileDialog.this.ext.toLowerCase())) {
                return NewResourceFileDialog.this.ErrorStatus;
            }
            if (NewResourceFileDialog.this.newFileName == null || NewResourceFileDialog.this.newFileName.toLowerCase().equals(NewResourceFileDialog.this.ext.toLowerCase())) {
                return NewResourceFileDialog.this.ErrorStatusInvalid;
            }
            return NewResourceFileDialog.this.OKStatus;
        }
    }
}

