/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.ReportParameterUtil;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.IDatasetPreviewTask;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportEngineFactory;
import org.eclipse.birt.report.model.api.DataSetHandle;

public class DataSetPreviewer {
    private DataSetHandle dataSetHandle;
    private int maxRow;
    private IReportEngine engine;
    private IDatasetPreviewTask task;
    private IExtractionResults result;

    public void open(Map appContext, EngineConfig config) throws BirtException {
        this.engine = DataSetPreviewer.createReportEngine(config);
        this.task = this.engine.createDatasetPreviewTask();
        this.task.setMaxRow(this.maxRow);
        this.task.setDataSet(this.dataSetHandle);
        this.task.setAppContext(appContext);
        ReportParameterUtil.completeParamDefalutValues((IEngineTask)this.task, this.dataSetHandle.getModuleHandle());
    }

    public DataSetPreviewer(DataSetHandle dataSetHandle, int maxRow, DataSetEditor container) {
        this.dataSetHandle = dataSetHandle;
        this.maxRow = maxRow;
    }

    public IResultIterator preview() throws BirtException {
        this.result = this.task.execute();
        return this.result.nextResultIterator().getResultIterator();
    }

    private static IReportEngine createReportEngine(EngineConfig config) throws BirtException {
        return new ReportEngineFactory().createReportEngine(config);
    }

    public void close() throws BirtException {
        if (this.result != null) {
            this.result.close();
        }
        if (this.task != null) {
            this.task.close();
        }
        if (this.engine != null) {
            this.engine.destroy();
        }
    }
}

