/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.dialogs;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.CubeQueryUtil;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.dialogs.AbstractBindingDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ResourceEditDialog;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.CLabel;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.CrosstabAggregationExpressionProvider;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.CrosstabBindingExpressionProvider;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.AggregationArgument;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrosstabBindingDialogHelper
extends AbstractBindingDialogHelper {
    protected static final String NAME = Messages.getString((String)"BindingDialogHelper.text.Name");
    protected static final String DATA_TYPE = Messages.getString((String)"BindingDialogHelper.text.DataType");
    protected static final String FUNCTION = Messages.getString((String)"BindingDialogHelper.text.Function");
    protected static final String DATA_FIELD = Messages.getString((String)"BindingDialogHelper.text.DataField");
    protected static final String FILTER_CONDITION = Messages.getString((String)"BindingDialogHelper.text.Filter");
    protected static final String AGGREGATE_ON = Messages.getString((String)"BindingDialogHelper.text.AggOn");
    protected static final String EXPRESSION = Messages.getString((String)"BindingDialogHelper.text.Expression");
    protected static final String ALL = Messages.getString((String)"CrosstabBindingDialogHelper.AggOn.All");
    protected static final String DISPLAY_NAME = Messages.getString((String)"BindingDialogHelper.text.displayName");
    protected static final String DISPLAY_NAME_ID = Messages.getString((String)"BindingDialogHelper.text.displayNameID");
    protected static final String DEFAULT_ITEM_NAME = Messages.getString((String)"BindingDialogHelper.bindingName.dataitem");
    protected static final String DEFAULT_AGGREGATION_NAME = Messages.getString((String)"BindingDialogHelper.bindingName.aggregation");
    private static final String EMPTY_STRING = "";
    protected static final IChoiceSet DATA_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getStructure("ComputedColumn").getMember("dataType").getAllowedChoices();
    protected static final IChoice[] DATA_TYPE_CHOICES = DATA_TYPE_CHOICE_SET.getChoices(null);
    protected String[] dataTypes = ChoiceSetFactory.getDisplayNamefromChoiceSet((IChoiceSet)DATA_TYPE_CHOICE_SET);
    private Text txtName;
    private Text txtFilter;
    private Text txtExpression;
    private Combo cmbType;
    private Combo cmbFunction;
    private Combo cmbAggOn;
    private Composite paramsComposite;
    private Map<String, Control> paramsMap = new HashMap<String, Control>();
    private Map<String, String> paramsValueMap = new HashMap<String, String>();
    private Composite composite;
    private Text txtDisplayName;
    private Text txtDisplayNameID;
    private ComputedColumn newBinding;
    private CLabel messageLine;
    private Label lbName;
    private Label lbDisplayNameID;
    private Object container;
    private Button btnDisplayNameID;
    private Button btnRemoveDisplayNameID;
    private boolean hasInitDialog = false;
    private boolean isEditModal = false;
    private boolean hasModified = false;

    public void createContent(Composite parent) {
        this.composite = parent;
        ((GridLayout)this.composite.getLayout()).numColumns = 4;
        this.lbName = new Label(this.composite, 0);
        this.lbName.setText(NAME);
        this.txtName = new Text(this.composite, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.widthHint = 250;
        this.txtName.setLayoutData((Object)gd);
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CrosstabBindingDialogHelper.this.modifyDialogContent();
                CrosstabBindingDialogHelper.this.validate();
            }
        });
        this.lbDisplayNameID = new Label(this.composite, 0);
        this.lbDisplayNameID.setText(DISPLAY_NAME_ID);
        this.lbDisplayNameID.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128 && e.doit) {
                    e.detail = 0;
                    CrosstabBindingDialogHelper.this.openKeySelectionDialog();
                }
            }
        });
        this.txtDisplayNameID = new Text(this.composite, 2056);
        this.txtDisplayNameID.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CrosstabBindingDialogHelper.this.modifyDialogContent();
                CrosstabBindingDialogHelper.this.validate();
            }
        });
        this.txtDisplayNameID.setLayoutData((Object)new GridData(768));
        this.btnDisplayNameID = new Button(this.composite, 0);
        this.btnDisplayNameID.setEnabled(this.getAvailableResourceUrls() != null && this.getAvailableResourceUrls().length > 0);
        this.btnDisplayNameID.setText("...");
        this.btnDisplayNameID.setToolTipText(Messages.getString((String)"ResourceKeyDescriptor.button.browse.tooltip"));
        this.btnDisplayNameID.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CrosstabBindingDialogHelper.this.openKeySelectionDialog();
            }
        });
        this.btnRemoveDisplayNameID = new Button(this.composite, 0);
        this.btnRemoveDisplayNameID.setImage(ReportPlatformUIImages.getImage((String)"IMG_TOOL_DELETE"));
        this.btnRemoveDisplayNameID.setToolTipText(Messages.getString((String)"ResourceKeyDescriptor.button.reset.tooltip"));
        this.btnRemoveDisplayNameID.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CrosstabBindingDialogHelper.this.txtDisplayNameID.setText(CrosstabBindingDialogHelper.EMPTY_STRING);
                CrosstabBindingDialogHelper.this.txtDisplayName.setText(CrosstabBindingDialogHelper.EMPTY_STRING);
                CrosstabBindingDialogHelper.this.updateRemoveBtnState();
            }
        });
        new Label(this.composite, 0).setText(DISPLAY_NAME);
        this.txtDisplayName = new Text(this.composite, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.txtDisplayName.setLayoutData((Object)gd);
        this.txtDisplayName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CrosstabBindingDialogHelper.this.modifyDialogContent();
                CrosstabBindingDialogHelper.this.validate();
            }
        });
        new Label(this.composite, 0).setText(DATA_TYPE);
        this.cmbType = new Combo(this.composite, 2056);
        this.cmbType.setLayoutData((Object)gd);
        this.cmbType.setVisibleItemCount(30);
        this.cmbType.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                CrosstabBindingDialogHelper.this.validate();
            }

            public void widgetSelected(SelectionEvent arg0) {
                CrosstabBindingDialogHelper.this.modifyDialogContent();
                CrosstabBindingDialogHelper.this.validate();
            }
        });
        if (this.isAggregate()) {
            this.createAggregateSection(this.composite);
        } else {
            this.createCommonSection(this.composite);
        }
        this.createMessageSection(this.composite);
        gd = new GridData(1808);
        this.composite.setLayoutData((Object)gd);
        this.setContentSize(this.composite);
    }

    private void openKeySelectionDialog() {
        ResourceEditDialog dlg = new ResourceEditDialog(this.composite.getShell(), Messages.getString((String)"ResourceKeyDescriptor.title.SelectKey"));
        dlg.setResourceURLs(this.getResourceURLs());
        if (dlg.open() == 0) {
            String[] result = (String[])dlg.getDetailResult();
            this.txtDisplayNameID.setText(result[0]);
            this.txtDisplayName.setText(result[1]);
            this.updateRemoveBtnState();
        }
    }

    public void initDialog() {
        this.cmbType.setItems(this.dataTypes);
        this.txtDisplayName.setFocus();
        if (this.isAggregate()) {
            this.initFunction();
            this.initFilter();
            this.initAggOn();
        }
        if (this.getBinding() == null) {
            this.setTypeSelect(this.dataTypes[0]);
            this.newBinding = StructureFactory.newComputedColumn((DesignElementHandle)this.getBindingHolder(), (String)(this.isAggregate() ? DEFAULT_AGGREGATION_NAME : DEFAULT_ITEM_NAME));
            this.setName(this.newBinding.getName());
        } else {
            this.setName(this.getBinding().getName());
            this.setDisplayName(this.getBinding().getDisplayName());
            this.setDisplayNameID(this.getBinding().getDisplayNameID());
            if (this.getBinding().getDataType() != null) {
                if (DATA_TYPE_CHOICE_SET.findChoice(this.getBinding().getDataType()) != null) {
                    this.setTypeSelect(DATA_TYPE_CHOICE_SET.findChoice(this.getBinding().getDataType()).getDisplayName());
                } else {
                    this.cmbType.setText(EMPTY_STRING);
                }
            }
            if (this.getBinding().getExpression() != null) {
                this.setDataFieldExpression(this.getBinding());
            }
        }
        if (this.getBinding() != null) {
            this.txtName.setEnabled(false);
        }
        this.validate();
        this.hasInitDialog = true;
    }

    private void initAggOn() {
        try {
            AggregationCellHandle cellHandle;
            CrosstabReportItemHandle xtabHandle = (CrosstabReportItemHandle)((ExtendedItemHandle)this.getBindingHolder()).getReportItem();
            String[] aggOns = this.getAggOns(xtabHandle);
            this.cmbAggOn.setItems(aggOns);
            String aggstr = EMPTY_STRING;
            if (this.getBinding() != null) {
                List aggOnList = this.getBinding().getAggregateOnList();
                int i = 0;
                Iterator iterator = aggOnList.iterator();
                while (iterator.hasNext()) {
                    if (i > 0) {
                        aggstr = String.valueOf(aggstr) + ",";
                    }
                    String name = (String)iterator.next();
                    aggstr = String.valueOf(aggstr) + name;
                    ++i;
                }
            } else if (this.getDataItemContainer() instanceof AggregationCellHandle) {
                cellHandle = (AggregationCellHandle)this.getDataItemContainer();
                if (cellHandle.getAggregationOnRow() != null) {
                    aggstr = String.valueOf(aggstr) + cellHandle.getAggregationOnRow().getFullName();
                    if (cellHandle.getAggregationOnColumn() != null) {
                        aggstr = String.valueOf(aggstr) + ",";
                    }
                }
                if (cellHandle.getAggregationOnColumn() != null) {
                    aggstr = String.valueOf(aggstr) + cellHandle.getAggregationOnColumn().getFullName();
                }
            } else if (this.container instanceof AggregationCellHandle) {
                cellHandle = (AggregationCellHandle)this.container;
                if (cellHandle.getAggregationOnRow() != null) {
                    aggstr = String.valueOf(aggstr) + cellHandle.getAggregationOnRow().getFullName();
                    if (cellHandle.getAggregationOnColumn() != null) {
                        aggstr = String.valueOf(aggstr) + ",";
                    }
                }
                if (cellHandle.getAggregationOnColumn() != null) {
                    aggstr = String.valueOf(aggstr) + cellHandle.getAggregationOnColumn().getFullName();
                }
            }
            int j = 0;
            while (j < aggOns.length) {
                if (aggOns[j].equals(aggstr)) {
                    this.cmbAggOn.select(j);
                    return;
                }
                ++j;
            }
            this.cmbAggOn.select(0);
        }
        catch (ExtendedElementException e) {
            ExceptionUtil.handle((Throwable)e);
        }
    }

    private String[] getAggOns(CrosstabReportItemHandle xtabHandle) {
        List rowLevelList = this.getCrosstabViewHandleLevels(xtabHandle, 0);
        List columnLevelList = this.getCrosstabViewHandleLevels(xtabHandle, 1);
        ArrayList<String> aggOnList = new ArrayList<String>();
        aggOnList.add(ALL);
        for (String name : rowLevelList) {
            aggOnList.add(name);
        }
        for (String name : columnLevelList) {
            aggOnList.add(name);
        }
        for (String name : rowLevelList) {
            for (String name2 : columnLevelList) {
                aggOnList.add(String.valueOf(name) + "," + name2);
            }
        }
        return aggOnList.toArray(new String[aggOnList.size()]);
    }

    private List getCrosstabViewHandleLevels(CrosstabReportItemHandle xtab, int type) {
        ArrayList<String> levelList = new ArrayList<String>();
        CrosstabViewHandle viewHandle = xtab.getCrosstabView(type);
        if (viewHandle != null) {
            int dimensions = viewHandle.getDimensionCount();
            int i = 0;
            while (i < dimensions) {
                DimensionViewHandle dimension = viewHandle.getDimension(i);
                int levels = dimension.getLevelCount();
                int j = 0;
                while (j < levels) {
                    LevelViewHandle level = dimension.getLevel(j);
                    if (level.getCubeLevel() != null) {
                        levelList.add(level.getCubeLevel().getFullName());
                    }
                    ++j;
                }
                ++i;
            }
        }
        return levelList;
    }

    private void initFilter() {
        ExpressionButtonUtil.initExpressionButtonControl((Control)this.txtFilter, (Object)this.binding, (String)"filterExpr");
    }

    private void initFunction() {
        this.cmbFunction.setItems(this.getFunctionDisplayNames());
        if (this.binding == null) {
            this.cmbFunction.select(0);
            this.handleFunctionSelectEvent();
            return;
        }
        try {
            String functionString = this.getFunctionDisplayName(DataAdapterUtil.adaptModelAggregationType((String)this.binding.getAggregateFunction()));
            int itemIndex = this.getItemIndex(this.getFunctionDisplayNames(), functionString);
            this.cmbFunction.select(itemIndex);
            this.handleFunctionSelectEvent();
        }
        catch (AdapterException e) {
            ExceptionUtil.handle((Throwable)e);
        }
        Iterator iterator = this.binding.argumentsIterator();
        while (iterator.hasNext()) {
            AggregationArgumentHandle arg = (AggregationArgumentHandle)iterator.next();
            String argName = DataAdapterUtil.adaptArgumentName((String)arg.getName());
            if (!this.paramsMap.containsKey(argName) || arg.getValue() == null) continue;
            Control control = this.paramsMap.get(argName);
            ExpressionButtonUtil.initExpressionButtonControl((Control)control, (Object)arg, (String)"value");
        }
    }

    private String[] getFunctionDisplayNames() {
        IAggrFunction[] choices = this.getFunctions();
        if (choices == null) {
            return new String[0];
        }
        String[] displayNames = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            displayNames[i] = choices[i].getDisplayName();
            ++i;
        }
        return displayNames;
    }

    private IAggrFunction getFunctionByDisplayName(String displayName) {
        IAggrFunction[] choices = this.getFunctions();
        if (choices == null) {
            return null;
        }
        int i = 0;
        while (i < choices.length) {
            if (choices[i].getDisplayName().equals(displayName)) {
                return choices[i];
            }
            ++i;
        }
        return null;
    }

    private String getFunctionDisplayName(String function) {
        try {
            return DataUtil.getAggregationManager().getAggregation(function).getDisplayName();
        }
        catch (BirtException e) {
            ExceptionUtil.handle((Throwable)e);
            return null;
        }
    }

    private IAggrFunction[] getFunctions() {
        try {
            List aggrInfoList = DataUtil.getAggregationManager().getAggregations(1);
            return aggrInfoList.toArray(new IAggrFunction[0]);
        }
        catch (BirtException e) {
            ExceptionUtil.handle((Throwable)e);
            return new IAggrFunction[0];
        }
    }

    private String getDataTypeDisplayName(String dataType) {
        int i = 0;
        while (i < DATA_TYPE_CHOICES.length) {
            if (dataType.equals(DATA_TYPE_CHOICES[i].getName())) {
                return DATA_TYPE_CHOICES[i].getDisplayName();
            }
            ++i;
        }
        return EMPTY_STRING;
    }

    private void initTextField(Text txtParam, IParameterDefn param) {
        if (this.paramsValueMap.containsKey(param.getName())) {
            txtParam.setText(this.paramsValueMap.get(param.getName()));
            return;
        }
        if (this.binding != null) {
            Iterator iterator = this.binding.argumentsIterator();
            while (iterator.hasNext()) {
                AggregationArgumentHandle arg = (AggregationArgumentHandle)iterator.next();
                if (!arg.getName().equals(param.getName())) continue;
                if (arg.getValue() != null) {
                    txtParam.setText(arg.getValue());
                }
                return;
            }
        }
    }

    private void initDataFields(Combo cmbDataField, IParameterDefn param) {
        List<String> datas = this.getMesures();
        datas.addAll(this.getDatas());
        String[] items = datas.toArray(new String[datas.size()]);
        cmbDataField.setItems(items);
        if (this.paramsValueMap.containsKey(param.getName())) {
            cmbDataField.setText(this.paramsValueMap.get(param.getName()));
            return;
        }
        if (this.binding != null) {
            Iterator iterator = this.binding.argumentsIterator();
            while (iterator.hasNext()) {
                AggregationArgumentHandle arg = (AggregationArgumentHandle)iterator.next();
                if (!arg.getName().equals(param.getName()) || arg.getValue() == null) continue;
                int i = 0;
                while (i < items.length) {
                    if (items[i].equals(arg.getValue())) {
                        cmbDataField.select(i);
                        return;
                    }
                    ++i;
                }
                cmbDataField.setText(arg.getValue());
                return;
            }
            if (this.binding.getExpression() != null) {
                int i = 0;
                while (i < items.length) {
                    if (items[i].equals(this.binding.getExpression())) {
                        cmbDataField.select(i);
                    }
                    ++i;
                }
            }
        }
    }

    private List<String> getMesures() {
        ArrayList<String> measures = new ArrayList<String>();
        try {
            CrosstabReportItemHandle xtabHandle = (CrosstabReportItemHandle)((ExtendedItemHandle)this.getBindingHolder()).getReportItem();
            measures.add(EMPTY_STRING);
            int i = 0;
            while (i < xtabHandle.getMeasureCount()) {
                MeasureViewHandle mv = xtabHandle.getMeasure(i);
                if (!(mv instanceof ComputedMeasureViewHandle)) {
                    measures.add(DEUtil.getExpression((Object)mv.getCubeMeasure()));
                }
                ++i;
            }
        }
        catch (ExtendedElementException extendedElementException) {}
        return measures;
    }

    private List<String> getDatas() {
        ArrayList<String> datas = new ArrayList<String>();
        try {
            CrosstabReportItemHandle xtabHandle = (CrosstabReportItemHandle)((ExtendedItemHandle)this.getBindingHolder()).getReportItem();
            try {
                IBinding[] aggregateBindings;
                IBinding[] iBindingArray = aggregateBindings = CubeQueryUtil.getAggregationBindings((IBinding[])this.getCrosstabBindings(xtabHandle));
                int n = aggregateBindings.length;
                int n2 = 0;
                while (n2 < n) {
                    IBinding binding = iBindingArray[n2];
                    if (this.getBinding() == null || !this.getBinding().getName().equals(binding.getBindingName())) {
                        datas.add(ExpressionUtil.createJSDataExpression((String)binding.getBindingName()));
                    }
                    ++n2;
                }
            }
            catch (AdapterException adapterException) {
            }
            catch (BirtException birtException) {}
        }
        catch (ExtendedElementException extendedElementException) {}
        return datas;
    }

    private IBinding[] getCrosstabBindings(CrosstabReportItemHandle xtabHandle) throws BirtException {
        Iterator bindingItr = ((ExtendedItemHandle)xtabHandle.getModelHandle()).columnBindingsIterator();
        ModuleHandle module = ((ExtendedItemHandle)xtabHandle.getModelHandle()).getModuleHandle();
        ArrayList<Binding> bindingList = new ArrayList<Binding>();
        if (bindingItr != null) {
            HashMap cache = new HashMap();
            ArrayList rowLevelNameList = new ArrayList();
            ArrayList columnLevelNameList = new ArrayList();
            DataRequestSession session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
            try {
                IModelAdapter modelAdapter = session.getModelAdaptor();
                while (bindingItr.hasNext()) {
                    ComputedColumnHandle column = (ComputedColumnHandle)bindingItr.next();
                    Binding binding = new Binding(column.getName());
                    binding.setAggrFunction(column.getAggregateFunction() == null ? null : DataAdapterUtil.adaptModelAggregationType((String)column.getAggregateFunction()));
                    binding.setExpression((IBaseExpression)modelAdapter.adaptExpression((Expression)column.getExpressionProperty("expression").getValue(), IModelAdapter.ExpressionLocation.CUBE));
                    binding.setDataType(DataAdapterUtil.adaptModelDataType((String)column.getDataType()));
                    if (column.getFilterExpression() != null) {
                        binding.setFilter((IBaseExpression)modelAdapter.adaptExpression((Expression)column.getExpressionProperty("filterExpr").getValue(), IModelAdapter.ExpressionLocation.CUBE));
                    }
                    Iterator argItr = column.argumentsIterator();
                    while (argItr.hasNext()) {
                        AggregationArgumentHandle aah = (AggregationArgumentHandle)argItr.next();
                        if (aah.getValue() == null) continue;
                        binding.addArgument(aah.getName(), (IBaseExpression)modelAdapter.adaptExpression((Expression)aah.getExpressionProperty("value").getValue(), IModelAdapter.ExpressionLocation.CUBE));
                    }
                    List aggrList = column.getAggregateOnList();
                    if (aggrList != null) {
                        for (String baseLevel : aggrList) {
                            CrosstabUtil.addHierachyAggregateOn((ModuleHandle)module, (Binding)binding, (String)baseLevel, rowLevelNameList, columnLevelNameList, cache);
                        }
                    }
                    bindingList.add(binding);
                }
            }
            finally {
                session.shutdown();
            }
        }
        return bindingList.toArray(new IBinding[bindingList.size()]);
    }

    private void setDataFieldExpression(ComputedColumnHandle binding) {
        if (binding.getExpression() != null) {
            if (this.isAggregate()) {
                IAggrFunction function = this.getFunctionByDisplayName(this.cmbFunction.getText());
                if (function != null) {
                    IParameterDefn[] params;
                    IParameterDefn[] iParameterDefnArray = params = function.getParameterDefn();
                    int n = params.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IParameterDefn param = iParameterDefnArray[n2];
                        if (param.isDataField()) {
                            Control control = this.paramsMap.get(param.getName());
                            if (ExpressionButtonUtil.getExpressionButton((Control)control) != null) {
                                ExpressionButtonUtil.initExpressionButtonControl((Control)control, (Object)binding, (String)"expression");
                            } else if (control instanceof Combo) {
                                ((Combo)control).setText(binding.getExpression());
                            } else if (control instanceof CCombo) {
                                ((CCombo)control).setText(binding.getExpression());
                            } else if (control instanceof Text) {
                                ((Text)control).setText(binding.getExpression());
                            }
                        }
                        ++n2;
                    }
                }
            } else if (this.txtExpression != null && !this.txtExpression.isDisposed()) {
                ExpressionButtonUtil.initExpressionButtonControl((Control)this.txtExpression, (Object)binding, (String)"expression");
            }
        }
    }

    private void setName(String name) {
        if (name != null && this.txtName != null) {
            this.txtName.setText(name);
        }
    }

    private void setDisplayName(String displayName) {
        if (displayName != null && this.txtDisplayName != null) {
            this.txtDisplayName.setText(displayName);
        }
    }

    private void setDisplayNameID(String displayNameID) {
        if (displayNameID != null && this.txtDisplayNameID != null) {
            this.txtDisplayNameID.setText(displayNameID);
        }
    }

    private void setTypeSelect(String typeSelect) {
        if (this.cmbType != null) {
            if (typeSelect != null) {
                this.cmbType.select(this.getItemIndex(this.cmbType.getItems(), typeSelect));
            } else {
                this.cmbType.select(0);
            }
        }
    }

    private int getItemIndex(String[] items, String item) {
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void createAggregateSection(Composite composite) {
        new Label(composite, 0).setText(FUNCTION);
        this.cmbFunction = new Combo(composite, 2056);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.cmbFunction.setLayoutData((Object)gd);
        this.cmbFunction.setVisibleItemCount(30);
        this.cmbFunction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CrosstabBindingDialogHelper.this.handleFunctionSelectEvent();
                CrosstabBindingDialogHelper.this.modifyDialogContent();
                CrosstabBindingDialogHelper.this.validate();
            }
        });
        this.paramsComposite = new Composite(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.exclude = true;
        this.paramsComposite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 4;
        Layout parentLayout = this.paramsComposite.getParent().getLayout();
        if (parentLayout instanceof GridLayout) {
            layout.horizontalSpacing = ((GridLayout)parentLayout).horizontalSpacing;
        }
        this.paramsComposite.setLayout((Layout)layout);
        new Label(composite, 0).setText(FILTER_CONDITION);
        this.txtFilter = new Text(composite, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.txtFilter.setLayoutData((Object)gridData);
        this.txtFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CrosstabBindingDialogHelper.this.modifyDialogContent();
            }
        });
        this.createExpressionButton(composite, (Control)this.txtFilter);
        Label lblAggOn = new Label(composite, 0);
        lblAggOn.setText(AGGREGATE_ON);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        lblAggOn.setLayoutData((Object)gridData);
        this.cmbAggOn = new Combo(composite, 2056);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.cmbAggOn.setLayoutData((Object)gridData);
        this.cmbAggOn.setVisibleItemCount(30);
        this.cmbAggOn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CrosstabBindingDialogHelper.this.modifyDialogContent();
            }
        });
    }

    private void createCommonSection(Composite composite) {
        new Label(composite, 0).setText(EXPRESSION);
        this.txtExpression = new Text(composite, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.txtExpression.setLayoutData((Object)gd);
        this.createExpressionButton(composite, (Control)this.txtExpression);
        this.txtExpression.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CrosstabBindingDialogHelper.this.modifyDialogContent();
                CrosstabBindingDialogHelper.this.validate();
            }
        });
    }

    private void createMessageSection(Composite composite) {
        this.messageLine = new CLabel(composite, 16384);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 4;
        this.messageLine.setLayoutData((Object)layoutData);
    }

    protected void handleFunctionSelectEvent() {
        Control[] children = this.paramsComposite.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        IAggrFunction function = this.getFunctionByDisplayName(this.cmbFunction.getText());
        if (function != null) {
            this.paramsMap.clear();
            IParameterDefn[] params = function.getParameterDefn();
            if (params.length > 0) {
                ((GridData)this.paramsComposite.getLayoutData()).exclude = false;
                ((GridData)this.paramsComposite.getLayoutData()).heightHint = -1;
                int width = 0;
                if (this.paramsComposite.getParent().getLayout() instanceof GridLayout) {
                    Control[] controls = this.paramsComposite.getParent().getChildren();
                    int i2 = 0;
                    while (i2 < controls.length) {
                        int labelWidth;
                        if (controls[i2] instanceof Label && ((GridData)controls[i2].getLayoutData()).horizontalSpan == 1 && (labelWidth = controls[i2].getBounds().width - controls[i2].getBorderWidth() * 2) > width) {
                            width = labelWidth;
                        }
                        ++i2;
                    }
                }
                IParameterDefn[] iParameterDefnArray = params;
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    final IParameterDefn param = iParameterDefnArray[n2];
                    Label lblParam = new Label(this.paramsComposite, 0);
                    lblParam.setText(String.valueOf(param.getDisplayName()) + ":");
                    GridData gd = new GridData();
                    gd.widthHint = lblParam.computeSize((int)-1, (int)-1).x;
                    if (gd.widthHint < width) {
                        gd.widthHint = width;
                    }
                    lblParam.setLayoutData((Object)gd);
                    if (param.isDataField()) {
                        final Combo cmbDataField = new Combo(this.paramsComposite, 2048);
                        cmbDataField.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create());
                        cmbDataField.setVisibleItemCount(30);
                        this.initDataFields(cmbDataField, param);
                        cmbDataField.addModifyListener(new ModifyListener(){

                            public void modifyText(ModifyEvent e) {
                                CrosstabBindingDialogHelper.this.modifyDialogContent();
                                CrosstabBindingDialogHelper.this.validate();
                                CrosstabBindingDialogHelper.this.paramsValueMap.put(param.getName(), cmbDataField.getText());
                            }
                        });
                        this.paramsMap.put(param.getName(), (Control)cmbDataField);
                    } else {
                        final Text txtParam = new Text(this.paramsComposite, 2048);
                        this.initTextField(txtParam, param);
                        txtParam.addModifyListener(new ModifyListener(){

                            public void modifyText(ModifyEvent e) {
                                CrosstabBindingDialogHelper.this.modifyDialogContent();
                                CrosstabBindingDialogHelper.this.validate();
                                CrosstabBindingDialogHelper.this.paramsValueMap.put(param.getName(), txtParam.getText());
                            }
                        });
                        GridData gridData = new GridData(768);
                        gridData.horizontalIndent = 0;
                        gridData.horizontalSpan = 2;
                        txtParam.setLayoutData((Object)gridData);
                        this.createExpressionButton(this.paramsComposite, (Control)txtParam);
                        this.paramsMap.put(param.getName(), (Control)txtParam);
                    }
                    ++n2;
                }
            } else {
                ((GridData)this.paramsComposite.getLayoutData()).heightHint = 0;
            }
            try {
                this.cmbType.setText(this.getDataTypeDisplayName(DataAdapterUtil.adapterToModelDataType((int)DataUtil.getAggregationManager().getAggregation(function.getName()).getDataType())));
            }
            catch (BirtException e) {
                ExceptionUtil.handle((Throwable)e);
            }
        } else {
            ((GridData)this.paramsComposite.getLayoutData()).heightHint = 0;
            ((GridData)this.paramsComposite.getLayoutData()).exclude = true;
        }
        this.composite.layout(true, true);
        this.setContentSize(this.composite);
    }

    private void createExpressionButton(Composite parent, Control control) {
        if (this.expressionProvider == null) {
            this.expressionProvider = this.isAggregate() ? new CrosstabAggregationExpressionProvider((DesignElementHandle)this.bindingHolder, this.binding) : new CrosstabBindingExpressionProvider((DesignElementHandle)this.bindingHolder, this.binding);
        }
        ExpressionButtonUtil.createExpressionButton((Composite)parent, (Control)control, (IExpressionProvider)this.expressionProvider, (Object)this.bindingHolder);
    }

    /*
     * Unable to fully structure code
     */
    public void validate() {
        block22: {
            block24: {
                block23: {
                    block21: {
                        if (this.txtName == null || this.txtName.getText() != null && !this.txtName.getText().trim().equals("")) break block21;
                        this.dialog.setCanFinish(false);
                        break block22;
                    }
                    if (this.txtExpression == null || this.txtExpression.getText() != null && !this.txtExpression.getText().trim().equals("")) break block23;
                    this.dialog.setCanFinish(false);
                    break block22;
                }
                if (this.binding == null) {
                    for (ComputedColumnHandle computedColumn : this.bindingHolder.getColumnBindings()) {
                        if (!computedColumn.getName().equals(this.txtName.getText())) continue;
                        this.dialog.setCanFinish(false);
                        this.messageLine.setText(Messages.getFormattedString((String)"BindingDialogHelper.error.nameduplicate", (Object[])new Object[]{this.txtName.getText()}));
                        this.messageLine.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
                        return;
                    }
                }
                if (!this.isAggregate() || (params = (function = this.getFunctionByDisplayName(this.cmbFunction.getText())).getParameterDefn()).length <= 0) break block24;
                var6_3 = params;
                var5_4 = params.length;
                var4_5 = 0;
                while (var4_5 < var5_4) {
                    param = var6_3[var4_5];
                    if (param.isDataField()) {
                        block18: {
                            block19: {
                                cmbDataField = (Combo)this.paramsMap.get(param.getName());
                                expression = cmbDataField.getText();
                                session = null;
                                session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
                                if (session.getCubeQueryUtil().getReferencedMeasureName(expression) == null || function.getType() != 1) break block18;
                                this.dialog.setCanFinish(false);
                                this.messageLine.setText(Messages.getFormattedString((String)"BindingDialogHelper.error.improperexpression", (Object[])new Object[]{function.getName()}));
                                this.messageLine.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
                                if (session == null) break block19;
                                session.shutdown();
                            }
                            return;
                        }
                        try {
                            try {
                                this.dialog.setCanFinish(true);
                            }
                            catch (Exception v0) {
                                if (session == null) ** GOTO lbl52
                                session.shutdown();
                            }
                        }
                        catch (Throwable var10_10) {
                            if (session != null) {
                                session.shutdown();
                            }
                            throw var10_10;
                        }
                        if (session != null) {
                            session.shutdown();
                        }
                    }
lbl52:
                    // 7 sources

                    ++var4_5;
                }
            }
            this.dialogCanFinish();
            this.messageLine.setText("");
            this.messageLine.setImage(null);
            if (this.txtExpression != null && (this.txtExpression.getText() == null || this.txtExpression.getText().trim().equals(""))) {
                this.dialog.setCanFinish(false);
                return;
            }
            if (this.isAggregate()) {
                try {
                    aggregation = DataUtil.getAggregationManager().getAggregation(this.getFunctionByDisplayName(this.cmbFunction.getText()).getName());
                    if (aggregation.getParameterDefn().length > 0) {
                        var6_3 = parameters = aggregation.getParameterDefn();
                        var5_4 = parameters.length;
                        var4_5 = 0;
                        while (var4_5 < var5_4) {
                            param = var6_3[var4_5];
                            if (!param.isOptional() && ((paramValue = this.getControlValue(this.paramsMap.get(param.getName()))) == null || paramValue.trim().equals(""))) {
                                this.dialog.setCanFinish(false);
                                return;
                            }
                            ++var4_5;
                        }
                    }
                }
                catch (BirtException v1) {}
            }
            this.dialogCanFinish();
        }
        this.updateRemoveBtnState();
    }

    private void dialogCanFinish() {
        if (!this.hasModified && this.isEditModal()) {
            this.dialog.setCanFinish(false);
        } else {
            this.dialog.setCanFinish(true);
        }
    }

    public boolean differs(ComputedColumnHandle binding) {
        if (this.isAggregate()) {
            if (!this.strEquals(binding.getName(), this.txtName.getText())) {
                return true;
            }
            if (!this.strEquals(binding.getDisplayName(), this.txtDisplayName.getText())) {
                return true;
            }
            if (!this.strEquals(binding.getDisplayNameID(), this.txtDisplayNameID.getText())) {
                return true;
            }
            if (!this.strEquals(binding.getDataType(), this.getDataType())) {
                return true;
            }
            try {
                if (!this.strEquals(DataAdapterUtil.adaptModelAggregationType((String)binding.getAggregateFunction()), this.getFunctionByDisplayName(this.cmbFunction.getText()).getName())) {
                    return true;
                }
            }
            catch (AdapterException adapterException) {}
            if (!this.exprEquals((Expression)binding.getExpressionProperty("filterExpr").getValue(), ExpressionButtonUtil.getExpression((Control)this.txtFilter))) {
                return true;
            }
            if (!this.strEquals(this.cmbAggOn.getText(), DEUtil.getAggregateOn((ComputedColumnHandle)binding))) {
                return true;
            }
            IAggrFunction function = this.getFunctionByDisplayName(this.cmbFunction.getText());
            if (function != null) {
                IParameterDefn[] params;
                IParameterDefn[] iParameterDefnArray = params = function.getParameterDefn();
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    IParameterDefn param = iParameterDefnArray[n2];
                    if (this.paramsMap.containsKey(param.getName())) {
                        Expression paramValue = ExpressionButtonUtil.getExpression((Control)this.paramsMap.get(param.getName()));
                        Iterator iterator = binding.argumentsIterator();
                        while (iterator.hasNext()) {
                            AggregationArgumentHandle handle = (AggregationArgumentHandle)iterator.next();
                            if (!param.getName().equals(handle.getName()) || this.exprEquals((Expression)handle.getExpressionProperty("value").getValue(), paramValue)) continue;
                            return true;
                        }
                        if (param.isDataField() && binding.getExpression() != null && !this.exprEquals((Expression)binding.getExpressionProperty("expression").getValue(), paramValue)) {
                            return true;
                        }
                    }
                    ++n2;
                }
            }
        } else {
            if (!this.strEquals(this.txtName.getText(), binding.getName())) {
                return true;
            }
            if (!this.strEquals(this.txtDisplayName.getText(), binding.getDisplayName())) {
                return true;
            }
            if (!this.strEquals(this.txtDisplayNameID.getText(), binding.getDisplayNameID())) {
                return true;
            }
            if (!this.strEquals(this.getDataType(), binding.getDataType())) {
                return true;
            }
            if (!this.exprEquals(ExpressionButtonUtil.getExpression((Control)this.txtExpression), (Expression)binding.getExpressionProperty("expression").getValue())) {
                return true;
            }
        }
        return false;
    }

    private boolean exprEquals(Expression left, Expression right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null && right != null) {
            return right.getExpression() == null;
        }
        if (left != null && right == null) {
            return left.getExpression() == null;
        }
        if (left.getStringExpression() == null && right.getStringExpression() == null) {
            return true;
        }
        return this.strEquals(left.getStringExpression(), right.getStringExpression()) && this.strEquals(left.getType(), right.getType());
    }

    private String getControlValue(Control control) {
        if (control instanceof Text) {
            return ((Text)control).getText();
        }
        if (control instanceof Combo) {
            return ((Combo)control).getText();
        }
        return null;
    }

    private boolean strEquals(String left, String right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return EMPTY_STRING.equals(right);
        }
        if (right == null) {
            return EMPTY_STRING.equals(left);
        }
        return left.equals(right);
    }

    private String getDataType() {
        int i = 0;
        while (i < DATA_TYPE_CHOICES.length) {
            if (DATA_TYPE_CHOICES[i].getDisplayName().equals(this.cmbType.getText())) {
                return DATA_TYPE_CHOICES[i].getName();
            }
            ++i;
        }
        return EMPTY_STRING;
    }

    public ComputedColumnHandle editBinding(ComputedColumnHandle binding) throws SemanticException {
        if (this.isAggregate()) {
            binding.setDisplayName(this.txtDisplayName.getText());
            binding.setDisplayNameID(this.txtDisplayNameID.getText());
            int i = 0;
            while (i < DATA_TYPE_CHOICES.length) {
                if (DATA_TYPE_CHOICES[i].getDisplayName().equals(this.cmbType.getText())) {
                    binding.setDataType(DATA_TYPE_CHOICES[i].getName());
                    break;
                }
                ++i;
            }
            binding.setAggregateFunction(this.getFunctionByDisplayName(this.cmbFunction.getText()).getName());
            ExpressionButtonUtil.saveExpressionButtonControl((Control)this.txtFilter, (Object)binding, (String)"filterExpr");
            binding.clearAggregateOnList();
            String aggStr = this.cmbAggOn.getText();
            StringTokenizer token = new StringTokenizer(aggStr, ",");
            while (token.hasMoreTokens()) {
                String agg = token.nextToken();
                if (agg.equals(ALL)) continue;
                binding.addAggregateOn(agg);
            }
            binding.setExpression(null);
            binding.clearArgumentList();
            for (String arg : this.paramsMap.keySet()) {
                String value = this.getControlValue(this.paramsMap.get(arg));
                if (value == null) continue;
                AggregationArgument argHandle = StructureFactory.createAggregationArgument();
                argHandle.setName(arg);
                if (ExpressionButtonUtil.getExpressionButton((Control)this.paramsMap.get(arg)) != null) {
                    ExpressionButtonUtil.saveExpressionButtonControl((Control)this.paramsMap.get(arg), (Object)argHandle, (String)"value");
                } else {
                    Expression expression = new Expression((Object)value, "javascript");
                    argHandle.setExpressionProperty("value", expression);
                }
                binding.addArgument(argHandle);
            }
        } else {
            int i = 0;
            while (i < DATA_TYPE_CHOICES.length) {
                if (DATA_TYPE_CHOICES[i].getDisplayName().equals(this.cmbType.getText())) {
                    binding.setDataType(DATA_TYPE_CHOICES[i].getName());
                    break;
                }
                ++i;
            }
            binding.setDisplayName(this.txtDisplayName.getText());
            binding.setDisplayNameID(this.txtDisplayNameID.getText());
            if (ExpressionButtonUtil.getExpressionButton((Control)this.txtExpression) != null) {
                ExpressionButtonUtil.saveExpressionButtonControl((Control)this.txtExpression, (Object)binding, (String)"expression");
            } else {
                Expression expression = new Expression((Object)this.getControlValue((Control)this.txtExpression), "javascript");
                binding.setExpressionProperty("value", expression);
            }
        }
        return binding;
    }

    public ComputedColumnHandle newBinding(ReportItemHandle bindingHolder, String name) throws SemanticException {
        ComputedColumn column = StructureFactory.newComputedColumn((DesignElementHandle)bindingHolder, (String)(name == null ? this.txtName.getText() : name));
        ComputedColumnHandle binding = DEUtil.addColumn((DesignElementHandle)bindingHolder, (ComputedColumn)column, (boolean)true);
        return this.editBinding(binding);
    }

    public void setContainer(Object container) {
        this.container = container;
    }

    public boolean canProcessAggregation() {
        return true;
    }

    private URL[] getAvailableResourceUrls() {
        ArrayList<URL> urls = new ArrayList<URL>();
        String[] baseNames = this.getBaseNames();
        if (baseNames == null) {
            return urls.toArray(new URL[0]);
        }
        int i = 0;
        while (i < baseNames.length) {
            URL url = SessionHandleAdapter.getInstance().getReportDesignHandle().findResource(baseNames[i], 5);
            if (url != null) {
                urls.add(url);
            }
            ++i;
        }
        return urls.toArray(new URL[0]);
    }

    private String[] getBaseNames() {
        List resources = SessionHandleAdapter.getInstance().getReportDesignHandle().getIncludeResources();
        if (resources == null) {
            return null;
        }
        return resources.toArray(new String[0]);
    }

    private URL[] getResourceURLs() {
        String[] baseNames = this.getBaseNames();
        if (baseNames == null) {
            return null;
        }
        URL[] urls = new URL[baseNames.length];
        int i = 0;
        while (i < baseNames.length) {
            urls[i] = SessionHandleAdapter.getInstance().getReportDesignHandle().findResource(baseNames[i], 5);
            ++i;
        }
        return urls;
    }

    private void updateRemoveBtnState() {
        this.btnRemoveDisplayNameID.setEnabled(!this.txtDisplayNameID.getText().equals(EMPTY_STRING));
    }

    public void setEditModal(boolean isEditModal) {
        this.isEditModal = isEditModal;
    }

    public boolean isEditModal() {
        return this.isEditModal;
    }

    private void modifyDialogContent() {
        if (this.hasInitDialog && this.isEditModal() && !this.hasModified) {
            this.hasModified = true;
            this.validate();
        }
    }
}

