/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.series;

import java.util.Collection;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.CurveFitting;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.CurveFittingImpl;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.model.type.DifferenceSeries;
import org.eclipse.birt.chart.model.type.GanttSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.interfaces.ISeriesButtonEntry;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.InteractivitySheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.DecorationSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.DialLabelSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.DialScaleSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.DialTickSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.LineSeriesMarkerSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.NeedleSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.PieTitleSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.SeriesLabelSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.SeriesRegionSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.SeriesTrendlineSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class SeriesYSheetImpl
extends SubtaskSheetImpl
implements Listener,
SelectionListener {
    private Button btnShowLine;
    private Button cbVisible;
    private Button cbDecoVisible;

    public void createControl(Composite parent) {
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout();
        this.cmpContent.setLayout((Layout)glContent);
        GridData gd = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd);
        Group grpDetails = new Group(this.cmpContent, 0);
        GridData gdCMPDetails = new GridData(1808);
        gdCMPDetails.horizontalSpan = 2;
        grpDetails.setLayoutData((Object)gdCMPDetails);
        grpDetails.setLayout((Layout)new FillLayout());
        grpDetails.setText(Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.SeriesDetails"));
        Series series = this.getSeriesDefinitionForProcessing().getDesignTimeSeries();
        this.getSeriesAttributeUI(series, (Composite)grpDetails);
        Composite cmpBottom = new Composite(this.cmpContent, 0);
        GridLayout glBottom = new GridLayout(3, false);
        cmpBottom.setLayout((Layout)glBottom);
        this.cbVisible = new Button(cmpBottom, 32);
        this.cbVisible.addSelectionListener((SelectionListener)this);
        this.cbVisible.setSelection(this.isMeterSeries() ? ((DialSeries)this.getSeriesDefinitionForProcessing().getDesignTimeSeries()).getDial().getLabel().isVisible() : this.getSeriesDefinitionForProcessing().getDesignTimeSeries().getLabel().isVisible());
        if (this.isMeterSeries()) {
            this.cbVisible.setText(Messages.getString("SeriesYSheetImpl.Label.ShowDialLabels"));
        } else {
            this.cbVisible.setText(Messages.getString("SeriesYSheetImpl.Label.ShowLabels"));
        }
        if (this.isGanttSeries()) {
            this.cbDecoVisible = new Button(cmpBottom, 32);
            this.cbDecoVisible.setText(Messages.getString("SeriesYSheetImpl.Label.ShowDecoLabels"));
            this.cbDecoVisible.addSelectionListener((SelectionListener)this);
            this.cbDecoVisible.setSelection(((GanttSeries)this.getSeriesDefinitionForProcessing().getDesignTimeSeries()).getDecorationLabel().isVisible());
        }
        if (this.isTrendlineAvailable()) {
            this.btnShowLine = new Button(cmpBottom, 32);
            this.btnShowLine.setText(Messages.getString("SeriesYSheetImpl.Label.ShowTrendline"));
            this.btnShowLine.addSelectionListener((SelectionListener)this);
            this.btnShowLine.setSelection(this.getSeriesDefinitionForProcessing().getDesignTimeSeries().getCurveFitting() != null);
        }
        this.createButtonGroup(this.cmpContent);
    }

    private void createButtonGroup(Composite parent) {
        AbstractPopupSheet popup;
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(6, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 0x1000008;
        cmp.setLayoutData((Object)gridData);
        SeriesDefinition sd = this.getSeriesDefinitionForProcessing();
        Series series = sd.getDesignTimeSeries();
        if (this.isMeterSeries()) {
            popup = new DialLabelSheet(Messages.getString("SeriesYSheetImpl.Label.DialLabels"), this.getContext(), this.getSeriesDefinitionForProcessing());
            Button btnDialLabel = this.createToggleButton(cmp, ".DialLables", Messages.getString("SeriesYSheetImpl.Label.DialLabels&"), popup, this.cbVisible.getSelection());
            btnDialLabel.addSelectionListener((SelectionListener)this);
            if (this.getChart() instanceof DialChart && !((DialChart)this.getChart()).isDialSuperimposition()) {
                popup = new NeedleSheet(Messages.getString("SeriesYSheetImpl.Label.Needles"), this.getContext(), this.getSeriesDefinitionForProcessing());
                Button btnNeedles = this.createToggleButton(cmp, ".Needles", Messages.getString("SeriesYSheetImpl.Label.Needles&"), popup);
                btnNeedles.addSelectionListener((SelectionListener)this);
            }
            popup = new SeriesRegionSheet(Messages.getString("SeriesYSheetImpl.Label.Region"), this.getContext(), this.getSeriesDefinitionForProcessing());
            Button btnDialRegion = this.createToggleButton(cmp, ".Regions", Messages.getString("SeriesYSheetImpl.Label.Region&"), popup);
            btnDialRegion.addSelectionListener((SelectionListener)this);
            popup = new DialTickSheet(Messages.getString("DialTicksDialog.Title.DialTicks"), this.getContext(), (DialSeries)this.getSeriesDefinitionForProcessing().getDesignTimeSeries());
            Button btnDialTicks = this.createToggleButton(cmp, ".Ticks", Messages.getString("MeterSeriesAttributeComposite.Lbl.DialTicks"), popup);
            btnDialTicks.addSelectionListener((SelectionListener)this);
            popup = new DialScaleSheet(Messages.getString("DialScaleDialog.Title.DialScale"), this.getContext(), (DialSeries)this.getSeriesDefinitionForProcessing().getDesignTimeSeries());
            Button btnDialScale = this.createToggleButton(cmp, ".Scale", Messages.getString("MeterSeriesAttributeComposite.Lbl.DialScale"), popup);
            btnDialScale.addSelectionListener((SelectionListener)this);
        } else {
            popup = new SeriesLabelSheet(Messages.getString("SeriesYSheetImpl.Label.Labels"), this.getContext(), this.getSeriesDefinitionForProcessing());
            Button btnLabel = this.createToggleButton(cmp, ".Label", Messages.getString("SeriesYSheetImpl.Label.Labels&"), popup);
            btnLabel.addSelectionListener((SelectionListener)this);
        }
        if (this.getSeriesDefinitionForProcessing().getDesignTimeSeries() instanceof PieSeries) {
            popup = new PieTitleSheet(Messages.getString("SeriesYSheetImpl.Label.Titles"), this.getContext(), this.getSeriesDefinitionForProcessing());
            Button btnPieTitle = this.createToggleButton(cmp, ".Title", Messages.getString("SeriesYSheetImpl.Label.Titles&"), popup);
            btnPieTitle.addSelectionListener((SelectionListener)this);
        }
        if (series instanceof LineSeries && !this.isDifferenceSeries()) {
            popup = new LineSeriesMarkerSheet(Messages.getString("SeriesYSheetImpl.Label.Markers"), this.getContext(), (LineSeries)this.getSeriesDefinitionForProcessing().getDesignTimeSeries());
            Button btnLineMarker = this.createToggleButton(cmp, ".Markers", Messages.getString("SeriesYSheetImpl.Label.Markers&"), popup);
            btnLineMarker.addSelectionListener((SelectionListener)this);
        }
        if (this.isDifferenceSeries()) {
            popup = new LineSeriesMarkerSheet(Messages.getString("SeriesYSheetImpl.Label.PositiveMarkers"), this.getContext(), (LineSeries)((DifferenceSeries)this.getSeriesDefinitionForProcessing().getDesignTimeSeries()), true);
            Button btnPLineMarker = this.createToggleButton(cmp, ".Positive", Messages.getString("SeriesYSheetImpl.Label.PositiveMarkers&"), popup);
            btnPLineMarker.addSelectionListener((SelectionListener)this);
            popup = new LineSeriesMarkerSheet(Messages.getString("SeriesYSheetImpl.Label.NegativeMarkers"), this.getContext(), (LineSeries)((DifferenceSeries)this.getSeriesDefinitionForProcessing().getDesignTimeSeries()), false);
            Button btnNLineMarker = this.createToggleButton(cmp, ".Negative", Messages.getString("SeriesYSheetImpl.Label.NegativeMarkers&"), popup);
            btnNLineMarker.addSelectionListener((SelectionListener)this);
        }
        if (series instanceof GanttSeries) {
            popup = new DecorationSheet(Messages.getString("SeriesYSheetImpl.Label.Decoration"), this.getContext(), (GanttSeries)this.getSeriesDefinitionForProcessing().getDesignTimeSeries());
            Button btnDecoration = this.createToggleButton(cmp, ".Decoration", Messages.getString("SeriesYSheetImpl.Label.Decoration&"), popup, this.cbDecoVisible.getSelection());
            btnDecoration.addSelectionListener((SelectionListener)this);
        }
        if (this.isTrendlineAvailable()) {
            popup = new SeriesTrendlineSheet(Messages.getString("SeriesYSheetImpl.Label.Trendline"), this.getContext(), this.getSeriesDefinitionForProcessing());
            Button btnTrendline = this.createToggleButton(cmp, ".Curve", Messages.getString("SeriesYSheetImpl.Label.Trendline&"), popup, this.btnShowLine.getSelection());
            btnTrendline.addSelectionListener((SelectionListener)this);
        }
        if (!(this.getChart() instanceof DialChart) || !((DialChart)this.getChart()).isDialSuperimposition()) {
            popup = new InteractivitySheet(Messages.getString("SeriesYSheetImpl.Label.Interactivity"), this.getContext(), this.getSeriesDefinitionForProcessing().getDesignTimeSeries().getTriggers(), (EObject)this.getSeriesDefinitionForProcessing().getDesignTimeSeries(), 1, true, false);
            Button btnInteractivity = this.createToggleButton(cmp, ".Interactivity", Messages.getString("SeriesYSheetImpl.Label.Interactivity&"), popup, this.getChart().getInteractivity().isEnable());
            btnInteractivity.addSelectionListener((SelectionListener)this);
        }
        for (ISeriesButtonEntry buttonEntry : ChartUIUtil.getSeriesUIProvider((Series)series).getCustomButtons(this.getContext(), sd)) {
            Button button = this.createToggleButton(cmp, buttonEntry.getButtonId(), buttonEntry.getPopupName(), buttonEntry.getPopupSheet(), buttonEntry.isEnabled());
            button.addSelectionListener((SelectionListener)this);
        }
    }

    private void getSeriesAttributeUI(Series series, Composite parent) {
        ChartUIUtil.getSeriesUIProvider((Series)series).getSeriesAttributeSheet(parent, series, this.getContext());
    }

    public void handleEvent(Event event) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.detachPopup(e.widget)) {
            return;
        }
        if (this.isRegistered(e.widget)) {
            this.attachPopup(((Button)e.widget).getData().toString());
        }
        if (e.widget.equals(this.btnShowLine)) {
            this.setToggleButtonEnabled(".Curve", this.btnShowLine.getSelection());
            if (this.btnShowLine.getSelection()) {
                CurveFitting cf = CurveFittingImpl.create();
                cf.eAdapters().addAll((Collection)this.getSeriesDefinitionForProcessing().getDesignTimeSeries().eAdapters());
                this.getSeriesDefinitionForProcessing().getDesignTimeSeries().setCurveFitting(cf);
            } else {
                this.getSeriesDefinitionForProcessing().getDesignTimeSeries().setCurveFitting(null);
                Button btnTrendline = this.getToggleButton(".Curve");
                if (btnTrendline.getSelection()) {
                    btnTrendline.setSelection(false);
                    this.detachPopup((Widget)btnTrendline);
                }
            }
        } else if (e.widget.equals(this.cbVisible)) {
            if (this.isMeterSeries()) {
                this.setToggleButtonEnabled(".DialLables", this.cbVisible.getSelection());
                ((DialSeries)this.getSeriesDefinitionForProcessing().getDesignTimeSeries()).getDial().getLabel().setVisible(this.cbVisible.getSelection());
                Button btnDialLabel = this.getToggleButton(".DialLables");
                if (!this.cbVisible.getSelection() && btnDialLabel.getSelection()) {
                    btnDialLabel.setSelection(false);
                    this.detachPopup((Widget)btnDialLabel);
                }
            } else {
                this.getSeriesDefinitionForProcessing().getDesignTimeSeries().getLabel().setVisible(this.cbVisible.getSelection());
            }
            this.refreshPopupSheet();
        } else if (e.widget.equals(this.cbDecoVisible)) {
            this.setToggleButtonEnabled(".Decoration", this.cbDecoVisible.getSelection());
            ((GanttSeries)this.getSeriesDefinitionForProcessing().getDesignTimeSeries()).getDecorationLabel().setVisible(this.cbDecoVisible.getSelection());
            Button btnDecoration = this.getToggleButton(".Decoration");
            if (!this.cbDecoVisible.getSelection() && btnDecoration.getSelection()) {
                btnDecoration.setSelection(false);
                this.detachPopup((Widget)btnDecoration);
            } else {
                this.refreshPopupSheet();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private SeriesDefinition getSeriesDefinitionForProcessing() {
        SeriesDefinition sd = null;
        if (this.getChart() instanceof ChartWithAxes) {
            int iAxis = this.getParentAxisIndex(this.getIndex());
            int iAxisSeries = this.getSeriesIndexWithinAxis(this.getIndex());
            sd = (SeriesDefinition)((Axis)((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getAssociatedAxes().get(iAxis)).getSeriesDefinitions().get(iAxisSeries);
        } else if (this.getChart() instanceof ChartWithoutAxes) {
            sd = (SeriesDefinition)((SeriesDefinition)((ChartWithoutAxes)this.getChart()).getSeriesDefinitions().get(0)).getSeriesDefinitions().get(this.getIndex());
        }
        return sd;
    }

    private int getParentAxisIndex(int iSeriesDefinitionIndex) {
        int iTmp = 0;
        int iAxisCount = ((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getAssociatedAxes().size();
        int i = 0;
        while (i < iAxisCount) {
            if ((iTmp += ((Axis)((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getAssociatedAxes().get(i)).getSeriesDefinitions().size()) - 1 >= iSeriesDefinitionIndex) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private int getSeriesIndexWithinAxis(int iSeriesDefinitionIndex) {
        int iTotalDefinitions = 0;
        int iAxisCount = ((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getAssociatedAxes().size();
        int i = 0;
        while (i < iAxisCount) {
            int iOldTotal = iTotalDefinitions;
            if ((iTotalDefinitions += ((Axis)((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getAssociatedAxes().get(i)).getSeriesDefinitions().size()) - 1 >= iSeriesDefinitionIndex) {
                return iSeriesDefinitionIndex - iOldTotal;
            }
            ++i;
        }
        return iSeriesDefinitionIndex;
    }

    private boolean isTrendlineAvailable() {
        return this.getChart() instanceof ChartWithAxes && !this.isGanttSeries() && !this.isDifferenceSeries() && this.getChart().getDimension() != ChartDimension.THREE_DIMENSIONAL_LITERAL && this.getContext().isEnabled("Series.Y Series.Curve");
    }

    private boolean isMeterSeries() {
        return this.getSeriesDefinitionForProcessing().getDesignTimeSeries() instanceof DialSeries;
    }

    private boolean isGanttSeries() {
        return this.getSeriesDefinitionForProcessing().getDesignTimeSeries() instanceof GanttSeries;
    }

    private boolean isDifferenceSeries() {
        return this.getSeriesDefinitionForProcessing().getDesignTimeSeries() instanceof DifferenceSeries;
    }
}

