/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.dataextraction.impl;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.AutoFormatter;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.IFormatter;
import org.eclipse.birt.core.format.LocaleNeutralFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.report.engine.api.IDataExtractionOption;
import org.eclipse.birt.report.engine.api.IDataIterator;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.dataextraction.CommonDataExtractionOption;
import org.eclipse.birt.report.engine.dataextraction.ICommonDataExtractionOption;
import org.eclipse.birt.report.engine.dataextraction.i18n.Messages;
import org.eclipse.birt.report.engine.extension.DataExtractionExtensionBase;

public class CommonDataExtractionImpl
extends DataExtractionExtensionBase {
    protected String PLUGIN_ID = "org.eclipse.birt.report.engine.dataextraction";
    private IReportContext context;
    private IDataExtractionOption options;
    private DateFormatter dateFormatter = null;
    private ULocale locale = null;
    private TimeZone timeZone = null;
    private boolean isLocaleNeutral;
    private IFormatter[] valueFormatters;
    private Map formatterMap;

    public void initialize(IReportContext context, IDataExtractionOption options) throws BirtException {
        this.context = context;
        this.options = options;
        if (options.getOutputStream() == null) {
            throw new BirtException(this.PLUGIN_ID, Messages.getString("exception.dataextraction.options.outputstream_required"), null);
        }
        this.initCommonOptions(context, options);
    }

    private void initCommonOptions(IReportContext context, IDataExtractionOption options) {
        String dateFormat = null;
        ICommonDataExtractionOption commonOptions = options instanceof ICommonDataExtractionOption ? (ICommonDataExtractionOption)options : new CommonDataExtractionOption(options.getOptions());
        this.isLocaleNeutral = commonOptions.isLocaleNeutralFormat();
        dateFormat = commonOptions.getDateFormat();
        Locale aLocale = null;
        aLocale = commonOptions.getLocale() != null ? commonOptions.getLocale() : context.getLocale();
        this.locale = aLocale == null ? ULocale.forLocale((Locale)Locale.getDefault()) : ULocale.forLocale((Locale)aLocale);
        java.util.TimeZone javaTimeZone = commonOptions.getTimeZone();
        this.timeZone = javaTimeZone != null ? TimeZone.getTimeZone((String)javaTimeZone.getID()) : context.getTimeZone();
        if (!this.isLocaleNeutral) {
            this.dateFormatter = this.createDateFormatter(dateFormat, this.locale, this.timeZone);
        }
        this.formatterMap = commonOptions.getFormatter();
    }

    public IReportContext getReportContext() {
        return this.context;
    }

    public IDataExtractionOption getOptions() {
        return this.options;
    }

    public void output(IExtractionResults results) throws BirtException {
        throw new BirtException(this.PLUGIN_ID, Messages.getString("exception.dataextraction.missing_implementation"), null);
    }

    protected void createFormatters(String[] columnNames, int[] columnTypes) {
        int length = columnNames.length;
        this.valueFormatters = new IFormatter[length];
        String[] patterns = this.getPatterns(columnNames);
        int i = 0;
        while (i < length) {
            if (patterns[i] == null && this.isLocaleNeutral) {
                this.valueFormatters[i] = new LocaleNeutralFormatter();
            } else {
                switch (columnTypes[i]) {
                    case -1: 
                    case 0: 
                    case 11: {
                        this.valueFormatters[i] = new AutoFormatter(patterns[i], this.locale, this.timeZone, this.dateFormatter);
                        break;
                    }
                    case 6: 
                    case 9: 
                    case 10: {
                        if (patterns[i] != null) {
                            this.valueFormatters[i] = this.createDateFormatter(patterns[i], this.locale, this.timeZone);
                            break;
                        }
                        this.valueFormatters[i] = this.dateFormatter;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        this.valueFormatters[i] = new NumberFormatter(patterns[i], this.locale);
                        break;
                    }
                    case 5: {
                        StringFormatter strFormatter = new StringFormatter(patterns[i], this.locale);
                        if (patterns[i] == null) {
                            strFormatter.setTrim(false);
                        }
                        this.valueFormatters[i] = strFormatter;
                        break;
                    }
                    default: {
                        this.valueFormatters[i] = new IFormatter.DefaultFormatter(this.locale);
                    }
                }
            }
            ++i;
        }
    }

    private String[] getPatterns(String[] columnNames) {
        String[] patterns = new String[columnNames.length];
        if (this.formatterMap != null && !this.formatterMap.isEmpty()) {
            int i = 0;
            while (i < columnNames.length) {
                String pattern = (String)this.formatterMap.get(i + 1);
                if (pattern == null) {
                    pattern = (String)this.formatterMap.get(columnNames[i]);
                }
                patterns[i] = pattern;
                ++i;
            }
        }
        return patterns;
    }

    public void release() {
    }

    protected DateFormatter createDateFormatter(String pattern, ULocale locale, TimeZone timeZone) {
        return new DateFormatter(pattern, locale, timeZone);
    }

    protected String getStringValue(IDataIterator dataIterator, String[] columnNames, int index) throws BirtException {
        Object obj = dataIterator.getValue(columnNames[index]);
        return obj != null ? this.valueFormatters[index].formatValue(obj) : null;
    }
}

