/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DataSetSettingsPage
extends AbstractDescriptionPropertyPage {
    private static String DEFAULT_MESSAGE = Messages.getString((String)"dataset.editor.settings");
    private transient Button fetchAllDataCheckBox = null;
    private transient Button selectResultSetCheckBox = null;
    private transient Button resultSetName = null;
    private transient Button resultSetNumber = null;
    private String numberText = null;
    private String nameText = null;
    boolean changed = false;
    private static String STORED_PROCEDURE_EXTENSION_ID = "org.eclipse.birt.report.data.oda.jdbc.SPSelectDataSet";
    private static IChoiceSet nullOrderingChoiceSet = MetaDataDictionary.getInstance().getElement("DataSet").getProperty("nullsOrdering").getAllowedChoices();
    private Combo localeCombo;
    private Combo nullOrderingCombo;

    public Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        DataSetHandle handle = ((DataSetEditor)this.getContainer()).getHandle();
        if (handle instanceof OdaDataSetHandle) {
            this.addDataFetchSettingGroup(composite);
            String extensionID = ((OdaDataSetHandle)handle).getExtensionID();
            if (extensionID != null && extensionID.equalsIgnoreCase(STORED_PROCEDURE_EXTENSION_ID)) {
                this.addResultSetGroup(composite);
            }
        }
        this.addDataComparisonGroup(composite);
        return composite;
    }

    private void addDataComparisonGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setText(Messages.getString((String)"DataSetSettingsPage.DataGroup.Title"));
        GridLayout groupGridLayout = new GridLayout();
        groupGridLayout.numColumns = 2;
        group.setLayout((Layout)groupGridLayout);
        Label localeLabel = new Label((Composite)group, 0);
        localeLabel.setText(Messages.getString((String)"DataSetSettingsPage.Locale.Label"));
        this.localeCombo = new Combo((Composite)group, 2056);
        this.localeCombo.setVisibleItemCount(30);
        GridData gd = new GridData();
        gd.widthHint = 200;
        this.localeCombo.setLayoutData((Object)gd);
        this.localeCombo.setVisibleItemCount(30);
        ArrayList<String> localeNames = new ArrayList<String>();
        localeNames.add(Messages.getString((String)"SortkeyBuilder.Locale.Auto"));
        localeNames.addAll(FormatAdapter.LOCALE_TABLE.keySet());
        this.localeCombo.setItems(localeNames.toArray(new String[0]));
        this.localeCombo.select(0);
        DataSetHandle dataset = ((DataSetEditor)this.getContainer()).getHandle();
        if (dataset.getLocale() != null) {
            String locale = null;
            for (Map.Entry entry : FormatAdapter.LOCALE_TABLE.entrySet()) {
                if (!dataset.getLocale().equals(entry.getValue())) continue;
                locale = (String)entry.getKey();
            }
            if (locale != null) {
                int index = this.localeCombo.indexOf(locale);
                this.localeCombo.select(index < 0 ? 0 : index);
            }
        }
        Label nullOrderingLabel = new Label((Composite)group, 0);
        nullOrderingLabel.setText(Messages.getString((String)"DataSetSettingsPage.NullValueOrdering.Label"));
        this.nullOrderingCombo = new Combo((Composite)group, 2056);
        gd = new GridData();
        gd.widthHint = 200;
        this.nullOrderingCombo.setLayoutData((Object)gd);
        this.nullOrderingCombo.setItems(ChoiceSetFactory.getDisplayNamefromChoiceSet((IChoiceSet)nullOrderingChoiceSet));
        this.nullOrderingCombo.setText(ChoiceSetFactory.getDisplayNameFromChoiceSet((String)"nulls lowest", (IChoiceSet)nullOrderingChoiceSet));
        if (dataset.getNullsOrdering() != null) {
            this.nullOrderingCombo.setText(ChoiceSetFactory.getDisplayNameFromChoiceSet((String)dataset.getNullsOrdering(), (IChoiceSet)nullOrderingChoiceSet));
        }
    }

    private void addDataFetchSettingGroup(Composite composite) {
        GridLayout groupGridLayout = new GridLayout();
        groupGridLayout.numColumns = 5;
        GridData groupGridData = new GridData(768);
        Group dataFetchSettingGroup = new Group(composite, 0);
        dataFetchSettingGroup.setLayoutData((Object)groupGridData);
        dataFetchSettingGroup.setLayout((Layout)groupGridLayout);
        dataFetchSettingGroup.setText(Messages.getString((String)"dataset.editor.settings.dataFetchSetting"));
        this.fetchAllDataCheckBox = new Button((Composite)dataFetchSettingGroup, 32);
        GridData data = new GridData();
        data.horizontalSpan = 5;
        this.fetchAllDataCheckBox.setLayoutData((Object)data);
        this.fetchAllDataCheckBox.setText(Messages.getString((String)"dataset.editor.settings.dataFetchSetting.fetchAll"));
        final Label dataFetchLabel = new Label((Composite)dataFetchSettingGroup, 0);
        dataFetchLabel.setText(Messages.getString((String)"SettingsPage.dataFetchSetting.label"));
        final Text rowFetchLimitText = new Text((Composite)dataFetchSettingGroup, 2048);
        GridData gData = new GridData(768);
        rowFetchLimitText.setLayoutData((Object)gData);
        if (this.getDataSetRowFetchLimit() > 0) {
            this.fetchAllDataCheckBox.setSelection(false);
            rowFetchLimitText.setEnabled(true);
            dataFetchLabel.setEnabled(true);
            rowFetchLimitText.setText(Integer.toString(this.getDataSetRowFetchLimit()));
        } else {
            this.fetchAllDataCheckBox.setSelection(true);
            rowFetchLimitText.setEnabled(false);
            dataFetchLabel.setEnabled(false);
            rowFetchLimitText.setText("");
        }
        this.fetchAllDataCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelection = DataSetSettingsPage.this.fetchAllDataCheckBox.getSelection();
                dataFetchLabel.setEnabled(!isSelection);
                rowFetchLimitText.setEnabled(!isSelection);
                if (isSelection) {
                    rowFetchLimitText.setText("");
                }
            }
        });
        rowFetchLimitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int rowFetchLimit = 0;
                try {
                    if (DataSetSettingsPage.this.isNumber(rowFetchLimitText.getText())) {
                        String rowLimitText = rowFetchLimitText.getText();
                        if (rowLimitText.trim().length() == 0) {
                            rowLimitText = "0";
                        }
                        rowFetchLimit = (rowFetchLimit = new Double(rowLimitText).intValue()) < 0 ? 0 : rowFetchLimit;
                        DataSetSettingsPage.this.setDataSetRowFetchLimit(rowFetchLimit);
                        DataSetSettingsPage.this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
                    } else {
                        DataSetSettingsPage.this.getContainer().setMessage(Messages.getString((String)"dataset.editor.settings.dataFetchSetting.errorNumberFormat"), 3);
                    }
                }
                catch (SemanticException semanticException) {
                    DataSetSettingsPage.this.getContainer().setMessage(Messages.getString((String)"dataset.editor.settings.dataFetchSetting.errorNumberFormat"), 3);
                }
            }
        });
    }

    private void addResultSetGroup(Composite composite) {
        GridLayout groupGridLayout = new GridLayout();
        GridData groupGridData = new GridData(768);
        Group resultSetNumberGroup = new Group(composite, 0);
        resultSetNumberGroup.setLayoutData((Object)groupGridData);
        resultSetNumberGroup.setLayout((Layout)groupGridLayout);
        resultSetNumberGroup.setText(Messages.getString((String)"dataset.editor.settings.resultsetselection.resultSetSelection"));
        this.selectResultSetCheckBox = new Button((Composite)resultSetNumberGroup, 32);
        GridData data = new GridData();
        this.selectResultSetCheckBox.setLayoutData((Object)data);
        this.selectResultSetCheckBox.setText(Messages.getString((String)"dataset.editor.settings.resultsetselection.enableResultSetSelection"));
        Composite selectionComposite = new Composite((Composite)resultSetNumberGroup, 0);
        GridLayout cmpLayout = new GridLayout();
        cmpLayout.numColumns = 5;
        selectionComposite.setLayout((Layout)cmpLayout);
        GridData cmpGridData = new GridData(768);
        selectionComposite.setLayoutData((Object)cmpGridData);
        this.resultSetName = new Button(selectionComposite, 16);
        data = new GridData();
        data.horizontalSpan = 3;
        this.resultSetName.setLayoutData((Object)data);
        this.resultSetName.setText(Messages.getString((String)"dataset.editor.settings.resultsetselection.selectResultSetByName"));
        final Text nameText = new Text(selectionComposite, 2048);
        GridData gData = new GridData(768);
        nameText.setLayoutData((Object)gData);
        this.resultSetNumber = new Button(selectionComposite, 16);
        data = new GridData();
        data.horizontalSpan = 3;
        this.resultSetNumber.setLayoutData((Object)data);
        this.resultSetNumber.setText(Messages.getString((String)"dataset.editor.settings.resultsetselection.selectResultSetByNumber"));
        final Text numberText = new Text(selectionComposite, 2048);
        gData = new GridData(768);
        numberText.setLayoutData((Object)gData);
        this.selectResultSetCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = DataSetSettingsPage.this.selectResultSetCheckBox.getSelection();
                DataSetSettingsPage.this.resultSetName.setEnabled(selected);
                DataSetSettingsPage.this.resultSetNumber.setEnabled(selected);
                if (selected) {
                    if (DataSetSettingsPage.this.resultSetName.getSelection()) {
                        numberText.setEnabled(false);
                        nameText.setEnabled(true);
                    } else if (DataSetSettingsPage.this.resultSetNumber.getSelection()) {
                        nameText.setEnabled(false);
                        numberText.setEnabled(true);
                    } else {
                        nameText.setEnabled(selected);
                        numberText.setEnabled(selected);
                    }
                } else {
                    nameText.setEnabled(selected);
                    numberText.setEnabled(selected);
                }
                DataSetSettingsPage.this.changed = true;
            }
        });
        this.resultSetName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                nameText.setEnabled(true);
                numberText.setEnabled(false);
                DataSetSettingsPage.this.changed = true;
            }
        });
        this.resultSetNumber.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                nameText.setEnabled(false);
                numberText.setEnabled(true);
                DataSetSettingsPage.this.changed = true;
            }
        });
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataSetSettingsPage.this.nameText = nameText.getText();
                DataSetSettingsPage.this.changed = true;
            }
        });
        numberText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DataSetSettingsPage.this.isNumber(numberText.getText())) {
                    String number = numberText.getText();
                    if (number.trim().length() == 0) {
                        number = "0";
                    }
                    DataSetSettingsPage.this.numberText = numberText.getText();
                    DataSetSettingsPage.this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
                    DataSetSettingsPage.this.changed = true;
                } else {
                    DataSetSettingsPage.this.getContainer().setMessage(Messages.getString((String)"dataset.editor.settings.dataFetchSetting.errorNumberFormatForResultSet"), 3);
                }
            }
        });
        if (((OdaDataSetHandle)((DataSetEditor)this.getContainer()).getHandle()).getResultSetName() != null) {
            this.resultSetName.setSelection(true);
            nameText.setText(((OdaDataSetHandle)((DataSetEditor)this.getContainer()).getHandle()).getResultSetName());
            numberText.setEnabled(false);
            this.selectResultSetCheckBox.setSelection(true);
        } else if (((OdaDataSetHandle)((DataSetEditor)this.getContainer()).getHandle()).getPropertyHandle("resultSetNumber").isSet()) {
            this.resultSetNumber.setSelection(true);
            numberText.setText(String.valueOf(((OdaDataSetHandle)((DataSetEditor)this.getContainer()).getHandle()).getResultSetNumber()));
            nameText.setEnabled(false);
            this.selectResultSetCheckBox.setSelection(true);
        } else {
            this.selectResultSetCheckBox.setSelection(false);
            this.resultSetName.setSelection(true);
            this.resultSetName.setEnabled(false);
            this.resultSetNumber.setEnabled(false);
            nameText.setEnabled(false);
            numberText.setEnabled(false);
        }
    }

    private boolean isNumber(String text) {
        if (text == null) {
            return false;
        }
        if (text.trim().length() == 0) {
            return true;
        }
        return text.matches("^[0-9]*[1-9][0-9]*$");
    }

    private void setDataSetRowFetchLimit(int count) throws SemanticException {
        ((DataSetEditor)this.getContainer()).getHandle().setRowFetchLimit(count);
    }

    private int getDataSetRowFetchLimit() {
        return ((DataSetEditor)this.getContainer()).getHandle().getRowFetchLimit();
    }

    public void pageActivated() {
        this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    public boolean canLeave() {
        block3: {
            try {
                ((OdaDataSetHandle)((DataSetEditor)this.getContainer()).getHandle()).setProperty("resultSetNumber", null);
                ((OdaDataSetHandle)((DataSetEditor)this.getContainer()).getHandle()).setResultSetName(null);
                this.dealDataSetLocale();
                this.dealDataSetNullOrdering();
                if (this.updateResultSetSetting()) break block3;
                return true;
            }
            catch (Exception exception) {
                return true;
            }
        }
        return this.canLeavePage();
    }

    protected boolean canLeavePage() {
        if (this.canFinish()) {
            return super.performOk();
        }
        return false;
    }

    protected boolean updateResultSetSetting() throws SemanticException {
        if (this.selectResultSetCheckBox == null) {
            return false;
        }
        if (this.selectResultSetCheckBox.getSelection()) {
            if (this.resultSetNumber.getSelection()) {
                ((OdaDataSetHandle)((DataSetEditor)this.getContainer()).getHandle()).setResultSetNumber(new Integer(this.numberText).intValue());
            } else if (this.resultSetName.getSelection()) {
                ((OdaDataSetHandle)((DataSetEditor)this.getContainer()).getHandle()).setResultSetName(this.nameText);
            }
        }
        if (this.changed) {
            Iterator it = ((DataSetEditor)this.getContainer()).getHandle().resultSetIterator();
            while (it.hasNext()) {
                it.remove();
            }
        }
        this.changed = false;
        return true;
    }

    public boolean canFinish() {
        return true;
    }

    public boolean performOk() {
        if (this.canLeave()) {
            return super.performOk();
        }
        return false;
    }

    private void dealDataSetNullOrdering() {
        if (this.nullOrderingCombo != null && !this.nullOrderingCombo.isDisposed()) {
            int i = 0;
            while (i < nullOrderingChoiceSet.getChoices().length) {
                IChoice choice = nullOrderingChoiceSet.getChoices()[i];
                if (choice.getDisplayName().equals(this.nullOrderingCombo.getText())) {
                    try {
                        ((DataSetEditor)this.getContainer()).getHandle().setNullsOrdering(choice.getName());
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
                ++i;
            }
        }
    }

    private void dealDataSetLocale() {
        if (this.localeCombo != null && !this.localeCombo.isDisposed()) {
            String locale = this.localeCombo.getText();
            try {
                if (FormatAdapter.LOCALE_TABLE.containsKey(locale)) {
                    ((DataSetEditor)this.getContainer()).getHandle().setLocale((ULocale)FormatAdapter.LOCALE_TABLE.get(locale));
                } else {
                    ((DataSetEditor)this.getContainer()).getHandle().setLocale(null);
                }
            }
            catch (SemanticException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    public String getToolTip() {
        return Messages.getString((String)"SettingsPage.CachePreference.Filter.Tooltip");
    }
}

