/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.CompareHints;
import org.eclipse.birt.data.engine.expression.ExprEvaluateUtil;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.odi.FilterUtil;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.odi.IResultObjectEvent;

public class FilterByRow
implements IResultObjectEvent {
    public static final int DATASET_FILTER = 1;
    public static final int QUERY_FILTER = 2;
    public static final int ALL_ROW_FILTER = 3;
    public static final int NO_FILTER = 4;
    public static final int GROUP_FILTER = 5;
    public static final int AGGR_FILTER = 6;
    public static final int DATASET_AGGR_FILTER = 7;
    private FilterByRowHelper currentFilters;
    private FilterByRowHelper dataSetFilters;
    private FilterByRowHelper dataSetAggrFilters;
    private FilterByRowHelper queryFilters;
    private FilterByRowHelper groupFilters;
    private FilterByRowHelper allRowFilters;
    private FilterByRowHelper aggrFilters;
    protected static Logger logger = Logger.getLogger(FilterByRow.class.getName());

    FilterByRow(List dataSetFilters, List queryFilters, List groupFilters, List aggrFilters, List dataSetAggrFilters, DataSetRuntime dataSet) throws DataException {
        Object[] params = new Object[]{dataSetFilters, queryFilters, groupFilters, dataSet};
        logger.entering(FilterByRow.class.getName(), "FilterByRow", params);
        if (dataSetFilters != null && dataSetFilters.size() > 0) {
            this.dataSetFilters = new FilterByRowHelper(dataSet, DataSetRuntime.Mode.DataSet, FilterUtil.sortFilters(dataSetFilters));
        }
        if (queryFilters != null && queryFilters.size() > 0) {
            this.queryFilters = new FilterByRowHelper(dataSet, DataSetRuntime.Mode.Query, FilterUtil.sortFilters(queryFilters));
        }
        if (groupFilters != null && groupFilters.size() > 0) {
            this.groupFilters = new FilterByRowHelper(dataSet, DataSetRuntime.Mode.Query, groupFilters);
        }
        if (this.dataSetFilters != null || this.queryFilters != null) {
            this.allRowFilters = new FilterByRowHelper(dataSet, DataSetRuntime.Mode.DataSet, this.getAllRowFilters(dataSetFilters, queryFilters));
        }
        if (aggrFilters != null && aggrFilters.size() > 0) {
            this.aggrFilters = new FilterByRowHelper(dataSet, DataSetRuntime.Mode.Query, aggrFilters);
        }
        if (dataSetAggrFilters != null && dataSetAggrFilters.size() > 0) {
            this.dataSetAggrFilters = new FilterByRowHelper(dataSet, DataSetRuntime.Mode.DataSet, dataSetAggrFilters);
        }
        this.currentFilters = this.allRowFilters;
        logger.exiting(FilterByRow.class.getName(), "FilterByRow");
        logger.log(Level.FINER, "FilterByRow starts up");
    }

    private List getAllRowFilters(List dataSetFilters, List queryFilters) {
        ArrayList temp = new ArrayList();
        temp.addAll(dataSetFilters);
        temp.addAll(queryFilters);
        return temp;
    }

    public void setWorkingFilterSet(int filterSetType) throws DataException {
        this.validateFilterType(filterSetType);
        switch (filterSetType) {
            case 1: {
                this.currentFilters = this.dataSetFilters;
                break;
            }
            case 2: {
                this.currentFilters = this.queryFilters;
                break;
            }
            case 3: {
                this.currentFilters = this.allRowFilters;
                break;
            }
            case 5: {
                this.currentFilters = this.groupFilters;
                break;
            }
            case 6: {
                this.currentFilters = this.aggrFilters;
                break;
            }
            case 7: {
                this.currentFilters = this.dataSetAggrFilters;
                break;
            }
            default: {
                this.currentFilters = null;
            }
        }
    }

    public void restoreWorkingFilterSet() {
        this.currentFilters = this.allRowFilters;
    }

    public boolean isFilterSetExist(int filterSetType) throws DataException {
        this.validateFilterType(filterSetType);
        if (1 == filterSetType) {
            return this.dataSetFilters != null;
        }
        if (2 == filterSetType) {
            return this.queryFilters != null;
        }
        if (5 == filterSetType) {
            return this.groupFilters != null;
        }
        if (6 == filterSetType) {
            return this.aggrFilters != null;
        }
        if (7 == filterSetType) {
            return this.dataSetAggrFilters != null;
        }
        return this.allRowFilters != null;
    }

    public boolean process(IResultObject row, int rowIndex) throws DataException {
        if (this.currentFilters != null) {
            return this.currentFilters.process(row, rowIndex);
        }
        return true;
    }

    public List getFilterList() throws DataException {
        if (this.currentFilters != null) {
            return this.currentFilters.getFilters();
        }
        return new ArrayList();
    }

    public List getFilterList(int filterSetType) throws DataException {
        this.validateFilterType(filterSetType);
        switch (filterSetType) {
            case 1: {
                return this.dataSetFilters != null ? this.dataSetFilters.getFilters() : new ArrayList();
            }
            case 2: {
                return this.queryFilters != null ? this.queryFilters.getFilters() : new ArrayList();
            }
            case 3: {
                return this.allRowFilters != null ? this.allRowFilters.getFilters() : new ArrayList();
            }
            case 5: {
                return this.groupFilters != null ? this.groupFilters.getFilters() : new ArrayList();
            }
            case 6: {
                return this.aggrFilters != null ? this.aggrFilters.getFilters() : new ArrayList();
            }
            case 7: {
                return this.dataSetAggrFilters != null ? this.dataSetAggrFilters.getFilters() : new ArrayList();
            }
        }
        return new ArrayList();
    }

    private void validateFilterType(int filterSetType) {
        if (filterSetType != 4 && filterSetType != 1 && filterSetType != 3 && filterSetType != 2 && filterSetType != 5 && filterSetType != 6 && filterSetType != 7) assert (false);
    }

    private static class FilterByRowHelper {
        private DataSetRuntime dataSet;
        private List currentFilters;
        private DataSetRuntime.Mode mode;
        private CompareHints compareHints;

        FilterByRowHelper(DataSetRuntime dataSet, DataSetRuntime.Mode mode, List filters) {
            this.dataSet = dataSet;
            this.currentFilters = filters;
            this.mode = mode;
            if (mode == DataSetRuntime.Mode.DataSet && this.dataSet.getDesign() != null) {
                String nullOrdering = this.dataSet.getDesign().getNullsOrdering();
                Collator collator = Collator.getInstance((ULocale)(this.dataSet.getDesign().getCompareLocale() == null ? dataSet.getSession().getEngineContext().getLocale() : this.dataSet.getDesign().getCompareLocale()));
                this.compareHints = new CompareHints((Comparator)collator, nullOrdering);
            }
        }

        public List getFilters() {
            return this.currentFilters;
        }

        public boolean process(IResultObject row, int rowIndex) throws DataException {
            if (this.currentFilters.size() == 0) {
                return true;
            }
            logger.entering(FilterByRow.class.getName(), "process");
            boolean isAccepted = true;
            Iterator filterIt = this.currentFilters.iterator();
            this.dataSet.setRowObject(row, false);
            this.dataSet.setCurrentRowIndex(rowIndex);
            DataSetRuntime.Mode temp = this.dataSet.getMode();
            this.dataSet.setMode(this.mode);
            try {
                while (filterIt.hasNext()) {
                    IFilterDefinition filter = (IFilterDefinition)filterIt.next();
                    IBaseExpression expr = filter.getExpression();
                    Object result = null;
                    try {
                        result = expr instanceof IConditionalExpression ? ExprEvaluateUtil.evaluateConditionExpression((IConditionalExpression)expr, this.dataSet.getScriptScope(), true, this.dataSet.getSession().getEngineContext().getScriptContext(), this.compareHints, this.dataSet) : ExprEvaluateUtil.evaluateRawExpression2(expr, this.dataSet.getScriptScope(), this.dataSet.getSession().getEngineContext().getScriptContext(), this.dataSet);
                    }
                    catch (BirtException e2) {
                        DataException dataEx = DataException.wrap(e2);
                        throw dataEx;
                    }
                    if (result == null) {
                        Object info = null;
                        info = expr instanceof IScriptExpression ? ((IScriptExpression)expr).getText() : expr;
                        throw new DataException("data.engine.BadFilterExpr", info);
                    }
                    try {
                        if (DataTypeUtil.toBoolean((Object)result).booleanValue()) continue;
                        isAccepted = false;
                        break;
                    }
                    catch (BirtException e) {
                        DataException e1 = new DataException("data.engine.DataConversionError", e);
                        logger.logp(Level.FINE, FilterByRow.class.getName(), "process", "An error is thrown by DataTypeUtil.", (Throwable)((Object)e1));
                        throw e1;
                    }
                }
                boolean bl = isAccepted;
                return bl;
            }
            finally {
                this.dataSet.setMode(temp);
            }
        }
    }
}

