/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.SizeOfUtil;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.MeasureInfo;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.DimColumn;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationCalculator;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.ColumnInfo;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.DiskSortedStackWrapper;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.ICubeDimensionReader;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.IDataSet4Aggregation;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.Row4Aggregation;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.Row4AggregationComparator;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.util.DiskSortedStack;

public class AggregationExecutor {
    private AggregationCalculator[] aggregationCalculators = null;
    private DiskSortedStackWrapper[] sortedFactRows = null;
    private List allSortedFactRows = null;
    private int[][] levelIndex = null;
    private DimColumn[] paraColumns = null;
    private ColumnInfo[] paraInfos;
    private IDataSet4Aggregation dataSet4Aggregation;
    protected static Logger logger = Logger.getLogger(AggregationExecutor.class.getName());
    public int maxDataObjectRows = -1;
    public long memoryCacheSize = 0L;

    public AggregationExecutor(ICubeDimensionReader cubeDimensionReader, IDataSet4Aggregation dataSet4Aggregation, AggregationDefinition[] aggregations, long memoryCacheSize) throws IOException, DataException {
        int i;
        Object[] params = new Object[]{dataSet4Aggregation, aggregations};
        logger.entering(AggregationExecutor.class.getName(), "AggregationExecutor", params);
        this.dataSet4Aggregation = dataSet4Aggregation;
        this.memoryCacheSize = memoryCacheSize;
        this.getParameterColIndex(aggregations);
        this.aggregationCalculators = new AggregationCalculator[aggregations.length];
        int detailAggregationIndex = -1;
        int detailLevelNum = 0;
        if (aggregations.length > 2) {
            i = 0;
            while (i < aggregations.length) {
                if (aggregations[i].getLevels() != null && aggregations[i].getLevels().length > detailLevelNum) {
                    detailLevelNum = aggregations[i].getLevels().length;
                    detailAggregationIndex = i;
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.aggregationCalculators.length) {
            this.aggregationCalculators[i] = i == detailAggregationIndex ? new AggregationCalculator(aggregations[i], this.paraColumns, dataSet4Aggregation.getMetaInfo(), cubeDimensionReader, this.memoryCacheSize / 10L) : new AggregationCalculator(aggregations[i], this.paraColumns, dataSet4Aggregation.getMetaInfo(), cubeDimensionReader, this.memoryCacheSize / 5L / (long)this.aggregationCalculators.length);
            ++i;
        }
        this.sortedFactRows = new DiskSortedStackWrapper[aggregations.length];
        this.getAggregationLevelIndex();
        logger.exiting(AggregationExecutor.class.getName(), "AggregationExecutor");
    }

    public IAggregationResultSet[] execute(StopSign stopSign) throws IOException, DataException {
        this.populateSortedFactRows(stopSign);
        int i = 0;
        while (i < this.allSortedFactRows.size()) {
            DiskSortedStackWrapper diskSortedStackWrapper = (DiskSortedStackWrapper)this.allSortedFactRows.get(i);
            int[] calculatorIndexs = new int[this.sortedFactRows.length];
            int pos = 0;
            int j = 0;
            while (j < calculatorIndexs.length) {
                if (this.sortedFactRows[j] == diskSortedStackWrapper) {
                    calculatorIndexs[pos] = j;
                    ++pos;
                }
                ++j;
            }
            while (diskSortedStackWrapper.pop() != null && !stopSign.isStopped()) {
                Row4Aggregation row = (Row4Aggregation)diskSortedStackWrapper.getCurrentObject();
                int j2 = 0;
                while (j2 < pos) {
                    this.aggregationCalculators[calculatorIndexs[j2]].onRow(row);
                    ++j2;
                }
            }
            ++i;
        }
        IAggregationResultSet[] resultSets = new IAggregationResultSet[this.aggregationCalculators.length];
        int i2 = 0;
        while (i2 < this.aggregationCalculators.length) {
            resultSets[i2] = new AggregationResultSet(this.aggregationCalculators[i2].aggregation, this.aggregationCalculators[i2].getResult(), this.getKeyNames(i2), this.getAttributeNames(i2));
            ++i2;
        }
        this.dataSet4Aggregation.close();
        return resultSets;
    }

    private String[][] getKeyNames(int aggregationIndex) {
        String[][] result = new String[this.levelIndex[aggregationIndex].length / 2][];
        int[] tmpLevelIndex = this.levelIndex[aggregationIndex];
        int i = 0;
        while (i < this.levelIndex[aggregationIndex].length / 2) {
            result[i] = this.dataSet4Aggregation.getMetaInfo().getKeyNames(tmpLevelIndex[i * 2], tmpLevelIndex[i * 2 + 1]);
            ++i;
        }
        return result;
    }

    private String[][] getAttributeNames(int aggregationIndex) {
        String[][] result = new String[this.levelIndex[aggregationIndex].length / 2][];
        int[] tmpLevelIndex = this.levelIndex[aggregationIndex];
        int i = 0;
        while (i < this.levelIndex[aggregationIndex].length / 2) {
            result[i] = this.dataSet4Aggregation.getMetaInfo().getAttributeNames(tmpLevelIndex[i * 2], tmpLevelIndex[i * 2 + 1]);
            ++i;
        }
        return result;
    }

    private void populateSortedFactRows(StopSign stopSign) throws IOException, DataException {
        this.prepareSortedStacks();
        int measureCount = this.dataSet4Aggregation.getMetaInfo().getMeasureInfos().length;
        int factRowCount = 0;
        try {
            while (this.dataSet4Aggregation.next() && !stopSign.isStopped()) {
                int i = 0;
                while (i < this.allSortedFactRows.size()) {
                    DiskSortedStackWrapper diskSortedStackWrapper = (DiskSortedStackWrapper)this.allSortedFactRows.get(i);
                    int[] levelIndex = diskSortedStackWrapper.levelIndex;
                    Row4Aggregation aggregationRow = new Row4Aggregation();
                    aggregationRow.setDimPos(this.dataSet4Aggregation.getDimensionPosition());
                    aggregationRow.setLevelMembers(this.getLevelMembers(levelIndex));
                    if (aggregationRow.getLevelMembers() != null) {
                        aggregationRow.setMeasures(new Object[measureCount]);
                        int j = 0;
                        while (j < measureCount) {
                            aggregationRow.getMeasures()[j] = this.dataSet4Aggregation.getMeasureValue(j);
                            ++j;
                        }
                        aggregationRow.setParameterValues(this.getParameterValues());
                        diskSortedStackWrapper.diskSortedStack.push(aggregationRow);
                    }
                    ++i;
                }
                if (this.maxDataObjectRows <= 0 || ++factRowCount <= this.maxDataObjectRows) continue;
                throw new DataException("data.engine.exceed.max.data.object.row");
            }
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    Member[] getLevelMembers(int[] levelIndex) throws BirtException, IOException {
        Member[] result = new Member[levelIndex.length / 2];
        int i = 0;
        while (i < result.length) {
            int dim = levelIndex[i * 2];
            int level = levelIndex[i * 2 + 1];
            result[i] = this.dataSet4Aggregation.getMember(dim, level);
            if (result[i] == null) {
                return null;
            }
            ++i;
        }
        return result;
    }

    Object[] getParameterValues() throws BirtException, IOException {
        if (this.paraInfos == null || this.paraInfos.length == 0) {
            return null;
        }
        Object[] reValues = new Object[this.paraInfos.length];
        int i = 0;
        while (i < reValues.length) {
            Member member = this.dataSet4Aggregation.getMember(this.paraInfos[i].getDimIndex(), this.paraInfos[i].getLevelIndex());
            reValues[i] = this.paraInfos[i].isKey() ? member.getKeyValues()[this.paraInfos[i].getColumnIndex()] : member.getAttributes()[this.paraInfos[i].getColumnIndex()];
            ++i;
        }
        return reValues;
    }

    private void prepareSortedStacks() throws DataException, IOException {
        this.allSortedFactRows = new ArrayList();
        int levelSize = 0;
        int measureSize = 0;
        block0: while (true) {
            int maxLevelCount = -1;
            int aggregationIndex = -1;
            int[] levelSortType = null;
            int i = 0;
            while (i < this.aggregationCalculators.length) {
                if (this.sortedFactRows[i] == null && (this.aggregationCalculators[i].aggregation.getLevels() != null && this.aggregationCalculators[i].aggregation.getLevels().length > maxLevelCount || this.aggregationCalculators[i].aggregation.getLevels() == null && maxLevelCount == -1)) {
                    aggregationIndex = i;
                    maxLevelCount = this.aggregationCalculators[i].aggregation.getLevels() != null ? this.aggregationCalculators[i].aggregation.getLevels().length : 0;
                    levelSortType = this.aggregationCalculators[i].aggregation.getSortTypes();
                }
                ++i;
            }
            if (aggregationIndex == -1) break;
            if (this.memoryCacheSize != 0L) {
                if (levelSize == 0) {
                    levelSize = this.getLevelSize(this.aggregationCalculators[aggregationIndex].aggregation.getLevels());
                } else if (this.aggregationCalculators[aggregationIndex].aggregation.getLevels() != null) {
                    levelSize += SizeOfUtil.getArraySize(this.aggregationCalculators[aggregationIndex].aggregation.getLevels().length);
                }
                if (measureSize == 0) {
                    measureSize = this.getMeasureSize();
                } else if (this.dataSet4Aggregation.getMetaInfo().getMeasureInfos() != null) {
                    measureSize += SizeOfUtil.getArraySize(this.dataSet4Aggregation.getMetaInfo().getMeasureInfos().length);
                }
            }
            Row4AggregationComparator comparator = new Row4AggregationComparator(levelSortType);
            DiskSortedStack diskSortedStack = new DiskSortedStack(100, false, comparator, Row4Aggregation.getCreator());
            if (this.memoryCacheSize == 0L) {
                diskSortedStack.setBufferSize(10000);
                diskSortedStack.setUseMemoryOnly(true);
            }
            DiskSortedStackWrapper diskSortedStackReader = new DiskSortedStackWrapper(diskSortedStack, this.levelIndex[aggregationIndex]);
            this.allSortedFactRows.add(diskSortedStackReader);
            int i2 = 0;
            while (true) {
                if (i2 >= this.aggregationCalculators.length) continue block0;
                if (this.sortedFactRows[i2] == null && AggregationExecutor.cover(this.levelIndex[aggregationIndex], this.levelIndex[i2])) {
                    this.sortedFactRows[i2] = diskSortedStackReader;
                }
                ++i2;
            }
            break;
        }
        if (this.memoryCacheSize > 0L) {
            int rowSize = 16 + (4 + (levelSize + measureSize) - 1) / 8 * 8;
            int bufferSize = (int)(this.memoryCacheSize * 4L / 5L / (long)rowSize);
            int i = 0;
            while (i < this.allSortedFactRows.size()) {
                DiskSortedStackWrapper diskSortedStackReader = (DiskSortedStackWrapper)this.allSortedFactRows.get(i);
                diskSortedStackReader.getDiskSortedStack().setBufferSize(bufferSize);
                ++i;
            }
        }
    }

    private int getMeasureSize() throws IOException {
        MeasureInfo[] measureInfo = this.dataSet4Aggregation.getMetaInfo().getMeasureInfos();
        if (measureInfo == null || measureInfo.length == 0) {
            return 0;
        }
        int[] dataType = new int[measureInfo.length];
        int i = 0;
        while (i < measureInfo.length) {
            dataType[i] = measureInfo[i].getDataType();
            ++i;
        }
        return SizeOfUtil.getObjectSize(dataType);
    }

    private int getLevelSize(DimLevel[] dimLevel) throws DataException {
        if (dimLevel == null || dimLevel.length == 0) {
            return 0;
        }
        int[] dataType = new int[dimLevel.length];
        int i = 0;
        while (i < dimLevel.length) {
            DimColumn dimColumn = new DimColumn(dimLevel[i].getDimensionName(), dimLevel[i].getLevelName(), dimLevel[i].getLevelName());
            ColumnInfo columnInfo = this.dataSet4Aggregation.getMetaInfo().getColumnInfo(dimColumn);
            dataType[i] = columnInfo.getDataType();
            ++i;
        }
        return SizeOfUtil.getObjectSize(dataType);
    }

    private static boolean cover(int[] dimensionIndex1, int[] dimensionIndex2) {
        if (dimensionIndex2 == null || dimensionIndex2.length == 0) {
            return true;
        }
        if (dimensionIndex1.length < dimensionIndex2.length) {
            return false;
        }
        int i = 0;
        while (i < dimensionIndex2.length) {
            if (dimensionIndex1[i] != dimensionIndex2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void getAggregationLevelIndex() throws DataException {
        if (this.aggregationCalculators == null) {
            return;
        }
        this.levelIndex = new int[this.aggregationCalculators.length][];
        int i = 0;
        while (i < this.aggregationCalculators.length) {
            DimLevel[] levels = this.aggregationCalculators[i].aggregation.getLevels();
            if (levels == null || levels.length == 0) {
                this.levelIndex[i] = new int[0];
            } else {
                int[] tmpLevelIndex = new int[levels.length * 2];
                int j = 0;
                while (j < tmpLevelIndex.length / 2) {
                    String dimensionName = levels[j].getDimensionName();
                    String levelName = levels[j].getLevelName();
                    int dimIndex = this.dataSet4Aggregation.getMetaInfo().getDimensionIndex(dimensionName);
                    if (dimIndex < 0) {
                        throw new DataException(String.valueOf(DataResourceHandle.getInstance().getMessage("data.olap.NonexistentDimension")) + dimensionName);
                    }
                    int levelIndex = this.dataSet4Aggregation.getMetaInfo().getLevelIndex(dimensionName, levelName);
                    if (levelIndex < 0) {
                        throw new DataException(String.valueOf(DataResourceHandle.getInstance().getMessage("data.olap.NonexistentLevel")) + "<" + dimensionName + " , " + levelName + ">");
                    }
                    tmpLevelIndex[j * 2] = dimIndex;
                    tmpLevelIndex[j * 2 + 1] = levelIndex;
                    ++j;
                }
                this.levelIndex[i] = tmpLevelIndex;
            }
            ++i;
        }
    }

    private void getParameterColIndex(AggregationDefinition[] aggregations) throws DataException {
        HashSet<DimColumn> paraCols = new HashSet<DimColumn>();
        int i = 0;
        while (i < aggregations.length) {
            AggregationFunctionDefinition[] functions = aggregations[i].getAggregationFunctions();
            if (functions != null) {
                int j = 0;
                while (j < functions.length) {
                    DimColumn paraCol = functions[j].getParaCol();
                    if (paraCol != null) {
                        paraCols.add(paraCol);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (paraCols.size() == 0) {
            return;
        }
        this.paraColumns = new DimColumn[paraCols.size()];
        paraCols.toArray(this.paraColumns);
        this.paraInfos = new ColumnInfo[this.paraColumns.length];
        this.findColumnIndex();
    }

    private void findColumnIndex() throws DataException {
        if (this.paraColumns == null) {
            return;
        }
        IDataSet4Aggregation.MetaInfo metaInfo = this.dataSet4Aggregation.getMetaInfo();
        int i = 0;
        while (i < this.paraColumns.length) {
            this.paraInfos[i] = metaInfo.getColumnInfo(this.paraColumns[i]);
            ++i;
        }
    }

    public void setMaxDataObjectRows(int rowSize) {
        this.maxDataObjectRows = rowSize;
    }

    public int getMaxDataObjectRows() {
        return this.maxDataObjectRows;
    }

    public void setMemoryCacheSize(long memoryCacheSize) {
        this.memoryCacheSize = memoryCacheSize;
    }

    public int getMemoryCacheSize(int memoryCacheSize) {
        return memoryCacheSize;
    }
}

