/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.editor.pages.xml;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.IColleague;
import org.eclipse.birt.report.designer.core.util.mediator.ReportMediator;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.command.WrapperCommandStack;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.ModelEventManager;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.outline.DesignerOutlinePage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.editors.IReportEditorPage;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.designer.ui.editors.MultiPageReportEditor;
import org.eclipse.birt.report.designer.ui.editors.pages.ReportFormPage;
import org.eclipse.birt.report.designer.ui.editors.schematic.action.TextSaveAction;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.ActivityStackEvent;
import org.eclipse.birt.report.model.api.activity.ActivityStackListener;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class ReportXMLSourceEditorFormPage
extends ReportFormPage
implements IColleague {
    private ModelEventManager manager;
    public static final String ID = "org.eclipse.birt.report.designer.ui.editors.xmlsource";
    private static final String switchAction_ID = "switch";
    private ActionRegistry registry;
    private static final String SWITCH_REPORT_OUTLINE = Messages.getString((String)"ContentOutlinePage.action.text.reportOutline");
    private static final String SWITCH_REPORT_XML_OUTLINE = Messages.getString((String)"ContentOutlinePage.action.text.reportXMLSourceOutline");
    private StructuredTextEditor reportXMLEditor;
    private Control control;
    private int staleType;
    private boolean isModified = false;
    private boolean isLeaving = false;
    private boolean registered = false;
    private ActivityStackListener commandStackListener;
    private OutlineSwitchAction outlineSwitchAction;
    private ErrorDetail errorDetail;

    public void init(IEditorSite site, final IEditorInput input) throws PartInitException {
        super.init(site, input);
        try {
            this.reportXMLEditor = new StructuredTextEditor(){

                protected void createActions() {
                    super.createActions();
                    this.setAction(ITextEditorActionConstants.SAVE, (IAction)new TextSaveAction((ITextEditor)this));
                }

                public void doSave(IProgressMonitor progressMonitor) {
                    super.doSave(progressMonitor);
                    ReportXMLSourceEditorFormPage.this.clearDirtyFlag();
                    try {
                        ReportXMLSourceEditorFormPage.this.getReportEditor().refreshMarkers(input);
                    }
                    catch (CoreException coreException) {}
                }
            };
            this.reportXMLEditor.init(site, input);
        }
        catch (Exception exception) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getErrorLIine(boolean checkReport) {
        this.errorDetail = null;
        IEditorInput input = this.getEditorInput();
        try {
            IPath path = this.getProvider().getInputPath(input);
            if (path.toOSString().endsWith(".rptlibrary")) {
                LibraryHandle library = null;
                try {
                    library = SessionHandleAdapter.getInstance().getSessionHandle().openLibrary(path.toOSString());
                    if (!checkReport) return -1;
                    int n = this.getErrorLineFromModuleHandle((ModuleHandle)library);
                    return n;
                }
                catch (DesignFileException e) {
                    int n = this.getExpetionErrorLine(e);
                    return n;
                }
                finally {
                    if (library != null) {
                        library.close();
                    }
                }
            }
            if (path.toOSString().endsWith(".rptdesign") || path.toOSString().endsWith(".rpttemplate")) {
                ReportDesignHandle report = null;
                try {
                    report = SessionHandleAdapter.getInstance().getSessionHandle().openDesign(path.toOSString(), (InputStream)new FileInputStream(path.toFile()));
                    if (!checkReport) return -1;
                    int n = this.getErrorLineFromModuleHandle((ModuleHandle)report);
                    return n;
                }
                catch (DesignFileException e) {
                    int n = this.getExpetionErrorLine(e);
                    return n;
                }
                finally {
                    if (report != null) {
                        report.close();
                    }
                }
            }
            ModuleHandle report = null;
            try {
                report = SessionHandleAdapter.getInstance().getSessionHandle().openModule(path.toOSString(), (InputStream)new FileInputStream(path.toFile()));
                if (!checkReport) return -1;
                int n = this.getErrorLineFromModuleHandle(report);
                return n;
            }
            catch (DesignFileException e) {
                int n = this.getExpetionErrorLine(e);
                return n;
            }
            finally {
                if (report != null) {
                    report.close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return 0;
        }
    }

    private int getExpetionErrorLine(DesignFileException e) {
        List errorList = e.getErrorList();
        for (Object element : errorList) {
            if (!(element instanceof ErrorDetail)) continue;
            this.errorDetail = (ErrorDetail)element;
            return ((ErrorDetail)element).getLineNo();
        }
        return 0;
    }

    private int getErrorLineFromModuleHandle(ModuleHandle handle) {
        handle.checkReport();
        List list = handle.getErrorList();
        if (list != null) {
            int i = 0;
            int m = list.size();
            while (i < m) {
                Object obj = list.get(i);
                if (obj instanceof ErrorDetail) {
                    ErrorDetail errorDetail;
                    this.errorDetail = errorDetail = (ErrorDetail)list.get(i);
                    return errorDetail.getLineNo();
                }
                ++i;
            }
        }
        return 0;
    }

    public boolean canLeaveThePage() {
        int errorLine;
        if (this.isDirty()) {
            MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"XMLSourcePage.Error.Dialog.title"), null, Messages.getString((String)"XMLSourcePage.Error.Dialog.Message.PromptMsg"), 2, new String[]{Messages.getString((String)"XMLSourcePage.Error.Dialog.Message.Yes"), Messages.getString((String)"XMLSourcePage.Error.Dialog.Message.No"), Messages.getString((String)"XMLSourcePage.Error.Dialog.Message.Cancel")}, 0);
            int ret = prefDialog.open();
            switch (ret) {
                case 0: {
                    this.isLeaving = true;
                    this.getReportEditor().doSave(null);
                    break;
                }
                case 1: {
                    if (this.getEditorInput() != null) {
                        this.setInput(this.getEditorInput());
                    }
                    this.clearDirtyFlag();
                    break;
                }
                case 2: {
                    return false;
                }
            }
        }
        if ((errorLine = this.getErrorLIine(false)) > -1) {
            if (this.errorDetail != null && this.errorDetail.getErrorCode().equals("Error.DesignParserException.UNSUPPORTED_VERSION")) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString((String)"XMLSourcePage.Error.Dialog.title"), (String)this.errorDetail.getMessage());
            } else {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString((String)"XMLSourcePage.Error.Dialog.title"), (String)Messages.getString((String)"XMLSourcePage.Error.Dialog.Message.InvalidFile"));
            }
            this.setFocus();
            this.setHighlightLine(errorLine);
            return false;
        }
        return true;
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        this.reportXMLEditor.setInput(input);
    }

    private void setHighlightLine(int line) {
        try {
            IRegion region = this.reportXMLEditor.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineInformation(--line);
            this.reportXMLEditor.setHighlightRange(region.getOffset(), region.getLength(), true);
        }
        catch (BadLocationException badLocationException) {}
    }

    public boolean selectReveal(Object marker) {
        int length;
        AbstractMarkerAnnotationModel markerModel;
        Position pos;
        int start = MarkerUtilities.getCharStart((IMarker)((IMarker)marker));
        int end = MarkerUtilities.getCharEnd((IMarker)((IMarker)marker));
        boolean selectLine = start < 0 || end < 0;
        IAnnotationModel model = this.reportXMLEditor.getDocumentProvider().getAnnotationModel((Object)this.reportXMLEditor.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel && (pos = (markerModel = (AbstractMarkerAnnotationModel)model).getMarkerPosition((IMarker)marker)) != null) {
            if (!pos.isDeleted()) {
                start = pos.getOffset();
                end = pos.getOffset() + pos.getLength();
            } else {
                return false;
            }
        }
        IDocument document = this.reportXMLEditor.getDocumentProvider().getDocument((Object)this.reportXMLEditor.getEditorInput());
        if (selectLine) {
            try {
                int line;
                if (start >= 0) {
                    line = document.getLineOfOffset(start);
                } else {
                    line = MarkerUtilities.getLineNumber((IMarker)((IMarker)marker));
                    if (line >= 1) {
                        --line;
                    }
                    start = document.getLineOffset(line);
                }
                end = start + document.getLineLength(line) - 1;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        if (end - 1 < (length = document.getLength()) && start < length) {
            this.reportXMLEditor.selectAndReveal(start, end - start);
        }
        return true;
    }

    public Control getPartControl() {
        return this.control;
    }

    public String getId() {
        return ID;
    }

    private ActivityStackListener getCommandStackListener() {
        if (this.commandStackListener == null) {
            this.commandStackListener = new ActivityStackListener(){

                public void stackChanged(ActivityStackEvent event) {
                    if (ReportXMLSourceEditorFormPage.this.isActive() && event.getAction() != 4) {
                        ReportXMLSourceEditorFormPage.this.reloadEditorInput();
                    }
                }
            };
        }
        return this.commandStackListener;
    }

    public void createPartControl(Composite parent) {
        this.reportXMLEditor.createPartControl(parent);
        Control[] children = parent.getChildren();
        this.control = children[children.length - 1];
        ModuleHandle model = this.getModel();
        SessionHandleAdapter.getInstance().getMediator(model).addColleague((IColleague)this);
        if (model != null && model.getCommandStack() != null) {
            this.getCommandStack(model).addCommandStackListener(this.getCommandStackListener());
            this.hookModelEventManager(model);
        }
        this.reportXMLEditor.getTextViewer().addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (!ReportXMLSourceEditorFormPage.this.isTextModified() && event.getOffset() != 0) {
                    ReportXMLSourceEditorFormPage.this.markDirty();
                }
            }
        });
        this.reportXMLEditor.getTextViewer().getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ReportXMLSourceEditorFormPage.this.markDirty();
            }
        });
    }

    private void registerOutlineSwitchAction() {
        if (this.registered) {
            return;
        }
        Page reportMultiBookPage = (Page)((MultiPageReportEditor)this.getEditor()).getOutlinePage();
        if (reportMultiBookPage.getSite() != null) {
            if (reportMultiBookPage.getSite().getActionBars().getMenuManager().find(this.getOutlineSwitchAction().getId()) == null) {
                reportMultiBookPage.getSite().getActionBars().getMenuManager().add((IAction)this.getOutlineSwitchAction());
            }
            this.registered = true;
        }
    }

    private void removeOutlineSwitchAction() {
        Page reportMultiBookPage = (Page)((MultiPageReportEditor)this.getEditor()).getOutlinePage();
        if (reportMultiBookPage.getSite() != null) {
            reportMultiBookPage.getSite().getActionBars().getMenuManager().remove(switchAction_ID);
            this.registered = false;
        }
    }

    public void setIsModified(boolean modified) {
        this.isModified = modified;
    }

    private boolean isTextModified() {
        return this.isModified;
    }

    protected void markDirty() {
        this.setIsModified(true);
        this.getEditor().editorDirtyStateChanged();
    }

    private WrapperCommandStack getCommandStack(ModuleHandle model) {
        if (model != null) {
            return new WrapperCommandStack(model.getCommandStack());
        }
        return null;
    }

    private void reloadEditorInput() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.getModel().serialize((OutputStream)out);
            String newInput = out.toString(this.getModel().getFileEncoding());
            this.reportXMLEditor.getDocumentProvider().getDocument((Object)this.getEditorInput()).set(newInput);
            this.markDirty();
        }
        catch (IOException e) {
            ExceptionUtil.handle((Throwable)e);
        }
    }

    public void performRequest(ReportRequest request) {
        if ("selection".equals(request.getType()) && !(request.getSource() instanceof ReportXMLSourceEditorFormPage) && this.isActive() && request.getSource() instanceof DesignerOutlinePage) {
            this.handleSelectionChange(request);
        }
    }

    private void handleSelectionChange(ReportRequest request) {
        List selectedObjects = request.getSelectionObject();
        ModuleHandle model = ((DesignerOutlinePage)request.getSource()).getRoot();
        if (!selectedObjects.isEmpty()) {
            this.setHighlightLine(model.getLineNo(selectedObjects.get(0)));
        }
    }

    public boolean onBroughtToTop(IReportEditorPage prePage) {
        ModuleHandle model;
        if (this.getEditorInput() != prePage.getEditorInput()) {
            this.setInput(prePage.getEditorInput());
        }
        if (this.getStaleType() == 4) {
            this.reloadEditorInput();
            this.doSave(null);
        } else if (prePage != this && (prePage.isDirty() || prePage.getStaleType() != 0)) {
            model = this.getModel();
            if (model != null && ModuleUtil.compareReportVersion((String)ModuleUtil.getReportVersion(), (String)model.getVersion()) > 0 && !MessageDialog.openConfirm((Shell)UIUtil.getDefaultShell(), (String)Messages.getString((String)"MultiPageReportEditor.ConfirmVersion.Dialog.Title"), (String)Messages.getString((String)"MultiPageReportEditor.ConfirmVersion.Dialog.Message"))) {
                return false;
            }
            prePage.doSave(null);
            UIUtil.doFinishSave((ModuleHandle)this.getModel());
            prePage.markPageStale(0);
            this.refreshDocument();
            this.markPageStale(0);
        }
        model = this.getModel();
        this.hookModelEventManager(model);
        SessionHandleAdapter.getInstance().getMediator(model).addColleague((IColleague)this);
        ReportMediator mediator = SessionHandleAdapter.getInstance().getMediator(model);
        ReportRequest request = new ReportRequest((Object)this);
        ArrayList<Object> list = new ArrayList<Object>(mediator.getCurrentState().getSelectionObject());
        if (list.isEmpty()) {
            list.add(new Object());
        }
        request.setSelectionObject(list);
        request.setType((Object)"selection");
        mediator.notifyRequest(request);
        this.reportXMLEditor.setFocus();
        return true;
    }

    public void markPageStale(int type) {
        this.staleType = type;
    }

    public int getStaleType() {
        return this.staleType;
    }

    public Object getAdapter(Class required) {
        if (required.equals(ActionRegistry.class)) {
            if (this.registry == null) {
                this.registry = new ActionRegistry();
            }
            return this.registry;
        }
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.getModel() != null) {
                DesignerOutlinePage outlinePage = new DesignerOutlinePage(this.getModel());
                this.getModelEventManager().addModelEventProcessor(outlinePage.getModelProcessor());
                this.registerOutlineSwitchAction();
                this.getOutlineSwitchAction().setText(SWITCH_REPORT_OUTLINE);
                return outlinePage;
            }
        } else if (ContentOutlinePage.class.equals((Object)required)) {
            this.getOutlineSwitchAction().setText(SWITCH_REPORT_XML_OUTLINE);
            return this.reportXMLEditor.getAdapter(IContentOutlinePage.class);
        }
        return super.getAdapter(required);
    }

    private ModelEventManager getModelEventManager() {
        if (this.manager == null) {
            this.manager = new ModelEventManager();
            return this.manager;
        }
        return this.manager;
    }

    protected void hookModelEventManager(ModuleHandle model) {
        this.getModelEventManager().hookRoot((Object)model);
        this.getModelEventManager().hookCommandStack(this.getCommandStack(model));
    }

    protected void unhookModelEventManager(ModuleHandle model) {
        this.getModelEventManager().unhookRoot((Object)model);
    }

    protected void finalize() throws Throwable {
        if (Policy.TRACING_PAGE_CLOSE) {
            System.out.println("Report source page finalized");
        }
        super.finalize();
    }

    public void refreshDocument() {
        this.setInput(this.getEditorInput());
    }

    public void doSave(IProgressMonitor progressMonitor) {
        this.reportXMLEditor.doSave(progressMonitor);
        UIUtil.doFinishSave((ModuleHandle)this.getModel());
    }

    private void clearDirtyFlag() {
        IReportProvider provider = this.getProvider();
        if (provider != null && this.getErrorLIine(false) == -1) {
            ModuleHandle oldModel = this.getModel();
            this.unhookModelEventManager(oldModel);
            this.getCommandStack(oldModel).removeCommandStackListener(this.getCommandStackListener());
            SessionHandleAdapter.getInstance().getMediator(oldModel).removeColleague((IColleague)this);
            ModuleHandle newModel = provider.getReportModuleHandle((Object)this.getEditorInput(), true);
            SessionHandleAdapter.getInstance().setReportDesignHandle(newModel);
            UIUtil.processSessionResourceFolder((IEditorInput)this.getEditorInput(), (IProject)UIUtil.getProjectFromInput((IEditorInput)this.getEditorInput()), (ModuleHandle)newModel);
            SessionHandleAdapter.getInstance().getMediator(newModel).addColleague((IColleague)this);
            this.hookModelEventManager(newModel);
            this.getCommandStack(newModel).addCommandStackListener(this.getCommandStackListener());
            this.setIsModified(false);
            this.getEditor().editorDirtyStateChanged();
            if (this.isActive() && !this.isLeaving) {
                this.getReportEditor().reloadOutlinePage();
            }
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return this.reportXMLEditor.isDirty();
    }

    public void dispose() {
        super.dispose();
        ((MultiPageEditorSite)this.getSite()).dispose();
        this.reportXMLEditor.dispose();
        this.reportXMLEditor = null;
        this.unhookModelEventManager(this.getModel());
        SessionHandleAdapter.getInstance().getMediator(this.getModel()).removeColleague((IColleague)this);
    }

    private OutlineSwitchAction getOutlineSwitchAction() {
        if (this.outlineSwitchAction == null) {
            this.outlineSwitchAction = new OutlineSwitchAction();
        }
        return this.outlineSwitchAction;
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (!active) {
            this.removeOutlineSwitchAction();
        }
    }

    protected class OutlineSwitchAction
    extends Action {
        public OutlineSwitchAction() {
            this.setText(SWITCH_REPORT_OUTLINE);
            this.setEnabled(true);
            this.setId(ReportXMLSourceEditorFormPage.switchAction_ID);
        }

        public void run() {
            ReportXMLSourceEditorFormPage.this.getReportEditor().outlineSwitch();
        }
    }
}

