/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.utilities;

import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;

public class ViewerWebApp {
    private ServiceRegistration<ContextHandler> serviceRegister;
    private Bundle bundle;
    private String webAppPath;
    private String contextPath;
    private String encoding;

    ViewerWebApp(Bundle bundle, String webAppPath, String contextPath, String encoding) {
        this.bundle = bundle;
        this.webAppPath = webAppPath;
        this.contextPath = contextPath;
        this.encoding = encoding;
    }

    public void start() throws IOException {
        WebAppContext webapp = new WebAppContext();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("Web-ContextPath", this.contextPath);
        ((Dictionary)props).put("Jetty-WarFolderPath", this.getWebAppPath(this.bundle, this.webAppPath));
        ((Dictionary)props).put("managedServerName", "org.eclipse.birt.report.viewer.server");
        if (this.encoding != null) {
            System.setProperty("org.eclipse.jetty.util.UrlEncoding.charset", this.encoding);
            System.setProperty("org.eclipse.jetty.util.URI.charset", this.encoding);
        }
        this.bundle.getBundleContext().registerService(ContextHandler.class, (Object)webapp, props);
    }

    public void stop() {
        if (this.serviceRegister != null) {
            this.serviceRegister.unregister();
            this.serviceRegister = null;
        }
    }

    private String getWebAppPath(Bundle bundle, String path) throws IOException {
        URL url = bundle.getEntry(path);
        if (url != null) {
            URL fileUrl = FileLocator.toFileURL((URL)url);
            return fileUrl.getFile();
        }
        return path;
    }
}

