/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.search.JavaSearchResult;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.search.MatchLocations;
import org.eclipse.jdt.internal.ui.search.NewSearchResultCollector;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchParticipantRecord;
import org.eclipse.jdt.internal.ui.search.SearchParticipantsExtensionPoint;
import org.eclipse.jdt.internal.ui.search.SearchResultUpdater;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.PatternQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;

public class JavaSearchQuery
implements ISearchQuery {
    private static final String PERF_SEARCH_PARTICIPANT = "org.eclipse.jdt.ui/perf/search/participants";
    private ISearchResult fResult;
    private final List<QuerySpecification> fPatternDataList;

    public JavaSearchQuery(QuerySpecification data) {
        if (data == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        this.fPatternDataList = new ArrayList<QuerySpecification>();
        this.fPatternDataList.add(data);
    }

    public JavaSearchQuery(List<QuerySpecification> dataList) {
        if (dataList == null || dataList.isEmpty()) {
            throw new IllegalArgumentException("data must not be null");
        }
        this.fPatternDataList = dataList;
    }

    public IStatus run(IProgressMonitor monitor) {
        JavaSearchResult textResult = (JavaSearchResult)this.getSearchResult();
        textResult.removeAll();
        SearchEngine engine = new SearchEngine();
        try {
            String stringPattern;
            SearchPattern pattern;
            int[] ticks;
            SearchParticipantRecord[] participantDescriptors;
            int totalTicks;
            block11: {
                block9: {
                    block10: {
                        totalTicks = 1000;
                        IProject[] projects = JavaSearchScopeFactory.getInstance().getProjects(this.getFirstSpecification().getScope());
                        participantDescriptors = SearchParticipantsExtensionPoint.getInstance().getSearchParticipants(projects);
                        ticks = new int[participantDescriptors.length];
                        int i = 0;
                        while (i < participantDescriptors.length) {
                            final int iPrime = i;
                            ISafeRunnable runnable = new ISafeRunnable(){

                                public void handleException(Throwable exception) {
                                    ticks[iPrime] = 0;
                                    String message = SearchMessages.JavaSearchQuery_error_participant_estimate;
                                    JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, message, exception));
                                }

                                public void run() throws Exception {
                                    for (QuerySpecification querySpecification : JavaSearchQuery.this.fPatternDataList) {
                                        int n = iPrime;
                                        ticks[n] = ticks[n] + participantDescriptors[iPrime].getParticipant().estimateTicks(querySpecification);
                                    }
                                }
                            };
                            SafeRunner.run((ISafeRunnable)runnable);
                            totalTicks += ticks[i];
                            ++i;
                        }
                        pattern = null;
                        stringPattern = null;
                        if (this.fPatternDataList.size() != 1) break block9;
                        if (!(this.getFirstSpecification() instanceof ElementQuerySpecification)) break block10;
                        IJavaElement element = ((ElementQuerySpecification)this.getFirstSpecification()).getElement();
                        stringPattern = JavaElementLabels.getElementLabel(element, JavaElementLabels.ALL_DEFAULT);
                        if (!element.exists()) {
                            return new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(SearchMessages.JavaSearchQuery_error_element_does_not_exist, stringPattern), null);
                        }
                        pattern = SearchPattern.createPattern((IJavaElement)element, (int)this.getFirstSpecification().getLimitTo(), (int)24);
                        break block11;
                    }
                    if (!(this.getFirstSpecification() instanceof PatternQuerySpecification)) break block11;
                    PatternQuerySpecification patternSpec = (PatternQuerySpecification)this.getFirstSpecification();
                    stringPattern = patternSpec.getPattern();
                    int matchMode = this.getMatchMode(stringPattern) | 0x10;
                    if (patternSpec.isCaseSensitive()) {
                        matchMode |= 8;
                    }
                    pattern = SearchPattern.createPattern((String)patternSpec.getPattern(), (int)patternSpec.getSearchFor(), (int)patternSpec.getLimitTo(), (int)matchMode);
                    break block11;
                }
                for (QuerySpecification querySpecification : this.fPatternDataList) {
                    if (!(querySpecification instanceof ElementQuerySpecification)) break;
                    IJavaElement element = ((ElementQuerySpecification)querySpecification).getElement();
                    stringPattern = JavaElementLabels.getElementLabel(element, JavaElementLabels.ALL_DEFAULT);
                    if (!element.exists()) {
                        return new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(SearchMessages.JavaSearchQuery_error_element_does_not_exist, stringPattern), null);
                    }
                    SearchPattern elementPattern = SearchPattern.createPattern((IJavaElement)element, (int)this.getFirstSpecification().getLimitTo(), (int)24);
                    SearchPattern searchPattern = pattern = pattern == null ? elementPattern : SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)elementPattern);
                }
            }
            if (pattern == null) {
                return new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(SearchMessages.JavaSearchQuery_error_unsupported_pattern, stringPattern), null);
            }
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.format(SearchMessages.JavaSearchQuery_task_label, stringPattern), (int)totalTicks);
            boolean ignorePotentials = NewSearchUI.arePotentialMatchesIgnored();
            NewSearchResultCollector collector = new NewSearchResultCollector(textResult, ignorePotentials);
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.getFirstSpecification().getScope(), (org.eclipse.jdt.core.search.SearchRequestor)collector, (IProgressMonitor)subMonitor.split(1000));
            int i = 0;
            while (i < participantDescriptors.length) {
                final SearchRequestor requestor = new SearchRequestor(participantDescriptors[i].getParticipant(), textResult);
                SubMonitor participantPM = subMonitor.split(ticks[i]);
                final int iPrime = i++;
                ISafeRunnable runnable = new ISafeRunnable((IProgressMonitor)participantPM){
                    private final /* synthetic */ IProgressMonitor val$participantPM;
                    {
                        this.val$participantPM = iProgressMonitor;
                    }

                    public void handleException(Throwable exception) {
                        participantDescriptors[iPrime].getDescriptor().disable();
                        String message = SearchMessages.JavaSearchQuery_error_participant_search;
                        JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, message, exception));
                    }

                    public void run() throws Exception {
                        IQueryParticipant participant = participantDescriptors[iPrime].getParticipant();
                        PerformanceStats stats = PerformanceStats.getStats((String)JavaSearchQuery.PERF_SEARCH_PARTICIPANT, (Object)participant);
                        stats.startRun();
                        for (QuerySpecification querySpecification : JavaSearchQuery.this.fPatternDataList) {
                            participant.search(requestor, querySpecification, this.val$participantPM);
                        }
                        stats.endRun();
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        String message = Messages.format(SearchMessages.JavaSearchQuery_status_ok_message, String.valueOf(textResult.getMatchCount()));
        return new Status(0, JavaPlugin.getPluginId(), 0, message, null);
    }

    private int getMatchMode(String pattern) {
        if (pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1) {
            return 2;
        }
        if (SearchUtils.isCamelCasePattern(pattern)) {
            return 128;
        }
        return 0;
    }

    public String getLabel() {
        return SearchMessages.JavaSearchQuery_label;
    }

    public String getResultLabel(int nMatches) {
        int limitTo = this.getMaskedLimitTo();
        if (nMatches == 1) {
            Object[] args = new String[]{this.getSearchPatternDescription(), this.getFirstSpecification().getScopeDescription()};
            switch (limitTo) {
                case 1: {
                    return Messages.format(SearchMessages.JavaSearchOperation_singularImplementorsPostfix, args);
                }
                case 0: {
                    return Messages.format(SearchMessages.JavaSearchOperation_singularDeclarationsPostfix, args);
                }
                case 2: {
                    return Messages.format(SearchMessages.JavaSearchOperation_singularReferencesPostfix, args);
                }
                case 3: {
                    return Messages.format(SearchMessages.JavaSearchOperation_singularOccurrencesPostfix, args);
                }
                case 4: {
                    return Messages.format(SearchMessages.JavaSearchOperation_singularReadReferencesPostfix, args);
                }
                case 5: {
                    return Messages.format(SearchMessages.JavaSearchOperation_singularWriteReferencesPostfix, args);
                }
            }
            String matchLocations = MatchLocations.getMatchLocationDescription(limitTo, 3);
            return Messages.format(SearchMessages.JavaSearchQuery_singularReferencesWithMatchLocations, new Object[]{args[0], args[1], matchLocations});
        }
        Object[] args = new Object[]{this.getSearchPatternDescription(), new Integer(nMatches), this.getFirstSpecification().getScopeDescription()};
        switch (limitTo) {
            case 1: {
                return Messages.format(SearchMessages.JavaSearchOperation_pluralImplementorsPostfix, args);
            }
            case 0: {
                return Messages.format(SearchMessages.JavaSearchOperation_pluralDeclarationsPostfix, args);
            }
            case 2: {
                return Messages.format(SearchMessages.JavaSearchOperation_pluralReferencesPostfix, args);
            }
            case 3: {
                return Messages.format(SearchMessages.JavaSearchOperation_pluralOccurrencesPostfix, args);
            }
            case 4: {
                return Messages.format(SearchMessages.JavaSearchOperation_pluralReadReferencesPostfix, args);
            }
            case 5: {
                return Messages.format(SearchMessages.JavaSearchOperation_pluralWriteReferencesPostfix, args);
            }
        }
        String matchLocations = MatchLocations.getMatchLocationDescription(limitTo, 3);
        return Messages.format(SearchMessages.JavaSearchQuery_pluralReferencesWithMatchLocations, new Object[]{args[0], args[1], args[2], matchLocations});
    }

    private String getSearchPatternDescription() {
        QuerySpecification firstSpecification = this.getFirstSpecification();
        if (firstSpecification instanceof ElementQuerySpecification) {
            IJavaElement element = ((ElementQuerySpecification)firstSpecification).getElement();
            return JavaElementLabels.getElementLabel(element, JavaElementLabels.ALL_DEFAULT | JavaElementLabels.ALL_FULLY_QUALIFIED | 0x1000000000000L | 0x2000000000L);
        }
        if (firstSpecification instanceof PatternQuerySpecification) {
            return BasicElementLabels.getFilePattern((String)((PatternQuerySpecification)firstSpecification).getPattern());
        }
        return new String("");
    }

    private int getMaskedLimitTo() {
        return this.getFirstSpecification().getLimitTo() & 0xFFFFFFCF;
    }

    ImageDescriptor getImageDescriptor() {
        int limitTo = this.getMaskedLimitTo();
        if (limitTo == 1 || limitTo == 0) {
            return JavaPluginImages.DESC_OBJS_SEARCH_DECL;
        }
        return JavaPluginImages.DESC_OBJS_SEARCH_REF;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            JavaSearchResult result = new JavaSearchResult(this);
            new SearchResultUpdater(result);
            this.fResult = result;
        }
        return this.fResult;
    }

    private QuerySpecification getFirstSpecification() {
        return this.fPatternDataList.get(0);
    }

    List<QuerySpecification> getSpecification() {
        return this.fPatternDataList;
    }

    private static class SearchRequestor
    implements ISearchRequestor {
        private IQueryParticipant fParticipant;
        private JavaSearchResult fSearchResult;

        @Override
        public void reportMatch(Match match) {
            IMatchPresentation participant = this.fParticipant.getUIParticipant();
            if (participant == null || match.getElement() instanceof IJavaElement || match.getElement() instanceof IResource) {
                this.fSearchResult.addMatch(match);
            } else {
                this.fSearchResult.addMatch(match, participant);
            }
        }

        protected SearchRequestor(IQueryParticipant participant, JavaSearchResult result) {
            this.fParticipant = participant;
            this.fSearchResult = result;
        }
    }
}

