/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.serializers;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import me.prettyprint.cassandra.serializers.AbstractSerializer;
import me.prettyprint.hector.api.ddl.ComparatorType;

public final class AsciiSerializer
extends AbstractSerializer<String> {
    private static final String US_ASCII = "US-ASCII";
    private static final AsciiSerializer instance = new AsciiSerializer();
    private static final Charset charset = Charset.forName("US-ASCII");

    public static AsciiSerializer get() {
        return instance;
    }

    @Override
    public String fromByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        return charset.decode(byteBuffer).toString();
    }

    @Override
    public ByteBuffer toByteBuffer(String obj) {
        if (obj == null) {
            return null;
        }
        return ByteBuffer.wrap(obj.getBytes(charset));
    }

    @Override
    public ComparatorType getComparatorType() {
        return ComparatorType.ASCIITYPE;
    }
}

