/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.util;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.oda.pojo.util.Utils;

public class ClassParser {
    private ClassLoader cl;
    private static Logger logger = Logger.getLogger(ClassParser.class.getName());

    public ClassParser(ClassLoader cl) {
        this.cl = cl;
    }

    public static Field[] getPublicFields(Class c) {
        assert (c != null);
        Field[] fields = c.getFields();
        Arrays.sort(fields, new MemberComparator());
        return fields;
    }

    public static Method[] getPublicMethods(Class c, String nameRegex) {
        assert (c != null);
        Method[] methods = c.getMethods();
        ArrayList<Method> result = new ArrayList<Method>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (ClassParser.isMappable(m) && ClassParser.isNameMatch(m.getName(), nameRegex)) {
                result.add(m);
            }
            ++n2;
        }
        Collections.sort(result, new MemberComparator());
        return result.toArray(new Method[0]);
    }

    private static boolean isMappable(Method m) {
        assert (m != null);
        return !m.getReturnType().equals(Void.TYPE);
    }

    public static Member[] getPublicMembers(Class c, String methodNameRegex) {
        assert (c != null);
        Field[] fields = ClassParser.getPublicFields(c);
        Method[] methods = ClassParser.getPublicMethods(c, methodNameRegex);
        Member[] members = new Member[fields.length + methods.length];
        System.arraycopy(fields, 0, members, 0, fields.length);
        System.arraycopy(methods, 0, members, fields.length, methods.length);
        return members;
    }

    private static boolean isNameMatch(String name, String filter) {
        assert (name != null);
        if (filter == null || filter.trim().length() == 0) {
            return true;
        }
        try {
            String pattern = Utils.toRegexPattern(filter);
            return name.toUpperCase().matches(pattern.toUpperCase());
        }
        catch (Exception e) {
            return false;
        }
    }

    public Member[] getPublicMembers(Field f, String methodNameRegex) {
        assert (f != null);
        Class c = this.getEssentialClass(f.getGenericType());
        return ClassParser.getPublicMembers(c, methodNameRegex);
    }

    public Member[] getPublicMembers(Method m, String methodNameRegex) {
        assert (m != null);
        Class c = this.getEssentialClass(m.getGenericReturnType());
        return ClassParser.getPublicMembers(c, methodNameRegex);
    }

    private static boolean isContainer(Class c) {
        assert (c != null);
        return Collection.class.isAssignableFrom(c) || Iterable.class.isAssignableFrom(c);
    }

    public Class getEssentialClass(Type type) {
        assert (type != null);
        if (type instanceof Class) {
            Class c = (Class)type;
            if (ClassParser.isContainer(c)) {
                return Object.class;
            }
            if (c.isArray()) {
                return this.getEssentialClass(this.getEssentialClassFromArray(c));
            }
            return c;
        }
        if (type instanceof ParameterizedType) {
            Type[] actualTypes;
            ParameterizedType pt = (ParameterizedType)type;
            if (pt.getRawType() instanceof Class && ClassParser.isContainer((Class)pt.getRawType()) && (actualTypes = pt.getActualTypeArguments()).length == 1) {
                return this.getEssentialClass(actualTypes[0]);
            }
            if (pt.getRawType() instanceof Class) {
                return (Class)pt.getRawType();
            }
        } else if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            return this.getEssentialClass(gat.getGenericComponentType());
        }
        return Object.class;
    }

    public static String getTypeLabel(Type type) {
        assert (type != null);
        if (type instanceof Class) {
            Class c = (Class)type;
            if (c.isArray()) {
                return ClassParser.getTypeLabelFromArray(c);
            }
            return c.getName();
        }
        return type.toString();
    }

    public Class getEssentialClassFromArray(Class c) {
        int last;
        assert (c.isArray());
        String name = c.getName();
        String className = name.substring((last = name.lastIndexOf(91)) + 1);
        if (className.length() > 1) {
            try {
                className = className.substring(1, className.length() - 1);
                if (this.cl != null) {
                    return this.cl.loadClass(className);
                }
                return Class.forName(className);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Failed to get the essential class for array", e);
                return Object.class;
            }
        }
        if ("Z".equals(className)) {
            return Boolean.TYPE;
        }
        if ("B".equals(className)) {
            return Byte.TYPE;
        }
        if ("C".equals(className)) {
            return Character.TYPE;
        }
        if ("D".equals(className)) {
            return Double.TYPE;
        }
        if ("F".equals(className)) {
            return Float.TYPE;
        }
        if ("I".equals(className)) {
            return Integer.TYPE;
        }
        if ("J".equals(className)) {
            return Long.TYPE;
        }
        if ("S".equals(className)) {
            return Short.TYPE;
        }
        logger.log(Level.SEVERE, "Failed to get the essential class for array");
        return Object.class;
    }

    public static String getTypeLabelFromArray(Class c) {
        int last;
        assert (c.isArray());
        String name = c.getName();
        String className = name.substring((last = name.lastIndexOf(91)) + 1);
        if (className.length() > 1) {
            className = className.substring(1, className.length() - 1);
        } else if ("Z".equals(className)) {
            className = Boolean.TYPE.getName();
        } else if ("B".equals(className)) {
            className = Byte.TYPE.getName();
        } else if ("C".equals(className)) {
            className = Character.TYPE.getName();
        } else if ("D".equals(className)) {
            className = Double.TYPE.getName();
        } else if ("F".equals(className)) {
            className = Float.TYPE.getName();
        } else if ("I".equals(className)) {
            className = Integer.TYPE.getName();
        } else if ("J".equals(className)) {
            className = Long.TYPE.getName();
        } else if ("S".equals(className)) {
            className = Short.TYPE.getName();
        } else assert (false);
        StringBuffer label = new StringBuffer(className);
        int i = 0;
        while (i <= last) {
            label.append("[]");
            ++i;
        }
        return label.toString();
    }

    public static String getParametersLabel(Method m) {
        assert (m != null && ClassParser.isMappable(m));
        StringBuffer sb = new StringBuffer();
        Type[] typeArray = m.getGenericParameterTypes();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type t = typeArray[n2];
            sb.append(", ").append(ClassParser.getTypeLabel(t));
            ++n2;
        }
        String result = sb.toString();
        if (result.length() > 0) {
            result = result.substring(2);
        }
        return result;
    }

    private static class MemberComparator
    implements Comparator<Member>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private MemberComparator() {
        }

        @Override
        public int compare(Member o1, Member o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

