/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.document.RtfDocumentSettings;
import com.lowagie.text.rtf.parser.RtfImportMappings;
import com.lowagie.text.rtf.parser.RtfParser;
import com.lowagie.text.rtf.text.RtfNewPage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventListener;

public class RtfWriter2
extends DocWriter {
    private RtfDocument rtfDoc = null;

    protected RtfWriter2(Document document, OutputStream outputStream) {
        super(document, outputStream);
        document.addDocListener(this);
        this.rtfDoc = new RtfDocument();
    }

    public static RtfWriter2 getInstance(Document document, OutputStream outputStream) {
        return new RtfWriter2(document, outputStream);
    }

    public void setHeader(HeaderFooter headerFooter) {
        this.rtfDoc.getDocumentHeader().setHeader(headerFooter);
    }

    public void resetHeader() {
        this.rtfDoc.getDocumentHeader().setHeader(null);
    }

    public void setFooter(HeaderFooter headerFooter) {
        this.rtfDoc.getDocumentHeader().setFooter(headerFooter);
    }

    public void resetFooter() {
        this.rtfDoc.getDocumentHeader().setFooter(null);
    }

    public void setPageCount(int n) {
    }

    public void resetPageCount() {
    }

    public void clearTextWrap() {
    }

    public void open() {
        super.open();
        this.rtfDoc.open();
    }

    public void close() {
        if (this.open) {
            this.rtfDoc.writeDocument(this.os);
            super.close();
            this.rtfDoc = new RtfDocument();
        }
    }

    public boolean add(Element element) throws DocumentException {
        if (this.pause) {
            return false;
        }
        RtfBasicElement[] rtfBasicElementArray = this.rtfDoc.getMapper().mapElement(element);
        if (rtfBasicElementArray.length != 0) {
            for (int i = 0; i < rtfBasicElementArray.length; ++i) {
                if (rtfBasicElementArray[i] == null) continue;
                this.rtfDoc.add(rtfBasicElementArray[i]);
            }
            return true;
        }
        return false;
    }

    public boolean newPage() {
        this.rtfDoc.add(new RtfNewPage(this.rtfDoc));
        return true;
    }

    public boolean setMargins(float f, float f2, float f3, float f4) {
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginLeft((int)((double)f * 20.0));
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginRight((int)((double)f2 * 20.0));
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginTop((int)((double)f3 * 20.0));
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginBottom((int)((double)f4 * 20.0));
        return true;
    }

    public boolean setPageSize(Rectangle rectangle) {
        this.rtfDoc.getDocumentHeader().getPageSetting().setPageSize(rectangle);
        return true;
    }

    public void setAutogenerateTOCEntries(boolean bl) {
        this.rtfDoc.setAutogenerateTOCEntries(bl);
    }

    public RtfDocumentSettings getDocumentSettings() {
        return this.rtfDoc.getDocumentSettings();
    }

    public void importRtfDocument(FileInputStream fileInputStream) throws IOException, DocumentException {
        this.importRtfDocument(fileInputStream, null);
    }

    public void importRtfDocument(InputStream inputStream, EventListener[] eventListenerArray) throws IOException, DocumentException {
        if (!this.open) {
            throw new DocumentException("The document must be open to import RTF documents.");
        }
        RtfParser rtfParser = new RtfParser(this.document);
        if (eventListenerArray != null) {
            for (int i = 0; i < eventListenerArray.length; ++i) {
                rtfParser.addListener(eventListenerArray[i]);
            }
        }
        rtfParser.importRtfDocument(inputStream, this.rtfDoc);
    }

    public void importRtfFragment(InputStream inputStream, RtfImportMappings rtfImportMappings) throws IOException, DocumentException {
        this.importRtfFragment(inputStream, rtfImportMappings, null);
    }

    public void importRtfFragment(InputStream inputStream, RtfImportMappings rtfImportMappings, EventListener[] eventListenerArray) throws IOException, DocumentException {
        if (!this.open) {
            throw new DocumentException("The document must be open to import RTF fragments.");
        }
        RtfParser rtfParser = new RtfParser(this.document);
        if (eventListenerArray != null) {
            for (int i = 0; i < eventListenerArray.length; ++i) {
                rtfParser.addListener(eventListenerArray[i]);
            }
        }
        rtfParser.importRtfFragment(inputStream, this.rtfDoc, rtfImportMappings);
    }

    public void importRtfDocumentIntoElement(Element element, FileInputStream fileInputStream) throws IOException, DocumentException {
        this.importRtfDocumentIntoElement(element, fileInputStream, null);
    }

    public void importRtfDocumentIntoElement(Element element, FileInputStream fileInputStream, EventListener[] eventListenerArray) throws IOException, DocumentException {
        RtfParser rtfParser = new RtfParser(this.document);
        if (eventListenerArray != null) {
            for (int i = 0; i < eventListenerArray.length; ++i) {
                rtfParser.addListener(eventListenerArray[i]);
            }
        }
        rtfParser.importRtfDocumentIntoElement(element, fileInputStream, this.rtfDoc);
    }
}

