/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.jndi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.factory.HFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraClientJndiResourceFactory
implements ObjectFactory {
    private Logger log = LoggerFactory.getLogger(CassandraClientJndiResourceFactory.class);
    private CassandraHostConfigurator cassandraHostConfigurator;
    private Cluster cluster;
    private Keyspace keyspace;

    @Override
    public Object getObjectInstance(Object object, Name jndiName, Context context, Hashtable<?, ?> environment) throws Exception {
        Reference resourceRef = null;
        if (!(object instanceof Reference)) {
            throw new Exception("Object provided is not a javax.naming.Reference type");
        }
        resourceRef = (Reference)object;
        if (this.cluster == null) {
            this.configure(resourceRef);
        }
        return this.keyspace;
    }

    private void configure(Reference resourceRef) throws Exception {
        RefAddr hostsRefAddr = resourceRef.get("hosts");
        RefAddr clusterNameRef = resourceRef.get("clusterName");
        RefAddr keyspaceNameRef = resourceRef.get("keyspace");
        RefAddr maxActiveRefAddr = resourceRef.get("maxActive");
        RefAddr maxWaitTimeWhenExhausted = resourceRef.get("maxWaitTimeWhenExhausted");
        RefAddr autoDiscoverHosts = resourceRef.get("autoDiscoverHosts");
        RefAddr runAutoDiscoverAtStartup = resourceRef.get("runAutoDiscoveryAtStartup");
        RefAddr retryDownedHostDelayInSeconds = resourceRef.get("retryDownedHostDelayInSeconds");
        if (hostsRefAddr == null || hostsRefAddr.getContent() == null) {
            throw new Exception("A url and port on which Cassandra is installed and listening on must be provided as a ResourceParams in the context.xml");
        }
        this.cassandraHostConfigurator = new CassandraHostConfigurator((String)hostsRefAddr.getContent());
        if (autoDiscoverHosts != null) {
            this.cassandraHostConfigurator.setAutoDiscoverHosts(Boolean.parseBoolean((String)autoDiscoverHosts.getContent()));
            if (runAutoDiscoverAtStartup != null) {
                this.cassandraHostConfigurator.setRunAutoDiscoveryAtStartup(Boolean.parseBoolean((String)autoDiscoverHosts.getContent()));
            }
        }
        if (retryDownedHostDelayInSeconds != null) {
            int retryDelay = Integer.parseInt((String)retryDownedHostDelayInSeconds.getContent());
            if (retryDelay < 1) {
                this.cassandraHostConfigurator.setRetryDownedHosts(false);
            }
            this.cassandraHostConfigurator.setRetryDownedHostsDelayInSeconds(retryDelay);
        }
        if (maxActiveRefAddr != null) {
            this.cassandraHostConfigurator.setMaxActive(Integer.parseInt((String)maxActiveRefAddr.getContent()));
        }
        if (maxWaitTimeWhenExhausted != null) {
            this.cassandraHostConfigurator.setMaxWaitTimeWhenExhausted(Integer.parseInt((String)maxWaitTimeWhenExhausted.getContent()));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("JNDI resource created with CassandraHostConfiguration: {}", (Object)this.cassandraHostConfigurator.getAutoDiscoverHosts());
        }
        this.cluster = HFactory.getOrCreateCluster((String)clusterNameRef.getContent(), this.cassandraHostConfigurator);
        this.keyspace = HFactory.createKeyspace((String)keyspaceNameRef.getContent(), this.cluster);
    }
}

