/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.sampledb;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.IConnectionFactory;
import org.eclipse.birt.report.data.oda.sampledb.SampledbPlugin;

public class SampleDBJDBCConnectionFactory
implements IConnectionFactory {
    private static final Logger logger = Logger.getLogger(SampleDBJDBCConnectionFactory.class.getName());
    private Driver derbyDriver;

    public Connection getConnection(String driverClass, String url, Properties connectionProperties) throws SQLException {
        if (!driverClass.equals("org.eclipse.birt.report.data.oda.sampledb.Driver")) {
            logger.log(Level.SEVERE, "Unexpected driverClass: " + driverClass);
            throw new SQLException("Unexpected driverClass " + driverClass);
        }
        if (!url.equals("jdbc:classicmodels:sampledb")) {
            logger.log(Level.WARNING, "Unexpected url: " + url);
            throw new SQLException("Classic Models Inc. Sample Database Driver does not recognize url: " + driverClass);
        }
        String dbUrl = SampledbPlugin.getDBUrl();
        Properties props = connectionProperties != null ? (Properties)connectionProperties.clone() : new Properties();
        props.put("user", "ClassicModels");
        props.put("password", "");
        if (logger.isLoggable(Level.FINER)) {
            logger.fine("Getting Sample DB JDBC connection. DriverClass=org.apache.derby.jdbc.EmbeddedDriver, Url=" + dbUrl);
        }
        return this.getDerbyDriver().connect(dbUrl, props);
    }

    void shutdownDerby() {
        try {
            this.getDerbyDriver().connect("jdbc:derby:;shutdown=true", null);
        }
        catch (SQLException sQLException) {}
    }

    private synchronized Driver getDerbyDriver() throws SQLException {
        if (this.derbyDriver == null) {
            try {
                this.derbyDriver = (Driver)Class.forName("org.apache.derby.jdbc.EmbeddedDriver", true, this.getClass().getClassLoader()).newInstance();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to load Derby embedded driver: org.apache.derby.jdbc.EmbeddedDriver", e);
                throw new SQLException(e.getLocalizedMessage());
            }
        }
        return this.derbyDriver;
    }

    public static String getDbUser() {
        return "ClassicModels";
    }
}

