/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model.thrift;

import java.util.LinkedHashMap;
import java.util.Map;
import me.prettyprint.cassandra.model.AbstractSliceQuery;
import me.prettyprint.cassandra.model.HKeyRange;
import me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import me.prettyprint.cassandra.model.OrderedRowsImpl;
import me.prettyprint.cassandra.model.QueryResultImpl;
import me.prettyprint.cassandra.service.KeyspaceService;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.OrderedRows;
import me.prettyprint.hector.api.exceptions.HectorException;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.RangeSlicesQuery;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;

public final class ThriftRangeSlicesQuery<K, N, V>
extends AbstractSliceQuery<K, N, V, OrderedRows<K, N, V>>
implements RangeSlicesQuery<K, N, V> {
    private final HKeyRange<K> keyRange;

    public ThriftRangeSlicesQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        super(keyspace, keySerializer, nameSerializer, valueSerializer);
        this.keyRange = new HKeyRange<K>(keySerializer);
    }

    @Override
    public int getRowCount() {
        return this.keyRange.getRowCount();
    }

    @Override
    public RangeSlicesQuery<K, N, V> setKeys(K start, K end) {
        this.keyRange.setKeys(start, end);
        return this;
    }

    @Override
    public RangeSlicesQuery<K, N, V> setRowCount(int rowCount) {
        this.keyRange.setRowCount(rowCount);
        return this;
    }

    @Override
    public QueryResult<OrderedRows<K, N, V>> execute() {
        Assert.notNull(this.columnFamilyName, "columnFamilyName can't be null");
        return new QueryResultImpl<OrderedRows<K, N, V>>(this.keyspace.doExecute(new KeyspaceOperationCallback<OrderedRows<K, N, V>>(){

            @Override
            public OrderedRows<K, N, V> doInKeyspace(KeyspaceService ks) throws HectorException {
                ColumnParent columnParent = new ColumnParent(ThriftRangeSlicesQuery.this.columnFamilyName);
                Map thriftRet = ThriftRangeSlicesQuery.this.keySerializer.fromBytesMap(ks.getRangeSlices(columnParent, ThriftRangeSlicesQuery.this.getPredicate(), ThriftRangeSlicesQuery.this.keyRange.toThrift()));
                return new OrderedRowsImpl((LinkedHashMap)thriftRet, ThriftRangeSlicesQuery.this.columnNameSerializer, ThriftRangeSlicesQuery.this.valueSerializer);
            }
        }), this);
    }

    public String toString() {
        return "RangeSlicesQuery(" + this.keyRange + super.toStringInternal() + ")";
    }

    @Override
    public RangeSlicesQuery<K, N, V> setRange(N start, N finish, boolean reversed, int count) {
        return (RangeSlicesQuery)super.setRange(start, finish, reversed, count);
    }

    @Override
    public RangeSlicesQuery<K, N, V> setColumnFamily(String cf) {
        return (RangeSlicesQuery)super.setColumnFamily(cf);
    }

    @Override
    public RangeSlicesQuery<K, N, V> setColumnNames(N ... columnNames) {
        return (RangeSlicesQuery)super.setColumnNames(columnNames);
    }

    @Override
    public ThriftRangeSlicesQuery<K, N, V> setReturnKeysOnly() {
        super.setReturnKeysOnly();
        return this;
    }

    @Override
    public ThriftRangeSlicesQuery<K, N, V> addEqualsExpression(N columnName, V columnValue) {
        this.keyRange.addToExpressions(new IndexExpression(this.columnNameSerializer.toByteBuffer(columnName), IndexOperator.EQ, this.valueSerializer.toByteBuffer(columnValue)));
        return this;
    }

    @Override
    public ThriftRangeSlicesQuery<K, N, V> addLteExpression(N columnName, V columnValue) {
        this.keyRange.addToExpressions(new IndexExpression(this.columnNameSerializer.toByteBuffer(columnName), IndexOperator.LTE, this.valueSerializer.toByteBuffer(columnValue)));
        return this;
    }

    @Override
    public ThriftRangeSlicesQuery<K, N, V> addGteExpression(N columnName, V columnValue) {
        this.keyRange.addToExpressions(new IndexExpression(this.columnNameSerializer.toByteBuffer(columnName), IndexOperator.GTE, this.valueSerializer.toByteBuffer(columnValue)));
        return this;
    }

    @Override
    public ThriftRangeSlicesQuery<K, N, V> addLtExpression(N columnName, V columnValue) {
        this.keyRange.addToExpressions(new IndexExpression(this.columnNameSerializer.toByteBuffer(columnName), IndexOperator.LT, this.valueSerializer.toByteBuffer(columnValue)));
        return this;
    }

    @Override
    public ThriftRangeSlicesQuery<K, N, V> addGtExpression(N columnName, V columnValue) {
        this.keyRange.addToExpressions(new IndexExpression(this.columnNameSerializer.toByteBuffer(columnName), IndexOperator.GT, this.valueSerializer.toByteBuffer(columnValue)));
        return this;
    }
}

