/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.computations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.computation.Point;
import org.eclipse.birt.chart.computation.Rectangle;
import org.eclipse.birt.chart.computation.Vector;

public class Polygon {
    private List points = new ArrayList();

    public void add(double x, double y) {
        this.add(new Point(x, y));
    }

    public void add(Point p) {
        this.points.add(p);
    }

    public Point getPoint(int index) {
        return (Point)this.points.get(index);
    }

    public List getPoints() {
        return this.points;
    }

    public Rectangle getBounds() {
        double xmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymax = -1.7976931348623157E308;
        for (int i = 0; i < this.points.size(); ++i) {
            double x = this.getPoint(i).getX();
            double y = this.getPoint(i).getY();
            if (x < xmin) {
                xmin = x;
            }
            if (x > xmax) {
                xmax = x;
            }
            if (y < ymin) {
                ymin = y;
            }
            if (!(y > ymax)) continue;
            ymax = y;
        }
        return new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    private boolean testInside(int count, double[] xa, double[] ya, double x, double y) {
        boolean c = false;
        int i = 0;
        int j = count - 1;
        while (i < count) {
            if ((ya[i] <= y && y < ya[j] || ya[j] <= y && y < ya[i]) && x < (xa[j] - xa[i]) * (y - ya[i]) / (ya[j] - ya[i]) + xa[i]) {
                c = !c;
            }
            j = i++;
        }
        return c;
    }

    private boolean testLineIntersect(Point p1, Point p2, Point q1, Point q2) {
        Vector pv1 = new Vector(p1.x, p1.y, 0.0);
        Vector pv2 = new Vector(p2.x, p2.y, 0.0);
        Vector qv1 = new Vector(q1.x, q1.y, 0.0);
        Vector qv2 = new Vector(q2.x, q2.y, 0.0);
        pv1.sub(qv1);
        pv2.sub(qv1);
        qv2.sub(qv1);
        return pv1.crossProduct(qv2).scalarProduct(qv2.crossProduct(pv2)) >= 0.0;
    }

    public boolean intersects(Polygon poly) {
        Point pt;
        if (poly == null) {
            return false;
        }
        boolean started = false;
        boolean diff = false;
        boolean oldDiff = false;
        int count = this.points.size();
        double[] xa = new double[count];
        double[] ya = new double[count];
        for (int i = 0; i < count; ++i) {
            pt = this.getPoint(i);
            xa[i] = pt.getX();
            ya[i] = pt.getY();
        }
        Iterator itr = poly.getPoints().iterator();
        while (itr.hasNext()) {
            pt = (Point)itr.next();
            diff = this.testInside(count, xa, ya, pt.getX(), pt.getY());
            if (!started) {
                started = true;
                oldDiff = diff;
            }
            if (diff != oldDiff) {
                return true;
            }
            oldDiff = diff;
        }
        if (diff) {
            return true;
        }
        if (this.getPoints().size() > 0) {
            count = poly.getPoints().size();
            xa = new double[count];
            ya = new double[count];
            for (int i = 0; i < count; ++i) {
                pt = poly.getPoint(i);
                xa[i] = pt.getX();
                ya[i] = pt.getY();
            }
            itr = this.points.iterator();
            while (itr.hasNext()) {
                pt = (Point)itr.next();
                if (!this.testInside(count, xa, ya, pt.getX(), pt.getY())) continue;
                return true;
            }
        }
        if (this.points.size() == 2 || poly.points.size() == 2) {
            List line = this.points;
            List pg = poly.points;
            if (line.size() > 2) {
                line = poly.points;
                pg = this.points;
            }
            Point lp1 = (Point)line.get(0);
            Point lp2 = (Point)line.get(1);
            for (int i = 0; i < pg.size(); ++i) {
                if (!(i == pg.size() - 1 ? this.testLineIntersect(lp1, lp2, (Point)pg.get(i), (Point)pg.get(0)) : this.testLineIntersect(lp1, lp2, (Point)pg.get(i), (Point)pg.get(i + 1)))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(Point p) {
        int count = this.points.size();
        double[] xa = new double[count];
        double[] ya = new double[count];
        for (int i = 0; i < count; ++i) {
            Point pt = this.getPoint(i);
            xa[i] = pt.getX();
            ya[i] = pt.getY();
        }
        return this.testInside(count, xa, ya, p.getX(), p.getY());
    }
}

