/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.IStreamSorter;
import org.eclipse.birt.core.archive.RAFolderOutputStream;
import org.eclipse.birt.core.archive.RAOutputStream;

public class FolderArchiveWriter
implements IDocArchiveWriter {
    private String folderName;
    private IStreamSorter streamSorter = null;
    private LinkedList openStreams = new LinkedList();

    public FolderArchiveWriter(String folderName) throws IOException {
        if (folderName == null || folderName.length() == 0) {
            throw new IOException("The folder name is null or empty string.");
        }
        File fd = new File(folderName);
        this.folderName = folderName = fd.getCanonicalPath();
    }

    public void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAOutputStream createRandomAccessStream(String relativePath) throws IOException {
        String path = ArchiveUtil.generateFullPath(this.folderName, relativePath);
        File fd = new File(path);
        ArchiveUtil.createParentFolder(fd);
        RAFolderOutputStream out = new RAFolderOutputStream(this, fd);
        LinkedList linkedList = this.openStreams;
        synchronized (linkedList) {
            this.openStreams.add(out);
        }
        return out;
    }

    public boolean dropStream(String relativePath) {
        String path = ArchiveUtil.generateFullPath(this.folderName, relativePath);
        File fd = new File(path);
        if (fd.exists() && fd.isFile()) {
            return fd.delete();
        }
        return false;
    }

    public String getName() {
        return this.folderName;
    }

    public boolean exists(String relativePath) {
        String path = ArchiveUtil.generateFullPath(this.folderName, relativePath);
        File fd = new File(path);
        return fd.exists();
    }

    public void setStreamSorter(IStreamSorter streamSorter) {
        this.streamSorter = streamSorter;
    }

    public void finish() throws IOException {
        this.closeAllStream();
    }

    public void toFileArchive(String fileArchiveName) throws IOException {
        this.createFileFromFolder(fileArchiveName);
        File folderArchive = new File(this.folderName);
        ArchiveUtil.DeleteAllFiles(folderArchive);
    }

    private void createFileFromFolder(String fileArchiveName) throws IOException {
        File targetFile = new File(fileArchiveName);
        ArchiveUtil.DeleteAllFiles(targetFile);
        RandomAccessFile compoundFile = null;
        compoundFile = new RandomAccessFile(targetFile, "rw");
        compoundFile.writeLong(0L);
        compoundFile.writeLong(0L);
        ArrayList<File> fileList = new ArrayList<File>();
        this.getAllFiles(new File(this.folderName), fileList);
        if (this.streamSorter != null) {
            ArrayList<String> streamNameList = new ArrayList<String>();
            for (int i = 0; i < fileList.size(); ++i) {
                File file = (File)fileList.get(i);
                streamNameList.add(ArchiveUtil.generateRelativePath(this.folderName, file.getAbsolutePath()));
            }
            ArrayList sortedNameList = this.streamSorter.sortStream(streamNameList);
            if (sortedNameList != null) {
                fileList.clear();
                for (int i = 0; i < sortedNameList.size(); ++i) {
                    String fileName = ArchiveUtil.generateFullPath(this.folderName, (String)sortedNameList.get(i));
                    fileList.add(new File(fileName));
                }
            }
        }
        long streamRelativePosition = 0L;
        long entryNum = 0L;
        for (int i = 0; i < fileList.size(); ++i) {
            File file = (File)fileList.get(i);
            String relativePath = ArchiveUtil.generateRelativePath(this.folderName, file.getAbsolutePath());
            compoundFile.writeUTF(relativePath);
            compoundFile.writeLong(streamRelativePosition);
            compoundFile.writeLong(file.length());
            streamRelativePosition += file.length();
            ++entryNum;
        }
        long streamSectionPos = compoundFile.getFilePointer();
        for (int i = 0; i < fileList.size(); ++i) {
            File file = (File)fileList.get(i);
            this.copyFileIntoTheArchive(file, compoundFile);
        }
        compoundFile.seek(0L);
        compoundFile.writeLong(streamSectionPos);
        compoundFile.writeLong(entryNum);
        compoundFile.close();
    }

    private void getAllFiles(File dir, ArrayList fileList) {
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files == null) {
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isFile()) {
                    fileList.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.getAllFiles(file, fileList);
            }
        }
    }

    private long copyFileIntoTheArchive(File in, RandomAccessFile out) throws IOException {
        long totalBytesWritten = 0L;
        FileInputStream fis = new FileInputStream(in);
        byte[] buf = new byte[5120];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            out.write(buf, 0, i);
            totalBytesWritten += (long)i;
        }
        fis.close();
        return totalBytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        IOException ioex = null;
        LinkedList linkedList = this.openStreams;
        synchronized (linkedList) {
            Iterator iter = this.openStreams.iterator();
            while (iter.hasNext()) {
                RAFolderOutputStream stream = (RAFolderOutputStream)iter.next();
                if (stream == null) continue;
                try {
                    stream.flush();
                }
                catch (IOException ex) {
                    ioex = ex;
                }
            }
        }
        if (ioex != null) {
            throw ioex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStream(RAFolderOutputStream stream) {
        LinkedList linkedList = this.openStreams;
        synchronized (linkedList) {
            this.openStreams.remove(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllStream() {
        LinkedList linkedList = this.openStreams;
        synchronized (linkedList) {
            LinkedList streams = new LinkedList(this.openStreams);
            Iterator iter = streams.iterator();
            while (iter.hasNext()) {
                RAFolderOutputStream stream = (RAFolderOutputStream)iter.next();
                if (stream == null) continue;
                try {
                    stream.close();
                }
                catch (IOException ex) {}
            }
            this.openStreams.clear();
        }
    }
}

