/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.data.ColumnBinding;
import org.eclipse.birt.core.data.ExpressionParserUtility;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.data.ParseIndicator;
import org.eclipse.birt.core.exception.BirtException;

public final class ExpressionUtil {
    private static final String ROW_INDICATOR = "row";
    private static final String DATASET_ROW_INDICATOR = "dataSetRow";
    private static String PREFIX = "COLUMN_";
    private static int suffix = 0;

    public static String createRowExpression(String rowName) {
        return "row[\"" + (rowName == null ? "" : rowName.trim()) + "\"]";
    }

    public static String createDataSetRowExpression(String rowName) {
        return "dataSetRow[\"" + (rowName == null ? "" : rowName.trim()) + "\"]";
    }

    public static String createRowExpression(int index) {
        return "row[" + index + "]";
    }

    public static List extractColumnExpressions(String oldExpression) throws BirtException {
        if (oldExpression == null) {
            return new ArrayList();
        }
        List exprList = ExpressionParserUtility.compileColumnExpression(oldExpression);
        int i = 0;
        while (i < exprList.size()) {
            IColumnBinding info = (IColumnBinding)exprList.get(i);
            if (info.getOuterLevel() != 0) {
                exprList.remove(i);
                continue;
            }
            ++i;
        }
        return exprList;
    }

    public static List extractColumnInfo(String oldExpression) throws BirtException {
        if (oldExpression == null) {
            return new ArrayList();
        }
        return ExpressionParserUtility.compileColumnExpression(oldExpression);
    }

    public static boolean hasAggregation(String expression) {
        if (expression == null) {
            return false;
        }
        try {
            return ExpressionParserUtility.hasAggregation(expression);
        }
        catch (BirtException e) {
            return false;
        }
    }

    public static IColumnBinding getColumnBinding(String oldExpression) {
        return new ColumnBinding(PREFIX + ++suffix, ExpressionUtil.toNewExpression(oldExpression));
    }

    public static String toNewExpression(String oldExpression) {
        if (oldExpression == null) {
            return null;
        }
        char[] chars = oldExpression.toCharArray();
        if (chars.length < 5) {
            return oldExpression;
        }
        ParseIndicator status = new ParseIndicator(0, 0, false, false, true, true);
        for (int i = 0; i < chars.length; ++i) {
            if ((i = (status = ExpressionUtil.getParseIndicator(chars, i, status.omitNextQuote(), status.getCandidateKey1(), status.getCandidateKey2())).getNewIndex()) < status.getRetrieveSize() + 3 || !status.isCandidateKey() || chars[i - status.getRetrieveSize() - 3] != 'r' || chars[i - status.getRetrieveSize() - 2] != 'o' || chars[i - status.getRetrieveSize() - 1] != 'w' || i - status.getRetrieveSize() - 4 > 0 && !ExpressionUtil.isValidProceeding(chars[i - status.getRetrieveSize() - 4]) || chars[i] != ' ' && chars[i] != '.' && chars[i] != '[') continue;
            String firstPart = oldExpression.substring(0, i - status.getRetrieveSize() - 3);
            String secondPart = ExpressionUtil.toNewExpression(oldExpression.substring(i - status.getRetrieveSize()));
            String newExpression = firstPart + DATASET_ROW_INDICATOR + secondPart;
            return newExpression;
        }
        return oldExpression;
    }

    private static ParseIndicator getParseIndicator(char[] chars, int i, boolean omitNextQuote, boolean candidateKey1, boolean candidateKey2) {
        int retrieveSize = 0;
        if (chars[i] == '/') {
            if (i > 0 && chars[i - 1] == '/') {
                ++retrieveSize;
                while (i < chars.length - 2) {
                    ++retrieveSize;
                    if (chars[++i] != '\n') continue;
                }
                ++retrieveSize;
                ++i;
            }
        } else if (chars[i] == '*' && i > 0 && chars[i - 1] == '/') {
            ++i;
            retrieveSize += 2;
            while (i < chars.length - 2) {
                ++retrieveSize;
                if (chars[++i - 1] != '*' || chars[i] != '/') continue;
            }
            ++retrieveSize;
            ++i;
        }
        if (!omitNextQuote && chars[i] == '\"') {
            boolean bl = candidateKey1 = !candidateKey1;
            if (candidateKey1) {
                candidateKey2 = true;
            }
        }
        if (!omitNextQuote && chars[i] == '\'') {
            boolean bl = candidateKey2 = !candidateKey2;
            if (candidateKey2) {
                candidateKey1 = true;
            }
        }
        omitNextQuote = chars[i] == '\\';
        return new ParseIndicator(retrieveSize, i, candidateKey1, omitNextQuote, candidateKey1, candidateKey2);
    }

    private static boolean isValidProceeding(char operator) {
        return !(operator >= 'A' && operator <= 'Z' || operator >= 'a' && operator <= 'z') && operator != '_';
    }
}

