/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt;

import java.text.MessageFormat;
import java.util.Vector;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.IMessageLookup;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.style.IStyleProcessor;
import org.eclipse.birt.chart.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartBuilderMessageLookup;
import org.eclipse.birt.chart.ui.swt.PreviewPanel;
import org.eclipse.birt.chart.ui.swt.interfaces.IChangeListener;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIManager;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIServiceProvider;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ChartModelAdapter
extends EContentAdapter
implements PaintListener {
    private transient IDeviceRenderer deviceRenderer = null;
    private IUIManager uiManager = null;
    private Vector vListeners = new Vector();
    private transient Chart chart = null;
    private static boolean bIgnoreNotifications = false;
    private transient boolean bIsPainting = false;
    private transient PreviewPanel preview = null;
    private transient IStyleProcessor processor = null;
    private IUIServiceProvider serviceProvider;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui/swt");

    public void notifyChanged(Notification notification) {
        if (bIgnoreNotifications || notification.isTouch()) {
            return;
        }
        logger.log(1, new MessageFormat(Messages.getString("ChartModelAdapter.Info.NotificationRecieved")).format(new Object[]{notification.getNotifier().getClass().getName()}));
        logger.log(1, new MessageFormat(Messages.getString("ChartModelAdapter.Info.NewValue")).format(new Object[]{notification.getNewValue()}));
        this.renderModel(this.uiManager.getCurrentModelState());
        for (int iC = 0; iC < this.vListeners.size(); ++iC) {
            ((IChangeListener)this.vListeners.elementAt(iC)).chartModified(this.uiManager.getCurrentModelState(), this.uiManager);
        }
    }

    public void renderModel(Chart chart) {
        this.chart = chart;
        bIgnoreNotifications = true;
        chart.createSampleRuntimeSeries();
        if (this.preview != null && !this.preview.shell.isDisposed()) {
            this.preview.canvas.redraw();
        }
        bIgnoreNotifications = false;
    }

    public static void ignoreNotifications(boolean bIgnoreNotifications) {
        ChartModelAdapter.bIgnoreNotifications = bIgnoreNotifications;
    }

    public PaintListener getPaintListener() {
        return this;
    }

    void setUiManager(IUIManager sheetManager) {
        this.uiManager = sheetManager;
    }

    void addListener(IChangeListener listener) {
        if (!this.vListeners.contains(listener)) {
            this.vListeners.add(listener);
        }
    }

    void clearListeners() {
        if (this.vListeners != null) {
            this.vListeners.removeAllElements();
        }
    }

    public void paintControl(PaintEvent pev) {
        if (this.bIsPainting) {
            return;
        }
        Throwable paintError = null;
        if (this.chart == null) {
            return;
        }
        this.bIsPainting = true;
        bIgnoreNotifications = true;
        Composite cmp = (Composite)pev.getSource();
        Rectangle re = cmp.getClientArea();
        GC gc = pev.gc;
        Bounds bo = BoundsImpl.create((double)(re.x + 2), (double)(re.y + 2), (double)(re.width - 4), (double)(re.height - 4));
        try {
            this.deviceRenderer = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException pex) {
            paintError = pex;
        }
        this.deviceRenderer.setProperty("device.output.context", (Object)gc);
        bo.scale(72.0 / (double)this.deviceRenderer.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        try {
            RunTimeContext rtc = new RunTimeContext();
            rtc.setScriptingEnabled(false);
            rtc.setMessageLookup((IMessageLookup)new ChartBuilderMessageLookup(this.serviceProvider));
            GeneratedChartState state = gr.build(this.deviceRenderer.getDisplayServer(), this.chart, bo, null, rtc, this.processor);
            gr.render(this.deviceRenderer, state);
        }
        catch (Exception ex) {
            paintError = ex;
        }
        if (paintError != null) {
            this.showException(gc, paintError);
        }
        bIgnoreNotifications = false;
        this.bIsPainting = false;
    }

    private final void showException(GC g2d, Throwable ex) {
        String sWrappedException = ex.getClass().getName();
        Throwable th = ex;
        while (ex.getCause() != null) {
            ex = (Exception)ex.getCause();
        }
        String sException = ex.getClass().getName();
        if (sWrappedException.equals(sException)) {
            sWrappedException = null;
        }
        String sMessage = null;
        sMessage = th instanceof BirtException ? ((BirtException)th).getLocalizedMessage() : ex.getMessage();
        if (sMessage == null) {
            sMessage = "<null>";
        }
        StackTraceElement[] stea = ex.getStackTrace();
        Rectangle rCA = this.preview.getClientArea();
        Display dv = Display.getCurrent();
        Font fo = new Font((Device)dv, "Courier", 1, 16);
        g2d.setFont(fo);
        FontMetrics fm = g2d.getFontMetrics();
        g2d.setBackground(dv.getSystemColor(1));
        g2d.fillRectangle(20, 20, rCA.width - 40, rCA.height - 40);
        g2d.setForeground(dv.getSystemColor(2));
        g2d.drawRectangle(20, 20, rCA.width - 40, rCA.height - 40);
        g2d.setClipping(20, 20, rCA.width - 40, rCA.height - 40);
        int x = 25;
        int y = 20 + fm.getHeight();
        ChartModelAdapter.drawString(g2d, Messages.getString("ChartModelAdapter.Exception.Exception"), x, y);
        g2d.setForeground(dv.getSystemColor(3));
        ChartModelAdapter.drawString(g2d, sException, x += g2d.textExtent((String)Messages.getString((String)"ChartModelAdapter.Exception.Exception")).x + 5, y);
        x = 25;
        y += fm.getHeight();
        if (sWrappedException != null) {
            g2d.setForeground(dv.getSystemColor(2));
            ChartModelAdapter.drawString(g2d, Messages.getString("ChartModelAdapter.Exception.WrappedIn"), x, y);
            g2d.setForeground(dv.getSystemColor(3));
            ChartModelAdapter.drawString(g2d, sWrappedException, x += g2d.textExtent((String)Messages.getString((String)"ChartModelAdapter.Exception.WrappedIn")).x + 5, y);
            x = 25;
            y += fm.getHeight();
        }
        g2d.setForeground(dv.getSystemColor(2));
        ChartModelAdapter.drawString(g2d, Messages.getString("ChartModelAdapter.Exception.Message"), x, y += 10);
        g2d.setForeground(dv.getSystemColor(9));
        ChartModelAdapter.drawString(g2d, sMessage, x += g2d.textExtent((String)Messages.getString((String)"ChartModelAdapter.Exception.Message")).x + 5, y);
        x = 25;
        y += fm.getHeight();
        g2d.setForeground(dv.getSystemColor(2));
        ChartModelAdapter.drawString(g2d, Messages.getString("ChartModelAdapter.Exception.Trace"), x, y += 10);
        x = 40;
        y += fm.getHeight();
        g2d.setForeground(dv.getSystemColor(6));
        if (stea == null) {
            ChartModelAdapter.drawString(g2d, "<null stack trace>", x, y);
        } else {
            for (int i = 0; i < stea.length; ++i) {
                ChartModelAdapter.drawString(g2d, stea[i].getClassName() + ":" + stea[i].getMethodName() + "(...):" + stea[i].getLineNumber(), x, y);
                x = 40;
                y += fm.getHeight();
            }
        }
        fo.dispose();
    }

    private static final void drawString(GC gc, String s, int x, int y) {
        if (s == null) {
            s = "<null>";
        }
        gc.drawString(s, x, y);
    }

    public void setStyleProcessor(IStyleProcessor processor) {
        this.processor = processor;
    }

    public void setPreview(PreviewPanel previewPanel) {
        this.preview = previewPanel;
    }

    public void setUIServiceProvider(IUIServiceProvider serviceprovider) {
        this.serviceProvider = serviceprovider;
    }
}

