/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class NavTree
extends Tree {
    public static final String SEPARATOR = ".";

    public NavTree(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    private void init() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
    }

    public void addListener(SelectionListener se) {
        this.addSelectionListener(se);
    }

    protected void checkSubclass() {
    }

    public boolean addNode(String nodePath, String displayName) {
        StringTokenizer stk = new StringTokenizer(nodePath, SEPARATOR);
        TreeItem currentItem = null;
        while (stk.hasMoreTokens()) {
            String str = stk.nextToken();
            currentItem = this.findAndAdd(str, currentItem, displayName);
        }
        return true;
    }

    public boolean addNode(String nodePath) {
        return this.addNode(nodePath, null);
    }

    private TreeItem findAndAdd(String sValue, TreeItem tiRoot, String displayName) {
        TreeItem tiTmp = this.findDirectChildren(tiRoot, sValue);
        if (tiTmp != null) {
            return tiTmp;
        }
        if (tiRoot != null) {
            tiTmp = this.add(tiRoot, sValue, displayName);
            if (!tiRoot.getExpanded()) {
                tiRoot.setExpanded(true);
            }
        } else {
            tiTmp = this.add(null, sValue, displayName);
        }
        return tiTmp;
    }

    private TreeItem findDirectChildren(TreeItem tiSubTree, String nodePath) {
        TreeItem[] tiNodes = null;
        tiNodes = tiSubTree == null ? this.getItems() : tiSubTree.getItems();
        for (int iC = 0; iC < tiNodes.length; ++iC) {
            if (!tiNodes[iC].getData().equals(nodePath)) continue;
            return tiNodes[iC];
        }
        return null;
    }

    private TreeItem add(TreeItem tiParent, String sNode, String displayName) {
        TreeItem tiTmp = this.findDirectChildren(tiParent, sNode);
        if (tiTmp == null) {
            tiTmp = tiParent != null ? new TreeItem(tiParent, 0) : new TreeItem((Tree)this, 0);
            if (displayName == null || displayName.trim().length() == 0) {
                tiTmp.setText(sNode);
            } else {
                tiTmp.setText(displayName);
            }
            tiTmp.setData((Object)sNode);
        }
        return tiTmp;
    }

    public TreeItem findTreeItem(String nodePath) {
        if (nodePath == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(nodePath, SEPARATOR);
        TreeItem item = null;
        TreeItem[] children = this.getItems();
        while (tokens.hasMoreTokens()) {
            String nodeText = tokens.nextToken();
            if (children.length == 0) {
                return item;
            }
            boolean isFound = false;
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].getData().equals(nodeText)) continue;
                isFound = true;
                item = children[i];
                children = item.getItems();
                break;
            }
            if (isFound) continue;
            return null;
        }
        return item;
    }

    public String getNodePath(TreeItem item) {
        String nodePath = (String)item.getData();
        while (item.getParentItem() != null) {
            item = item.getParentItem();
            nodePath = item.getData() + SEPARATOR + nodePath;
        }
        return nodePath;
    }
}

