/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard;

import java.text.MessageFormat;
import java.util.Vector;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.interfaces.IChangeWithoutNotification;
import org.eclipse.birt.chart.ui.swt.interfaces.ITaskChangeListener;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;

public class ChartAdapter
extends EContentAdapter {
    private Vector vListeners = new Vector();
    private static boolean bIgnoreNotifications = false;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui/swt");
    private transient WizardBase wizardContainer;

    public ChartAdapter(WizardBase wizardContainer) {
        this.wizardContainer = wizardContainer;
    }

    public void notifyChanged(Notification notification) {
        if (bIgnoreNotifications || notification.isTouch()) {
            return;
        }
        logger.log(1, new MessageFormat(Messages.getString("ChartAdapter.Info.NotificationRecieved")).format(new Object[]{notification.getNotifier().getClass().getName()}));
        logger.log(1, new MessageFormat(Messages.getString("ChartAdapter.Info.NewValue")).format(new Object[]{notification.getNewValue()}));
        for (int iC = 0; iC < this.vListeners.size(); ++iC) {
            ITaskChangeListener changeLs = (ITaskChangeListener)this.vListeners.elementAt(iC);
            if (this.wizardContainer.getCurrentTask() != changeLs) continue;
            changeLs.changeTask(notification);
        }
    }

    public static void ignoreNotifications(boolean bIgnoreNotifications) {
        ChartAdapter.bIgnoreNotifications = bIgnoreNotifications;
    }

    public static boolean isNotificationIgnored() {
        return bIgnoreNotifications;
    }

    public static Object changeChartWithoutNotification(IChangeWithoutNotification runable) {
        boolean status = bIgnoreNotifications;
        bIgnoreNotifications = true;
        Object context = runable.run();
        bIgnoreNotifications = status;
        return context;
    }

    public void addListener(ITaskChangeListener listener) {
        if (!this.vListeners.contains(listener)) {
            this.vListeners.add(listener);
        }
    }

    public void clearListeners() {
        if (this.vListeners != null) {
            this.vListeners.removeAllElements();
        }
    }
}

