/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.util;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.DataRowExpressionEvaluatorAdapter;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.impl.AxisOriginImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.ComponentPackage;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.interfaces.IChangeWithoutNotification;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartType;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ChartUIUtil {
    public static final String FONT_AUTO = Messages.getString("ChartUIUtil.Font.Auto");

    public static void setBackgroundColor(Control control, boolean selected, Color color) {
        if (selected) {
            control.setBackground(color);
        } else {
            control.setBackground(null);
        }
    }

    public static Composite createCompositeWrapper(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        cmp.setLayout((Layout)gridLayout);
        return cmp;
    }

    public static Query getDataQuery(SeriesDefinition seriesDefn, int queryIndex) {
        if (seriesDefn.getDesignTimeSeries().getDataDefinition().size() <= queryIndex) {
            Query query = QueryImpl.create((String)"");
            query.eAdapters().addAll((Collection)seriesDefn.eAdapters());
            seriesDefn.getDesignTimeSeries().getDataDefinition().add((Object)query);
            return query;
        }
        return (Query)seriesDefn.getDesignTimeSeries().getDataDefinition().get(queryIndex);
    }

    public static String getExpressionString(String colName) {
        if (colName == null) {
            return "";
        }
        return "row[\"" + ChartUIUtil.escape(colName) + "\"]";
    }

    public static String escape(String str) {
        String[][] chars = new String[][]{{"\\\\", "\"", "'"}, {"\\\\\\\\", "\\\\\"", "\\\\'"}};
        String result = str;
        for (int i = 0; i < chars[0].length; ++i) {
            result = result.replaceAll(chars[0][i], chars[1][i]);
        }
        return result;
    }

    public static EList getBaseSeriesDefinitions(Chart chart) {
        if (chart instanceof ChartWithAxes) {
            return ((Axis)((ChartWithAxes)chart).getAxes().get(0)).getSeriesDefinitions();
        }
        if (chart instanceof ChartWithoutAxes) {
            return ((ChartWithoutAxes)chart).getSeriesDefinitions();
        }
        return null;
    }

    public static int getOrthogonalAxisNumber(Chart chart) {
        if (chart instanceof ChartWithAxes) {
            EList axisList = ((Axis)((ChartWithAxes)chart).getAxes().get(0)).getAssociatedAxes();
            return axisList.size();
        }
        if (chart instanceof ChartWithoutAxes) {
            return 1;
        }
        return 0;
    }

    public static EList getOrthogonalSeriesDefinitions(Chart chart, int axisIndex) {
        if (chart instanceof ChartWithAxes) {
            EList axisList = ((Axis)((ChartWithAxes)chart).getAxes().get(0)).getAssociatedAxes();
            return ((Axis)axisList.get(axisIndex)).getSeriesDefinitions();
        }
        if (chart instanceof ChartWithoutAxes) {
            return ((SeriesDefinition)((ChartWithoutAxes)chart).getSeriesDefinitions().get(0)).getSeriesDefinitions();
        }
        return null;
    }

    public static List getAllOrthogonalSeriesDefinitions(Chart chart) {
        ArrayList seriesList = new ArrayList();
        if (chart instanceof ChartWithAxes) {
            EList axisList = ((Axis)((ChartWithAxes)chart).getAxes().get(0)).getAssociatedAxes();
            for (int i = 0; i < axisList.size(); ++i) {
                seriesList.addAll(((Axis)axisList.get(i)).getSeriesDefinitions());
            }
        } else if (chart instanceof ChartWithoutAxes) {
            seriesList.addAll(((SeriesDefinition)((ChartWithoutAxes)chart).getSeriesDefinitions().get(0)).getSeriesDefinitions());
        }
        return seriesList;
    }

    public static String getStockTitle(int index) {
        switch (index) {
            case 0: {
                return Messages.getString("ChartUIUtil.StockExp.High");
            }
            case 1: {
                return Messages.getString("ChartUIUtil.StockExp.Low");
            }
            case 2: {
                return Messages.getString("ChartUIUtil.StockExp.Open");
            }
            case 3: {
                return Messages.getString("ChartUIUtil.StockExp.Close");
            }
        }
        return "";
    }

    public static Axis getAxisXForProcessing(ChartWithAxes chartWithAxis) {
        return (Axis)chartWithAxis.getAxes().get(0);
    }

    public static Axis getAxisYForProcessing(ChartWithAxes chartWithAxis, int axisIndex) {
        return (Axis)ChartUIUtil.getAxisXForProcessing(chartWithAxis).getAssociatedAxes().get(axisIndex);
    }

    public static Axis getAxisZForProcessing(ChartWithAxes chartWithAxis) {
        return (Axis)ChartUIUtil.getAxisXForProcessing(chartWithAxis).getAncillaryAxes().get(0);
    }

    public static boolean is3DType(Chart chart) {
        return chart.getDimension().getValue() == 2;
    }

    public static int getFontRotation(FontDefinition font) {
        return font.isSetRotation() ? (int)font.getRotation() : 0;
    }

    public static String getFontName(FontDefinition font) {
        return font.getName() == null ? FONT_AUTO : font.getName();
    }

    public static TextAlignment getFontTextAlignment(FontDefinition font) {
        return font.getAlignment() == null ? TextAlignmentImpl.create() : font.getAlignment();
    }

    public static boolean checkDataBinding(Chart chart) {
        EList sdList = ChartUIUtil.getBaseSeriesDefinitions(chart);
        if (!ChartUIUtil.checkDataDefinition((List)sdList)) {
            return false;
        }
        for (int i = 0; i < ChartUIUtil.getOrthogonalAxisNumber(chart); ++i) {
            sdList = ChartUIUtil.getOrthogonalSeriesDefinitions(chart, i);
            if (ChartUIUtil.checkDataDefinition((List)sdList)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkDataDefinition(List sdList) {
        for (int i = 0; i < sdList.size(); ++i) {
            EList ddList = ((SeriesDefinition)sdList.get(i)).getDesignTimeSeries().getDataDefinition();
            if (ddList.size() == 0) {
                return false;
            }
            for (int j = 0; j < ddList.size(); ++j) {
                String query = ((Query)ddList.get(j)).getDefinition();
                if (query != null && query.length() != 0) continue;
                return false;
            }
        }
        return true;
    }

    public static void syncRuntimeSeries(Chart chart) {
        block13: {
            block12: {
                int i;
                if (!(chart instanceof ChartWithAxes)) break block12;
                ChartWithAxes cwa = (ChartWithAxes)chart;
                Axis[] axa = cwa.getOrthogonalAxes(cwa.getPrimaryBaseAxes()[0], true);
                int iOrthogonalSeriesDefinitionCount = 0;
                for (i = 0; i < axa.length; ++i) {
                    EList elSD = axa[i].getSeriesDefinitions();
                    for (int j = 0; j < elSD.size(); ++j) {
                        String sExpression;
                        SeriesDefinition sd = (SeriesDefinition)elSD.get(j);
                        Query qy = sd.getQuery();
                        if (qy == null || (sExpression = qy.getDefinition()) == null || sExpression.length() == 0) continue;
                        ++iOrthogonalSeriesDefinitionCount;
                    }
                }
                for (i = 0; i < axa.length; ++i) {
                    Iterator itr = axa[i].getSeriesDefinitions().iterator();
                    while (itr.hasNext()) {
                        SeriesDefinition sdOrthogonal = (SeriesDefinition)itr.next();
                        Series seDesignOrthogonal = sdOrthogonal.getDesignTimeSeries();
                        ArrayList seRuntimes = sdOrthogonal.getRunTimeSeries();
                        sdOrthogonal.getSeries().removeAll((Collection)seRuntimes);
                        for (int j = 0; j < seRuntimes.size(); ++j) {
                            Series seRuntimeOrthogonal = (Series)EcoreUtil.copy((EObject)seDesignOrthogonal);
                            seRuntimeOrthogonal.setDataSet(((Series)seRuntimes.get(j)).getDataSet());
                            if (iOrthogonalSeriesDefinitionCount < 1) {
                                seRuntimeOrthogonal.setSeriesIdentifier(seDesignOrthogonal.getSeriesIdentifier());
                            } else {
                                seRuntimeOrthogonal.setSeriesIdentifier(((Series)seRuntimes.get(j)).getSeriesIdentifier());
                            }
                            sdOrthogonal.getSeries().add((Object)seRuntimeOrthogonal);
                        }
                    }
                }
                break block13;
            }
            if (!(chart instanceof ChartWithoutAxes)) break block13;
            ChartWithoutAxes cwoa = (ChartWithoutAxes)chart;
            SeriesDefinition sdBase = (SeriesDefinition)cwoa.getSeriesDefinitions().get(0);
            int iOrthogonalSeriesDefinitionCount = 0;
            EList elSD = sdBase.getSeriesDefinitions();
            for (int j = 0; j < elSD.size(); ++j) {
                String sExpression;
                SeriesDefinition sd = (SeriesDefinition)elSD.get(j);
                Query qy = sd.getQuery();
                if (qy == null || (sExpression = qy.getDefinition()) == null || sExpression.length() == 0) continue;
                ++iOrthogonalSeriesDefinitionCount;
            }
            Iterator itr = elSD.iterator();
            while (itr.hasNext()) {
                SeriesDefinition sdOrthogonal = (SeriesDefinition)itr.next();
                Series seDesignOrthogonal = sdOrthogonal.getDesignTimeSeries();
                ArrayList seRuntimes = sdOrthogonal.getRunTimeSeries();
                sdOrthogonal.getSeries().removeAll((Collection)seRuntimes);
                for (int j = 0; j < seRuntimes.size(); ++j) {
                    Series seRuntimeOrthogonal = (Series)EcoreUtil.copy((EObject)seDesignOrthogonal);
                    seRuntimeOrthogonal.setDataSet(((Series)seRuntimes.get(j)).getDataSet());
                    if (iOrthogonalSeriesDefinitionCount < 1) {
                        seRuntimeOrthogonal.setSeriesIdentifier(seDesignOrthogonal.getSeriesIdentifier());
                    } else {
                        seRuntimeOrthogonal.setSeriesIdentifier(((Series)seRuntimes.get(j)).getSeriesIdentifier());
                    }
                    sdOrthogonal.getSeries().add((Object)seRuntimeOrthogonal);
                }
            }
        }
    }

    public static void doLivePreview(Chart chart, IDataServiceProvider dataProvider) throws ChartException {
        List expressions = Generator.instance().getRowExpressions(chart, null);
        Object[] columnData = dataProvider.getDataForColumns(expressions.toArray(new String[0]), -1, false);
        final HashMap map = new HashMap();
        for (int i = 0; i < expressions.size(); ++i) {
            map.put(expressions.get(i), columnData[i]);
        }
        DataRowExpressionEvaluatorAdapter evaluator = new DataRowExpressionEvaluatorAdapter(){
            private int i;
            private Object[] column;

            public Object evaluate(String expression) {
                this.column = (Object[])map.get(expression);
                if (this.i >= this.column.length) {
                    throw new RuntimeException(new ChartException("org.eclipse.birt.chart.ui", 1, Messages.getString("ChartUIUtil.Exception.NoValueReturned")));
                }
                return this.column[this.i];
            }

            public boolean first() {
                this.i = 0;
                if (map.size() > 0) {
                    this.column = (Object[])map.values().iterator().next();
                    if (this.column != null && this.i <= this.column.length - 1) {
                        return true;
                    }
                }
                return false;
            }

            public boolean next() {
                if (this.column != null && this.i < this.column.length - 1) {
                    ++this.i;
                    return true;
                }
                return false;
            }

            public void close() {
            }
        };
        RunTimeContext context = new RunTimeContext();
        context.setULocale(ULocale.getDefault());
        Generator.instance().bindData((IDataRowExpressionEvaluator)evaluator, chart, context);
    }

    public static String getConvertedSampleDataRepresentation(AxisType axisType, String sOldRepresentation) {
        return ChartUIUtil.getNewSampleData(axisType);
    }

    public static String getNewSampleData(AxisType axisType) {
        if (axisType.equals(AxisType.DATE_TIME_LITERAL)) {
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
            GregorianCalendar today = new GregorianCalendar();
            GregorianCalendar firstDay = new GregorianCalendar(today.get(1), 0, 1);
            GregorianCalendar lastDay = new GregorianCalendar(today.get(1), 11, 31);
            return sdf.format(firstDay.getTime()) + "," + sdf.format(today.getTime()) + "," + sdf.format(lastDay.getTime());
        }
        if (axisType.equals(AxisType.TEXT_LITERAL)) {
            return "'A','B','C'";
        }
        return "5,4,12";
    }

    public static void setAllGroupingQueryExceptFirst(Chart chart, String queryDefinition) {
        List sds = ChartUIUtil.getAllOrthogonalSeriesDefinitions(chart);
        for (int i = 0; i < sds.size(); ++i) {
            if (i == 0) continue;
            SeriesDefinition sd = (SeriesDefinition)sds.get(i);
            if (sd.getQuery() != null) {
                sd.getQuery().setDefinition(queryDefinition);
                continue;
            }
            Query query = QueryImpl.create((String)queryDefinition);
            query.eAdapters().addAll((Collection)sd.eAdapters());
            sd.setQuery(query);
        }
    }

    public static void addAxis(final ChartWithAxes chartModel) {
        Object overlayAxis = ChartAdapter.changeChartWithoutNotification(new IChangeWithoutNotification(){

            public Object run() {
                Axis yAxis = (Axis)((Axis)chartModel.getAxes().get(0)).getAssociatedAxes().get(0);
                Axis overlayAxis = (Axis)EcoreUtil.copy((EObject)yAxis);
                overlayAxis.setPrimaryAxis(false);
                overlayAxis.setOrigin(AxisOriginImpl.create((IntersectionType)IntersectionType.MAX_LITERAL, null));
                overlayAxis.setLabelPosition(Position.RIGHT_LITERAL);
                overlayAxis.setTitlePosition(Position.RIGHT_LITERAL);
                overlayAxis.getTitle().getCaption().setValue(Messages.getString("TaskSelectType.Caption.OverlayAxis1"));
                overlayAxis.eAdapters().addAll((Collection)yAxis.eAdapters());
                if (overlayAxis.getSeriesDefinitions().size() > 1) {
                    EList list = overlayAxis.getSeriesDefinitions();
                    for (int i = list.size() - 1; i > 0; --i) {
                        list.remove(i);
                    }
                }
                SeriesDefinition sdOverlay = (SeriesDefinition)overlayAxis.getSeriesDefinitions().get(0);
                EList dds = sdOverlay.getDesignTimeSeries().getDataDefinition();
                for (int i = 0; i < dds.size(); ++i) {
                    ((Query)dds.get(i)).setDefinition("");
                }
                SampleData sd = chartModel.getSampleData();
                int currentSize = sd.getOrthogonalSampleData().size();
                OrthogonalSampleData sdOrthogonal = (OrthogonalSampleData)EcoreUtil.copy((EObject)((EObject)chartModel.getSampleData().getOrthogonalSampleData().get(0)));
                sdOrthogonal.setDataSetRepresentation(ChartUIUtil.getNewSampleData(overlayAxis.getType()));
                sdOrthogonal.setSeriesDefinitionIndex(currentSize);
                sdOrthogonal.eAdapters().addAll((Collection)sd.eAdapters());
                sd.getOrthogonalSampleData().add((Object)sdOrthogonal);
                return overlayAxis;
            }
        });
        ((Axis)chartModel.getAxes().get(0)).getAssociatedAxes().add(overlayAxis);
    }

    public static void removeLastAxes(ChartWithAxes chartModel, int removedAxisNumber) {
        for (int i = 0; i < removedAxisNumber; ++i) {
            ChartUIUtil.removeLastAxis(chartModel);
        }
    }

    public static void removeLastAxis(ChartWithAxes chartModel) {
        ChartUIUtil.removeAxis((Chart)chartModel, ChartUIUtil.getOrthogonalAxisNumber((Chart)chartModel) - 1);
    }

    public static void removeAxis(final Chart chartModel, final int axisIndex) {
        if (chartModel instanceof ChartWithoutAxes) {
            return;
        }
        ChartAdapter.changeChartWithoutNotification(new IChangeWithoutNotification(){

            public Object run() {
                Axis oldPrimaryAxis = ChartUIUtil.getAxisYForProcessing((ChartWithAxes)chartModel, axisIndex);
                if (oldPrimaryAxis.isPrimaryAxis()) {
                    int yAxisSize = ChartUIUtil.getOrthogonalAxisNumber(chartModel);
                    Axis newPrimaryAxis = null;
                    newPrimaryAxis = axisIndex + 1 < yAxisSize ? ChartUIUtil.getAxisYForProcessing((ChartWithAxes)chartModel, axisIndex + 1) : ChartUIUtil.getAxisYForProcessing((ChartWithAxes)chartModel, 0);
                    newPrimaryAxis.setPrimaryAxis(true);
                    newPrimaryAxis.setOrigin(oldPrimaryAxis.getOrigin());
                    newPrimaryAxis.setLabelPosition(oldPrimaryAxis.getLabelPosition());
                    newPrimaryAxis.setTitlePosition(oldPrimaryAxis.getTitlePosition());
                }
                return null;
            }
        });
        ChartUIUtil.getAxisXForProcessing((ChartWithAxes)chartModel).getAssociatedAxes().remove(axisIndex);
    }

    public static int getLastSeriesIndexWithinAxis(Chart chartModel, int axisIndex) {
        if (chartModel instanceof ChartWithoutAxes || axisIndex < 0 || axisIndex >= ChartUIUtil.getOrthogonalAxisNumber(chartModel)) {
            return -1;
        }
        int seriesIndex = -1;
        for (int i = 0; i <= axisIndex; ++i) {
            seriesIndex += ChartUIUtil.getOrthogonalSeriesDefinitions(chartModel, i).size();
        }
        return seriesIndex;
    }

    public static void reorderOrthogonalSampleDataIndex(Chart chartModel) {
        EList list = chartModel.getSampleData().getOrthogonalSampleData();
        for (int i = 0; i < list.size(); ++i) {
            ((OrthogonalSampleData)list.get(i)).setSeriesDefinitionIndex(i);
        }
    }

    public static void copyGeneralSeriesAttributes(Series oldSeries, Series newSeries) {
        newSeries.setLabel(oldSeries.getLabel());
        newSeries.setSeriesIdentifier(oldSeries.getSeriesIdentifier());
        if (oldSeries.isSetVisible()) {
            newSeries.setVisible(oldSeries.isVisible());
        }
        if (oldSeries.isSetStacked() && newSeries.canBeStacked()) {
            newSeries.setStacked(oldSeries.isStacked());
        }
        if (oldSeries.isSetTranslucent()) {
            newSeries.setTranslucent(oldSeries.isTranslucent());
        }
        if (oldSeries.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_Triggers())) {
            newSeries.getTriggers().addAll((Collection)oldSeries.getTriggers());
        }
        if (oldSeries.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_DataPoint())) {
            newSeries.setDataPoint(oldSeries.getDataPoint());
        }
        if (oldSeries.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_CurveFitting())) {
            newSeries.setCurveFitting(oldSeries.getCurveFitting());
        }
        if (oldSeries.getLabelPosition().equals(Position.INSIDE_LITERAL) || oldSeries.getLabelPosition().equals(Position.OUTSIDE_LITERAL)) {
            if (newSeries instanceof LineSeries) {
                newSeries.setLabelPosition(Position.ABOVE_LITERAL);
            } else {
                newSeries.setLabelPosition(oldSeries.getLabelPosition());
            }
        } else if (newSeries instanceof LineSeries) {
            newSeries.setLabelPosition(oldSeries.getLabelPosition());
        } else {
            newSeries.setLabelPosition(Position.OUTSIDE_LITERAL);
        }
        if (oldSeries.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getSeries_DataDefinition())) {
            Object query = oldSeries.getDataDefinition().get(0);
            newSeries.getDataDefinition().clear();
            if (newSeries instanceof StockSeries) {
                if (oldSeries.getDataDefinition().size() != 4) {
                    newSeries.getDataDefinition().add((Object)EcoreUtil.copy((EObject)((Query)query)));
                    newSeries.getDataDefinition().add((Object)EcoreUtil.copy((EObject)((Query)query)));
                    newSeries.getDataDefinition().add((Object)EcoreUtil.copy((EObject)((Query)query)));
                    newSeries.getDataDefinition().add((Object)EcoreUtil.copy((EObject)((Query)query)));
                } else {
                    newSeries.getDataDefinition().addAll((Collection)oldSeries.getDataDefinition());
                }
            } else {
                newSeries.getDataDefinition().add(query);
            }
        }
    }

    public static ChartDimension getDimensionType(String sDimension) {
        if (sDimension == null || sDimension.equals(IChartType.TWO_DIMENSION_TYPE)) {
            return ChartDimension.TWO_DIMENSIONAL_LITERAL;
        }
        if (sDimension.equals(IChartType.THREE_DIMENSION_TYPE)) {
            return ChartDimension.THREE_DIMENSIONAL_LITERAL;
        }
        return ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL;
    }

    public static String getDimensionString(ChartDimension dimension) {
        if (dimension == null || dimension == ChartDimension.TWO_DIMENSIONAL_LITERAL) {
            return IChartType.TWO_DIMENSION_TYPE;
        }
        if (dimension == ChartDimension.THREE_DIMENSIONAL_LITERAL) {
            return IChartType.THREE_DIMENSION_TYPE;
        }
        return IChartType.TWO_DIMENSION_WITH_DEPTH_TYPE;
    }

    public static void bindHelp(Control control, String contextId) {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.getHelpSystem().setHelp((Control)control.getShell(), contextId);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static boolean is3DWallFloorSet(Chart chart) {
        if (!ChartUIUtil.is3DType(chart) || chart instanceof ChartWithoutAxes) {
            return true;
        }
        ChartWithAxes chartWithAxes = (ChartWithAxes)chart;
        ColorDefinition wall = (ColorDefinition)chartWithAxes.getWallFill();
        ColorDefinition floor = (ColorDefinition)chartWithAxes.getFloorFill();
        return wall != null && wall.getTransparency() > 0 || floor != null && floor.getTransparency() > 0;
    }
}

