/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.birt.chart.model.component.ComponentPackage;
import org.eclipse.birt.chart.model.component.Dial;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.IntegerSpinControl;
import org.eclipse.birt.chart.ui.swt.composites.TextEditorComposite;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DialScaleDialog
implements Listener {
    private transient Group grpScale = null;
    private transient Label lblMin = null;
    private transient TextEditorComposite txtScaleMin = null;
    private transient Label lblMax = null;
    private transient TextEditorComposite txtScaleMax = null;
    private transient Label lblStep = null;
    private transient TextEditorComposite txtScaleStep = null;
    private transient Label lblGridCount = null;
    private transient IntegerSpinControl iscGridCount = null;
    private transient DialSeries series;
    private transient Shell shell;

    public DialScaleDialog(Shell parent, DialSeries series) {
        this.series = series;
        this.shell = new Shell(parent, 67696);
        this.shell.setSize(400, 150);
        this.shell.setLayout((Layout)new FillLayout());
        UIHelper.centerOnScreen((Shell)this.shell);
        this.placeComponents();
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                Control focusControl = Display.getDefault().getFocusControl();
                if (focusControl instanceof Text) {
                    focusControl.notifyListeners(16, null);
                }
            }
        });
        this.shell.setText(Messages.getString("DialScaleDialog.Title.DialScale"));
        this.shell.layout();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    protected Composite placeComponents() {
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        glContent.verticalSpacing = 5;
        Composite cmpContent = new Composite((Composite)this.shell, 0);
        cmpContent.setLayout((Layout)glContent);
        GridLayout glScale = new GridLayout();
        glScale.numColumns = 4;
        glScale.horizontalSpacing = 5;
        glScale.verticalSpacing = 5;
        glScale.marginHeight = 2;
        glScale.marginWidth = 7;
        this.grpScale = new Group(cmpContent, 0);
        GridData gdGRPScale = new GridData(768);
        gdGRPScale.horizontalSpan = 2;
        this.grpScale.setLayoutData((Object)gdGRPScale);
        this.grpScale.setLayout((Layout)glScale);
        this.grpScale.setText(Messages.getString("OrthogonalSeriesDataSheetImpl.Lbl.Scale"));
        this.lblMin = new Label((Composite)this.grpScale, 0);
        GridData gdLBLMin = new GridData();
        this.lblMin.setLayoutData((Object)gdLBLMin);
        this.lblMin.setText(Messages.getString("OrthogonalSeriesDataSheetImpl.Lbl.Minimum"));
        this.txtScaleMin = new TextEditorComposite((Composite)this.grpScale, 2052);
        GridData gdTXTScaleMin = new GridData(768);
        this.txtScaleMin.setLayoutData(gdTXTScaleMin);
        this.txtScaleMin.setText(this.getValue(this.getDialForProcessing().getScale().getMin()));
        this.txtScaleMin.addListener(this);
        this.lblMax = new Label((Composite)this.grpScale, 0);
        GridData gdLBLMax = new GridData();
        this.lblMax.setLayoutData((Object)gdLBLMax);
        this.lblMax.setText(Messages.getString("OrthogonalSeriesDataSheetImpl.Lbl.Maximum"));
        this.txtScaleMax = new TextEditorComposite((Composite)this.grpScale, 2052);
        GridData gdTXTScaleMax = new GridData(768);
        this.txtScaleMax.setLayoutData(gdTXTScaleMax);
        this.txtScaleMax.setText(this.getValue(this.getDialForProcessing().getScale().getMax()));
        this.txtScaleMax.addListener(this);
        this.lblStep = new Label((Composite)this.grpScale, 0);
        GridData gdLBLStep = new GridData();
        this.lblStep.setLayoutData((Object)gdLBLStep);
        this.lblStep.setText(Messages.getString("OrthogonalSeriesDataSheetImpl.Lbl.Step"));
        this.lblStep.setEnabled(true);
        this.txtScaleStep = new TextEditorComposite((Composite)this.grpScale, 2052);
        GridData gdTXTScaleStep = new GridData(768);
        this.txtScaleStep.setLayoutData(gdTXTScaleStep);
        String str = "";
        if (this.getDialForProcessing().getScale().eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getScale_Step())) {
            str = String.valueOf(this.getDialForProcessing().getScale().getStep());
        }
        this.txtScaleStep.setText(str);
        this.txtScaleStep.addListener(this);
        this.txtScaleStep.setEnabled(true);
        GridLayout glGridCount = new GridLayout();
        glGridCount.numColumns = 2;
        glGridCount.horizontalSpacing = 5;
        glGridCount.marginHeight = 0;
        glGridCount.marginWidth = 0;
        Composite cmpGridCount = new Composite((Composite)this.grpScale, 0);
        GridData gdCMPGridCount = new GridData(768);
        gdCMPGridCount.horizontalSpan = 4;
        cmpGridCount.setLayoutData((Object)gdCMPGridCount);
        cmpGridCount.setLayout((Layout)glGridCount);
        this.lblGridCount = new Label(cmpGridCount, 0);
        GridData gdLBLGridCount = new GridData();
        this.lblGridCount.setLayoutData((Object)gdLBLGridCount);
        this.lblGridCount.setText(Messages.getString("OrthogonalSeriesDataSheetImpl.Lbl.MinorGridCount"));
        this.iscGridCount = new IntegerSpinControl(cmpGridCount, 0, this.getDialForProcessing().getScale().getMinorGridsPerUnit());
        GridData gdISCGridCount = new GridData(768);
        this.iscGridCount.setLayoutData(gdISCGridCount);
        this.iscGridCount.addListener(this);
        return cmpContent;
    }

    public Dial getDialForProcessing() {
        return this.series.getDial();
    }

    public void handleEvent(Event event) {
        block17: {
            if (event.widget.equals((Object)this.txtScaleMin)) {
                if (this.txtScaleMin.getText().length() == 0) {
                    this.getDialForProcessing().getScale().eUnset((EStructuralFeature)ComponentPackage.eINSTANCE.getScale_Min());
                } else {
                    DataElement de = this.getTypedDataElement(this.txtScaleMin.getText());
                    if (de != null) {
                        this.getDialForProcessing().getScale().setMin(de);
                    }
                }
            } else if (event.widget.equals((Object)this.txtScaleMax)) {
                if (this.txtScaleMax.getText().length() == 0) {
                    this.getDialForProcessing().getScale().eUnset((EStructuralFeature)ComponentPackage.eINSTANCE.getScale_Max());
                } else {
                    DataElement de = this.getTypedDataElement(this.txtScaleMax.getText());
                    if (de != null) {
                        this.getDialForProcessing().getScale().setMax(de);
                    }
                }
            } else if (event.widget.equals((Object)this.txtScaleStep)) {
                try {
                    if (this.txtScaleStep.getText().length() == 0) {
                        this.getDialForProcessing().getScale().eUnset((EStructuralFeature)ComponentPackage.eINSTANCE.getScale_Step());
                        break block17;
                    }
                    double dbl = Double.valueOf(this.txtScaleStep.getText());
                    if (dbl == 0.0) {
                        this.getDialForProcessing().getScale().eUnset((EStructuralFeature)ComponentPackage.eINSTANCE.getScale_Step());
                        break block17;
                    }
                    this.getDialForProcessing().getScale().setStep(dbl);
                }
                catch (NumberFormatException e1) {
                    this.txtScaleStep.setText(String.valueOf(this.getDialForProcessing().getScale().getStep()));
                }
            } else if (event.widget.equals((Object)this.iscGridCount)) {
                this.getDialForProcessing().getScale().setMinorGridsPerUnit(((Integer)event.data).intValue());
            }
        }
    }

    private String getValue(DataElement de) {
        if (de instanceof DateTimeDataElement) {
            Date dt = ((DateTimeDataElement)de).getValueAsCalendar().getTime();
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
            return sdf.format(dt);
        }
        if (de instanceof NumberDataElement) {
            return NumberFormat.getInstance().format(((NumberDataElement)de).getValue());
        }
        return "";
    }

    private DataElement getTypedDataElement(String strDataElement) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        NumberFormat nf = NumberFormat.getInstance();
        try {
            Date dateElement = sdf.parse(strDataElement);
            Calendar cal = Calendar.getInstance();
            cal.setTime(dateElement);
            return DateTimeDataElementImpl.create((Calendar)cal);
        }
        catch (ParseException e) {
            try {
                Number numberElement = nf.parse(strDataElement);
                return NumberDataElementImpl.create((double)numberElement.doubleValue());
            }
            catch (ParseException e1) {
                return null;
            }
        }
    }

    public boolean disposed() {
        return this.shell.isDisposed();
    }
}

