/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Gradient;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.ColorSelectionCanvas;
import org.eclipse.birt.chart.ui.swt.composites.FillCanvas;
import org.eclipse.birt.chart.ui.swt.composites.GradientEditorDialog;
import org.eclipse.birt.chart.ui.swt.composites.ImageDialog;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;

public class FillChooserComposite
extends Composite
implements SelectionListener,
MouseListener,
DisposeListener,
KeyListener,
FocusListener {
    private transient Composite cmpContentInner = null;
    private transient Composite cmpContentOuter = null;
    private transient Composite cmpDropDown = null;
    private transient Composite cmpButtons = null;
    private transient FillCanvas cnvSelection = null;
    private transient Button btnDown = null;
    private transient Label lblTransparency = null;
    private transient Slider srTransparency = null;
    private transient Button btnCustom = null;
    private transient Button btnGradient = null;
    private transient Button btnImage = null;
    private transient Button btnReset = null;
    private transient Button btnAuto = null;
    private static Color[] colorArray = null;
    private transient boolean bGradientEnabled = true;
    private transient boolean bImageEnabled = true;
    private transient boolean bTransparentEnabled = true;
    private transient boolean bAutoEnabled = false;
    private transient Fill fCurrent = null;
    private transient boolean bTransparencyChanged = false;
    private transient int iTransparency = 0;
    private transient Vector vListeners = null;
    public static final int FILL_CHANGED_EVENT = 1;
    public static final int MOUSE_CLICKED_EVENT = 2;
    private transient boolean bEnabled = true;
    private transient int iSize = 18;
    private boolean bJustFocusLost = false;
    private transient ChartWizardContext wizardContext;
    boolean isPressingKey = false;

    public FillChooserComposite(Composite parent, int style, ChartWizardContext wizardContext, Fill fCurrent, boolean bEnableGradient, boolean bEnableImage, boolean bEnableAuto, boolean bEnableTransparent) {
        super(parent, style);
        this.fCurrent = fCurrent;
        this.bGradientEnabled = bEnableGradient;
        this.bImageEnabled = bEnableImage;
        this.bAutoEnabled = bEnableAuto;
        this.bTransparentEnabled = bEnableTransparent;
        this.wizardContext = wizardContext;
        this.init();
        this.placeComponents();
        this.initAccessible();
    }

    public FillChooserComposite(Composite parent, int style, ChartWizardContext wizardContext, Fill fCurrent, boolean bEnableGradient, boolean bEnableImage) {
        super(parent, style);
        this.fCurrent = fCurrent;
        this.bGradientEnabled = bEnableGradient;
        this.bImageEnabled = bEnableImage;
        this.wizardContext = wizardContext;
        this.init();
        this.placeComponents();
        this.initAccessible();
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
        Display display = Display.getDefault();
        colorArray = this.createColorMap(display);
        this.vListeners = new Vector();
    }

    private void placeComponents() {
        FillLayout flMain = new FillLayout();
        flMain.marginHeight = 0;
        flMain.marginWidth = 0;
        this.setLayout((Layout)flMain);
        this.cmpContentOuter = new Composite((Composite)this, 0);
        GridLayout glContentOuter = new GridLayout();
        glContentOuter.verticalSpacing = 0;
        glContentOuter.horizontalSpacing = 0;
        glContentOuter.marginHeight = 0;
        glContentOuter.marginWidth = 0;
        glContentOuter.numColumns = 1;
        this.cmpContentOuter.setLayout((Layout)glContentOuter);
        this.cmpContentInner = new Composite(this.cmpContentOuter, 2048);
        GridLayout glContentInner = new GridLayout();
        glContentInner.verticalSpacing = 0;
        glContentInner.horizontalSpacing = 0;
        glContentInner.marginHeight = 0;
        glContentInner.marginWidth = 0;
        glContentInner.numColumns = 2;
        this.cmpContentInner.setLayout((Layout)glContentInner);
        GridData gdContentInner = new GridData(768);
        this.cmpContentInner.setLayoutData((Object)gdContentInner);
        this.cnvSelection = new FillCanvas(this.cmpContentInner, 0, this.bAutoEnabled);
        GridData gdCNVSelection = new GridData(1808);
        gdCNVSelection.heightHint = this.iSize;
        this.cnvSelection.setLayoutData(gdCNVSelection);
        this.cnvSelection.setFill(this.fCurrent);
        this.cnvSelection.addMouseListener(this);
        this.btnDown = new Button(this.cmpContentInner, 1028);
        GridData gdBDown = new GridData(4);
        gdBDown.verticalAlignment = 1;
        gdBDown.widthHint = this.iSize - 2;
        gdBDown.heightHint = this.iSize;
        this.btnDown.setLayoutData((Object)gdBDown);
        this.btnDown.addSelectionListener((SelectionListener)this);
        this.addDisposeListener(this);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                FillChooserComposite.this.handleEventCanvas(event);
            }
        };
        int[] textEvents = new int[]{1, 31, 15, 16};
        for (int i = 0; i < textEvents.length; ++i) {
            this.cnvSelection.addListener(textEvents[i], listener);
        }
    }

    void handleEventCanvas(Event event) {
        switch (event.type) {
            case 15: {
                this.cnvSelection.redraw();
                break;
            }
            case 16: {
                this.cnvSelection.redraw();
                break;
            }
            case 1: {
                if (this.isDisposed()) break;
                if (event.keyCode == 0x1000002) {
                    event.doit = true;
                    this.isPressingKey = true;
                    this.toggleDropDown();
                    this.isPressingKey = false;
                    break;
                }
            }
            case 31: {
                switch (event.detail) {
                    case 4: 
                    case 8: 
                    case 16: 
                    case 32: 
                    case 64: {
                        event.doit = true;
                        this.cnvSelection.redraw();
                    }
                }
            }
        }
    }

    private Color[] createColorMap(Display display) {
        return new Color[]{new Color((Device)display, 0, 0, 0), new Color((Device)display, 154, 50, 0), new Color((Device)display, 51, 51, 0), new Color((Device)display, 0, 50, 0), new Color((Device)display, 0, 50, 100), new Color((Device)display, 0, 0, 128), new Color((Device)display, 51, 51, 153), new Color((Device)display, 51, 51, 51), new Color((Device)display, 128, 0, 0), new Color((Device)display, 254, 102, 0), new Color((Device)display, 124, 124, 0), new Color((Device)display, 0, 128, 0), new Color((Device)display, 0, 128, 128), new Color((Device)display, 0, 0, 254), new Color((Device)display, 102, 102, 153), new Color((Device)display, 128, 128, 128), new Color((Device)display, 254, 0, 0), new Color((Device)display, 254, 153, 0), new Color((Device)display, 154, 204, 0), new Color((Device)display, 51, 153, 102), new Color((Device)display, 51, 204, 204), new Color((Device)display, 51, 102, 254), new Color((Device)display, 128, 0, 128), new Color((Device)display, 145, 145, 145), new Color((Device)display, 254, 0, 254), new Color((Device)display, 254, 204, 0), new Color((Device)display, 254, 254, 0), new Color((Device)display, 0, 254, 0), new Color((Device)display, 0, 254, 254), new Color((Device)display, 0, 204, 254), new Color((Device)display, 154, 50, 102), new Color((Device)display, 192, 192, 192), new Color((Device)display, 253, 153, 204), new Color((Device)display, 254, 204, 153), new Color((Device)display, 254, 254, 153), new Color((Device)display, 204, 254, 204), new Color((Device)display, 204, 254, 254), new Color((Device)display, 153, 204, 254), new Color((Device)display, 204, 153, 254), new Color((Device)display, 254, 254, 254)};
    }

    private void createDropDownComponent(int iXLoc, int iYLoc) {
        if (!this.bEnabled) {
            return;
        }
        int iShellHeight = 170;
        int iShellWidth = 160;
        if (this.bGradientEnabled) {
            iShellHeight += 30;
        }
        if (this.bImageEnabled) {
            iShellHeight += 30;
        }
        if (this.bAutoEnabled) {
            iShellHeight += 30;
        }
        if (this.bTransparentEnabled) {
            iShellHeight += 30;
        }
        Shell shell = new Shell(this.getShell(), 524288);
        shell.setLayout((Layout)new FillLayout());
        shell.setSize(iShellWidth, iShellHeight);
        if ((this.getStyle() & 0x4000000) != 0) {
            iXLoc -= iShellWidth;
        }
        shell.setLocation(iXLoc, iYLoc);
        this.cmpDropDown = new Composite((Composite)shell, 524288);
        GridLayout glDropDown = new GridLayout();
        glDropDown.marginHeight = 2;
        glDropDown.marginWidth = 2;
        glDropDown.horizontalSpacing = 1;
        glDropDown.verticalSpacing = 4;
        glDropDown.numColumns = 8;
        this.cmpDropDown.setLayout((Layout)glDropDown);
        this.cmpDropDown.addFocusListener((FocusListener)this);
        if (colorArray == null) {
            colorArray = this.createColorMap(this.getDisplay());
        }
        ColorSelectionCanvas cnv = new ColorSelectionCanvas(this.cmpDropDown, 526336, colorArray);
        GridData gdCnv = new GridData(1808);
        gdCnv.horizontalSpan = 8;
        gdCnv.heightHint = 110;
        cnv.setLayoutData(gdCnv);
        cnv.addMouseListener(this);
        if (this.fCurrent instanceof ColorDefinition) {
            cnv.setColor(new Color((Device)this.getDisplay(), ((ColorDefinition)this.fCurrent).getRed(), ((ColorDefinition)this.fCurrent).getGreen(), ((ColorDefinition)this.fCurrent).getBlue()));
        }
        this.cmpButtons = new Composite(this.cmpDropDown, 524288);
        GridLayout glButtons = new GridLayout();
        glButtons.marginHeight = 3;
        glButtons.marginWidth = 4;
        glButtons.horizontalSpacing = 1;
        glButtons.verticalSpacing = 4;
        glButtons.numColumns = 2;
        this.cmpButtons.setLayout((Layout)glButtons);
        GridData gdButtons = new GridData(768);
        gdButtons.horizontalSpan = 8;
        this.cmpButtons.setLayoutData((Object)gdButtons);
        GridLayout glTransparency = new GridLayout();
        glTransparency.numColumns = 1;
        glTransparency.horizontalSpacing = 5;
        glTransparency.verticalSpacing = 3;
        glTransparency.marginHeight = 4;
        glTransparency.marginWidth = 0;
        Composite cmpTransparency = new Composite(this.cmpButtons, 524288);
        GridData gdTransparency = new GridData(1808);
        gdTransparency.horizontalSpan = 2;
        cmpTransparency.setLayoutData((Object)gdTransparency);
        cmpTransparency.setLayout((Layout)glTransparency);
        this.lblTransparency = new Label(cmpTransparency, 0);
        GridData gdLBLTransparency = new GridData(768);
        gdLBLTransparency.horizontalIndent = 2;
        this.lblTransparency.setLayoutData((Object)gdLBLTransparency);
        this.lblTransparency.setText(Messages.getString("FillChooserComposite.Lbl.Opacity"));
        this.srTransparency = new Slider(cmpTransparency, 524544);
        GridData gdTransparent = new GridData(770);
        gdTransparent.horizontalSpan = 2;
        this.srTransparency.setLayoutData((Object)gdTransparent);
        if (this.fCurrent == null) {
            this.srTransparency.setValues(0, 0, 256, 1, 1, 10);
            this.srTransparency.setEnabled(false);
        } else {
            int iValue = 0;
            if (this.fCurrent instanceof ColorDefinition) {
                iValue = ((ColorDefinition)this.fCurrent).getTransparency();
                this.srTransparency.setValues(iValue, 0, 256, 1, 1, 10);
            } else if (this.fCurrent instanceof Gradient) {
                iValue = ((Gradient)this.fCurrent).getTransparency();
                this.srTransparency.setValues(iValue, 0, 256, 1, 1, 10);
            } else {
                this.srTransparency.setEnabled(false);
            }
        }
        this.lblTransparency.setText(new MessageFormat(Messages.getString("FillChooserComposite.Lbl.Opacity")).format(new Object[]{new Integer(this.srTransparency.getSelection())}));
        this.srTransparency.setToolTipText(String.valueOf(this.srTransparency.getSelection()));
        this.srTransparency.addSelectionListener((SelectionListener)this);
        this.srTransparency.addFocusListener((FocusListener)this);
        if (this.bTransparentEnabled) {
            this.btnReset = new Button(this.cmpButtons, 0);
            GridData gdReset = new GridData(1808);
            gdReset.heightHint = 26;
            gdReset.horizontalSpan = 2;
            this.btnReset.setLayoutData((Object)gdReset);
            this.btnReset.setText(Messages.getString("FillChooserComposite.Lbl.Transparent"));
            this.btnReset.addSelectionListener((SelectionListener)this);
            this.btnReset.addFocusListener((FocusListener)this);
            this.btnReset.addKeyListener((KeyListener)this);
        }
        if (this.bAutoEnabled) {
            this.btnAuto = new Button(this.cmpButtons, 0);
            GridData gdGradient = new GridData(1808);
            gdGradient.heightHint = 26;
            gdGradient.horizontalSpan = 2;
            this.btnAuto.setLayoutData((Object)gdGradient);
            this.btnAuto.setText(Messages.getString("FillChooserComposite.Lbl.Auto"));
            this.btnAuto.addSelectionListener((SelectionListener)this);
            this.btnAuto.addFocusListener((FocusListener)this);
            this.btnAuto.addKeyListener((KeyListener)this);
        }
        if (this.bGradientEnabled) {
            this.btnGradient = new Button(this.cmpButtons, 0);
            GridData gdGradient = new GridData(1808);
            gdGradient.heightHint = 26;
            gdGradient.horizontalSpan = 2;
            this.btnGradient.setLayoutData((Object)gdGradient);
            this.btnGradient.setText(Messages.getString("FillChooserComposite.Lbl.Gradient"));
            this.btnGradient.addSelectionListener((SelectionListener)this);
            this.btnGradient.addFocusListener((FocusListener)this);
            this.btnGradient.addKeyListener((KeyListener)this);
        }
        this.btnCustom = new Button(this.cmpButtons, 0);
        GridData gdCustom = new GridData(1808);
        gdCustom.heightHint = 26;
        gdCustom.horizontalSpan = 2;
        this.btnCustom.setLayoutData((Object)gdCustom);
        this.btnCustom.setText(Messages.getString("FillChooserComposite.Lbl.CustomColor"));
        this.btnCustom.addSelectionListener((SelectionListener)this);
        this.btnCustom.addFocusListener((FocusListener)this);
        this.btnCustom.addKeyListener((KeyListener)this);
        if (this.bImageEnabled) {
            this.btnImage = new Button(this.cmpButtons, 0);
            GridData gdImage = new GridData(1808);
            gdImage.heightHint = 26;
            gdImage.horizontalSpan = 2;
            this.btnImage.setLayoutData((Object)gdImage);
            this.btnImage.setText(Messages.getString("FillChooserComposite.Lbl.Image"));
            this.btnImage.addSelectionListener((SelectionListener)this);
            this.btnImage.addFocusListener((FocusListener)this);
            this.btnImage.addKeyListener((KeyListener)this);
        }
        shell.layout();
        shell.open();
    }

    public void setFill(Fill fill) {
        this.fCurrent = fill;
        this.cnvSelection.setFill(fill);
        this.cnvSelection.redraw();
    }

    public Fill getFill() {
        return this.fCurrent;
    }

    public void setEnabled(boolean bState) {
        this.btnDown.setEnabled(bState);
        this.cnvSelection.setEnabled(bState);
        this.cnvSelection.redraw();
        this.bEnabled = bState;
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }

    public Point getPreferredSize() {
        return new Point(160, 24);
    }

    public void addListener(Listener listener) {
        this.vListeners.add(listener);
    }

    private void toggleDropDown() {
        if (this.bJustFocusLost) {
            this.bJustFocusLost = false;
            return;
        }
        if (this.cmpDropDown == null || this.cmpDropDown.isDisposed() || !this.cmpDropDown.isVisible()) {
            Point pLoc = UIHelper.getScreenLocation((Composite)this.cnvSelection);
            this.createDropDownComponent(pLoc.x, pLoc.y + this.cnvSelection.getSize().y + 1);
            this.cmpButtons.setFocus();
        } else {
            this.cmpDropDown.getShell().close();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object oSource = e.getSource();
        if (oSource.equals(this.btnDown)) {
            this.fireHandleEvent(2);
            this.toggleDropDown();
        } else if (oSource.equals(this.btnImage)) {
            Fill imgFill;
            ImageDialog idlg = new ImageDialog(this.getShell(), this.fCurrent);
            this.cmpDropDown.getShell().close();
            if (idlg.open() == 0 && (imgFill = idlg.getResult()) != null) {
                this.addAdapters((Notifier)imgFill);
                this.setFill(imgFill);
                this.fireHandleEvent(1);
            }
        } else if (oSource.equals(this.btnReset)) {
            this.setFill((Fill)ColorDefinitionImpl.TRANSPARENT());
            this.fireHandleEvent(1);
            this.cmpDropDown.getShell().close();
        } else if (oSource.equals(this.btnAuto)) {
            this.setFill(null);
            this.fireHandleEvent(1);
            this.cmpDropDown.getShell().close();
        } else if (oSource.equals(this.btnCustom)) {
            RGB rgb;
            ColorDialog cDlg = new ColorDialog(this.getShell(), 0);
            this.cmpDropDown.getShell().close();
            int iTrans = 255;
            if (this.fCurrent instanceof ColorDefinition) {
                if (!this.fCurrent.equals(ColorDefinitionImpl.TRANSPARENT())) {
                    this.iTransparency = ((ColorDefinition)this.fCurrent).getTransparency();
                }
                cDlg.setRGB(new RGB(((ColorDefinition)this.fCurrent).getRed(), ((ColorDefinition)this.fCurrent).getGreen(), ((ColorDefinition)this.fCurrent).getBlue()));
            }
            if ((rgb = cDlg.open()) != null) {
                ColorDefinition cdNew = AttributeFactory.eINSTANCE.createColorDefinition();
                cdNew.set(rgb.red, rgb.green, rgb.blue);
                cdNew.setTransparency(this.bTransparencyChanged ? this.iTransparency : iTrans);
                this.addAdapters((Notifier)cdNew);
                this.setFill((Fill)cdNew);
                this.fireHandleEvent(1);
            }
        } else if (oSource.equals(this.btnGradient)) {
            GradientEditorDialog ged = null;
            this.cmpDropDown.getShell().close();
            if (this.fCurrent instanceof Gradient) {
                ged = new GradientEditorDialog(this.getShell(), this.wizardContext, (Gradient)this.fCurrent);
            } else if (this.fCurrent instanceof ColorDefinition) {
                ColorDefinition newCD = (ColorDefinition)EcoreUtil.copy((EObject)this.fCurrent);
                newCD.eAdapters().addAll((Collection)this.fCurrent.eAdapters());
                ged = new GradientEditorDialog(this.getShell(), this.wizardContext, null, newCD);
            } else {
                ged = new GradientEditorDialog(this.getShell(), this.wizardContext, null);
            }
            if (ged.getGradient() != null) {
                Gradient fTmp = ged.getGradient();
                this.addAdapters((Notifier)fTmp);
                if (this.fCurrent == null || !this.fCurrent.equals(fTmp)) {
                    this.setFill((Fill)fTmp);
                    this.fireHandleEvent(1);
                }
            }
        } else if (oSource.equals(this.srTransparency)) {
            this.iTransparency = this.srTransparency.getSelection();
            this.lblTransparency.setText(new MessageFormat(Messages.getString("FillChooserComposite.Lbl.Opacity")).format(new Object[]{new Integer(this.iTransparency)}));
            this.srTransparency.setToolTipText(String.valueOf(this.srTransparency.getSelection()));
            if (this.fCurrent instanceof ColorDefinition) {
                ((ColorDefinition)this.fCurrent).setTransparency(this.iTransparency);
            }
            this.setFill(this.fCurrent);
            this.bTransparencyChanged = true;
            this.fireHandleEvent(1);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void fireHandleEvent(int iType) {
        for (int iL = 0; iL < this.vListeners.size(); ++iL) {
            Event se = new Event();
            se.widget = this;
            se.data = this.fCurrent;
            se.type = iType;
            ((Listener)this.vListeners.get(iL)).handleEvent(se);
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (!this.bEnabled) {
            return;
        }
        this.fireHandleEvent(2);
        if (e.getSource().equals((Object)this.cnvSelection)) {
            if (!this.cnvSelection.isDisposed()) {
                this.toggleDropDown();
            }
        } else if (e.getSource() instanceof ColorSelectionCanvas) {
            ColorDefinition cTmp = AttributeFactory.eINSTANCE.createColorDefinition();
            Color clrTmp = ((ColorSelectionCanvas)((Object)e.getSource())).getColorAt(e.x, e.y);
            cTmp.set(clrTmp.getRed(), clrTmp.getGreen(), clrTmp.getBlue());
            int iTransparency = 255;
            if (this.fCurrent instanceof ColorDefinition && this.iTransparency != 0) {
                iTransparency = this.bTransparencyChanged ? this.iTransparency : ((ColorDefinition)this.fCurrent).getTransparency();
            }
            cTmp.setTransparency(iTransparency);
            this.addAdapters((Notifier)cTmp);
            this.setFill((Fill)cTmp);
            this.fireHandleEvent(1);
            this.cmpDropDown.getShell().close();
        }
    }

    public void mouseUp(MouseEvent e) {
    }

    public void widgetDisposed(DisposeEvent e) {
        if (colorArray != null) {
            for (int iC = 0; iC < colorArray.length; ++iC) {
                colorArray[iC].dispose();
            }
            colorArray = null;
        }
    }

    public void keyPressed(KeyEvent e) {
        if (this.cmpDropDown != null && !this.cmpDropDown.getShell().isDisposed()) {
            if (e.keyCode == 0x1000001) {
                this.cmpDropDown.getShell().close();
                return;
            }
            if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                this.iTransparency = this.srTransparency.getSelection();
                if (this.fCurrent instanceof ColorDefinition && this.bTransparencyChanged) {
                    ((ColorDefinition)this.fCurrent).setTransparency(this.iTransparency);
                }
                this.setFill(this.fCurrent);
                this.cmpDropDown.getShell().close();
                return;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (this.isPopupControl(e.getSource())) {
            Control cTmp;
            Control control = cTmp = this.isPressingKey ? Display.getCurrent().getFocusControl() : Display.getCurrent().getCursorControl();
            if (cTmp != null) {
                if (this.isPopupControl(cTmp) || cTmp == this.cnvSelection || cTmp == this.btnDown) {
                    return;
                }
                if (cTmp.equals((Object)this.cnvSelection) || cTmp.equals(this.btnDown)) {
                    this.bJustFocusLost = true;
                }
            }
            this.cmpDropDown.getShell().close();
            return;
        }
    }

    private boolean isPopupControl(Object control) {
        return control != null && control instanceof Control && ((Control)control).getShell() == this.cmpDropDown.getShell();
    }

    private void addAdapters(Notifier notifier) {
        if (this.wizardContext != null) {
            notifier.eAdapters().addAll((Collection)this.wizardContext.getModel().eAdapters());
        }
    }

    void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = FillChooserComposite.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = FillChooserComposite.this.toControl(new Point(e.x, e.y));
                if (FillChooserComposite.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = FillChooserComposite.this.getBounds();
                Point pt = FillChooserComposite.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }
        });
    }
}

