/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class LineCanvas
extends Canvas
implements PaintListener {
    int iLineStyle = 1;
    int iLineWidth = 1;

    public LineCanvas(Composite parent, int iStyle, int iLineStyle, int iLineWidth) {
        super(parent, iStyle);
        this.iLineStyle = iLineStyle;
        this.iLineWidth = iLineWidth;
        this.addPaintListener(this);
    }

    public int getLineStyle() {
        return this.iLineStyle;
    }

    public void setLineStyle(int iLineStyle) {
        this.iLineStyle = iLineStyle;
    }

    public int getLineWidth() {
        return this.iLineWidth;
    }

    public void setLineWidth(int iLineWidth) {
        this.iLineWidth = iLineWidth;
    }

    public void paintControl(PaintEvent pe) {
        Color cForeground = null;
        Color cBackground = null;
        if (this.isEnabled()) {
            cForeground = Display.getCurrent().getSystemColor(2);
            cBackground = Display.getCurrent().getSystemColor(25);
        } else {
            cForeground = Display.getCurrent().getSystemColor(16);
            cBackground = Display.getCurrent().getSystemColor(22);
        }
        GC gc = pe.gc;
        gc.setBackground(cBackground);
        gc.setForeground(cForeground);
        gc.setLineStyle(this.iLineStyle);
        gc.setLineWidth(this.iLineWidth);
        gc.fillRectangle(0, 0, this.getSize().x, this.getSize().y);
        gc.drawLine(10, this.getSize().y / 2, this.getSize().x - 10, this.getSize().y / 2);
        if (this.isEnabled() && this.isFocusControl()) {
            gc.setLineStyle(3);
            gc.setLineWidth(1);
            gc.setForeground(Display.getCurrent().getSystemColor(2));
            gc.drawRectangle(1, 1, this.getSize().x - 3, this.getSize().y - 3);
        }
    }

    public void setEnabled(boolean bState) {
        super.setEnabled(bState);
        this.redraw();
    }
}

