/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.NumberFormat;
import java.text.ParseException;
import java.util.Vector;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

public class LocalizedNumberEditorComposite
extends Composite
implements ModifyListener,
FocusListener,
KeyListener {
    public static final int TEXT_MODIFIED = 0;
    public static final int TEXT_FRACTION_CONVERTED = 1;
    private transient Text txtValue;
    private transient Vector vModifyListeners;
    private transient Vector vFractionListeners;
    private transient double dValue;
    private transient boolean bTextModified = false;
    private transient boolean bValueIsSet = false;
    private transient boolean bEnabled = true;
    private transient int iStyle = 0;

    public LocalizedNumberEditorComposite(Composite parent, int iStyle) {
        super(parent, 0);
        this.iStyle = iStyle;
        this.vModifyListeners = new Vector();
        this.vFractionListeners = new Vector();
        this.setLayout((Layout)new FillLayout());
        this.placeComponents();
        this.initAccessible();
    }

    private void placeComponents() {
        this.txtValue = new Text((Composite)this, this.iStyle);
        this.txtValue.setToolTipText(Messages.getString("TextEditorComposite.Tooltip.EnterDecimalOrFractionValue"));
        this.txtValue.addModifyListener((ModifyListener)this);
        this.txtValue.addFocusListener((FocusListener)this);
        this.txtValue.addKeyListener((KeyListener)this);
    }

    public void setEnabled(boolean bState) {
        this.bEnabled = bState;
        this.txtValue.setEnabled(bState);
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }

    public boolean isSetValue() {
        return this.bValueIsSet;
    }

    public void unsetValue() {
        this.bValueIsSet = false;
        this.dValue = 0.0;
        this.txtValue.setText("");
    }

    public void setValue(double value) {
        this.bValueIsSet = true;
        this.dValue = value;
        this.txtValue.setText(NumberFormat.getInstance().format(value));
    }

    public double getValue() {
        return this.dValue;
    }

    public void setToolTipText(String string) {
        this.txtValue.setToolTipText(string);
    }

    public void addModifyListener(ModifyListener listener) {
        this.vModifyListeners.add(listener);
    }

    public void addFractionListener(Listener listener) {
        this.vFractionListeners.add(listener);
    }

    public void modifyText(ModifyEvent e) {
        this.bTextModified = true;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (this.bTextModified) {
            this.bTextModified = false;
            this.fireEvent();
        }
    }

    public void keyPressed(KeyEvent e) {
        if ((e.keyCode == 13 || e.keyCode == 0x1000050) && this.bTextModified) {
            this.bTextModified = false;
            this.fireEvent();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    private void handleFormatError(String value) {
        MessageBox mbox = new MessageBox(this.getShell(), 40);
        mbox.setText(Messages.getString("LocalizedNumberEditorComposite.error.Title"));
        mbox.setMessage(MessageFormat.format((String)Messages.getString("LocalizedNumberEditorComposite.error.Message"), (Object[])new Object[]{value}));
        mbox.open();
    }

    private void fireEvent() {
        Event e;
        int i;
        boolean isFractionConverted = false;
        String sText = this.txtValue.getText();
        if (sText == null || sText.trim().length() == 0) {
            this.bValueIsSet = false;
            this.dValue = 0.0;
        } else {
            int iDelimiter = sText.indexOf(47);
            if (iDelimiter < 0) {
                iDelimiter = sText.indexOf(58);
            }
            if (iDelimiter > 0) {
                isFractionConverted = true;
                String numerator = sText.substring(0, iDelimiter);
                String denominator = sText.substring(iDelimiter + 1);
                try {
                    Number nume = NumberFormat.getInstance().parse(numerator);
                    Number deno = NumberFormat.getInstance().parse(denominator);
                    this.dValue = nume.doubleValue() / deno.doubleValue();
                    this.bValueIsSet = true;
                    sText = NumberFormat.getInstance().format(this.dValue);
                    this.txtValue.setText(sText);
                }
                catch (ParseException e2) {
                    this.handleFormatError(sText);
                }
            } else {
                try {
                    Number num = NumberFormat.getInstance().parse(sText);
                    this.dValue = num.doubleValue();
                    this.bValueIsSet = true;
                    sText = NumberFormat.getInstance().format(this.dValue);
                }
                catch (ParseException e3) {
                    this.handleFormatError(sText);
                }
            }
        }
        for (i = 0; i < this.vModifyListeners.size(); ++i) {
            e = new Event();
            e.data = sText;
            e.widget = this;
            e.type = 0;
            ((ModifyListener)this.vModifyListeners.get(i)).modifyText(new ModifyEvent(e));
        }
        if (isFractionConverted) {
            for (i = 0; i < this.vFractionListeners.size(); ++i) {
                e = new Event();
                e.data = sText;
                e.widget = this;
                e.type = 1;
                ((Listener)this.vFractionListeners.get(i)).handleEvent(e);
            }
        }
    }

    void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = LocalizedNumberEditorComposite.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleTextListener((AccessibleTextListener)new AccessibleTextAdapter(){

            public void getCaretOffset(AccessibleTextEvent e) {
                e.offset = LocalizedNumberEditorComposite.this.txtValue.getCaretPosition();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = LocalizedNumberEditorComposite.this.toControl(new Point(e.x, e.y));
                if (LocalizedNumberEditorComposite.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = LocalizedNumberEditorComposite.this.getBounds();
                Point pt = LocalizedNumberEditorComposite.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 42;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = LocalizedNumberEditorComposite.this.txtValue.getText();
            }
        });
    }
}

